/*************************************************************************
 *
 *  $RCSfile: EnumTypeDescription.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2001/12/03 11:00:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.comp.typedescriptionmanager;

import com.sun.star.uno.*;
import com.sun.star.uno.RuntimeException;
import com.sun.star.reflection.XEnumTypeDescription;

import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;


//==================================================================================================
class EnumTypeDescription extends TypeDescription implements XEnumTypeDescription
{
	private boolean				_bDefaultSet = false;
	private int					_nDefault;
	private String[]			_enumNames = null;
	private int[]				_enumValues = null;
	
	//______________________________________________________________________________________________
	public EnumTypeDescription( Class c )
	{
		super( c, TypeClass.ENUM );
	}
	
	// XEnumTypeDescription
	//______________________________________________________________________________________________
    public int getDefaultEnumValue()
		throws RuntimeException
	{
		if (! _bDefaultSet)
		{
			try
			{
				Method m = _class.getMethod( "getDefault", new Class[0] );
				Object ret = m.invoke( null, new Object[0] );
				_nDefault = ((com.sun.star.uno.Enum)ret).getValue();
				_bDefaultSet = true;
				return _nDefault;
			}
			catch (NoSuchMethodException exc)
			{
			}
			catch (java.lang.SecurityException exc)
			{
			}
			catch (IllegalAccessException exc)
			{
			}
			catch (IllegalArgumentException exc)
			{
			}
			catch (InvocationTargetException exc)
			{
			}
			throw new RuntimeException( "no enum default method available!", null );
		}
		return _nDefault;
	}
	
	//______________________________________________________________________________________________
	private void init()
		throws RuntimeException
	{
		Field[] fields = _class.getDeclaredFields();
		if (fields != null)
		{
			int nFields = fields.length;
			String[] names = new String[nFields /2];
			int[] values   = new int[nFields /2];
			
			int nLen = 0;
			for ( int nPos = 0; nPos < nFields; ++nPos )
			{
				Field field = fields[nPos];
				int nMod = field.getModifiers();
				
				if (Enum.class.isAssignableFrom( field.getType() ) &&
					Modifier.isPublic( nMod ) && Modifier.isFinal( nMod ) && Modifier.isStatic( nMod ))
				{
					try
					{
						values[nLen] = ((Enum)field.get( null )).getValue();
						names[nLen]  = field.getName();
						++nLen;
					}
					catch (IllegalAccessException exc)
					{
					}
				}
			}
			
			if (nLen != nFields)
			{
				int[] enumValues = new int[nLen];
				String[] enumNames  = new String[nLen];
				System.arraycopy( values, 0, enumValues, 0, nLen );
				System.arraycopy( names, 0, enumNames, 0, nLen );
				_enumValues = enumValues;
				_enumNames  = enumNames;
			}
			else
			{
				_enumValues = values;
				_enumNames  = names;
			}
		}
	}
	//______________________________________________________________________________________________
    public String[] getEnumNames()
		throws RuntimeException
	{
		if (_enumNames == null)
			init();
		return _enumNames;
	}
	//______________________________________________________________________________________________
    public int[] getEnumValues()
		throws RuntimeException
	{
		if (_enumValues == null)
			init();
		return _enumValues;
	}
}

