/*************************************************************************
 *
 *  $RCSfile: inittemplates.cxx,v $
 *
 *  $Revision: 1.1.4.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/15 15:14:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __FRAMEWORK_JOBS_INITTEMPLATES_HXX_
#include <jobs/inittemplates.hxx>
#endif

//_______________________________________________
// own includes

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

//_______________________________________________
// interface includes

#ifndef _COM_SUN_STAR_FRAME_XDOCUMENTTEMPLATES_HPP_
#include <com/sun/star/frame/XDocumentTemplates.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XLOCALIZABLE_HPP_
#include <com/sun/star/lang/XLocalizable.hpp>
#endif

//_______________________________________________
// other includes

#ifndef _SV_SETTINGS_HXX
#include <vcl/settings.hxx>
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

//_______________________________________________
// namespace

namespace framework{

#ifndef css
namespace css = ::com::sun::star;
#endif

//_______________________________________________
// definitions

/*-----------------------------------------------
    03.09.2003 08:56
-----------------------------------------------*/
DEFINE_XINTERFACE_3(InitTemplates                             ,
                    OWeakObject                               ,
                    DIRECT_INTERFACE(css::lang::XTypeProvider),
                    DIRECT_INTERFACE(css::lang::XServiceInfo ),
                    DIRECT_INTERFACE(css::task::XJob         ))

DEFINE_XTYPEPROVIDER_3(InitTemplates           ,
                       css::lang::XTypeProvider,
                       css::lang::XServiceInfo ,
                       css::task::XJob         )

DEFINE_XSERVICEINFO_MULTISERVICE(InitTemplates                   ,
                                 ::cppu::OWeakObject             ,
                                 SERVICENAME_JOB                 ,
                                 IMPLEMENTATIONNAME_INITTEMPLATES)

DEFINE_INIT_SERVICE(InitTemplates,
                    {
                        /*  Attention
                            I think we don't need any mutex or lock here ... because we are called by our own static method impl_createInstance()
                            to create a new instance of this class by our own supported service factory.
                            see macro DEFINE_XSERVICEINFO_MULTISERVICE and "impl_initService()" for further informations!
                        */
                    }
                   )

/*-----------------------------------------------
    03.09.2003 08:56
-----------------------------------------------*/
InitTemplates::InitTemplates(const css::uno::Reference< css::lang::XMultiServiceFactory >& xSMGR)
    : ThreadHelpBase(     )
    , m_xSMGR       (xSMGR)
{
}

/*-----------------------------------------------
    03.09.2003 08:56
-----------------------------------------------*/
InitTemplates::~InitTemplates()
{
}

/*-----------------------------------------------
    03.09.2003 10:36
-----------------------------------------------*/
css::uno::Any SAL_CALL InitTemplates::execute(const css::uno::Sequence< css::beans::NamedValue >& lArguments)
    throw(css::lang::IllegalArgumentException,
          css::uno::Exception                ,
          css::uno::RuntimeException         )
{
    try
    {
        // SAFE -> ------------------------------
        ReadGuard aReadLock(m_aLock);
        css::uno::Reference< css::frame::XDocumentTemplates > xTemplates(m_xSMGR->createInstance(SERVICENAME_DOCUMENTTEMPLATES), css::uno::UNO_QUERY);
        aReadLock.unlock();
        // <- SAFE ------------------------------

		// non chance to init templates ...
		// But try it again if next time this job is started.
		// => dont deactivate it!
		if (!xTemplates.is())
			return css::uno::Any();

        // This service needs the current office locale to initialize templates right.
        AllSettings       aSettings;
        css::lang::Locale aLocale  = aSettings.GetLocale();
        css::uno::Reference< css::lang::XLocalizable > xLocalizable(xTemplates, css::uno::UNO_QUERY);
        xLocalizable->setLocale(aLocale);

		// This function is defined as "init(!) or update templates without UI" ...
		xTemplates->update();

        // disable this job!
        css::uno::Sequence< css::beans::NamedValue > lResult(1);
        lResult[0].Name    = ::rtl::OUString::createFromAscii("Deactivate");
        lResult[0].Value <<= sal_True;

        css::uno::Any aResult;
        aResult <<= lResult;

        return aResult;
    }
    catch(const css::uno::RuntimeException&)
        { throw; }
    catch(const css::lang::IllegalArgumentException&)
        { throw; }
    catch(const css::uno::Exception&)
        {}

    return css::uno::Any();
}

} // namespace framework
