/*************************************************************************
 *
 *  $RCSfile: framectr.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ADR_FRAMECTR_HXX
#define _ADR_FRAMECTR_HXX
#ifndef _SMART_COM_SUN_STAR_FRAME_XCONTROLLER_HXX_
#include <smart/com/sun/star/frame/XController.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XSTORABLE_HXX_
#include <smart/com/sun/star/frame/XStorable.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XMODEL_HXX_
#include <smart/com/sun/star/frame/XModel.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HXX_
#include <smart/com/sun/star/frame/XFrameActionListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HXX_
#include <smart/com/sun/star/frame/XComponentLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAME_HXX_
#include <smart/com/sun/star/frame/XFrame.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HXX_
#include <smart/com/sun/star/frame/FrameActionEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTION_HXX_
#include <smart/com/sun/star/frame/FrameAction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_UTIL_XURLTRANSFORMER_HXX_
#include <smart/com/sun/star/util/XURLTransformer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XTOPWINDOW_HXX_
#include <smart/com/sun/star/awt/XTopWindow.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XWINDOW_HXX_
#include <smart/com/sun/star/awt/XWindow.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_POSSIZE_HXX_
#include <smart/com/sun/star/awt/PosSize.hxx>
#endif
#include <usr/uno.hxx>


#ifndef _SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif

#ifndef _ADR_FIELDWIN_HXX
#include "fieldwin.hxx"
#endif

#ifndef _ADR_DATMAN_HXX
#include "datman.hxx"
#endif

class AdrStatusDispatch
{
public:
	URL					aURL;
	XStatusListenerRef	xListener;
						AdrStatusDispatch( const URL& rURL, const XStatusListenerRef xRef )
							: aURL( rURL )
							, xListener( xRef )
						{}
};

typedef AdrStatusDispatch* AdrStatusDispatchPtr;
SV_DECL_PTRARR_DEL( AdrStatusDispatchArr, AdrStatusDispatchPtr, 4, 4 );

class AdrFrameController : public XController,public XDispatch, 
								public XDispatchProvider, public UsrObject
{
friend class AdrFrameCtrl_Impl;
	AdrFrameCtrl_Impl*			pImp;

private:
	AdrStatusDispatchArr		aStatusListeners;
	XWindowRef					xWindow;
	XFrameRef					xFrame;
	BOOL						bDisposing;
	BOOL						bHierarchical;
	AdrDataManagerPtr			pDatMan;
	XPropertyChangeListenerRef	xDatMan;
	AdrFieldWin*				pFieldWin;

public:
								AdrFrameController();
								AdrFrameController(AdrDataManager* pDatMan);
								~AdrFrameController();

								SMART_UNO_DECLARATION( AdrFrameController, UsrObject );
	
	void						InitController(const XWindowRef& xComponent);
	void						activate();
	void						deactivate();

	AdrDataManagerHdl			GetDataManager();
	void						ChangeDataSource(const Sequence< PropertyValue >& aArgs);
	void						RemoveFilter();
	
	void						RecordChanged();
	
	virtual BOOL 				queryInterface( UsrUik aUIK, XInterfaceRef& );

								// XController
	virtual void 				attachFrame( const XFrameRef& xFrame );
	virtual BOOL 				attachModel( const XModelRef& xModel );
	virtual BOOL 				suspend( BOOL bSuspend );
	UsrAny						getViewData();
	void						restoreViewData( const UsrAny& Value );
	XFrameRef					getFrame();
	XModelRef					getModel();

								// XComponent
	virtual void				dispose();
	virtual void 				addEventListener( const XEventListenerRef& aListener );
	virtual void 				removeEventListener( const XEventListenerRef& aListener );

								// XDispatchProvider
	virtual XDispatchRef 		queryDispatch( const URL& aURL, const UString& aTargetFrameName, INT32 nSearchFlags);
	virtual Sequence< XDispatchRef > queryDispatches( const Sequence< DispatchDescriptor >& aDescripts);

								//class XDispatch
    virtual void				dispatch(const URL& aURL, const Sequence< PropertyValue >& aArgs);
    virtual void				addStatusListener(const XStatusListenerRef& xControl, const URL& aURL);
    virtual void				removeStatusListener(const XStatusListenerRef& xControl, const URL& aURL);

};

#endif

