/*************************************************************************
 *
 *  $RCSfile: fieldwin.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _ADR_FIELDWIN_HXX
#define _ADR_FIELDWIN_HXX

#ifndef _SVTREEBOX_HXX //autogen
#include <svtools/svtreebx.hxx>
#endif

#ifndef _SV_FLOATWIN_HXX //autogen
#include <vcl/floatwin.hxx>
#endif

#ifndef _BASEDLGS_HXX //autogen
#include <sfx2/basedlgs.hxx>
#endif

#ifndef _SFX_CHILDWIN_HXX //autogen
#include <sfx2/childwin.hxx>
#endif

#ifndef _SFXCTRLITEM_HXX //autogen
#include <sfx2/ctrlitem.hxx>
#endif

#ifndef _SMART_COM_SUN_STAR_FORM_XUPDATEBROADCASTER_HXX_
#include <smart/com/sun/star/form/XUpdateBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XCONFIRMDELETEBROADCASTER_HXX_
#include <smart/com/sun/star/form/XConfirmDeleteBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEFORMUPDATE_HXX_
#include <smart/com/sun/star/form/XDatabaseFormUpdate.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XUPDATELISTENER_HXX_
#include <smart/com/sun/star/form/XUpdateListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATASELECTIONTYPE_HXX_
#include <smart/com/sun/star/form/DataSelectionType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XERRORLISTENER_HXX_
#include <smart/com/sun/star/form/XErrorListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XRESTORELISTENER_HXX_
#include <smart/com/sun/star/form/XRestoreListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATABASEPARAMETEREVENT_HXX_
#include <smart/com/sun/star/form/DatabaseParameterEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XINSERTLISTENER_HXX_
#include <smart/com/sun/star/form/XInsertListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDELETELISTENER_HXX_
#include <smart/com/sun/star/form/XDeleteListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATABASEDELETEEVENT_HXX_
#include <smart/com/sun/star/form/DatabaseDeleteEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XPOSITIONINGLISTENER_HXX_
#include <smart/com/sun/star/form/XPositioningListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XBOUNDCOMPONENT_HXX_
#include <smart/com/sun/star/form/XBoundComponent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEPARAMETERLISTENER_HXX_
#include <smart/com/sun/star/form/XDatabaseParameterListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XLOADLISTENER_HXX_
#include <smart/com/sun/star/form/XLoadListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_NAVIGATIONBARMODE_HXX_
#include <smart/com/sun/star/form/NavigationBarMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XCONFIRMDELETELISTENER_HXX_
#include <smart/com/sun/star/form/XConfirmDeleteListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XERRORBROADCASTER_HXX_
#include <smart/com/sun/star/form/XErrorBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_ERROREVENT_HXX_
#include <smart/com/sun/star/form/ErrorEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_LISTSOURCETYPE_HXX_
#include <smart/com/sun/star/form/ListSourceType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEPARAMETERBROADCASTER_HXX_
#include <smart/com/sun/star/form/XDatabaseParameterBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_TABULATORCYCLE_HXX_
#include <smart/com/sun/star/form/TabulatorCycle.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEFORM_HXX_
#include <smart/com/sun/star/form/XDatabaseForm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XBOUNDCONTROL_HXX_
#include <smart/com/sun/star/form/XBoundControl.hxx>
#endif

//==================================================================
class AdrFieldWin;
class AdrFieldListBox: public SvTreeListBox
{
	AdrFieldWin* pTabWin;

protected:
	virtual void Command( const CommandEvent& rEvt );

public:
	AdrFieldListBox( AdrFieldWin* pParent );
	virtual ~AdrFieldListBox();

	virtual BOOL QueryDrop( DropEvent& rDEvt ) { if (!nDragDropMode) return FALSE; return SvTreeListBox::QueryDrop(rDEvt); }
		// this prevents an assertion the base class makes (unjustified ?) to fail - 67071 - fs - 21.06.99
};

//========================================================================
class AdrFieldWin :	public FloatingWindow
{
	AdrFieldListBox* pListBox;
	String			   aDatabaseName,
					   aObjectName;
	UINT16			   nObjectType;

protected:

	virtual void Resize();

public:
	AdrFieldWin(Window* pParent);
	virtual ~AdrFieldWin();


	const String& GetDatabaseName() const {return aDatabaseName;}
	const String& GetObjectName() const {return aObjectName;}
	UINT16		  GetObjectType() const {return nObjectType;}

	void	Update(const XDatabaseFormRef& xForm);
};


#endif

