/*************************************************************************
 *
 *  $RCSfile: cntmbitm.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/17 17:03:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "cntmbitm.hxx"

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _CACHESTR_HXX
#include <tools/cachestr.hxx>
#endif

#ifndef _INETCOREMSG_HXX
#include "inetmsg.hxx"
#endif

using namespace chaos;

/*=======================================================================
 *
 * CntMessageBodyItem Internals.
 *
 *=====================================================================*/
#define CNT_MESSAGEBODY_MAGIC ((ULONG)0x58190322)

namespace chaos {

class CntMessageBodyItemImp
{
	friend class CntMessageBodyItem;

	USHORT              nRefCnt;
	USHORT              eType;
	INetCoreNewsMessage *pMessage;
	String              aURL;

	void DeleteMessage (INetCoreNewsMessage *pMsg);

public:
	CntMessageBodyItemImp (void);
	~CntMessageBodyItemImp (void);

	int operator== (const CntMessageBodyItemImp& rOther);

	INetCoreNewsMessage *CloneMessage (
		const INetCoreNewsMessage& rMsg);
	INetCoreNewsMessage *DetachChildren (
		INetCoreNewsMessage& rMsg,
		bool bRecursive);

	SvStream& LoadMessage  (
		SvStream& rStrm, INetCoreNewsMessage& rMsg);

	SvStream& StoreMessage (
		SvStream& rStrm, INetCoreNewsMessage& rMsg);
};

}

/*=======================================================================
 *
 * CntMessageBodyItem Implementation.
 *
 *=====================================================================*/
/*
 * CntMessageBodyItem.
 */
TYPEINIT1_AUTOFACTORY (CntMessageBodyItem, SfxPoolItem);

CntMessageBodyItem::CntMessageBodyItem (void)
	: SfxPoolItem (),
	  pImp        (new CntMessageBodyItemImp)
{
}

CntMessageBodyItem::CntMessageBodyItem (USHORT nWhich, const String& rURL)
	: SfxPoolItem (nWhich),
	  pImp        (new CntMessageBodyItemImp)
{
	pImp->aURL = rURL;
}

CntMessageBodyItem::CntMessageBodyItem (const CntMessageBodyItem& rOther)
	: SfxPoolItem (rOther.Which()),
	  pImp        (rOther.pImp)
{
	pImp->nRefCnt++;
}

/*
 * ~CntMessageBodyItem.
 */
CntMessageBodyItem::~CntMessageBodyItem (void)
{
	pImp->nRefCnt--;
	if (pImp->nRefCnt == 0) delete pImp;
}

/*
 * operator==
 */
int CntMessageBodyItem::operator== (const SfxPoolItem& rItem) const
{
	const CntMessageBodyItem& rOther = (const CntMessageBodyItem&)rItem;

	return ((pImp != rOther.pImp) ? (*pImp == *rOther.pImp) : TRUE);
}

/*
 * Clone.
 */
SfxPoolItem* CntMessageBodyItem::Clone (SfxItemPool *pPool) const
{
	return new CntMessageBodyItem (*this);
}

/*
 * Create.
 */
SfxPoolItem* CntMessageBodyItem::Create (
	SvStream& rStrm, USHORT nVersion) const
{
	// (NYI).
	return NULL;
}

/*
 * Store.
 */
SvStream& CntMessageBodyItem::Store (SvStream& rStrm, USHORT nVersion) const
{
	// (NYI).
	return rStrm;
}

/*
 * GetType.
 */
USHORT CntMessageBodyItem::GetType (void) const
{
	return pImp->eType;
}

/*
 * Get.
 */
INetCoreNewsMessage* CntMessageBodyItem::Get (void) const
{
	return pImp->pMessage;
}

/*
 * Set.
 */
BOOL CntMessageBodyItem::Set (INetCoreNewsMessage *pMsg)
{
	pImp->pMessage = pMsg;
	return TRUE;
}

/*
 * LoadMessage (using CntMessageBodyItemImp::LoadMessage).
 */
SvStream& CntMessageBodyItem::LoadMessage (
	SvStream& rStrm, INetCoreNewsMessage& rMsg)
{
	CntMessageBodyItemImp aImp;
	aImp.eType = CNT_MESSAGEBODY_NEWS;	// always load NewsMessage
 	return aImp.LoadMessage (rStrm, rMsg);
}

/*
 * StoreMessage (using CntMessageBodyItemImp::StoreMessage).
 */
SvStream& CntMessageBodyItem::StoreMessage (
	SvStream& rStrm, INetCoreNewsMessage& rMsg)
{
	CntMessageBodyItemImp aImp;
	return aImp.StoreMessage (rStrm, rMsg);
}

/*
 * QueryValue.
 */
BOOL CntMessageBodyItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  	 BYTE nMemberId ) const
{
	return FALSE;
}

/*
 * PutValue.
 */
BOOL CntMessageBodyItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		BYTE nMemberId )
{
	return FALSE;
}

/*=======================================================================
 *
 * CntMessageBodyItemImp Implementation.
 *
 *=====================================================================*/
/*
 * CntMessageBodyItemImp.
 */
CntMessageBodyItemImp::CntMessageBodyItemImp (void)
	: nRefCnt  (1),
	  eType    (CNT_MESSAGEBODY_NONE),
	  pMessage (NULL)
{
}

/*
 * ~CntMessageBodyItemImp.
 */
CntMessageBodyItemImp::~CntMessageBodyItemImp (void)
{
	DBG_ASSERT ((nRefCnt < 0xffff), "pImp already deleted");
	DeleteMessage (pMessage);

	nRefCnt  = 0xffff;
	eType    = CNT_MESSAGEBODY_NONE;
	pMessage = NULL;
}

/*
 * operator==
 */
int CntMessageBodyItemImp::operator== (const CntMessageBodyItemImp& rOther)
{
	return ((eType    == rOther.eType   ) &&
			(aURL     == rOther.aURL    ) &&
			(pMessage == rOther.pMessage)    );
}

/*
 * DeleteMessage.
 */
void CntMessageBodyItemImp::DeleteMessage (INetCoreNewsMessage *pMsg)
{
	if (pMsg)
	{
		SvStream *pStream = pMsg->GetDocumentStream();
		if (pStream) delete pStream;

		ULONG nCount = pMsg->GetChildCount();
		for (ULONG i = 0; i < nCount; i++)
			DeleteMessage ((INetCoreNewsMessage *)(pMsg->GetChild (i)));

		delete pMsg;
	}
}

/*
 * CloneMessage.
 */
INetCoreNewsMessage *CntMessageBodyItemImp::CloneMessage (
	const INetCoreNewsMessage& rMsg)
{
	INetCoreNewsMessage *pNewMsg = new INetCoreNewsMessage();

	SvMemoryStream aStrm;
	aStrm << rMsg;
	aStrm.Seek (STREAM_SEEK_TO_BEGIN);
	aStrm >> *pNewMsg;
	pNewMsg->SetDocumentStream (NULL);

	return pNewMsg;
}

/*
 * DetachChildren.
 */
INetCoreNewsMessage *CntMessageBodyItemImp::DetachChildren (
	INetCoreNewsMessage& rMsg, bool bRecursive)
{
	INetCoreNewsMessage *pNewMsg = &rMsg;
	if (rMsg.IsContainer())
	{
		// Clone container.
		pNewMsg = CloneMessage (rMsg);

		// Detach children.
		ULONG nCount = rMsg.GetChildCount();
		for (ULONG i = 0; i < nCount; i++)
		{
			// Create child message.
			INetCoreNewsMessage *pChild = new INetCoreNewsMessage();

			// Create child stream.
			SvCacheStream *pChildStrm = new SvCacheStream;
			pChild->SetDocumentStream (pChildStrm);

			// Detach child message.
			rMsg.DetachChild (i, *pChild);
			pChildStrm->Seek (STREAM_SEEK_TO_BEGIN);

			// Check for grand-children.
			INetCoreNewsMessage *pNewChild = DetachChildren (*pChild, true);
			if (pNewChild != pChild)
			{
				// Cleanup pChild (replaced by pNewChild).
				delete pChild;
			}

			// Attach new child.
			pNewMsg->AttachChild (*pNewChild);
		}

		// Cleanup parent stream (if not toplevel storage).
		if (bRecursive)
		{
			SvStream *pParentStrm = rMsg.GetDocumentStream();
			delete pParentStrm;
		}
		rMsg.SetDocumentStream (NULL);
	}
	return pNewMsg;
}

/*
 * INetCoreNewsMessage::LoadMessage().
 */
SvStream& CntMessageBodyItemImp::LoadMessage (
	SvStream& rStrm, INetCoreNewsMessage& rMsg)
{
	// Load message header.
	ULONG nMagic = 0;
	rStrm >> nMagic;

	DBG_ASSERT ((nMagic == CNT_MESSAGEBODY_MAGIC), "Magic number mismatch");
	if (!(nMagic == CNT_MESSAGEBODY_MAGIC))
		return rStrm;

	rStrm >> rMsg;

	// Load document size.
	nMagic = 0;
	rStrm >> nMagic;

	DBG_ASSERT ((nMagic == CNT_MESSAGEBODY_MAGIC), "Magic number mismatch");
	if (!(nMagic == CNT_MESSAGEBODY_MAGIC))
		return rStrm;

	ULONG nDocSiz = 0;
	rStrm >> nDocSiz;
	rMsg.SetDocumentSize (nDocSiz);

	// Load message document.
	if (nDocSiz > 0)
	{
		SvCacheStream *pStrm = new SvCacheStream;

		char  pBuffer[2048];
		ULONG nBufSiz = sizeof (pBuffer);
		ULONG nRead   = 0;

		while ((nRead = rStrm.Read (
			pBuffer, (nDocSiz > nBufSiz) ? nBufSiz : nDocSiz)) > 0)
			nDocSiz -= pStrm->Write (pBuffer, nRead);

		pStrm->Seek (STREAM_SEEK_TO_BEGIN);
		rMsg.SetDocumentStream (pStrm);
	}

	// Load children.
	ULONG nChildren = rMsg.GetChildCount();
	for (ULONG i = 0; i < nChildren; i++)
	{
		INetCoreNewsMessage *pChild = NULL;
		if (eType == CNT_MESSAGEBODY_NEWS)
			pChild = new INetCoreNewsMessage();

		if (pChild)
		{
			LoadMessage (rStrm, *pChild);
			rMsg.AttachChild (*pChild);
		}
	}

	// Done.
	return rStrm;
}

/*
 * INetCoreNewsMessage::StoreMessage().
 */
SvStream& CntMessageBodyItemImp::StoreMessage (
	SvStream& rStrm, INetCoreNewsMessage& rMsg)
{
	// Determine and set correct document size.
	ULONG nDocSiz = 0;
	SvStream *pDocStrm = rMsg.GetDocumentStream();
	if (pDocStrm)
	{
		pDocStrm->Seek (STREAM_SEEK_TO_END);
		nDocSiz = pDocStrm->Tell();
		pDocStrm->Seek (STREAM_SEEK_TO_BEGIN);
	}
	rMsg.SetDocumentSize (nDocSiz);

	// Store message header.
	rStrm << CNT_MESSAGEBODY_MAGIC; // Magic!
	rStrm << rMsg;

	// Store message document.
	rStrm << CNT_MESSAGEBODY_MAGIC; // Magic!
	rStrm << nDocSiz;
	if (pDocStrm) rStrm << *pDocStrm;

	// Store children.
	ULONG nChildren = rMsg.GetChildCount();
	for (ULONG i = 0; i < nChildren; i++)
	{
		INetCoreNewsMessage *pChild =
			(INetCoreNewsMessage *)(rMsg.GetChild (i));
		if (pChild) StoreMessage (rStrm, *pChild);
	}

	// Done.
	return rStrm;
}
