/*************************************************************************
 *
 *  $RCSfile: inetmsg.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/17 16:58:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INETCOREMSG_HXX
#define _INETCOREMSG_HXX "$Revision: 1.2 $"

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _TOOLS_INETMIME_HXX
#include <tools/inetmime.hxx>
#endif

class Date;
class Time;
class SvStream;
class SvLockBytes;

/*=======================================================================
 *
 * INetCoreMessage Interface.
 *
 * References:
 *   RFC  822 - Format of Electronic Mail Messages (STD 11).
 *   RFC 1036 - Standard for Interchange of USENET Messages.
 *   RFC 1521 - Multipurpose Internet Mail Extensions (Draft Standard).
 *   RFC 1522 - MIME Part II - Message Header Extension for Non-ASCII Text.
 *   RFC 1920 - Internet Official Protocol Standards (STD 1).
 *
 *=====================================================================*/

/*=======================================================================
 *
 * INetCoreMessage (Message Container) Interface.
 *
 *======================================================================*/
class INetCoreMessage
{
	UniString    m_aDocFilename;
	ULONG        m_nDocSize;
	SvStream    *m_pDocStream;
	SvLockBytes *m_pDocLB;

	// Not implemented.
	INetCoreMessage (const INetCoreMessage& rMsg);
	INetCoreMessage& operator= (const INetCoreMessage& rMsg);

protected:
	UniString Decode_Impl (
		INetMIME::HeaderFieldType eType, const ByteString &rValue) const
	{
		return INetMIME::decodeHeaderFieldBody (eType, rValue);
	}

	ByteString Encode_Impl (
		INetMIME::HeaderFieldType eType, const UniString &rValue) const
	{
		INetMIMEStringOutputSink aSink (0, STRING_MAXLEN);
		INetMIME::writeHeaderFieldBody (
			aSink, eType, rValue, gsl_getSystemTextEncoding(), false);
		return aSink.takeBuffer();
	}

	virtual SvStream& operator<< (SvStream& rStrm) const;
	virtual SvStream& operator>> (SvStream& rStrm);

public:
	INetCoreMessage (void);
	virtual ~INetCoreMessage (void);

	inline const UniString& GetDocumentFilename (void) const;
	inline ULONG            GetDocumentSize     (void) const;
	inline SvStream*        GetDocumentStream   (void) const;
	inline SvLockBytes*     GetDocumentLB       (void) const;

	inline void  SetDocumentFilename (const UniString& rDocumentFilename);
	inline void  SetDocumentSize     (ULONG nDocumentSize);
	inline void  SetDocumentStream   (SvStream *pDocumentStream);
	inline void  SetDocumentLB       (SvLockBytes *pDocumentLB);

	friend SvStream& operator<< (
		SvStream& rStrm, const INetCoreMessage& rMsg)
	{
		return rMsg.operator<< (rStrm);
	}

	friend SvStream& operator>> (
		SvStream& rStrm, INetCoreMessage& rMsg)
	{
		return rMsg.operator>> (rStrm);
	}
};

/*
 * DocumentFilename.
 */
inline const UniString& INetCoreMessage::GetDocumentFilename (void) const
{
	return m_aDocFilename;
}

inline void INetCoreMessage::SetDocumentFilename (
	const UniString& rDocumentFilename)
{
	m_aDocFilename = rDocumentFilename;
}

/*
 * DocumentSize.
 */
inline ULONG INetCoreMessage::GetDocumentSize (void) const
{
	return m_nDocSize;
}

inline void INetCoreMessage::SetDocumentSize (ULONG nDocumentSize)
{
	m_nDocSize = nDocumentSize;
}

/*
 * DocumentStream.
 */
inline SvStream *INetCoreMessage::GetDocumentStream (void) const
{
	return m_pDocStream;
}

inline void INetCoreMessage::SetDocumentStream (SvStream *pDocumentStream)
{
	m_pDocStream = pDocumentStream;
}

/*
 * DocumentLB.
 */
inline SvLockBytes *INetCoreMessage::GetDocumentLB (void) const
{
	return m_pDocLB;
}

inline void INetCoreMessage::SetDocumentLB (SvLockBytes *pDocumentLB)
{
	m_pDocLB = pDocumentLB;
}

/*========================================================================
 *
 * INetCoreRFC822Message Interface.
 *
 *======================================================================*/
class INetCoreRFC822Message : public INetCoreMessage
{
	ByteString m_aBCC;
	ByteString m_aCC;
	ByteString m_aComments;
	ByteString m_aDate;
	ByteString m_aEncoding;
	ByteString m_aFrom;
	ByteString m_aInReplyTo;
	ByteString m_aKeywords;
	ByteString m_aMessageID;
	ByteString m_aReceived;
	ByteString m_aReferences;
	ByteString m_aReplyTo;
	ByteString m_aReturnPath;
	ByteString m_aSubject;
	ByteString m_aSender;
	ByteString m_aTo;
	ByteString m_aXMailer;
	ByteString m_aXPriority;
	ByteString m_aReturnReceiptTo;

#if (defined (_INETCOREMSG_CXX) || defined (_INETCORESTRM_CXX))
	// Generator/Parser.
	friend class INetCoreRFC822MessageStream;

	const ByteString& GetBCC_Impl             (void) const;
	const ByteString& GetCC_Impl              (void) const;
	const ByteString& GetComments_Impl        (void) const;
	const ByteString& GetDate_Impl            (void) const;
	const ByteString& GetEncoding_Impl        (void) const;
	const ByteString& GetFrom_Impl            (void) const;
	const ByteString& GetInReplyTo_Impl       (void) const;
	const ByteString& GetKeywords_Impl        (void) const;
	const ByteString& GetMessageID_Impl       (void) const;
	const ByteString& GetReceived_Impl        (void) const;
	const ByteString& GetReferences_Impl      (void) const;
	const ByteString& GetReplyTo_Impl         (void) const;
	const ByteString& GetReturnPath_Impl      (void) const;
	const ByteString& GetSubject_Impl         (void) const;
	const ByteString& GetSender_Impl          (void) const;
	const ByteString& GetTo_Impl              (void) const;
	const ByteString& GetXMailer_Impl         (void) const;
	const ByteString& GetXPriority_Impl       (void) const;
	const ByteString& GetReturnReceiptTo_Impl (void) const;

	void  SetBCC_Impl             (const ByteString& rValue);
	void  SetCC_Impl              (const ByteString& rValue);
	void  SetComments_Impl        (const ByteString& rValue);
	void  SetDate_Impl            (const ByteString& rValue);
	void  SetEncoding_Impl        (const ByteString& rValue);
	void  SetFrom_Impl            (const ByteString& rValue);
	void  SetInReplyTo_Impl       (const ByteString& rValue);
	void  SetKeywords_Impl        (const ByteString& rValue);
	void  SetMessageID_Impl       (const ByteString& rValue);
	void  SetReceived_Impl        (const ByteString& rValue);
	void  SetReferences_Impl      (const ByteString& rValue);
	void  SetReplyTo_Impl         (const ByteString& rValue);
	void  SetSubject_Impl         (const ByteString& rValue);
	void  SetReturnPath_Impl      (const ByteString& rValue);
	void  SetSender_Impl          (const ByteString& rValue);
	void  SetTo_Impl              (const ByteString& rValue);
	void  SetXMailer_Impl         (const ByteString& rValue);
	void  SetXPriority_Impl       (const ByteString& rValue);
	void  SetReturnReceiptTo_Impl (const ByteString& rValue);
#endif /* _INETCOREMSG_CXX || _INETCORESTRM_CXX */

	// Not implemented.
	INetCoreRFC822Message (const INetCoreRFC822Message& rMsg);
	INetCoreRFC822Message& operator= (const INetCoreRFC822Message& rMsg);

protected:
	virtual SvStream& operator<< (SvStream& rStrm) const;
	virtual SvStream& operator>> (SvStream& rStrm);

public:
	INetCoreRFC822Message (void);
	virtual ~INetCoreRFC822Message (void);

	virtual BOOL GenerateDateField (
		const Date& rDate, const Time& rTime, UniString& rDateField) const;
	virtual BOOL ParseDateField (
		const UniString& rDateField, Date& rDate, Time& rTime) const;

	UniString GetBCC             (void) const;
	UniString GetCC              (void) const;
	UniString GetComments        (void) const;
	UniString GetDate            (void) const;
	UniString GetEncoding        (void) const;
	UniString GetFrom            (void) const;
	UniString GetInReplyTo       (void) const;
	UniString GetKeywords        (void) const;
	UniString GetMessageID       (void) const;
	UniString GetReceived        (void) const;
	UniString GetReferences      (void) const;
	UniString GetReplyTo         (void) const;
	UniString GetReturnPath      (void) const;
	UniString GetSubject         (void) const;
	UniString GetSender          (void) const;
	UniString GetTo              (void) const;
	UniString GetXMailer         (void) const;
	UniString GetXPriority       (void) const;
	UniString GetReturnReceiptTo (void) const;

	void  SetBCC             (const UniString& rValue);
	void  SetCC              (const UniString& rValue);
	void  SetComments        (const UniString& rValue);
	void  SetDate            (const UniString& rValue);
	void  SetEncoding        (const UniString& rValue);
	void  SetFrom            (const UniString& rValue);
	void  SetInReplyTo       (const UniString& rValue);
	void  SetKeywords        (const UniString& rValue);
	void  SetMessageID       (const UniString& rValue);
	void  SetReceived        (const UniString& rValue);
	void  SetReferences      (const UniString& rValue);
	void  SetReplyTo         (const UniString& rValue);
	void  SetSubject         (const UniString& rValue);
	void  SetReturnPath      (const UniString& rValue);
	void  SetSender          (const UniString& rValue);
	void  SetTo              (const UniString& rValue);
	void  SetXMailer         (const UniString& rValue);
	void  SetXPriority       (const UniString& rValue);
	void  SetReturnReceiptTo (const UniString& rValue);

	friend SvStream& operator<< (
		SvStream& rStrm, const INetCoreRFC822Message& rMsg)
	{
		return rMsg.operator<< (rStrm);
	}

	friend SvStream& operator>> (
		SvStream& rStrm, INetCoreRFC822Message& rMsg)
	{
		return rMsg.operator>> (rStrm);
	}
};

/*
 * BCC.
 */
inline UniString INetCoreRFC822Message::GetBCC (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_ADDRESS, m_aBCC);
}
inline void INetCoreRFC822Message::SetBCC (const UniString& rValue)
{
	m_aBCC = Encode_Impl (INetMIME::HEADER_FIELD_ADDRESS, rValue);
}

/*
 * CC.
 */
inline UniString INetCoreRFC822Message::GetCC (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_ADDRESS, m_aCC);
}
inline void INetCoreRFC822Message::SetCC (const UniString& rValue)
{
	m_aCC = Encode_Impl (INetMIME::HEADER_FIELD_ADDRESS, rValue);
}

/*
 * Comments.
 */
inline UniString INetCoreRFC822Message::GetComments (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_TEXT, m_aComments);
}
inline void INetCoreRFC822Message::SetComments (const UniString& rValue)
{
	m_aComments = Encode_Impl (INetMIME::HEADER_FIELD_TEXT, rValue);
}

/*
 * Date.
 */
inline UniString INetCoreRFC822Message::GetDate (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aDate);
}
inline void INetCoreRFC822Message::SetDate (const UniString& rValue)
{
	m_aDate = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * Encoding.
 */
inline UniString INetCoreRFC822Message::GetEncoding (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_TEXT, m_aEncoding);
}
inline void INetCoreRFC822Message::SetEncoding (const UniString& rValue)
{
	m_aEncoding = Encode_Impl (INetMIME::HEADER_FIELD_TEXT, rValue);
}

/*
 * From.
 */
inline UniString INetCoreRFC822Message::GetFrom (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_ADDRESS, m_aFrom);
}
inline void INetCoreRFC822Message::SetFrom (const UniString& rValue)
{
	m_aFrom = Encode_Impl (INetMIME::HEADER_FIELD_ADDRESS, rValue);
}

/*
 * InReplyTo.
 */
inline UniString INetCoreRFC822Message::GetInReplyTo (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_ADDRESS, m_aInReplyTo);
}
inline void INetCoreRFC822Message::SetInReplyTo (const UniString& rValue)
{
	m_aInReplyTo = Encode_Impl (INetMIME::HEADER_FIELD_ADDRESS, rValue);
}

/*
 * Keywords.
 */
inline UniString INetCoreRFC822Message::GetKeywords (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_PHRASE, m_aKeywords);
}
inline void INetCoreRFC822Message::SetKeywords (const UniString& rValue)
{
	m_aKeywords = Encode_Impl (INetMIME::HEADER_FIELD_PHRASE, rValue);
}

/*
 * MessageID.
 */
inline UniString INetCoreRFC822Message::GetMessageID (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_MESSAGE_ID, m_aMessageID);
}
inline void INetCoreRFC822Message::SetMessageID (const UniString& rValue)
{
	m_aMessageID = Encode_Impl (INetMIME::HEADER_FIELD_MESSAGE_ID, rValue);
}

/*
 * Received.
 */
inline UniString INetCoreRFC822Message::GetReceived (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aReceived);
}
inline void INetCoreRFC822Message::SetReceived (const UniString& rValue)
{
	m_aReceived = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * References.
 */
inline UniString INetCoreRFC822Message::GetReferences (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_ADDRESS, m_aReferences);
}
inline void INetCoreRFC822Message::SetReferences (const UniString& rValue)
{
	m_aReferences = Encode_Impl (INetMIME::HEADER_FIELD_ADDRESS, rValue);
}

/*
 * ReplyTo.
 */
inline UniString INetCoreRFC822Message::GetReplyTo (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_ADDRESS, m_aReplyTo);
}
inline void INetCoreRFC822Message::SetReplyTo (const UniString& rValue)
{
	m_aReplyTo = Encode_Impl (INetMIME::HEADER_FIELD_ADDRESS, rValue);
}

/*
 * ReturnPath.
 */
inline UniString INetCoreRFC822Message::GetReturnPath (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aReturnPath);
}
inline void INetCoreRFC822Message::SetReturnPath (const UniString& rValue)
{
	m_aReturnPath = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * Subject.
 */
inline UniString INetCoreRFC822Message::GetSubject (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_TEXT, m_aSubject);
}
inline void INetCoreRFC822Message::SetSubject (const UniString& rValue)
{
	m_aSubject = Encode_Impl (INetMIME::HEADER_FIELD_TEXT, rValue);
}

/*
 * Sender.
 */
inline UniString INetCoreRFC822Message::GetSender (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_ADDRESS, m_aSender);
}
inline void INetCoreRFC822Message::SetSender (const UniString& rValue)
{
	m_aSender = Encode_Impl (INetMIME::HEADER_FIELD_ADDRESS, rValue);
}

/*
 * To.
 */
inline UniString INetCoreRFC822Message::GetTo (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_ADDRESS, m_aTo);
}
inline void INetCoreRFC822Message::SetTo (const UniString& rValue)
{
	m_aTo = Encode_Impl (INetMIME::HEADER_FIELD_ADDRESS, rValue);
}

/*
 * XMailer.
 */
inline UniString INetCoreRFC822Message::GetXMailer (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_TEXT, m_aXMailer);
}
inline void INetCoreRFC822Message::SetXMailer (const UniString& rValue)
{
	m_aXMailer = Encode_Impl (INetMIME::HEADER_FIELD_TEXT, rValue);
}

/*
 * XPriority.
 */
inline UniString INetCoreRFC822Message::GetXPriority (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aXPriority);
}
inline void INetCoreRFC822Message::SetXPriority (const UniString& rValue)
{
	m_aXPriority = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * ReturnReceiptTo.
 */
inline UniString INetCoreRFC822Message::GetReturnReceiptTo (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_ADDRESS, m_aReturnReceiptTo);
}
inline void INetCoreRFC822Message::SetReturnReceiptTo (const UniString& rValue)
{
	m_aReturnReceiptTo = Encode_Impl (INetMIME::HEADER_FIELD_ADDRESS, rValue);
}

/*=========================================================================
 *
 * INetCoreMIMEMessage Interface.
 *
 *=======================================================================*/
class INetCoreMIMEMessageStream;

enum INetCoreMessageContainerType
{
	INETCOREMSG_MESSAGE_RFC822,
	INETCOREMSG_MULTIPART_MIXED,
	INETCOREMSG_MULTIPART_ALTERNATIVE,
	INETCOREMSG_MULTIPART_DIGEST,
	INETCOREMSG_MULTIPART_PARALLEL,
	INETCOREMSG_MULTIPART_RELATED
};

class INetCoreMIMEMessage : public INetCoreRFC822Message
{
	// Representation.
	INetCoreMIMEMessage *m_pParent;
	ULONG                m_nChildren;
	List                 m_aChildren;
	ByteString           m_aBoundary;

	// Header fields.
	ByteString m_aMIMEVersion;
	ByteString m_aContentBase;
	ByteString m_aContentDescription;
	ByteString m_aContentDisposition;
	ByteString m_aContentID;
	ByteString m_aContentLocation;
	ByteString m_aContentType;
	ByteString m_aContentTransferEncoding;

#if (defined (_INETCOREMSG_CXX) || defined (_INETCORESTRM_CXX))
	// Generator/Parser.
	friend class INetCoreMIMEMessageStream;

	ByteString GetDefaultContentType_Impl (void) const;
	void  SetChildCount_Impl (ULONG nCount);

	const ByteString& GetMultipartBoundary_Impl (void) const;

	const ByteString& GetMIMEVersion_Impl             (void) const;
	const ByteString& GetContentBase_Impl             (void) const;
	const ByteString& GetContentDescription_Impl      (void) const;
	const ByteString& GetContentDisposition_Impl      (void) const;
	const ByteString& GetContentID_Impl               (void) const;
	const ByteString& GetContentLocation_Impl         (void) const;
	const ByteString& GetContentType_Impl             (void) const;
	const ByteString& GetContentTransferEncoding_Impl (void) const;

	void  SetMIMEVersion_Impl             (const ByteString& rValue);
	void  SetContentBase_Impl             (const ByteString& rValue);
	void  SetContentDescription_Impl      (const ByteString& rValue);
	void  SetContentDisposition_Impl      (const ByteString& rValue);
	void  SetContentID_Impl               (const ByteString& rValue);
	void  SetContentLocation_Impl         (const ByteString& rValue);
	void  SetContentType_Impl             (const ByteString& rValue);
	void  SetContentTransferEncoding_Impl (const ByteString& rValue);
#endif /* _INETCOREMSG_CXX || _INETCORESTRM_CXX */

	// Not implemented.
	INetCoreMIMEMessage (const INetCoreMIMEMessage& rMsg);
	INetCoreMIMEMessage& operator= (const INetCoreMIMEMessage& rMsg);

protected:
	virtual SvStream& operator<< (SvStream& rStrm) const;
	virtual SvStream& operator>> (SvStream& rStrm);

	void  SetMultipartBoundary_Impl (const ByteString& rValue);

public:
	INetCoreMIMEMessage (void);
	virtual ~INetCoreMIMEMessage (void);

	// MessageStream factory.
	virtual INetCoreMIMEMessageStream *CreateMessageStream (void) const;

	// Header fields.
	UniString GetMIMEVersion             (void) const;
	UniString GetContentBase             (void) const;
	UniString GetContentDescription      (void) const;
	UniString GetContentDisposition      (void) const;
	UniString GetContentID               (void) const;
	UniString GetContentLocation         (void) const;
	UniString GetContentType             (void) const;
	UniString GetContentTransferEncoding (void) const;

	void  SetMIMEVersion             (const UniString& rValue);
	void  SetContentBase             (const UniString& rValue);
	void  SetContentDescription      (const UniString& rValue);
	void  SetContentDisposition      (const UniString& rValue);
	void  SetContentID               (const UniString& rValue);
	void  SetContentLocation         (const UniString& rValue);
	void  SetContentType             (const UniString& rValue);
	void  SetContentTransferEncoding (const UniString& rValue);

	// Message container methods.
	inline  BOOL  IsContainer (void) const;
	inline  BOOL  IsMessage   (void) const;
	inline  BOOL  IsMultipart (void) const;

	inline  ULONG                GetChildCount (void) const;
	inline  INetCoreMIMEMessage* GetChild      (ULONG nIndex) const;
	inline  INetCoreMIMEMessage* GetParent     (void) const;

	virtual BOOL EnableAttachChild (
		INetCoreMessageContainerType eType = INETCOREMSG_MULTIPART_MIXED);
	virtual BOOL AttachChild (
		INetCoreMIMEMessage& rChildMsg);
	virtual BOOL DetachChild (
		ULONG nIndex, INetCoreMIMEMessage& rChildMsg) const;

	// Stream operators.
	friend SvStream& operator<< (
		SvStream& rStrm, const INetCoreMIMEMessage& rMsg)
	{
		return rMsg.operator<< (rStrm);
	}

	friend SvStream& operator>> (
		SvStream& rStrm, INetCoreMIMEMessage& rMsg)
	{
		return rMsg.operator>> (rStrm);
	}
};

/*
 * MIMEVersion.
 */
inline UniString INetCoreMIMEMessage::GetMIMEVersion (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aMIMEVersion);
}

inline void INetCoreMIMEMessage::SetMIMEVersion (const UniString& rValue)
{
	m_aMIMEVersion = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * ContentBase.
 */
inline UniString INetCoreMIMEMessage::GetContentBase (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_TEXT, m_aContentBase);
}

inline void INetCoreMIMEMessage::SetContentBase (const UniString& rValue)
{
	m_aContentBase = Encode_Impl (INetMIME::HEADER_FIELD_TEXT, rValue);
}

/*
 * ContentDescription.
 */
inline UniString INetCoreMIMEMessage::GetContentDescription (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_TEXT, m_aContentDescription);
}

inline void
INetCoreMIMEMessage::SetContentDescription (const UniString& rValue)
{
	m_aContentDescription = Encode_Impl (
		INetMIME::HEADER_FIELD_TEXT, rValue);
}

/*
 * ContentDisposition.
 */
inline UniString INetCoreMIMEMessage::GetContentDisposition (void) const
{
	return Decode_Impl (
		INetMIME::HEADER_FIELD_STRUCTURED, m_aContentDisposition);
}

inline void
INetCoreMIMEMessage::SetContentDisposition (const UniString& rValue)
{
	m_aContentDisposition = Encode_Impl (
		INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * ContentID.
 */
inline UniString INetCoreMIMEMessage::GetContentID (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_MESSAGE_ID, m_aContentID);
}

inline void INetCoreMIMEMessage::SetContentID (const UniString& rValue)
{
	m_aContentID = Encode_Impl (INetMIME::HEADER_FIELD_MESSAGE_ID, rValue);
}

/*
 * ContentLocation.
 */
inline UniString INetCoreMIMEMessage::GetContentLocation (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_TEXT, m_aContentLocation);
}

inline void INetCoreMIMEMessage::SetContentLocation (const UniString& rValue)
{
	m_aContentLocation = Encode_Impl (INetMIME::HEADER_FIELD_TEXT, rValue);
}

/*
 * ContentType.
 */
inline UniString INetCoreMIMEMessage::GetContentType (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aContentType);
}

inline void INetCoreMIMEMessage::SetContentType (const UniString& rValue)
{
	m_aContentType = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * ContentTransferEncoding.
 */
inline UniString INetCoreMIMEMessage::GetContentTransferEncoding (void) const
{
	return Decode_Impl (
		INetMIME::HEADER_FIELD_STRUCTURED, m_aContentTransferEncoding);
}

inline void
INetCoreMIMEMessage::SetContentTransferEncoding (const UniString& rValue)
{
	m_aContentTransferEncoding = Encode_Impl (
		INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * Message container methods.
 */
inline BOOL INetCoreMIMEMessage::IsMessage (void) const
{
	return (m_aContentType.CompareIgnoreCaseToAscii ("message/", 8) == 0);
}

inline BOOL INetCoreMIMEMessage::IsMultipart (void) const
{
	return (m_aContentType.CompareIgnoreCaseToAscii ("multipart/", 10) == 0);
}

inline BOOL INetCoreMIMEMessage::IsContainer (void) const
{
	return (IsMessage() || IsMultipart());
}

inline ULONG INetCoreMIMEMessage::GetChildCount (void) const
{
	return m_nChildren;
}

inline INetCoreMIMEMessage* INetCoreMIMEMessage::GetChild (ULONG nIndex) const
{
	return (INetCoreMIMEMessage*)(m_aChildren.GetObject (nIndex));
}

inline INetCoreMIMEMessage* INetCoreMIMEMessage::GetParent (void) const
{
	return m_pParent;
}

/*=========================================================================
 *
 * INetCoreNewsMessage Interface.
 *
 *=======================================================================*/
class INetCoreNewsMessage : public INetCoreMIMEMessage
{
	// Required header fields.
	ByteString m_aNewsgroups;
	ByteString m_aPath;

	// Optional header fields.
	ByteString m_aApproved;
	ByteString m_aBytes;
	ByteString m_aControl;
	ByteString m_aDistribution;
	ByteString m_aExpires;
	ByteString m_aFollowupTo;
	ByteString m_aLines;
	ByteString m_aOrganization;
	ByteString m_aSummary;
	ByteString m_aXref;
	ByteString m_aXNewsreader;

#if (defined (_INETCOREMSG_CXX) || defined (_INETCORESTRM_CXX))
	// Generator/Parser.
	friend class INetCoreNewsMessageStream;

	const ByteString& GetNewsgroups_Impl   (void) const;
	const ByteString& GetPath_Impl         (void) const;

	void  SetNewsgroups_Impl (const ByteString& rValue);
	void  SetPath_Impl       (const ByteString& rValue);

	const ByteString& GetApproved_Impl     (void) const;
	const ByteString& GetBytes_Impl        (void) const;
	const ByteString& GetControl_Impl      (void) const;
	const ByteString& GetDistribution_Impl (void) const;
	const ByteString& GetExpires_Impl      (void) const;
	const ByteString& GetFollowupTo_Impl   (void) const;
	const ByteString& GetLines_Impl        (void) const;
	const ByteString& GetOrganization_Impl (void) const;
	const ByteString& GetSummary_Impl      (void) const;
	const ByteString& GetXref_Impl         (void) const;
	const ByteString& GetXNewsreader_Impl  (void) const;

	void  SetApproved_Impl     (const ByteString& rValue);
	void  SetBytes_Impl        (const ByteString& rValue);
	void  SetControl_Impl      (const ByteString& rValue);
	void  SetDistribution_Impl (const ByteString& rValue);
	void  SetExpires_Impl      (const ByteString& rValue);
	void  SetFollowupTo_Impl   (const ByteString& rValue);
	void  SetLines_Impl        (const ByteString& rValue);
	void  SetOrganization_Impl (const ByteString& rValue);
	void  SetSummary_Impl      (const ByteString& rValue);
	void  SetXref_Impl         (const ByteString& rValue);
	void  SetXNewsreader_Impl  (const ByteString& rValue);
#endif /* _INETCOREMSG_CXX || _INETCORESTRM_CXX */

	// Not implemented.
	INetCoreNewsMessage (const INetCoreNewsMessage& rMsg);
	INetCoreNewsMessage& operator= (const INetCoreNewsMessage& rMsg);

protected:
	virtual SvStream& operator<< (SvStream& rStrm) const;
	virtual SvStream& operator>> (SvStream& rStrm);

public:
	INetCoreNewsMessage (void);
	virtual ~INetCoreNewsMessage (void);

	// MessageStream Factory.
	virtual INetCoreMIMEMessageStream *CreateMessageStream (void) const;

	// Required header fields.
	UniString GetNewsgroups   (void) const;
	UniString GetPath         (void) const;

	void  SetNewsgroups (const UniString& rValue);
	void  SetPath       (const UniString& rValue);

	// Optional header fields.
	UniString GetApproved     (void) const;
	UniString GetBytes        (void) const;
	UniString GetControl      (void) const;
	UniString GetDistribution (void) const;
	UniString GetExpires      (void) const;
	UniString GetFollowupTo   (void) const;
	UniString GetLines        (void) const;
	UniString GetOrganization (void) const;
	UniString GetSummary      (void) const;
	UniString GetXref         (void) const;
	UniString GetXNewsreader  (void) const;

	void  SetApproved     (const UniString& rValue);
	void  SetBytes        (const UniString& rValue);
	void  SetControl      (const UniString& rValue);
	void  SetDistribution (const UniString& rValue);
	void  SetExpires      (const UniString& rValue);
	void  SetFollowupTo   (const UniString& rValue);
	void  SetLines        (const UniString& rValue);
	void  SetOrganization (const UniString& rValue);
	void  SetSummary      (const UniString& rValue);
	void  SetXref         (const UniString& rValue);
	void  SetXNewsreader  (const UniString& rValue);

	friend SvStream& operator<< (
		SvStream& rStrm, const INetCoreNewsMessage& rMsg)
	{
		return rMsg.operator<< (rStrm);
	}

	friend SvStream& operator>> (
		SvStream& rStrm, INetCoreNewsMessage& rMsg)
	{
		return rMsg.operator>> (rStrm);
	}
};

/*
 * Newsgroups.
 */
inline UniString INetCoreNewsMessage::GetNewsgroups (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aNewsgroups);
}
inline void INetCoreNewsMessage::SetNewsgroups (const UniString& rValue)
{
	m_aNewsgroups = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * Path.
 */
inline UniString INetCoreNewsMessage::GetPath (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aPath);
}
inline void INetCoreNewsMessage::SetPath (const UniString& rValue)
{
	m_aPath = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * Approved.
 */
inline UniString INetCoreNewsMessage::GetApproved (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_ADDRESS, m_aApproved);
}
inline void INetCoreNewsMessage::SetApproved (const UniString& rValue)
{
	m_aApproved = Encode_Impl (INetMIME::HEADER_FIELD_ADDRESS, rValue);
}

/*
 * Bytes.
 */
inline UniString INetCoreNewsMessage::GetBytes (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aBytes);
}
inline void INetCoreNewsMessage::SetBytes (const UniString& rValue)
{
	m_aBytes = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * Control.
 */
inline UniString INetCoreNewsMessage::GetControl (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_TEXT, m_aControl);
}
inline void INetCoreNewsMessage::SetControl (const UniString& rValue)
{
	m_aControl = Encode_Impl (INetMIME::HEADER_FIELD_TEXT, rValue);
}

/*
 * Distribution.
 */
inline UniString INetCoreNewsMessage::GetDistribution (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aDistribution);
}
inline void INetCoreNewsMessage::SetDistribution (const UniString& rValue)
{
	m_aDistribution = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * Expires.
 */
inline UniString INetCoreNewsMessage::GetExpires (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aExpires);
}
inline void INetCoreNewsMessage::SetExpires (const UniString& rValue)
{
	m_aExpires = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * Followup-To.
 */
inline UniString INetCoreNewsMessage::GetFollowupTo (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aFollowupTo);
}
inline void INetCoreNewsMessage::SetFollowupTo (const UniString& rValue)
{
	m_aFollowupTo = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * Lines.
 */
inline UniString INetCoreNewsMessage::GetLines (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aLines);
}
inline void INetCoreNewsMessage::SetLines (const UniString& rValue)
{
	m_aLines = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * Organization.
 */
inline UniString INetCoreNewsMessage::GetOrganization (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_TEXT, m_aOrganization);
}
inline void INetCoreNewsMessage::SetOrganization (const UniString& rValue)
{
	m_aOrganization = Encode_Impl (INetMIME::HEADER_FIELD_TEXT, rValue);
}

/*
 * Summary.
 */
inline UniString INetCoreNewsMessage::GetSummary (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_TEXT, m_aSummary);
}
inline void INetCoreNewsMessage::SetSummary (const UniString& rValue)
{
	m_aSummary = Encode_Impl (INetMIME::HEADER_FIELD_TEXT, rValue);
}

/*
 * Xref.
 */
inline UniString INetCoreNewsMessage::GetXref (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, m_aXref);
}
inline void INetCoreNewsMessage::SetXref (const UniString& rValue)
{
	m_aXref = Encode_Impl (INetMIME::HEADER_FIELD_STRUCTURED, rValue);
}

/*
 * XNewsreader.
 */
inline UniString INetCoreNewsMessage::GetXNewsreader (void) const
{
	return Decode_Impl (INetMIME::HEADER_FIELD_TEXT, m_aXNewsreader);
}
inline void INetCoreNewsMessage::SetXNewsreader (const UniString& rValue)
{
	m_aXNewsreader = Encode_Impl (INetMIME::HEADER_FIELD_TEXT, rValue);
}

#endif /* !_INETCOREMSG_HXX */



