/*************************************************************************
 *
 *  $RCSfile: cg_gate.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include "cg_gate.hxx"


// NOT FULLY DEFINED SERVICES
#include <ary/idg.hxx>
#include <ary/cpp/cg_proj.hxx>
#include <ary/cpp/cg_file.hxx>
#include <store/g_stgifc.hxx>


namespace ary
{
namespace cpp
{


Gate_Groups::Gate_Groups( ary::store::Groups_Ifc & io_rGroupStorage_Ifc,
                          ary::IdGenerator &       io_rIdGenerator  )
    :   pGroupStorage_Ifc(&io_rGroupStorage_Ifc),
        pIdGenerator(&io_rIdGenerator)
{
    pGroupStorage_Ifc-> Init_TopProject(
            *new ary::TopProject(io_rIdGenerator.Id_TopProject()) );
}

Gate_Groups::~Gate_Groups()
{

}

ProjectGroup &
Gate_Groups::do_CheckIn_ProjectGroup( const udmstri &     i_sName,
                                      Lid                 i_nSourceCodeRootDirectory )
{
    ProjectGroup * ret = pGroupStorage_Ifc->Search_ProjectGroup_Cpp( i_nSourceCodeRootDirectory );
    if ( ret != 0 )
        return *ret;

    ret = new ProjectGroup( pIdGenerator->NewGid(),
                            i_sName,
                            i_nSourceCodeRootDirectory );
    pGroupStorage_Ifc->Add_ProjectGroup_Cpp( *ret );
    pGroupStorage_Ifc->Top().Add_Project( ret->Id_Group() );

    return *ret;
}

FileGroup &
Gate_Groups::do_CheckIn_FileGroup( Lid                 i_nSourceCodeFile,
                                   Gid                 i_nProjectGroup,
                                   const udmstri &     i_sFileName  )
{
    FileGroup * ret = pGroupStorage_Ifc->Search_FileGroup_Cpp( i_nSourceCodeFile );
    if ( ret != 0 )
        return *ret;

    ret = new FileGroup( pIdGenerator->NewGid(),
                         i_nSourceCodeFile,
                         i_sFileName,
                         i_nProjectGroup );
    pGroupStorage_Ifc->Add_FileGroup_Cpp( *ret );
    ProjectGroup * pPrj = pGroupStorage_Ifc->Find_ProjectGroup_Cpp( i_nProjectGroup );
    if ( pPrj != 0 )
        pPrj->Add_File( i_nSourceCodeFile );

    return *ret;
}

const AryGroup *
Gate_Groups::inq_Find_Group( Gid i_nId ) const
{
    return pGroupStorage_Ifc->Find_Group( i_nId );
}

const TopProject &
Gate_Groups::inq_Get_TopProject() const
{
    return pGroupStorage_Ifc->Top();
}

const ProjectGroup *
Gate_Groups::inq_Find_ProjectGroup( Gid i_nId ) const
{
    return pGroupStorage_Ifc->Find_ProjectGroup_Cpp( i_nId );
}

const ProjectGroup *
Gate_Groups::inq_Search_ProjectGroup( const udmstri & i_sProjectName ) const
{
    return pGroupStorage_Ifc->Search_ProjectGroup_Cpp( i_sProjectName );
}

const FileGroup *
Gate_Groups::inq_Search_FileGroup( Lid i_nAssociatedFileId ) const
{
    return pGroupStorage_Ifc->Search_FileGroup_Cpp( i_nAssociatedFileId );
}



}   // namespace cpp
}   // namespace ary

