/*************************************************************************
 *
 *  $RCSfile: cpp_disp.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_CPP_CPP_DISP_HXX
#define ARY_CPP_CPP_DISP_HXX

// USED SERVICES
	// BASE CLASSES
#include <ary/ary_disp.hxx>
	// COMPONENTS
	// PARAMETERS

namespace ary
{

namespace cpp
{
    class ProjectGroup;
    class FileGroup;

    class Namespace;
    class Class;
    class Enum;
    class Typedef;
    class Function;
    class Variable;
    class EnumValue;

    class Define;
    class Macro;

    struct S_Classes_Base;
    class Type;


/** Displaying CodeEntities of ary::cpp .

    @descr
    This class is an interface, but the functions are defaulted,
    to do nothing. so a derived class needn't implement all of them.
*/

class Display : public ary::Display
{
  public:
	virtual 			~Display();

	virtual void	  	Display_ProjectGroup(
							const ary::cpp::ProjectGroup &
												i_rData );
	virtual void	  	Display_FileGroup(
							const ary::cpp::FileGroup &
												i_rData );

    virtual void        Display_Namespace(
                            const Namespace &   i_rData );
    virtual void        Display_Class(
                            const Class &       i_rData );
    virtual void        Display_Enum(
                            const Enum &        i_rData );
    virtual void        Display_Typedef(
                            const Typedef &     i_rData );
    virtual void        Display_Function(
                            const Function &    i_rData );
	virtual void        Display_Variable(
                            const Variable &    i_rData );
    virtual void        Display_EnumValue(
                            const EnumValue &   i_rData );

	virtual void        Display_Define(
							const Define &      i_rData );
	virtual void        Display_Macro(
							const Macro &      	i_rData );

	virtual void		DisplaySlot_BaseClass(
							const S_Classes_Base &
                            					i_rData );
};


}   // namespace cpp
}   // namespace ary

#endif


