/*************************************************************************
 *
 *  $RCSfile: QueryHitData.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.util.PrefixTranslator;
import java.io.*;

public final class QueryHitData implements Externalizable {
    private double             _penalty;
    private String            _document;
    private String            _docType;
    private MultiTokenLocator _locator;
  
    public QueryHitData() { /* for Externalizable */ }
  
    public QueryHitData(double penalty, String document, String[] terms) {
	_penalty = penalty;
	_document = document;
	_locator = new MultiTokenLocator(terms);
    }

    public MultiTokenLocator getLocator() {
	return _locator;
    }

    public void readExternal(ObjectInput in)
	throws ClassNotFoundException, IOException {
	_penalty = in.readDouble();
	_document = (String) in.readObject();
	_docType = (String) in.readObject();
	_locator = new MultiTokenLocator();
	_locator.readExternal(in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
	out.writeDouble(_penalty);
	out.writeObject(_document);
	out.writeObject(_docType);
	_locator.writeExternal(out);
    }

    public void setCommonPath(String path) {
	_locator.setCommonPath(path);
    }

    public String getCommonPath() {
	return _locator.getCommonPath();
    }
  
    public String getPath(int i) {
	return _locator.getPath(i);
    }
  
    public void setMatchLocation(int index, String relPath, int nthToken) {
	_locator.setMatchLocation(index, relPath, nthToken);
    }

    public int getNumberOfTerms() {
	return _locator.getNumberOfTerms();
    }

    public int getTokenNumber(int i) {
	return _locator.getTokenNumber(i);
    }

    public String getTerm(int i) {
	return _locator.getTerm(i);
    }

    public double getPenalty() {
	return _penalty;
    }

    public String getDocument() {
	return _document;
    }
  
    public String getDocumentType() {
	return _docType;
    }

    public void setDocumentType(String docType) {
	_docType = docType;
    }
  
    public QueryHitData translate(PrefixTranslator translator) {
	_document = translator.translatePrefix(_document);
	return this;
    }

    /*
      public String toString() {
      StringBuffer buffer = new StringBuffer(1024);
      buffer.append("QueryHitData:\n\tpenalty=");
      buffer.append(_penalty);
      buffer.append("\n\tdocument=");
      buffer.append(_document);
      buffer.append("\n\tpath=");
      buffer.append(_commonPath);
      for (int i = 0; i < _matchedTerms.length; i++) {
      buffer.append("\n\t\t");
      if (_matchedTerms[i] == null)
      buffer.append("missingTerm");
      else {
      buffer.append("term=");
      buffer.append(_matchedTerms[i]);
      buffer.append(", path=");
      buffer.append(_relativePaths[i]);
      buffer.append(", token=");
      buffer.append(_tokenNumbers[i]);
      }
      }
      return buffer.toString();
      }
  
      public void toElement(StringBuffer buffer) {
      buffer.append("<QueryHit penalty=\"");
      buffer.append(_penalty);
      buffer.append("\" doc=\"");
      buffer.append(_document);
      buffer.append("\"><Matches path=\"");
      buffer.append(_commonPath);
      buffer.append("\">");
      for (int i = 0; i < _matchedTerms.length; i++)
      if (_matchedTerms[i] == null)
      buffer.append("<MissingTerm/>");
      else {
      buffer.append("<Match term=\"");
      buffer.append(_matchedTerms[i]);
      buffer.append("\" path=\"");
      buffer.append(_relativePaths[i]);
      buffer.append("\" tokenNumber=\"");
      buffer.append(_tokenNumbers[i]);
      buffer.append("\"/>");
      }
      buffer.append("</Matches></QueryHit>");
      }
  
      public static String toXml(QueryHitData[] hits) {
      StringBuffer result = new StringBuffer(1024*8);
      result.append("<QueryResults>");
      for (int i = 0; i < hits.length; i++)
      if (hits[i] != null)
      hits[i].toElement(result);
      else
      break;
      result.append("</QueryResults>");
      return result.toString();
      }
    */
}
