/*************************************************************************
 *
 *  $RCSfile: StreamDecompressor.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.util;

import java.io.*;

public final class StreamDecompressor extends Decompressor {
  private InputStream _input;
  
  public StreamDecompressor(InputStream input) {
    initReading(input);
  }

  public void initReading(InputStream input) {
    _input = input;
    initReading();
  }
  
  public int getNextByte() throws java.io.IOException {
    return _input.read();
  }

  /*  main is for testing
  public static void main(String[] args) {
    try {
      FileInputStream file = new FileInputStream(args[0]);
      try {
	int k1 = file.read();
	long start = System.currentTimeMillis();
	System.out.println("k1 = " + k1);
	IntegerArray concepts = new IntegerArray();
	StreamDecompressor documents = new StreamDecompressor(file);
	try {
	  documents.ascDecode(k1, concepts);
	}
	catch (Exception e) {
	  System.err.println(e);
	}
	System.out.println("index1 = " + concepts.cardinality());
	int k2 = file.read();
	System.out.println("k2 = " + k2);
	IntegerArray offs = new IntegerArray(concepts.cardinality());
	StreamDecompressor offsets = new StreamDecompressor(file);
	try {
	  offsets.decode(k2, offs);
	}
	catch (Exception e) {
	  System.err.println(e);
	}
	System.out.println("index2 = " + offs.cardinality());
	System.out.println((System.currentTimeMillis() - start) + " msec");
	file.close();
      }
      catch (IOException e) {
	System.err.println(e);
      }
    }
    catch (FileNotFoundException e) {
      System.err.println(e);
    }
  }
  */
}
