/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

class TableSheetCell
extends AbstractCellEditor
implements TableModelListener,
PropertyChangeListener,
TableCellEditor,
TableCellRenderer {
    private NodeTableModel tableModel;
    private Boolean flat;
    private WrapperPropertyModel propModel;
    private Node node;
    private Node.Property prop;
    private TableCellRenderer headerRenderer = new JTableHeader().getDefaultRenderer();
    private NullPanel nullPanel;
    private Border nullPanelBorder;
    private Border nullPanelFocusBorder;
    private HashMap panelCache = new HashMap();
    static /* synthetic */ Class class$org$openide$explorer$view$TableSheetCell;

    public TableSheetCell(NodeTableModel nodeTableModel) {
        this.tableModel = nodeTableModel;
        this.setFlat(false);
    }

    public void setFlat(boolean bl) {
        this.nullPanelBorder = bl ? new EmptyBorder(1, 1, 1, 1) : new CompoundBorder(new MatteBorder(0, 0, 1, 1, SystemColor.controlDkShadow), new MatteBorder(1, 1, 0, 0, SystemColor.controlLtHighlight));
        this.nullPanelFocusBorder = new CompoundBorder(new CompoundBorder(this.nullPanelBorder, new EmptyBorder(1, 1, 1, 1)), new MatteBorder(1, 1, 1, 1, UIManager.getColor("Button.focus")));
        this.flat = new Boolean(bl);
    }

    public Object getCellEditorValue() {
        return null;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.prop = (Node.Property)object;
        this.node = this.tableModel.nodeForRow(n);
        this.propModel = new WrapperPropertyModel(this.node, this.prop);
        this.node.addPropertyChangeListener(this);
        this.tableModel.addTableModelListener(this);
        FocusHackedPropertyPanel focusHackedPropertyPanel = new FocusHackedPropertyPanel(this.propModel, this.prop.canWrite() ? 0 : 1);
        focusHackedPropertyPanel.putClientProperty("flat", this.flat);
        focusHackedPropertyPanel.setBackground(jTable.getSelectionBackground());
        return focusHackedPropertyPanel;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                if (TableSheetCell.this.propModel != null) {
                    TableSheetCell.this.propModel.firePropertyChange();
                }
            }
        });
    }

    public boolean stopCellEditing() {
        if (this.prop != null) {
            this.detachEditor();
        }
        return super.stopCellEditing();
    }

    public void cancelCellEditing() {
        if (this.prop != null) {
            this.detachEditor();
        }
        super.cancelCellEditing();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.cancelCellEditing();
    }

    private void detachEditor() {
        this.node.removePropertyChangeListener(this);
        this.tableModel.removeTableModelListener(this);
        this.node = null;
        this.prop = null;
        this.propModel = null;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n == -1) {
            Component component = this.headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JComponent) {
                String string = n2 > 0 ? this.tableModel.propertyForColumn(n2).getShortDescription() : jTable.getColumnName(0);
                ((JComponent)component).setToolTipText(string);
            }
            return component;
        }
        Node.Property property = (Node.Property)object;
        Node node = this.tableModel.nodeForRow(n);
        if (property != null) {
            Integer n3 = new Integer(node.hashCode() * property.hashCode());
            FocusedPropertyPanel focusedPropertyPanel = (FocusedPropertyPanel)this.panelCache.get(n3);
            if (focusedPropertyPanel == null) {
                WrapperPropertyModel wrapperPropertyModel = new WrapperPropertyModel(node, property);
                focusedPropertyPanel = new FocusedPropertyPanel(wrapperPropertyModel, 0);
                focusedPropertyPanel.putClientProperty("flat", this.flat);
                this.panelCache.put(n3, focusedPropertyPanel);
            } else {
                ((WrapperPropertyModel)focusedPropertyPanel.getModel()).firePropertyChange();
            }
            focusedPropertyPanel.setFocused(bl2);
            focusedPropertyPanel.setToolTipText(property.getShortDescription());
            focusedPropertyPanel.setOpaque(true);
            if (bl) {
                focusedPropertyPanel.setBackground(jTable.getSelectionBackground());
            } else {
                focusedPropertyPanel.setBackground(jTable.getBackground());
            }
            return focusedPropertyPanel;
        }
        if (this.nullPanel == null) {
            this.nullPanel = new NullPanel(node);
            this.nullPanel.setOpaque(true);
        } else {
            this.nullPanel.setNode(node);
        }
        if (bl) {
            this.nullPanel.setBackground(jTable.getSelectionBackground());
        } else {
            this.nullPanel.setBackground(jTable.getBackground());
        }
        if (bl2) {
            this.nullPanel.setBorder(this.nullPanelFocusBorder);
        } else {
            this.nullPanel.setBorder(this.nullPanelBorder);
        }
        return this.nullPanel;
    }

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$view$TableSheetCell == null ? (class$org$openide$explorer$view$TableSheetCell = TableSheetCell.class$("org.openide.explorer.view.TableSheetCell")) : class$org$openide$explorer$view$TableSheetCell).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FocusHackedPropertyPanel
    extends PropertyPanel {
        public FocusHackedPropertyPanel(PropertyModel propertyModel, int n) {
            super(propertyModel, n);
        }

        public void requestFocus() {
            this.requestDefaultFocus();
        }

        public void addNotify() {
            super.addNotify();
            this.requestFocus();
        }
    }

    private static class FocusedPropertyPanel
    extends PropertyPanel {
        boolean focused;

        public FocusedPropertyPanel(PropertyModel propertyModel, int n) {
            super(propertyModel, n);
        }

        public void setFocused(boolean bl) {
            this.focused = bl;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.focused) {
                graphics.setColor(UIManager.getColor("Button.focus"));
                graphics.drawRect(2, 1, this.getWidth() - 5, this.getHeight() - 4);
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleFocusedPropertyPanel();
            }
            return this.accessibleContext;
        }

        private class AccessibleFocusedPropertyPanel
        extends JComponent.AccessibleJComponent {
            private AccessibleFocusedPropertyPanel() {
                super(FocusedPropertyPanel.this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }

            public String getAccessibleName() {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getFeatureDescriptor();
                PropertyEditor propertyEditor = FocusedPropertyPanel.this.getPropertyEditor();
                return MessageFormat.format(TableSheetCell.getString("ACS_PropertyPanelRenderer"), featureDescriptor.getDisplayName(), propertyEditor == null ? TableSheetCell.getString("CTL_No_value") : propertyEditor.getAsText());
            }

            public String getAccessibleDescription() {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getFeatureDescriptor();
                Node node = (Node)((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getBeans()[0];
                Class clazz = FocusedPropertyPanel.this.getModel().getPropertyType();
                return MessageFormat.format(TableSheetCell.getString("ACSD_PropertyPanelRenderer"), featureDescriptor.getShortDescription(), clazz == null ? TableSheetCell.getString("CTL_No_type") : clazz.getName(), node.getDisplayName());
            }
        }
    }

    private static class NullPanel
    extends JPanel {
        Node node;

        NullPanel(Node node) {
            this.node = node;
        }

        void setNode(Node node) {
            this.node = node;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleNullPanel();
            }
            return this.accessibleContext;
        }

        private class AccessibleNullPanel
        extends JPanel.AccessibleJPanel {
            private AccessibleNullPanel() {
                super(NullPanel.this);
            }

            public String getAccessibleName() {
                String string = super.getAccessibleName();
                if (string == null) {
                    string = TableSheetCell.getString("ACS_NullPanel");
                }
                return string;
            }

            public String getAccessibleDescription() {
                String string = super.getAccessibleDescription();
                if (string == null) {
                    string = MessageFormat.format(TableSheetCell.getString("ACSD_NullPanel"), NullPanel.this.node.getDisplayName());
                }
                return string;
            }
        }
    }

    private static class WrapperPropertyModel
    implements ExPropertyModel {
        PropertyChangeSupport support = new PropertyChangeSupport(this);
        Node.Property prop;
        Node node;

        public WrapperPropertyModel(Node node, Node.Property property) {
            this.prop = property;
            this.node = node;
        }

        public Object getValue() throws InvocationTargetException {
            try {
                return this.prop.getValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorManager.getDefault().notify(1, illegalAccessException);
                throw new InvocationTargetException(illegalAccessException);
            }
        }

        public void setValue(Object object) throws InvocationTargetException {
            if (!this.prop.canWrite()) {
                return;
            }
            try {
                this.prop.setValue(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorManager.getDefault().notify(1, illegalAccessException);
                throw new InvocationTargetException(illegalAccessException);
            }
        }

        public Class getPropertyType() {
            return this.prop.getValueType();
        }

        public Class getPropertyEditorClass() {
            return this.prop.getPropertyEditor().getClass();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }

        public void firePropertyChange() {
            this.support.firePropertyChange("value", null, null);
        }

        public Object[] getBeans() {
            return new Object[]{this.node};
        }

        public FeatureDescriptor getFeatureDescriptor() {
            return this.prop;
        }
    }
}

