/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.jarpackager.ContentMember;
import org.netbeans.modules.jarpackager.DataObjectList;
import org.netbeans.modules.jarpackager.JarCreator;
import org.netbeans.modules.jarpackager.api.ArchiveFilter;
import org.netbeans.modules.jarpackager.api.ArchiveMember;
import org.netbeans.modules.jarpackager.api.ArchiveMemberSet;
import org.netbeans.modules.jarpackager.util.JarUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class ContentMemberList
extends ArrayList
implements Serializable {
    static final long serialVersionUID = 7194592824986427208L;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ContentMemberList;

    public ContentMemberList() {
    }

    public ContentMemberList(Collection collection) {
        super(collection);
    }

    public ContentMemberList(int n) {
        super(n);
    }

    public ContentMemberList(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            Object object;
            Object object2;
            Object e = arrayList.get(n);
            if (e instanceof ContentMember) {
                this.add(e);
            } else if (e instanceof DataObject) {
                this.addMember((DataObject)e);
            } else if (e instanceof FileObject) {
                object2 = (FileObject)e;
                try {
                    object = DataObject.find((FileObject)object2);
                    this.addMember((DataObject)object);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ContentMemberList == null ? ContentMemberList.class$("org.netbeans.modules.jarpackager.ContentMemberList") : class$org$netbeans$modules$jarpackager$ContentMemberList)).getString("FMT_ContentFileNotFound");
                    System.out.println(MessageFormat.format(string, object2));
                }
            } else {
                object2 = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ContentMemberList == null ? ContentMemberList.class$("org.netbeans.modules.jarpackager.ContentMemberList") : class$org$netbeans$modules$jarpackager$ContentMemberList)).getString("FMT_ContentBadClass`");
                object = e.getClass().getName();
                System.out.println(MessageFormat.format((String)object2, object));
            }
            ++n;
        }
    }

    public boolean addMember(DataObject dataObject) {
        if (this.findDataObject(dataObject) == -1) {
            ContentMember contentMember = new ContentMember();
            contentMember.dataObject = dataObject;
            contentMember.isRecursive = true;
            this.add(contentMember);
            return true;
        }
        return false;
    }

    public boolean addMember(DataObject dataObject, String string) {
        if (this.findDataObject(dataObject) == -1) {
            ContentMember contentMember = new ContentMember();
            contentMember.dataObject = dataObject;
            contentMember.targetDirectory = string;
            contentMember.isRecursive = true;
            this.add(contentMember);
            return true;
        }
        return false;
    }

    public void addList(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            Object e = arrayList.get(n);
            if (e instanceof DataObject) {
                this.addMember((DataObject)e);
            } else if (e instanceof ContentMember) {
                this.add(e);
            }
            ++n;
        }
    }

    public boolean removeMember(DataObject dataObject) {
        int n = this.findDataObject(dataObject);
        if (n != -1) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public boolean removeMember(int n) {
        if (n >= 0 && n < this.size()) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public int findDataObject(DataObject dataObject) {
        int n = 0;
        while (n < this.size()) {
            ContentMember contentMember = (ContentMember)this.get(n);
            if (contentMember.getDataObject().equals(dataObject)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public List getAllFiles(ArchiveFilter archiveFilter) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.size()) {
            ContentMember contentMember = (ContentMember)this.get(n);
            this.addFiles(arrayList, contentMember.getDataObject(), contentMember.isRecursive, archiveFilter, contentMember.getFilter());
            ++n;
        }
        return arrayList;
    }

    private void addFiles(List list, DataObject dataObject, boolean bl, ArchiveFilter archiveFilter, ArchiveFilter archiveFilter2) {
        FileObject fileObject;
        Object object;
        if (dataObject instanceof DataFolder) {
            object = ((DataFolder)dataObject).children(false);
            while (object.hasMoreElements()) {
                fileObject = (DataObject)object.nextElement();
                if (!bl && fileObject instanceof DataFolder) continue;
                this.addFiles(list, dataObject, bl, archiveFilter, archiveFilter2);
            }
        }
        object = dataObject.files().iterator();
        while (object.hasNext()) {
            fileObject = (FileObject)object.next();
            if (archiveFilter != null && !archiveFilter.accept(fileObject)) {
                fileObject = null;
            }
            if (fileObject != null && archiveFilter2 != null && !archiveFilter2.accept(fileObject)) {
                fileObject = null;
            }
            if (fileObject == null) continue;
            list.add(fileObject);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ArchiveMemberSetImpl
    implements ArchiveMemberSet {
        private Map entries = new HashMap();
        private ArchiveMember[] members = null;
        private boolean changed = false;

        ArchiveMemberSetImpl(ContentMemberList contentMemberList) {
            int n = 0;
            while (n < contentMemberList.size()) {
                ContentMember contentMember = (ContentMember)contentMemberList.get(n);
                ContentMember contentMember2 = contentMember.resolve();
                if (contentMember2.dataObject instanceof DataFolder) {
                    List list = this.expandFolder(contentMember2, contentMember2.isRecursive);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ContentMember contentMember3 = (ContentMember)iterator.next();
                        contentMember3.setFilter(contentMember2.filter);
                        this.addEntry(contentMember3);
                    }
                } else {
                    this.addEntry(contentMember2.dataObject, contentMember2.filter, contentMember2.targetDirectory);
                }
                ++n;
            }
        }

        ArchiveMemberSetImpl(DataObjectList dataObjectList) {
            this(new ContentMemberList(dataObjectList));
        }

        int size() {
            return this.entries.size();
        }

        void setChanged() {
            this.changed = true;
            this.members = null;
        }

        void setUnchanged() {
            this.changed = false;
        }

        boolean wasChanged() {
            return this.changed;
        }

        public ArchiveMember[] allMembers() {
            if (this.members == null) {
                ArchiveMember[] archiveMemberArray = new ArchiveMember[this.entries.size()];
                this.members = this.entries.values().toArray(archiveMemberArray);
            }
            return this.members;
        }

        public int addMember(DataObject dataObject, ArchiveFilter archiveFilter, String string) {
            return this.addMember(dataObject, archiveFilter, string, false);
        }

        private int addMember(DataObject dataObject, ArchiveFilter archiveFilter, String string, boolean bl) {
            int n = 0;
            if (dataObject instanceof DataFolder) {
                List list = ArchiveMemberSetImpl.expandFolder((DataFolder)dataObject, bl, string);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ContentMember contentMember = (ContentMember)iterator.next();
                    contentMember.filter = archiveFilter;
                    if (!this.addEntry(contentMember)) continue;
                    ++n;
                }
            } else if (this.addEntry(dataObject, archiveFilter, string)) {
                ++n;
            }
            return n;
        }

        public int removeMember(DataObject dataObject) {
            int n = 0;
            if (dataObject instanceof DataFolder) {
                List list = ArchiveMemberSetImpl.expandFolder((DataFolder)dataObject, false, null);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ContentMember contentMember = (ContentMember)iterator.next();
                    if (this.entries.remove(contentMember.dataObject) == null) continue;
                    this.setChanged();
                    ++n;
                }
            } else if (this.entries.remove(dataObject) != null) {
                this.setChanged();
                ++n;
            }
            return n;
        }

        public ArchiveMember getMember(DataObject dataObject) {
            return (ArchiveMember)this.entries.get(dataObject);
        }

        public ArchiveMember[] getMembers(DataFolder dataFolder) {
            Object object;
            ArrayList arrayList = new ArrayList();
            List list = ArchiveMemberSetImpl.expandFolder(dataFolder, false, null);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (ContentMember)iterator.next();
                Object v = this.entries.get(object.dataObject);
                if (v == null) continue;
                arrayList.add(v);
            }
            object = new ArchiveMember[arrayList.size()];
            return arrayList.toArray((T[])object);
        }

        private boolean addEntry(DataObject dataObject, ArchiveFilter archiveFilter, String string) {
            if (this.entries.get(dataObject) == null) {
                this.entries.put(dataObject, new ContentMember(dataObject, archiveFilter, string));
                this.setChanged();
                return true;
            }
            return false;
        }

        private boolean addEntry(ContentMember contentMember) {
            if (this.entries.get(contentMember.dataObject) == null) {
                this.entries.put(contentMember.dataObject, contentMember);
                this.setChanged();
                return true;
            }
            return false;
        }

        private List expandFolder(ContentMember contentMember, boolean bl) {
            return ArchiveMemberSetImpl.expandFolder((DataFolder)contentMember.dataObject, bl, contentMember.targetDirectory);
        }

        static List expandFolder(DataFolder dataFolder, boolean bl, String string) {
            string = JarCreator.getCanonicalTargetName(string);
            ArrayList<ContentMember> arrayList = new ArrayList<ContentMember>();
            Enumeration enumeration = dataFolder.children(false);
            while (enumeration.hasMoreElements()) {
                DataObject dataObject = JarUtils.resolve((DataObject)enumeration.nextElement());
                if (!(dataObject instanceof DataFolder)) {
                    arrayList.add(new ContentMember(dataObject, null, string));
                    continue;
                }
                if (!bl) continue;
                String string2 = null;
                if ("<root>".equals(string)) {
                    string2 = dataObject.getName();
                } else if (string != null) {
                    string2 = string + dataObject.getName();
                }
                List list = ArchiveMemberSetImpl.expandFolder((DataFolder)dataObject, bl, string2);
                arrayList.addAll(list);
            }
            return arrayList;
        }
    }
}

