/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.ui.about;

import com.jrefinery.ui.SortableTableModel;
import com.jrefinery.ui.about.SystemProperty;
import com.jrefinery.ui.about.SystemPropertyComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class SystemPropertiesTableModel
extends SortableTableModel {
    private List properties = new ArrayList();
    private String nameColumnLabel;
    private String valueColumnLabel;

    public SystemPropertiesTableModel() {
        Object object;
        String string;
        Properties properties = System.getProperties();
        Iterator iterator = ((Hashtable)properties).keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = System.getProperty(string);
            SystemProperty systemProperty = new SystemProperty(string, (String)object);
            this.properties.add(systemProperty);
        }
        Collections.sort(this.properties, new SystemPropertyComparator(true));
        string = "com.jrefinery.ui.about.resources.AboutResources";
        object = ResourceBundle.getBundle(string);
        this.nameColumnLabel = ((ResourceBundle)object).getString("system-properties-table.column.name");
        this.valueColumnLabel = ((ResourceBundle)object).getString("system-properties-table.column.value");
    }

    public boolean isSortable(int n) {
        return n == 0;
    }

    public int getRowCount() {
        return this.properties.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return this.nameColumnLabel;
        }
        return this.valueColumnLabel;
    }

    public Object getValueAt(int n, int n2) {
        SystemProperty systemProperty = (SystemProperty)this.properties.get(n);
        if (n2 == 0) {
            return systemProperty.getName();
        }
        if (n2 == 1) {
            return systemProperty.getValue();
        }
        return null;
    }

    public void sortByColumn(int n, boolean bl) {
        if (this.isSortable(n)) {
            super.sortByColumn(n, bl);
            Collections.sort(this.properties, new SystemPropertyComparator(bl));
        }
    }
}

