/*
 * Copyright (C) 2014 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "ToThisStatus.h"

namespace JSC {

ToThisStatus merge(ToThisStatus a, ToThisStatus b)
{
    switch (a) {
    case ToThisOK:
        return b;
    case ToThisConflicted:
        return ToThisConflicted;
    case ToThisClearedByGC:
        if (b == ToThisConflicted)
            return ToThisConflicted;
        return ToThisClearedByGC;
    }

    RELEASE_ASSERT_NOT_REACHED();
    return ToThisConflicted;
}

} // namespace JSC

namespace WTF {

using namespace JSC;

void printInternal(PrintStream& out, ToThisStatus status)
{
    switch (status) {
    case ToThisOK:
        out.print("OK");
        return;
    case ToThisConflicted:
        out.print("Conflicted");
        return;
    case ToThisClearedByGC:
        out.print("ClearedByGC");
        return;
    }

    RELEASE_ASSERT_NOT_REACHED();
}

} // namespace WTF

