/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/
#ifndef __OPENCV_EXPOSURE_COMPENSATE_HPP__
#define __OPENCV_EXPOSURE_COMPENSATE_HPP__

#include "precomp.hpp"


class ExposureCompensator
{
public:
    enum { NO, GAIN, GAIN_BLOCKS };
    static cv::Ptr<ExposureCompensator> createDefault(int type);

    void feed(const std::vector<cv::Point> &corners, const std::vector<cv::Mat> &images, 
              const std::vector<cv::Mat> &masks);
    virtual void feed(const std::vector<cv::Point> &corners, const std::vector<cv::Mat> &images, 
                      const std::vector<std::pair<cv::Mat,uchar> > &masks) = 0;
    virtual void apply(int index, cv::Point corner, cv::Mat &image, const cv::Mat &mask) = 0;
};


class NoExposureCompensator : public ExposureCompensator
{
public:
    void feed(const std::vector<cv::Point> &/*corners*/, const std::vector<cv::Mat> &/*images*/, 
              const std::vector<std::pair<cv::Mat,uchar> > &/*masks*/) {};
    void apply(int /*index*/, cv::Point /*corner*/, cv::Mat &/*image*/, const cv::Mat &/*mask*/) {};
};


class GainCompensator : public ExposureCompensator
{
public:
    void feed(const std::vector<cv::Point> &corners, const std::vector<cv::Mat> &images, 
              const std::vector<std::pair<cv::Mat,uchar> > &masks);
    void apply(int index, cv::Point corner, cv::Mat &image, const cv::Mat &mask);
    std::vector<double> gains() const;

private:
    cv::Mat_<double> gains_;
};


class BlocksGainCompensator : public ExposureCompensator
{
public:
    BlocksGainCompensator(int bl_width = 32, int bl_height = 32) 
            : bl_width_(bl_width), bl_height_(bl_height) {}
    void feed(const std::vector<cv::Point> &corners, const std::vector<cv::Mat> &images, 
              const std::vector<std::pair<cv::Mat,uchar> > &masks);
    void apply(int index, cv::Point corner, cv::Mat &image, const cv::Mat &mask);

private:
    int bl_width_, bl_height_;
    std::vector<cv::Mat_<float> > gain_maps_;
};

#endif // __OPENCV_EXPOSURE_COMPENSATE_HPP__