/*
 * Copyright 2000, International Business Machines Corporation and others.
 * All Rights Reserved.
 * 
 * This software has been released under the terms of the IBM Public
 * License.  For details, see the LICENSE file in the top-level source
 * directory or online at http://www.openafs.org/dl/license10.html
 */

#define IDS_SVR_LISTS_TITLE             0
#define IDS_TAB_SERVICES                1
#define IDS_TAB_AGGREGATES              2
#define IDS_TAB_FILESETS                3
#define IDS_SERVICE_NONESELECTED        4
#define IDS_SERVICE_GOTSELECTED         5
#define IDS_AGGREGATE_ALL               6
#define IDS_AGGREGATE_ONE               7
#define IDS_FILESET_ALL                 8
#define IDS_FILESET_ONE                 9
#define IDS_SVR_LISTS_TAB               10
#define IDS_SVR_PROP_TITLE              11
#define IDS_SVR_GENERAL_TAB             12
#define IDS_SVR_SCOUT_TAB               13
#define IDS_SERVER_TITLE                14

#define IDS_SERVER_DESC                 16
#define IDS_SVC_PROP_TITLE              17
#define IDS_SVC_GENERAL_TAB             18
#define IDS_SVC_ADD_TITLE               19
#define IDS_SVC_ADD_TAB                 20
#define IDS_AGG_PROP_TITLE              21
#define IDS_AGG_GENERAL_TAB             22
#define IDS_SET_REP_TITLE               23
#define IDS_SET_REPSITES_TAB            24
#define IDS_SET_PROP_TITLE              25
#define IDS_SET_GENERAL_TAB             26
#define IDS_SET_UNLOCKBTN               27
#define IDS_SET_LOCKBTN                 28

#define IDS_USAGE_FILESET               32
#define IDS_USAGE_AGGREGATE             33

#define IDS_AGGCOL_ALLOCATED            48
#define IDS_SVRCOL_NAME                 49
#define IDS_SVRCOL_STATUS               50
#define IDS_SETCOL_DATE_ACCESS          51
#define IDS_SETCOL_DATE_BACKUP          52
#define IDS_SVCCOL_NAME                 53
#define IDS_SVCCOL_TYPE                 54
#define IDS_SVCCOL_PARAMS               55
#define IDS_SVCCOL_STATUS               56

#define IDS_SVCCOL_DATE_START           64
#define IDS_SVCCOL_DATE_STOP            65
#define IDS_SVCCOL_DATE_STARTSTOP       66
#define IDS_SVCCOL_DATE_FAILED          67
#define IDS_SVCCOL_LASTERROR            68
#define IDS_AGGCOL_NAME                 69
#define IDS_AGGCOL_ID                   70
#define IDS_AGGCOL_DEVICE               71
#define IDS_AGGCOL_USED                 72
#define IDS_AGGCOL_USED_PER             73
#define IDS_AGGCOL_FREE                 74
#define IDS_AGGCOL_TOTAL                75
#define IDS_AGGCOL_STATUS               76
#define IDS_SETCOL_NAME                 77
#define IDS_SETCOL_TYPE                 78

#define IDS_SETCOL_DATE_CREATE          80
#define IDS_SETCOL_DATE_UPDATE          81
#define IDS_SETCOL_STATUS               82
#define IDS_SETCOL_QUOTA_USED           83
#define IDS_SETCOL_QUOTA_USED_PER       84
#define IDS_SETCOL_QUOTA_FREE           85
#define IDS_SETCOL_QUOTA_TOTAL          86
#define IDS_TRYAGAINBTN                 87
#define IDS_NO_CELL_SELECTED            88
#define IDS_NO_AFS_ID                   89
#define IDS_AFS_ID_WILLEXP              90
#define IDS_ELAPSED_TIME                91
#define IDS_SEARCHING_FOR_SERVERS       92
#define IDS_STATUS_NOALERTS             93
#define IDS_TITLE_BROWSE_USER           94
#define IDS_AGGTYPE_OTHER               95

#define IDS_ACTION_CREATEFILESET        96
#define IDS_ACTION_DELETEFILESET        97
#define IDS_ACTION_MOVEFILESET          98
#define IDS_ACTION_SETFILESETQUOTA      99
#define IDS_SVCSTOP_DESC2               101
#define IDS_SVCSTART_DESC2              102
#define IDS_SYNCVLDB_SVR_DESC           103
#define IDS_SYNCVLDB_SVR_DESC2          104
#define IDS_SYNCVLDB_AGG_DESC           105
#define IDS_SYNCVLDB_AGG_DESC2          106
#define IDS_PROMPT_BROWSE_USER          107
#define IDS_PREVIEWIN_BUTTON            108
#define IDS_PREVIEWOUT_BUTTON           109

#define IDS_ADMCOL_TYPE_USER            112
#define IDS_TITLE_BROWSE_PRINCIPAL      113
#define IDS_TITLE_BROWSE_OWNGROUP       114
#define IDS_PROMPT_BROWSE_PRINCIPAL     115
#define IDS_PROMPT_BROWSE_OWNGROUP      116
#define IDS_ACTION_CLONE                117
#define IDS_ACTION_CLONESYS             118
#define IDS_CLONESYS_FAILED             119
#define IDS_SET_UNSPECIFIED             120
#define IDS_SETCOL_ID                   121
#define IDS_SETCOL_FILES                122
#define IDS_SET_DUMP_NAME               123
#define IDS_ACTION_DUMP                 124

#define IDS_FILESETNAME_ERROR           128
#define IDS_SETCOL_AGGREGATE            129
#define IDS_REFRESH_DESC_CELL           130
#define IDS_REFRESH_DESC_SERVER         131
#define IDS_REFRESH_CURRENT_CELL        132
#define IDS_REFRESH_CURRENT_SERVER      133
#define IDS_REFRESH_CURRENT_AGGREGATE   134
#define IDS_REFRESH_CURRENT_FILESET     135
#define IDS_REFRESH_CURRENT_SERVICE     136
#define IDS_REFRESH_PERCENT             137
#define IDS_PROBLEMS                    138
#define IDS_SERVER_NO_PROBLEMS          139
#define IDS_SERVICE_NO_PROBLEMS         140
#define IDS_AGGREGATE_NO_PROBLEMS       141
#define IDS_FILESET_NO_PROBLEMS         142
#define IDS_AGGTYPE_TYPE1               143

#define IDS_AGGTYPE_TYPE2               144
#define IDS_AGGTYPE_TYPE3               145
#define IDS_AGGTYPE_TYPE4               146
#define IDS_AGGTYPE_TYPE5               147
#define IDS_REFRESH_CURRENT_VLDB        148
#define IDS_FILESETTYPE_RW              149
#define IDS_FILESETTYPE_RO              150
#define IDS_FILESETTYPE_CLONE           151
#define IDS_MOVESET_READWRITE           152
#define IDS_MOVESET_READONLY            153
#define IDS_SVC_START_TITLE             154
#define IDS_SVC_STOP_TITLE              155
#define IDS_SERVICESTATUS_STARTING      156
#define IDS_SERVICESTATUS_RUNNING       157
#define IDS_SERVICESTATUS_STOPPED       158
#define IDS_SERVICESTATUS_STOPPING      159

#define IDS_SERVICESTATUS_UNKNOWN       160
#define IDS_SVC_RESTART_BUTTON          161
#define IDS_PROBLEM_BOX                 162
#define IDS_VIEWLOG_DESC_NOFILE         163
#define IDS_NO_GROUP                    164
#define IDS_VIEWLOG_FROMSERVER          165
#define IDS_VIEWLOG_FROMSERVICE         166
#define IDS_VIEWLOG_TRUNCATED           167
#define IDS_SAVELOG_FILTER              168
#define IDS_ADVANCEDIN_BUTTON           169
#define IDS_ADVANCEDOUT_BUTTON          170
#define IDS_REPTYPE_RELEASE             171
#define IDS_REPTYPE_SCHEDULED           172

#define IDS_UPDATEALL_BUTTON            178
#define IDS_UPDATETHIS_BUTTON           179
#define IDS_SERVER_MULTIPLE_PROBLEMS    180
#define IDS_SERVICE_MULTIPLE_PROBLEMS   181
#define IDS_AGGREGATE_MULTIPLE_PROBLEMS 182
#define IDS_FILESET_MULTIPLE_PROBLEMS   183
#define IDS_FILESETTYPE_RO_STAGE        184
#define IDS_SERVICETYPE_SIMPLE_LONG     185
#define IDS_SERVICETYPE_CRON_LONG       186
#define IDS_QUOTAUNITS_KB               187
#define IDS_QUOTAUNITS_MB               188
#define IDS_NO_QUOTA_REPLICA            189
#define IDS_NO_QUOTA_CLONE              190
#define IDS_USAGE_REPLICA               191
#define IDS_USAGE_CLONE                 192
#define IDS_COL_AGGS_MOVE               193

#define IDS_PERCENTAGE                  194
#define IDS_AGGREGATES_IN_SERVER        195
#define IDS_AGGREGATES_IN_CELL          196
#define IDS_AGGREGATES_IN_NOTHING       197
#define IDS_FILESETS_IN_SERVER          198
#define IDS_FILESETS_IN_CELL            199
#define IDS_FILESETS_IN_NOTHING         200
#define IDS_SERVICES_IN_SERVER          201
#define IDS_SERVICES_IN_NOTHING         202
#define IDS_UNKNOWN                     203
#define IDS_UNKNOWN_GROUP               204
#define IDS_AGGFULL_WARN_OFF            205
#define IDS_SERVER_AGGREGATE            206
#define IDS_SERVERNAME_ERROR            207
#define IDS_AGGREGATENAME_ERROR         208
#define IDS_SETFULL_WARN_OFF            209

#define IDS_SERVICE_LASTERRORDATE       210
#define IDS_COL_SERVERS                 211
#define IDS_COL_FILESETS                212
#define IDS_COL_AGGREGATES              213
#define IDS_COL_SERVICES                214
#define IDS_COL_REPLICAS                215
#define IDS_COLUMNS_TITLE               216
#define IDS_REPCOL_SERVER               217
#define IDS_REPCOL_AGGREGATE            218
#define IDS_REPCOL_DATE_UPDATE          219

#define IDS_COL_AGGS_CREATE             224
#define IDS_WARN_TITLE                  225
#define IDS_WARN_DISABLE_AUTH           226
#define IDS_WARN_DISABLE_AUTH2          227
#define IDS_SVR_NO_ADDR                 228
#define IDS_TITLE_BAD_CELL              229
#define IDS_DESC_BAD_CELL               230
#define IDS_AGGFULL_WARN_ON             231
#define IDS_SETFULL_WARN_ON             232

#define IDS_SVR_ERROR_BAD_CREDENTIALS       240
#define IDS_SVR_CREDS_NONE                  241
#define IDS_SVR_CREDS_VALID                 242
#define IDS_SVR_CREDS_EXPIRED               243

#define IDS_AGG_FILESETS                256
#define IDS_ACTION_DESC_NONE            257
#define IDS_ACTION_DESC_ONE             258
#define IDS_ACTION_DESC_MULT            259
#define IDS_ACTCOL_OPERATION            260
#define IDS_ACTCOL_ELAPSED              261
#define IDS_ACTION_REFRESH              262
#define IDS_ACTION_CREATESERVER         263
#define IDS_ACTION_DELETESERVER         264
#define IDS_ACTION_GETSERVERLOGFILE     265
#define IDS_ACTION_SETSERVERAUTH        266
#define IDS_ACTION_CHANGESERVERSTATUS   267
#define IDS_ACTION_STARTSERVICE         268
#define IDS_ACTION_STOPSERVICE          269
#define IDS_ACTION_RESTARTSERVICE       270

#define IDS_ACTION_SYNCVLDB_SVR         272
#define IDS_ACTION_SYNCVLDB_AGG         273
#define IDS_ACTION_SCOUT                274

#define IDS_ACTION_SETREPPARAMS         288
#define IDS_ACTION_CREATEREPLICA        289
#define IDS_DELSET_REPLICA_DESC         290
#define IDS_DELSET_CLONE_DESC           291
#define IDS_INSTALL_DESC1               292

#define IDS_INSTALL_DESC2               304
#define IDS_ACTION_INSTALLFILE          305
#define IDS_ACTION_UNINSTALLFILE        306
#define IDS_ACTION_PRUNEFILES           307
#define IDS_FILTER_ALLFILES             308
#define IDS_ACTION_RENAMEFILESET        309
#define IDS_RECUR_DAILY                 310
#define IDS_RECUR_SUNDAY                311
#define IDS_RECUR_MONDAY                312
#define IDS_RECUR_TUESDAY               313
#define IDS_RECUR_WEDNESDAY             314
#define IDS_RECUR_THURSDAY              315
#define IDS_RECUR_FRIDAY                316
#define IDS_RECUR_SATURDAY              317

#define IDS_ACTION_CREATESERVICE        320
#define IDS_ACTION_DELETESERVICE        321
#define IDS_ACTION_RELEASEFILESET       322
#define IDS_ACTION_UPDATEFILESET        323
#define IDS_ACTION_UPDATEALL            324
#define IDS_UPDATE_FAILED               325
#define IDS_ACTION_GETDATES             326
#define IDS_LASTMODIFIED                327
#define IDS_SVR_SECURITY_TITLE          328
#define IDS_SVR_LIST_TAB                329
#define IDS_ACTION_ADMINLIST_LOAD       330
#define IDS_ACTION_ADMINLIST_SAVE       331
#define IDS_ADMCOL_PRINCIPAL            332
#define IDS_ADMCOL_TYPE                 333
#define IDS_ADMCOL_TYPE_GROUP           334

#define IDS_ACTION_RESTORE              336
#define IDS_COL_AGGS_RESTORE            337
#define IDS_RESTORE_FILTER              338
#define IDS_SVC_BOS_TAB                 339
#define IDS_ACTION_SETRESTART           340
#define IDS_RESTORE_CREATESET           341
#define IDS_RESTORE_OVERWRITESET        342
#define IDS_SUBSET_TITLE_LOAD           343
#define IDS_SUBSET_TITLE_SAVE           344
#define IDS_BUTTON_OPEN                 345
#define IDS_BUTTON_SAVE                 346
#define IDS_SUBSET_SAVE_TITLE           347
#define IDS_SUBSET_SAVE_DESC            348
#define IDS_SUBSET_CHANGED              349
#define IDS_SUBSET_TAB                  350
#define IDS_SUBSET_DISCARD_TITLE        351

#define IDS_SUBSET_DISCARD_DESC         352
#define IDS_SUBSET_DISCARD_DESC2        353
#define IDS_SUBSET_NONAME               354
#define IDS_SUBSET_NOSUBSET             355
#define IDS_SUBSET_SERVERSUBSET         356
#define IDS_FILESET_SOME                357
#define IDS_AGGREGATE_SOME              358
#define IDS_SERVICE_SOME                359
#define IDS_FILESET_UNMON               360
#define IDS_AGGREGATE_UNMON             361
#define IDS_SERVICE_UNMON               362
#define IDS_SUBSET_DELETE_TITLE         363
#define IDS_SUBSET_DELETE_DESC          364
#define IDS_ERROR_TRANSLATED            365
#define IDS_ERROR_NOTTRANSLATED         366
#define IDS_FIND_NOTHING_TITLE          367

#define IDS_FIND_NOTHING_DESC           368
#define IDS_FIND_UNKNOWN_TITLE          369
#define IDS_FIND_UNKNOWN_DESC           370
#define IDS_HELPABOUT_DESC1             371
#define IDS_HELPABOUT_DESC2             372
#define IDS_HELPABOUT_DESC3             373
#define IDS_CANT_QUIT_TITLE             374
#define IDS_CANT_QUIT_REBOOT            375
#define IDS_APP_TITLE                   376
#define IDS_ACTION_OPENCELL             377
#define IDS_OPTIONS_TITLE               378
#define IDS_OPTIONS_GENERAL_TAB         379
#define IDS_BADCREDS_DESC               380

#define IDS_CONFIRMATION_TITLE          384
#define IDS_NO_GROUP_CHECKBOX           385
#define IDS_AFS_ID_DIDEXP               386

#define IDS_QUERYING                    400
#define IDS_ADMCOL_TYPE_FOREIGN_GROUP   401
#define IDS_ADMCOL_TYPE_FOREIGN_USER    402

#define IDS_SVCCOL_NOTIFIER             416
#define IDS_SVC_NONOTIFIER              417
#define IDS_SVR_KEY_TAB                 418
#define IDS_KEYNAME_NOTIME              419
#define IDS_KEYNAME_WITHTIME            420
#define IDS_SVRKEY_VERSION              421
#define IDS_SVRKEY_DATA                 422
#define IDS_SVRKEY_CHECKSUM             423
#define IDS_SVRKEY_DATA_UNKNOWN         424
#define IDS_STARTSERVICE_TITLE          425
#define IDS_STOPSERVICE_TITLE           426
#define IDS_STARTSERVICE_TEXT           427

#define IDS_STOPSERVICE_TEXT            432
#define IDS_STARTSERVICE_STARTUP        433
#define IDS_STOPSERVICE_STARTUP         434
#define IDS_STARTSERVICE_PERMANENT      435
#define IDS_STARTSERVICE_TEMPORARY      436
#define IDS_STOPSERVICE_PERMANENT       437
#define IDS_STOPSERVICE_TEMPORARY       438
#define IDS_ACTION_EXECUTE              439
#define IDS_ACTION_SALVAGE_SVR          440
#define IDS_ACTION_SALVAGE_AGG          441
#define IDS_ACTION_SALVAGE_VOL          442
#define IDS_SALVAGE_SVR                 443
#define IDS_SALVAGE_AGG                 444
#define IDS_SALVAGE_SET                 445
#define IDS_SETSTATUS_SALVAGE           446

#define IDS_SETSTATUS_LOCKED            448
#define IDS_SETSTATUS_NO_VOL            449
#define IDS_SETSTATUS_BUSY              450
#define IDS_SETSTATUS_MOVED             451
#define IDS_SVR_CAPACITY                452
#define IDS_SVR_ALLOCATION              453
#define IDS_SVRCOL_ADDRESS              454
#define IDS_HOST_TITLE                  456
#define IDS_SVR_HOSTS_TITLE             457
#define IDS_SVR_HOST_TAB                458
#define IDS_ACTION_HOSTLIST_LOAD        459
#define IDS_ACTION_HOSTLIST_SAVE        460
#define IDS_SETSTATUS_1ALERT            461
#define IDS_SETSTATUS_2ALERT            462

#define IDS_ACTION_CHANGEADDR           464

#define IDS_COMMAND_VOS_ADDSITE         480
#define IDS_COMMAND_VOS_BACKUP          481
#define IDS_COMMAND_VOS_BACKUPSYS       482
#define IDS_COMMAND_VOS_CREATE          483

#define IDS_COMMAND_VOS_DELENTRY        496
#define IDS_COMMAND_VOS_DUMP            497
#define IDS_COMMAND_VOS_EXAMINE         498
#define IDS_COMMAND_VOS_LISTPART        499
#define IDS_COMMAND_VOS_LISTVLDB        500
#define IDS_COMMAND_VOS_LISTVOL         501
#define IDS_COMMAND_VOS_LOCK            502
#define IDS_COMMAND_VOS_MOVE            503
#define IDS_COMMAND_VOS_PARTINFO        504
#define IDS_COMMAND_VOS_RELEASE         505
#define IDS_COMMAND_VOS_REMOVE          506
#define IDS_COMMAND_VOS_REMSITE         507
#define IDS_COMMAND_VOS_RENAME          508
#define IDS_COMMAND_VOS_RESTORE         509
#define IDS_COMMAND_VOS_SYNCVLDB        510
#define IDS_COMMAND_VOS_UNLOCK          511

#define IDS_COMMAND_VOS_UNLOCKVLDB      512
#define IDS_COMMAND_VOS_ZAP             513
#define IDS_COMMAND_BOS_ADDHOST         514
#define IDS_COMMAND_BOS_ADDKEY          515
#define IDS_COMMAND_BOS_ADDUSER         516
#define IDS_COMMAND_BOS_CREATE          517
#define IDS_COMMAND_BOS_DELETE          518
#define IDS_COMMAND_BOS_EXEC            519
#define IDS_COMMAND_BOS_GETDATE         520
#define IDS_COMMAND_BOS_GETLOG          521
#define IDS_COMMAND_BOS_GETRESTART      522
#define IDS_COMMAND_BOS_INSTALL         523
#define IDS_COMMAND_BOS_LISTHOSTS       524
#define IDS_COMMAND_BOS_LISTKEYS        525
#define IDS_COMMAND_BOS_LISTUSERS       526
#define IDS_COMMAND_BOS_PRUNE           527

#define IDS_COMMAND_BOS_REMOVEHOST      528
#define IDS_COMMAND_BOS_REMOVEKEY       529
#define IDS_COMMAND_BOS_REMOVEUSER      530
#define IDS_COMMAND_BOS_RESTART         531
#define IDS_COMMAND_BOS_SALVAGE         532
#define IDS_COMMAND_BOS_SETAUTH         533
#define IDS_COMMAND_BOS_SETRESTART      534
#define IDS_COMMAND_BOS_SHUTDOWN        535
#define IDS_COMMAND_BOS_START           536
#define IDS_COMMAND_BOS_STARTUP         537
#define IDS_COMMAND_BOS_STATUS          538
#define IDS_COMMAND_BOS_STOP            539
#define IDS_COMMAND_BOS_UNINSTALL       540
#define IDS_COMMAND_KAS_GETRANDOMKEY    541
#define IDS_COMMAND_FS_LISTQUOTA        542
#define IDS_COMMAND_FS_QUOTA            543

#define IDS_COMMAND_FS_SETQUOTA         544

#define IDS_ALERT_DESCSHORT_UNMONITORED 560
#define IDS_ALERT_DESCSHORT_TIMEOUT     561
#define IDS_ALERT_DESCSHORT_AGG_FULL    562
#define IDS_ALERT_DESCSHORT_SET_FULL    563
#define IDS_ALERT_DESCSHORT_NO_VLDBENT  564
#define IDS_ALERT_DESCSHORT_NO_SVRENT_SET 565
#define IDS_ALERT_DESCSHORT_STOPPED     566
#define IDS_ALERT_DESCSHORT_NO_SVRENT_AGG 567
#define IDS_ALERT_DESCSHORT_BADCREDS    568
#define IDS_ALERT_DESCSHORT_AGG_ALLOC   569
#define IDS_ALERT_DESCSHORT_STATE_NO_VNODE 570
#define IDS_ALERT_DESCSHORT_STATE_NO_SERVICE 571
#define IDS_ALERT_DESCSHORT_STATE_OFFLINE 572

#define IDS_ALERT_DESCFULL_TIMEOUT      576

#define IDS_ALERT_DESCFULL_AGG_FULL          592
#define IDS_ALERT_DESCFULL_SET_FULL          593
#define IDS_ALERT_DESCFULL_NO_VLDBENT        594
#define IDS_ALERT_DESCFULL_NO_SVRENT_SET     595
#define IDS_ALERT_DESCFULL_STOPPED           596
#define IDS_ALERT_DESCFULL_NO_SVRENT_AGG     597
#define IDS_ALERT_DESCFULL_BADCREDS          598
#define IDS_ALERT_DESCFULL_AGG_ALLOC         599
#define IDS_ALERT_DESCFULL_STATE_NO_VNODE    600
#define IDS_ALERT_DESCFULL_STATE_NO_SERVICE  601
#define IDS_ALERT_DESCFULL_STATE_OFFLINE     602

#define IDS_ALERT_FIX_TIMEOUT           608
#define IDS_ALERT_FIX_AGG_FULL          609
#define IDS_ALERT_FIX_SET_FULL          610

#define IDS_ALERT_FIX_NO_VLDBENT        624
#define IDS_ALERT_FIX_NO_SVRENT_SET     625
#define IDS_ALERT_FIX_STOPPED           626
#define IDS_ALERT_FIX_NO_SVRENT_AGG     627
#define IDS_ALERT_FIX_BADCREDS          628
#define IDS_ALERT_FIX_AGG_ALLOC         629
#define IDS_ALERT_FIX_STATE_NO_VNODE    630
#define IDS_ALERT_FIX_STATE_NO_SERVICE  631
#define IDS_ALERT_FIX_STATE_OFFLINE     632

#define IDS_ALERT_BUTTON_TRYAGAIN       640
#define IDS_ALERT_BUTTON_WARNINGS       641
#define IDS_ALERT_BUTTON_VIEWLOG        642
#define IDS_ALERT_BUTTON_SHOWME         643
#define IDS_ALERT_BUTTON_GETCREDS       644

#define IDS_ERROR_REFRESH_CELLSERVERS_NOCELL 656
#define IDS_ERROR_REFRESH_CELLSERVERS        657
#define IDS_ERROR_CANT_OPEN_CELL             658
#define IDS_ERROR_REFRESH_AGGREGATES         659
#define IDS_ERROR_REFRESH_SERVER_STATUS      660
#define IDS_ERROR_CHANGE_SERVER_STATUS       661
#define IDS_ERROR_REFRESH_AGGREGATE_STATUS   662

#define IDS_ERROR_REFRESH_FILESET_STATUS      672
#define IDS_ERROR_REFRESH_SERVICE_STATUS      673
#define IDS_ERROR_MOVE_FILESET                674
#define IDS_ERROR_VIEW_LOGFILE                675
#define IDS_ERROR_NOT_REPLICATED              676
#define IDS_ERROR_CANT_CREATE_FILESET         677
#define IDS_ERROR_CANT_DELETE_FILESET         678
#define IDS_ERROR_CANT_CREATE_VLDB_ENTRY      679
#define IDS_ERROR_CANT_SET_FILESET_QUOTA      680
#define IDS_ERROR_CANT_CREATE_SERVER          681
#define IDS_ERROR_CANT_PING_SERVER            682
#define IDS_ERROR_CANT_DELETE_SERVER          683
#define IDS_ERROR_CANT_DELETE_SERVER_FILESETS 684
#define IDS_ERROR_CHANGE_AGGREGATE_STATUS     685
#define IDS_ERROR_CHANGE_SERVICE_STATUS       686
#define IDS_ERROR_CANT_START_SERVICE          687

#define IDS_ERROR_CANT_STOP_SERVICE          688
#define IDS_ERROR_CANT_RESTART_SERVICE       689
#define IDS_ERROR_CHANGE_REPLICA_STATUS      690
#define IDS_ERROR_CANT_SYNCVLDB              691
#define IDS_ERROR_CANT_CREATE_REPLICA        692
#define IDS_ERROR_CANT_INSTALL_FILE          693
#define IDS_ERROR_CANT_UNINSTALL_FILE        694
#define IDS_ERROR_CANT_PRUNE_FILES           695
#define IDS_ERROR_CANT_RENAME_FILESET        696
#define IDS_ERROR_CANT_CREATE_SERVICE        697
#define IDS_ERROR_CANT_DELETE_SERVICE        698
#define IDS_ERROR_CANT_RELEASE_FILESET       699
#define IDS_ERROR_CANT_UPDATE_FILESET        700
#define IDS_ERROR_CANT_UPDATE_ALL            701

#define IDS_ERROR_CANT_LOAD_ADMLIST          704
#define IDS_ERROR_CANT_LOAD_KEYLIST          705
#define IDS_ERROR_CANT_CREATE_KEY            706
#define IDS_ERROR_CANT_SAVE_ADMLIST          707
#define IDS_ERROR_CANT_CLONE                 708
#define IDS_ERROR_CANT_CLONESYS              709
#define IDS_ERROR_CANT_DUMP_FILESET          710
#define IDS_ERROR_CANT_RESTORE_FILESET       711
#define IDS_ERROR_CANT_SET_RESTART_TIMES     712
#define IDS_ERROR_CANT_DELETE_REPLICATED_FILESET 713
#define IDS_CMDLINE_TITLE                    714
#define IDS_CMDLINE_SYNTAX                   715
#define IDS_CMDLINE_UNRECOGNIZED             716
#define IDS_CMDLINE_DUPLICATE                717
#define IDS_CMDLINE_UNEXPECTVALUE            718
#define IDS_CMDLINE_MISSINGVAL               719

#define IDS_CMDLINE_SUBSETNOTCELL            720
#define IDS_CMDLINE_INVALIDSUBSET            721
#define IDS_CMDLINE_SERVERNOTCELL            722
#define IDS_CMDLINE_RESET_TITLE              723
#define IDS_CMDLINE_RESET_DESC               724
#define IDS_ERROR_CANT_SYNC_GHOST_AGGREGATE  725
#define IDS_CMDLINE_USERPASSWORD             726
#define IDS_ERROR_CANT_DELETE_KEY            727
#define IDS_ERROR_CANT_GETRANDOMKEY          728
#define IDS_ERROR_CANT_EXECUTE_COMMAND       729
#define IDS_ERROR_CANT_READ_SALVAGE_LOG      730
#define IDS_ERROR_CANT_SALVAGE               731
#define IDS_ERROR_CANT_AUTH_ON               732
#define IDS_ERROR_CANT_AUTH_OFF              733
#define IDS_ERROR_CANT_LOAD_HOSTLIST         734
#define IDS_ERROR_CANT_SAVE_HOSTLIST         735

#define IDS_ERROR_CANT_INIT_AFSCLASS_INSTALL 736
#define IDS_ERROR_CANT_INIT_AFSCLASS_UNKNOWN 737
#define IDS_ERROR_CANT_CHANGEADDR            738

#define IDS_SERVER_SERVICE                   752
#define IDS_SERVICETYPE_SIMPLE               753
#define IDS_SERVICETYPE_CRON                 754
#define IDS_SERVICESTATE_STOPPED             755
#define IDS_SERVICESTATE_STOPPING            756
#define IDS_SERVICESTATE_STARTING            757
#define IDS_SERVICESTATE_RUNNING             758
#define IDS_SERVICETYPE_FS_LONG              759
#define IDS_SERVICETYPE_FS                   760
#define IDS_SERVICE_LASTERROR                761
#define IDS_SERVICES_IN_CELL                 762
#define IDS_SERVICE_STARTDATE                763
#define IDS_SERVICE_STOPDATE                 764
                                        
#define IDC_CELL                        1000
#define IDC_SERVERS                     1001
#define IDC_TABS                        1002
#define IDC_SPLITTER_SERVER             1004
#define IDC_SET_LOCK                    1006
#define IDC_SVC_LIST                    1007
#define IDC_SET_UNLOCK                  1007
#define IDC_SVC_RESTART                 1008
#define IDC_SET_QUOTA                   1008
#define IDC_SVC_CREATE                  1009
#define IDC_SVC_DELETE                  1010
#define IDC_AGG_LIST                    1011
#define IDC_SET_LIST                    1012
#define IDC_SET_CREATE                  1013
#define IDC_SET_DELETE                  1015
#define IDC_CELL_BORDER                 1016
#define IDC_SET_REP                     1016
#define IDC_SVC_DESC                    1017
#define IDC_AGG_DESC                    1018
#define IDC_SET_DESC                    1019
#define IDC_SVR_WARN_SETFULL_PERCENT    1028
#define IDC_AGG_WARN_AGGFULL_DESC       1029
#define IDC_SET_WARN_SETFULL_DESC       1030
#define IDC_SVR_WARN_AGGFULL            1031
#define IDC_SVR_WARN_SETFULL            1032
#define IDC_SVR_WARN_SVCSTOP            1033
#define IDC_SVR_WARN_TIMEOUT            1034
#define IDC_SVR_WARN_AGGALLOC           1035
#define IDC_SVR_WARN_SETNOVLDB          1036
#define IDC_SVR_LISTS_ADD               1037
#define IDC_SVR_WARN_SETNOSERV          1037
#define IDC_LIST_ADD                    1037
#define IDC_SVR_LISTS_DELETE            1038
#define IDC_SVR_WARN_AGGNOSERV          1038
#define IDC_LIST_REMOVE                 1038
#define IDC_SVR_LISTS_EDIT              1039
#define IDC_SVR_LISTS_LIST              1040
#define IDC_LIST_LIST                   1040
#define IDC_SVR_WARN_AGGFULL_PERCENT    1042
#define IDC_SVR_AUTOREFRESH             1050
#define IDC_SVR_AUTOREFRESH_MINUTES     1051
#define IDC_AGG_NAME                    1052
#define IDC_SVR_SETAUTH                 1052
#define IDC_AGG_ID                      1053
#define IDC_AGG_DEVICE                  1054
#define IDC_AGG_USAGE                   1056
#define IDC_AGG_USAGEBAR                1057
#define IDC_AGG_FILESETS                1058
#define IDC_SVR_NAME                    1069
#define IDC_SVR_SETQUOTA                1071
#define IDC_SVR_SETQUOTA_INFINITE       1072
#define IDC_SVR_NUMFILESETS             1073
#define IDC_SVR_NUMAGGREGATES           1074
#define IDC_SVR_OWNER                   1075
#define IDC_SVR_CAPACITY                1075
#define IDC_SVR_GROUP                   1076
#define IDC_SVR_ALLOCATION              1076
#define IDC_SVR_LOAD                    1077
#define IDC_SVC_NAME                    1082
#define IDC_SVC_TYPE                    1083
#define IDC_SVC_VIEWLOG                 1084
#define IDC_SVC_PARAMS                  1086
#define IDC_SVC_STATUS                  1087
#define IDC_SVC_TYPE_CRON_WHEN          1087
#define IDC_AGG_WARN                    1088
#define IDC_SVC_START                   1089
#define IDC_SVC_LOGFILE                 1089
#define IDC_AGG_WARNALLOC               1089
#define IDC_SVC_STARTDATE               1090
#define IDC_AGG_WARN_AGGFULL            1090
#define IDC_SVC_COMMAND                 1090
#define IDC_SVC_STOPDATE                1091
#define IDC_AGG_WARN_AGGFULL_PERCENT    1091
#define IDC_AGG_WARN_AGGFULL_DEF        1092
#define IDC_SVC_LASTERROR               1092
#define IDC_SET_NAME                    1093
#define IDC_SVC_WARNSTOP                1093
#define IDC_SET_CREATEDATE              1094
#define IDC_SET_SERVER                  1094
#define IDC_SVC_STOP                    1094
#define IDC_SET_UPDATEDATE              1095
#define IDC_SET_AGGREGATE               1095
#define IDC_SVC_NOTIFIER                1095
#define IDC_SET_USAGE                   1096
#define IDC_SET_USAGEBAR                1097
#define IDC_SET_WARN                    1098
#define IDC_SET_WARN_SETFULL_DEF        1099
#define IDC_SET_WARN_SETFULL            1100
#define IDC_SET_WARN_SETFULL_PERCENT    1101
#define IDC_SET_LOCKS                   1102
#define IDC_SET_STATUS                  1102
#define IDC_SET_ACCESSDATE              1103
#define IDC_SET_BACKUPDATE              1104
#define IDC_SET_ID                      1105
#define IDC_SET_VERSION                 1106
#define IDC_SET_FILES                   1106
#define IDC_SET_LOAD                    1107
#define IDC_SVC_TYPE_SIMPLE             1109
#define IDC_SVC_TYPE_CRON               1110
#define IDC_SVC_TYPE_FS                 1111
#define IDC_SVC_TYPE_CRON_WHENPROMPT    1112
#define IDC_SET_REPTYPE_RELEASE         1114
#define IDC_SET_REPTYPE_SCHEDULED       1115
#define IDC_SET_RELEASE                 1116
#define IDC_SET_UPDATE                  1117
#define IDC_SET_REP_MAXAGE              1118
#define IDC_SET_REP_FAILAGE             1119
#define IDC_SET_REP_LIST                1119
#define IDC_SET_REP_RECWAIT             1120
#define IDC_SET_REPSITE_ADD             1120
#define IDC_SET_REPSITE_EDIT            1121
#define IDC_SET_REP_DEFSITEAGE          1122
#define IDC_SET_REPSITE_DELETE          1122
#define IDC_AFS_LOGIN                   1123
#define IDC_AFS_ID                      1124
#define IDC_AFS_PASSWORD                1125
#define IDC_AFS_CURRENTID               1129
#define IDC_AFS_EXPDATE                 1130
#define IDC_TIMEOUT_WAIT                1134
#define IDC_TIMEOUT_KILL                1135
#define IDC_TIMEOUT_ELAPSED             1136
#define IDC_SVR_ADDRESSES               1140
#define IDC_SVR_CHOWN                   1141
#define IDC_SVR_CHGRP                   1142
#define IDC_COLUMNS                     1142
#define IDC_SVR_CHADDR                  1143
#define IDC_COL_AVAIL                   1144
#define IDC_COL_INSERT                  1145
#define IDC_COL_DELETE                  1146
#define IDC_COL_SHOWN                   1147
#define IDC_COL_UP                      1148
#define IDC_COL_DOWN                    1149
#define IDC_REFRESH_PERCENTBAR          1149
#define IDC_REFRESH_PERCENT             1150
#define IDC_REFRESH_CURRENT             1151
#define IDC_REFRESH_DESC                1152
#define IDC_AGG_CREATESET               1153
#define IDC_SVR_TITLE                   1156
#define IDC_SVR_GROUP_NONE              1157
#define IDC_DELSET_DESC                 1163
#define IDC_DELSET_SERVER               1165
#define IDC_DELSET_VLDB                 1166
#define IDC_SVC_RUNNOW                  1166
#define IDC_CLONESET_ONE                1167
#define IDC_CLONE_ONE                   1167
#define IDC_CLONESET_MULTIPLE           1168
#define IDC_CLONE_MULTIPLE              1168
#define IDC_DUMP_LIMIT_TIME             1168
#define IDC_CLONESET_SVR_LIMIT          1169
#define IDC_CLONE_SVR_LIMIT             1169
#define IDC_DUMP_LIMIT_VERSION          1169
#define IDC_CLONESET_SVR                1170
#define IDC_CLONE_SVR                   1170
#define IDC_CLONESET_AGG_LIMIT          1171
#define IDC_CLONE_AGG_LIMIT             1171
#define IDC_CLONESET_AGG                1172
#define IDC_CLONE_AGG                   1172
#define IDC_CLONESET_PREFIX_LIMIT       1173
#define IDC_CLONE_PREFIX_LIMIT          1173
#define IDC_CLONESET_PREFIX             1174
#define IDC_CLONE_PREFIX                1174
#define IDC_PROBLEM_SCROLL              1176
#define IDC_PROBLEM_TEXT                1178
#define IDC_PROBLEM_REMEDY              1181
#define IDC_PROBLEM_HEADER              1185
#define IDC_PROBLEM_TITLE               1189
#define IDC_SET_SETQUOTA                1189
#define IDC_MOVESET_DESC                1190
#define IDC_MOVESET_SERVER              1191
#define IDC_REPSET_DESC                 1192
#define IDC_REPSET_DESC2                1193
#define IDC_ANIMATE                     1196
#define IDC_SET_ENABLE                  1197
#define IDC_SET_DISABLE                 1198
#define IDC_PROBLEM_BOX                 1198
#define IDC_VIEWLOG_DESC                1199
#define IDC_VIEWLOG_SERVER              1200
#define IDC_VIEWLOG_FILENAME            1201
#define IDC_SVC_VIEWLOG_DESC            1202
#define IDC_SVC_VIEWLOG_FILENAME        1203
#define IDC_VIEWLOG_TEXT                1204
#define IDC_SVC_VIEWLOG_CONTENTS        1205
#define IDC_VIEWLOG_SAVEAS              1207
#define IDC_REPSET_TYPE                 1209
#define IDC_REPSET_TITLE                1210
#define IDC_REPSET_ADVANCED             1211
#define IDC_SET_REP_MAXAGE_PROMPT       1212
#define IDC_SET_REP_FAILAGE_PROMPT      1213
#define IDC_SET_REP_RECWAIT_PROMPT      1214
#define IDC_SET_REP_MINDELAY_PROMPT     1215
#define IDC_SET_REP_DEFSITEAGE_PROMPT   1216
#define IDC_SET_REP_MINDELAY            1217
#define IDC_SET_CLONE                   1218
#define IDC_SET_QUOTA_UNITS             1220
#define IDC_SVR_ADDR                    1225
#define IDC_SVR_ADDR_ADD                1226
#define IDC_SVR_ADDR_UP                 1227
#define IDC_SVR_ADDR_DOWN               1228
#define IDC_SVR_ADDR_REMOVE             1229
#define IDC_SVR_ADDR_PING               1230
#define IDC_SVR_ADDR_DESC               1231
#define IDC_AGG_PROPERTIES              1234
#define IDC_ACTION_DESC                 1235
#define IDC_ACTION_LIST                 1236
#define IDC_SVC_DESC2                   1241
#define IDC_SYNC_DESC                   1242
#define IDC_SYNC_DESC2                  1243
#define IDC_BROWSE                      1247
#define IDC_SERVER                      1248
#define IDC_FILENAME                    1249
#define IDC_DIRECTORY                   1250
#define IDC_DATE_FILE                   1250
#define IDC_INSTALL_DESC                1251
#define IDC_DATE_BAK                    1251
#define IDC_OP_RESTORE                  1252
#define IDC_DATE_OLD                    1252
#define IDC_OP_UNINSTALL                1253
#define IDC_OP_DELETE_CORE              1253
#define IDC_OP_DELETE_BAK               1254
#define IDC_RENSET_DESC                 1254
#define IDC_OP_DELETE_OLD               1255
#define IDC_RENSET_OLD                  1255
#define IDC_RENSET_NEW                  1256
#define IDC_SVC_RUNDAY                  1257
#define IDC_SVC_RUNTIME                 1258
#define IDC_SVC_SERVER                  1259
#define IDC_DUMP_DATE                   1259
#define IDC_DELSVR_DESC                 1261
#define IDC_UPDATE_DETAILS              1262
#define IDC_UPDATE_DESC                 1263
#define IDC_LIST_NAME                   1264
#define IDC_CLONESYS_DETAILS            1269
#define IDC_DUMP_FILENAME               1271
#define IDC_DUMP_FULL                   1272
#define IDC_DUMP_TIME                   1274
#define IDC_DUMP_VERSION                1275
#define IDC_RESTORE_FILENAME            1276
#define IDC_RESTORE_BROWSE              1277
#define IDC_RESTORE_SETNAME             1280
#define IDC_RESTORE_CREATE              1281
#define IDC_RESTORE_SERVER              1282
#define IDC_BOS_GENRES                  1283
#define IDC_BOS_GENRES_DESC1            1284
#define IDC_BOS_GENRES_DESC2            1285
#define IDC_BOS_GENRES_DATE             1286
#define IDC_BOS_GENRES_TIME             1287
#define IDC_BOS_BINRES                  1288
#define IDC_DUMPSET_DESC                1288
#define IDC_BOS_BINRES_DESC1            1289
#define IDC_RESTORESET_DESC             1289
#define IDC_BOS_BINRES_DESC2            1290
#define IDC_UPDATESET_DESC              1290
#define IDC_BOS_BINRES_DATE             1291
#define IDC_CLONE_ALL                   1291
#define IDC_BOS_BINRES_TIME             1292
#define IDC_CLONE_SOME                  1292
#define IDC_CLONE_DESC                  1293
#define IDC_ADVANCED                    1294
#define IDC_ADVANCED_GROUP              1295
#define IDC_MON_ALL                     1296
#define IDC_MON_ONE                     1297
#define IDC_MON_SERVER                  1298
#define IDC_MON_SOME                    1299
#define IDC_MON_SUBSET                  1300
#define IDC_SUBSET_LIST                 1301
#define IDC_SUBSET_NAME                 1302
#define IDC_SUBSET_LOAD                 1303
#define IDC_SUBSET_SAVE                 1304
#define IDC_SUBSET_ALL                  1305
#define IDC_SUBSET_DELETE               1306
#define IDC_FIND_COMMAND                1306
#define IDC_SUBSET_NONE                 1307
#define IDC_SUBSET_RENAME               1307
#define IDC_ERROR_NUMBER                1307
#define IDC_ERROR_TRANSLATE             1308
#define IDC_ADVANCED_BOX                1309
#define IDC_HELPABOUT_ICON              1310
#define IDC_HELPABOUT_DESC              1311
#define IDC_OPENCELL_DESC               1313
#define IDC_OPT_SVR_LONGNAMES           1315
#define IDC_OPT_SVR_DBL_PROP            1316
#define IDC_OPT_SVR_OPENMON             1317
#define IDC_OPT_SVR_DBL_DEPENDS         1318
#define IDC_OPT_SVR_DBL_OPEN            1319
#define IDC_OPT_SVR_CLOSEUNMON          1320
#define IDC_OPT_WARN_BADCREDS           1321
#define IDC_DELSVR_FILESETS             1324
#define IDC_DUMP_BROWSE                 1325
#define IDC_REFRESH_SKIP                1326
#define IDC_KEY_LIST                    1328
#define IDC_KEY_NAME                    1329
#define IDC_KEY_ADD                     1330
#define IDC_KEY_REMOVE                  1331
#define IDC_KEY_TITLE                   1332
#define IDC_KEY_VERSION                 1333
#define IDC_KEY_STRING                  1334
#define IDC_KEY_BYSTRING                1335
#define IDC_KEY_DATA                    1336
#define IDC_KEY_BYDATA                  1337
#define IDC_KEY_RANDOM                  1338
#define IDC_STARTSTOP_TEXT              1342
#define IDC_STARTSTOP_PERMANENT         1343
#define IDC_STARTSTOP_TEMPORARY         1344
#define IDC_STARTSTOP_STARTUP           1345
#define IDC_COMMAND                     1346
#define IDC_ADVANCEDBOX                 1347
#define IDC_SET_REP_SITEAGE_PROMPT      1348
#define IDC_SET_REP_SITEAGE             1349
#define IDC_DELSVC_DESC                 1350
#define IDC_AGGREGATE_ALL               1353
#define IDC_AGGREGATE                   1354
#define IDC_FILESET                     1355
#define IDC_FILESET_ALL                 1356
#define IDC_SALVAGE_TEMPDIR             1358
#define IDC_SALVAGE_LOG_FILE            1359
#define IDC_SALVAGE_LOG_INODES          1360
#define IDC_SALVAGE_LOG_ROOT            1361
#define IDC_SALVAGE_SIMUL               1362
#define IDC_SALVAGE_NUM                 1363
#define IDC_SALVAGE_READONLY            1364
#define IDC_SALVAGE_TITLE               1365
#define IDC_SALVAGE_DETAILS             1366
#define IDC_SALVAGE_BLOCK               1367
#define IDC_RELSET_DESC                 1367
#define IDC_SALVAGE_FORCE               1368
#define IDC_RELSET_NORMAL               1368
#define IDC_SALVAGE_FIXDIRS             1369
#define IDC_RELSET_FORCE                1369
#define IDC_SVR_AUTH_YES                1369
#define IDC_SVR_AUTH_NO                 1370
#define IDC_HOST_TITLE                  1372
#define IDC_HOST_ADD                    1374
#define IDC_HOST_REMOVE                 1375
#define IDC_HOST_LIST                   1376
#define IDC_ADDHOST_DESC                1377
#define IDC_ADDHOST_HOST                1379
#define IDC_RESTORE_INCREMENTAL         1380
#define IDC_SVR_CHANGEADDR              1381
#define IDC_ADDR_CHANGE                 1382
#define IDC_ADDR_REMOVE                 1383
#define IDC_TITLE                       1384
#define IDC_ADDRESS                     1385
#define IDD_MAIN                        3000
#define IDD_SERVICES                    3001
#define IDD_AGGREGATES                  3002
#define IDD_FILESETS                    3003
#define IDD_SUBSET_LOADSAVE             3004
#define ACCEL_MAIN                      3005
#define MENU_MAIN                       3006
#define IDI_MAIN                        3007
#define MENU_SVR                        3014
#define MENU_AGG                        3015
#define MENU_SVC                        3016
#define MENU_AGG_NONE                   3017
#define MENU_SVR_NONE                   3018
#define MENU_SVC_NONE                   3019
#define MENU_SET                        3020
#define MENU_SET_NONE                   3021
#define MENU_COLUMNS                    3022
#define MENU_SVC_BOS                    3023
#define IDD_AGG_GENERAL                 3024
#define MENU_SET_DRAGDROP               3024
#define IDD_SVR_LISTS                   3025
#define IDD_SVR_GENERAL                 3028
#define IDD_SVR_SCOUT                   3030
#define IDD_SVC_GENERAL                 3031
#define IDD_SET_GENERAL                 3032
#define IDD_SERVER                      3034
#define IDD_SVC_CREATE                  3036
#define IDD_SET_REPINFO                 3037
#define IDD_SET_REPSITES                3038
#define IDD_OPENCELL                    3039
#define IDD_TIMEOUT                     3042
#define IDD_COLUMNS                     3044
#define IDD_REFRESHALL                  3045
#define IDD_SVR_CREATE                  3046
#define IDD_SET_CREATE                  3047
#define IDD_SET_DELETE                  3048
#define IDD_SET_CLONE                   3049
#define IDD_SVC_PROBLEMS                3050
#define IDD_SVR_PROBLEMS                3051
#define IDD_AGG_PROBLEMS                3052
#define IDD_SET_PROBLEMS                3053
#define IDD_SET_MOVETO                  3054
#define IDD_SET_MOVING                  3055
#define IDI_INSTALL                     3055
#define IDD_SVC_STARTSTOP               3056
#define IDI_ADMINLIST                   3056
#define IDD_SVC_LOGNAME                 3057
#define IDI_BTN_RENAME                  3057
#define IDD_SVC_VIEWLOG                 3058
#define IDI_BTN_DELETE                  3058
#define IDD_SET_NOTREP                  3059
#define IDI_UNINSTALL                   3059
#define IDD_SET_SETQUOTA                3060
#define IDI_PRUNE                       3060
#define IDI_GETDATES                    3061
#define IDD_ACTIONS                     3062
#define IDI_SUBSET                      3062
#define IDD_SVR_SYNCVLDB                3063
#define IDD_SET_CREATEREP               3065
#define IDD_SVR_INSTALL                 3066
#define IDD_SVR_UNINSTALL               3067
#define IDD_SVR_PRUNE                   3068
#define IDD_SET_RENAME                  3069
#define IDD_SVC_DELETE                  3070
#define IDD_SVR_DELETE                  3071
#define IDD_SVR_DELETE_CONFIRM          3072
#define IDD_SVR_GETDATES                3074
#define IDD_SVR_GETDATES_RESULTS        3075
#define IDD_SVR_LISTS_SELECT            3076
#define IDD_SET_CLONESYS_RESULTS        3077
#define IDD_SET_DUMP                    3078
#define IDD_SET_RESTORE                 3079
#define IDD_SVC_BOS                     3080
#define IDD_SET_DUMPING                 3081
#define IDD_SET_RESTORING               3082
#define IDD_SVR_KEYS                    3083
#define IDD_SET_CLONESYS                3084
#define IDD_SUBSETS                     3085
#define IDD_HELP_FIND                   3086
#define IDD_HELP_ERROR                  3087
#define IDD_HELP_ABOUT                  3088
#define IDD_OPENINGCELL                 3089
#define IDD_OPTIONS_GENERAL             3090
#define IDD_SET_DELREP                  3091
#define IDD_SET_DELCLONE                3092
#define IDD_SVR_EXECUTE                 3093
#define IDD_SVC_START                   3094
#define IDD_SVC_STOP                    3095
#define IDD_SET_RELEASE                 3096
#define IDD_SVR_HOSTS                   3097
#define IDD_SVR_ADDHOST                 3098
#define IDD_SVR_ADDRESS                 3099
#define IDD_SVR_NEWADDR                 3100
#define IDD_SVR_SALVAGE_RESULTS         3101
#define IDD_SVR_CREATEKEY               3102
#define IDD_SVR_SALVAGE                 3103
#define M_DIVIDE_NONE                   5005
#define M_DIVIDE_V                      5006
#define M_DIVIDE_H                      5007
#define M_CELL_OPEN                     5008
#define M_EXIT                          5009
#define M_CREDENTIALS                   5013
#define M_PROPERTIES                    5016
#define M_SVC_START                     5025
#define M_SVC_DELETE                    5026
#define M_SVC_CREATE                    5035
#define M_SVC_RESTART                   5037
#define M_SVC_STOP                      5040
#define M_SVR_VIEW_LARGE                5042
#define M_SVR_VIEW_SMALL                5043
#define M_SVR_VIEW_REPORT               5044
#define M_SVR_HOSTS                     5045
#define M_SET_DELETE                    5048
#define M_SET_REPLICATION               5049
#define M_SET_RENAME                    5050
#define M_SET_LOCK                      5051
#define M_SET_UNLOCK                    5052
#define M_SET_RELEASE                   5053
#define M_SET_CLONE                     5055
#define M_SET_VIEW_REPORT               5058
#define M_SET_VIEW_TREELIST             5059
#define M_SET_VIEW_TREE                 5060
#define M_SET_CREATE                    5061
#define M_SVR_OPEN                      5062
#define M_SVR_CLOSEALL                  5063
#define M_SVR_CLOSE                     5064
#define M_REFRESH                       5065
#define M_REFRESHALL                    5066
#define M_COLUMNS                       5067
#define M_SVR_CREATE                    5072
#define M_SVR_DELETE                    5073
#define M_SYNCVLDB                      5074
#define M_SVR_INSTALL                   5075
#define M_SVR_PRUNE                     5076
#define M_SVR_UNINSTALL                 5077
#define M_SET_MOVETO                    5079
#define M_SVR_GETDATES                  5080
#define M_VIEWLOG                       5081
#define M_SET_UPDATE                    5084
#define M_SET_DUMP                      5085
#define M_HELP                          5088
#define M_HELP_FIND                     5089
#define M_HELP_XLATE                    5090
#define M_ABOUT                         5091
#define M_SET_MOVEHERE                  5092
#define M_SET_REPHERE                   5093
#define M_OPTIONS                       5094
#define M_ACTIONS                       5095
#define M_SET_SETQUOTA                  5096
#define M_EXPORT                        5097
#define M_SET_RESTORE                   5099
#define AVI_SETMOVE                     5100
#define M_SUBSET                        5101
#define M_SVR_MONITOR                   5102
#define M_VIEW_ONEICON                  5103
#define M_VIEW_TWOICONS                 5104
#define M_VIEW_STATUS                   5105
#define M_SVR_VIEW_ONEICON              5106
#define M_SVR_VIEW_TWOICONS             5107
#define M_SVR_VIEW_STATUS               5108
#define M_KEY_RETURN                    5109
#define M_KEY_TAB                       5110
#define M_KEY_BACKTAB                   5111
#define M_KEY_MENU                      5112
#define M_KEY_ESC                       5113
#define M_KEY_CTRLTAB                   5114
#define M_KEY_CTRLBACKTAB               5115
#define M_KEY_PROPERTIES                5116
#define M_SVR_SECURITY                  5117
#define M_SALVAGE                       5118
#define M_EXECUTE                       5119
#define IDC_STATIC                      -1

// Next default values for new objects
// 
#ifdef APSTUDIO_INVOKED
#ifndef APSTUDIO_READONLY_SYMBOLS
#define _APS_NO_MFC                     1
#define _APS_3D_CONTROLS                     1
#define _APS_NEXT_RESOURCE_VALUE        3104
#define _APS_NEXT_COMMAND_VALUE         5120
#define _APS_NEXT_CONTROL_VALUE         1387
#define _APS_NEXT_SYMED_VALUE           4000
#endif
#endif
