/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

#include "heapdef.h"

	/* if flag == HA_PANIC_CLOSE then all files are removed for more
	   memory */

int heap_panic(enum ha_panic_function flag)
{
  LIST *element,*next_open;
  DBUG_ENTER("heap_panic");

  pthread_mutex_lock(&THR_LOCK_heap);
  for (element=heap_open_list ; element ; element=next_open)
  {
    HP_INFO *info=(HP_INFO*) element->data;
    next_open=element->next;	/* Save if close */
    switch (flag) {
    case HA_PANIC_CLOSE:
      _hp_close(info);
      break;
    default:
      break;
    }
  }
  for (element=heap_share_list ; element ; element=next_open)
  {
    HP_SHARE *share=(HP_SHARE*) element->data;
    next_open=element->next;	/* Save if close */
    switch (flag) {
    case HA_PANIC_CLOSE:
    {
      if (!share->open_count)
	_hp_free(share);
      break;
    }
    default:
      break;
    }
  }
  pthread_mutex_unlock(&THR_LOCK_heap);
  DBUG_RETURN(0);
} /* heap_panic */
