/*!========================================================================

  @file         vta321.cpp
  @ingroup      slowci
  @author       ElkeZ

  @brief        Pascal interface

  @since        2003-10-14  13:18
  @sa           

  ==========================================================================

  \if EMIT_LICENCE


    ========== licence begin  GPL
    Copyright (c) 2003-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



  \endif
 ============================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include  "gta00.h"
#include  "hgg17.h"
#include  "hta320.h"
//
// next two to be excluded if 'new' messagelist can be used without old one
#include  "geo200.h"
#include  "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageEventConverter.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

/*===========================================================================*
 *  DECLARATIONS                                                             *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTION PROTOTYPES                                        *
 *===========================================================================*/

/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/


externC void t321_GetError 
(
    tta_user_proc_globals  *pUpg,
    tsp1_part              *pError
) 
{
    teo200_EventList        eventList;
    teo200_EventList        tmpEventList;
    SAPDBErr_MessageList    messageList;
    SAPDB_Byte             *pMsgText;

    
	pMsgText = REINTERPRET_CAST(SAPDB_Byte*, pError) + sizeof (pError->sp1p_part_header());
    if (eventList.eo200_LoadEventList (pMsgText, pError->sp1p_buf_len(), &tmpEventList))
    {
        SAPDBErr_ConvertEventToMessageList (messageList, eventList);

        SAPDBErr_MessageList * pNextMsg   = messageList.NextMessage();
        SAPDB_Char const     * pMessage   = messageList.Message();
        SAPDB_Char const     * pFileName  = messageList.FileName();
        int                    messageID  = messageList.ID();
        SAPDB_UInt4            lineNo     = messageList.LineNumber();
        int                    messageLen = strlen(messageList.Message());
        char                 * constText  = "in line      of file";

        do 
            {
                pUpg->prot.ln = pUpg->term->blankline;

                /*
                if (tasim_unicode == pUpg->term_simulation)
                {
                    // messagelist will be transferred using UTF8, it has to be converted
                }
                else
                */
                    if (messageLen <= sizeof (pUpg->prot.ln))
                    {
                        // output
                        memcpy (pUpg->prot.ln, pMessage, messageLen);
                        t320prot (*pUpg, messageLen);
                    }
                    else
                    {
                        // to be implemented
                    }
                
                /* if FileName and LineNumber are filled, this should be no comment any more
                pUpg->prot.ln = pUpg->term->blankline;
                memcpy (pUpg->prot.ln, constText, strlen(constText)); 
                g17int4to_line (lineNo, false, 5, 8, pUpg->prot.ln);
                t320prot (*pUpg, strlen(constText));

                pUpg->prot.ln = pUpg->term->blankline;
                memcpy (pUpg->prot.ln, pFileName, strlen(pFileName)); 
                t320prot (*pUpg, strlen(pFileName));
                */
                
            if (pNextMsg != NULL)   
            {
                pMessage   = pNextMsg->Message();
                messageID  = pNextMsg->ID();
                pFileName  = pNextMsg->FileName();
                lineNo     = pNextMsg->LineNumber();
                pNextMsg   = pNextMsg->NextMessage();
                messageLen = strlen(pMessage);
            }
            else
                pMessage = NULL;

            } while (pMessage != NULL);

    }

}


/*---------------------------------------------------------------------------*/
