/*!*********************************************************************

    @file         Proc_ParameterCopy.hpp
    
    @author       DanielD

    @brief

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2003-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
***********************************************************************/

#ifndef PROC_PARAMETERCOPY_HPP
#define PROC_PARAMETERCOPY_HPP

#include "SAPDBCommon/Fields/SAPDBFields_FieldList.hpp"

class SAPDBMem_IRawAllocator;
class SAPDBFields_FieldMap;
class KSQL_PreparedStatement;

/*!

  @class Proc_ParameterCopy
  @brief copy db proc parameters to prevent overwriting
    them through a nested statement context

 */
class Proc_ParameterCopy
    : public SAPDBFields_FieldList
{
public:
    Proc_ParameterCopy (SAPDBMem_IRawAllocator     * allocator,
                        SAPDBFields_IFieldSequence * parameterMap);
    ~Proc_ParameterCopy ();
    void bindParameter (KSQL_PreparedStatement * stmt, int paramIndex);

private:
    SAPDBMem_IRawAllocator * allocator;
    void                   * raw;
};


#endif
