'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbFreeServerMap __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbFreeServerMap \- Free memory used by the server member of an XkbDescRec 
structure
.SH SYNOPSIS
.HP
.B void XkbFreeServerMap
.BI "(\^XkbDescPtr " "xkb" "\^,"
.BI "unsigned int " "which" "\^,"
.BI "Bool " "free_all" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
keyboard description containing server map to free
.TP
.I \- which
mask identifying components of map to free
.TP
.I \- free_all
True => free all server map components and server itself
.SH DESCRIPTION
.LP
The 
.I XkbFreeServerMap 
function frees the specified components of server map in the XkbDescRec 
structure specified by the 
.I xkb 
parameter and sets the corresponding structure component values to NULL. The
.I which parameter specifies a combination of the server map masks and is a 
bitwise inclusive OR 
of the masks listed in Table 1. If 
.I free_all 
is True, 
.I which 
is ignored and 
.I XkbFreeServerMap 
frees every non-NULL structure component in the server map, frees the 
XkbServerMapRec structure 
referenced by the 
.I server 
member of the 
.I xkb 
parameter, and sets the 
.I server 
member to NULL.

.TS
c s
l l
l lw(4i).
Table 1 XkbAllocServerMap Masks
_
Mask	Effect
_
XkbExplicitComponentsMask	T{
The min_key_code and max_key_code fields of the xkb parameter are used to
allocate the explicit field of the server map.
T}
.sp
XkbKeyActionsMask	T{
The min_key_code and max_key_code fields of the xkb parameter are used to 
allocate the key_acts 
field of the server map. The count_acts parameter is used to allocate the acts 
field of the 
server map.
T}
.sp
XkbKeyBehaviorsMask	T{
The min_key_code and max_key_code fields of the xkb parameter are used to 
allocate the behaviors 
field of the server map.
T}
.sp
XkbVirtualModMapMask	T{
The min_key_code and max_key_code fields of the xkb parameter are used to 
allocate the vmodmap 
field of the server map.
T}

.TE
.SH STRUCTURES
.LP
The complete description of an Xkb keyboard is given by an XkbDescRec. The 
component 
structures in the XkbDescRec represent the major Xkb components.

.nf
typedef struct {
   struct _XDisplay * display;      /\(** connection to X server */
   unsigned short     flags;        /\(** private to Xkb, do not modify */
   unsigned short     device_spec;  /\(** device of interest */
   KeyCode            min_key_code; /\(** minimum keycode for device */
   KeyCode            max_key_code; /\(** maximum keycode for device */
   XkbControlsPtr     ctrls;        /\(** controls */
   XkbServerMapPtr    server;       /\(** server keymap */
   XkbClientMapPtr    map;          /\(** client keymap */
   XkbIndicatorPtr    indicators;   /\(** indicator map */
   XkbNamesPtr        names;        /\(** names for all components */
   XkbCompatMapPtr    compat;       /\(** compatibility map */
   XkbGeometryPtr     geom;         /\(** physical geometry of keyboard */
} XkbDescRec, *XkbDescPtr;

.fi
The 
.I display 
field points to an X display structure. The 
.I flags field is private to the library: modifying 
.I flags 
may yield unpredictable results. The 
.I device_spec 
field specifies the device identifier of the keyboard input device, or 
XkbUseCoreKeyboard, which specifies the core keyboard device. The 
.I min_key_code
and 
.I max_key_code 
fields specify the least and greatest keycode that can be returned by the 
keyboard. 

Each structure component has a corresponding mask bit that is used in function 
calls to 
indicate that the structure should be manipulated in some manner, such as 
allocating it 
or freeing it. These masks and their relationships to the fields in the 
XkbDescRec are 
shown in Table 2.

.TS
c s s
l l l
l l l.
Table 2 Mask Bits for XkbDescRec
_
Mask Bit	XkbDescRec Field	Value
_
XkbControlsMask	ctrls	(1L<<0)
XkbServerMapMask	server	(1L<<1)
XkbIClientMapMask	map	(1L<<2)
XkbIndicatorMapMask	indicators	(1L<<3)
XkbNamesMask	names	(1L<<4)
XkbCompatMapMask	compat	(1L<<5)
XkbGeometryMask	geom	(1L<<6)
XkbAllComponentsMask	All Fields	(0x7f)
.TE

The Xkb server map contains the information the server needs to interpret key 
events and is of 
type XkbServerMapRec:

.nf
\&#define XkbNumVirtualMods          16

typedef struct {                    /\(** Server Map */
    unsigned short    num_acts;     /\(** # of occupied entries in acts */
    unsigned short    size_acts;    /\(** # of entries in acts */
    XkbAction *       acts;         /\(** linear 2d tables of key actions, 1 per keycode */
    XkbBehavior *     behaviors;    /\(** key behaviors,1 per keycode */
    unsigned short *  key_acts;     /\(** index into acts, 1 per keycode */
    unsigned char *   explicit;     /\(** explicit overrides of core remapping, 1 per key */
    unsigned char     vmods[XkbNumVirtualMods]; /\(** real mods bound to virtual mods */
    unsigned short *  vmodmap;      /\(** virtual mods bound to key, 1 per keycode*/
} XkbServerMapRec, *XkbServerMapPtr;

.fi
