/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.kde.kjas.server.KJASAppletClassLoader;
import org.kde.kjas.server.KJASAppletStub;
import org.kde.kjas.server.KJASSoundPlayer;
import org.kde.kjas.server.Main;

public class KJASAppletContext
implements AppletContext {
    private Hashtable stubs = new Hashtable();
    private Hashtable images = new Hashtable();
    private String myID;
    private KJASAppletClassLoader loader;
    private boolean active;

    public KJASAppletContext(String string) {
        this.myID = string;
        this.active = true;
    }

    public String getID() {
        return this.myID;
    }

    public void createApplet(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, Hashtable hashtable) {
        String string10 = new String("archive").toUpperCase();
        if (string6 == null) {
            if (hashtable.containsKey(string10)) {
                string6 = (String)hashtable.get(string10);
            }
        } else if (!hashtable.containsKey(string10)) {
            hashtable.put(string10, string6);
        }
        string10 = new String("codebase").toUpperCase();
        if (string5 == null && hashtable.containsKey(string10)) {
            string5 = (String)hashtable.get(string10);
        }
        if (!hashtable.containsKey(string10 = new String("width").toUpperCase())) {
            hashtable.put(string10, string7);
        }
        if (!hashtable.containsKey(string10 = new String("height").toUpperCase())) {
            hashtable.put(string10, string8);
        }
        try {
            Object object;
            KJASAppletClassLoader kJASAppletClassLoader = KJASAppletClassLoader.getLoader(string4, string5);
            if (string6 != null) {
                object = new StringTokenizer(string6, ",", false);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string11 = ((StringTokenizer)object).nextToken().trim();
                    kJASAppletClassLoader.addArchiveName(string11);
                }
            }
            kJASAppletClassLoader.paramsDone();
            object = new KJASAppletStub(this, string, kJASAppletClassLoader.getCodeBase(), kJASAppletClassLoader.getDocBase(), string2, string3, new Dimension(Integer.parseInt(string7), Integer.parseInt(string8)), hashtable, string9, kJASAppletClassLoader);
            this.stubs.put(string, object);
            ((KJASAppletStub)object).createApplet();
        }
        catch (Exception exception) {
            Main.kjas_err("Something bad happened in createApplet: " + exception, exception);
        }
    }

    public void initApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not init and show applet: " + string);
        } else {
            kJASAppletStub.initApplet();
        }
    }

    public void destroyApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not destroy applet: " + string);
        } else {
            Main.debug("stopping applet: " + string);
            kJASAppletStub.die();
            this.stubs.remove(string);
        }
    }

    public void startApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not start applet: " + string);
        } else {
            kJASAppletStub.startApplet();
        }
    }

    public void stopApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not stop applet: " + string);
        } else {
            kJASAppletStub.stopApplet();
        }
    }

    public void destroy() {
        Enumeration enumeration = this.stubs.elements();
        while (enumeration.hasMoreElements()) {
            KJASAppletStub kJASAppletStub = (KJASAppletStub)enumeration.nextElement();
            kJASAppletStub.die();
        }
        this.stubs.clear();
        this.active = false;
    }

    public Applet getApplet(String string) {
        if (this.active) {
            Enumeration enumeration = this.stubs.elements();
            while (enumeration.hasMoreElements()) {
                KJASAppletStub kJASAppletStub = (KJASAppletStub)enumeration.nextElement();
                if (!kJASAppletStub.getAppletName().equals(string)) continue;
                return kJASAppletStub.getApplet();
            }
        }
        return null;
    }

    public Enumeration getApplets() {
        if (this.active) {
            Vector<KJASAppletStub> vector = new Vector<KJASAppletStub>();
            Enumeration enumeration = this.stubs.elements();
            while (enumeration.hasMoreElements()) {
                KJASAppletStub kJASAppletStub = (KJASAppletStub)enumeration.nextElement();
                vector.add(kJASAppletStub);
            }
            return vector.elements();
        }
        return null;
    }

    public AudioClip getAudioClip(URL uRL) {
        Main.debug("getAudioClip, url = " + uRL);
        return new KJASSoundPlayer(uRL);
    }

    public void addImage(String string, byte[] byArray) {
        Main.debug("addImage for url = " + string);
        this.images.put(string, byArray);
    }

    public Image getImage(URL uRL) {
        if (this.active && uRL != null) {
            String string = uRL.toString();
            Main.debug("getImage, url = " + string);
            Main.protocol.sendGetURLDataCmd(this.myID, string);
            while (!this.images.containsKey(string) && this.active) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.images.containsKey(string)) {
                byte[] byArray = (byte[])this.images.get(string);
                if (byArray.length > 0) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    return toolkit.createImage(byArray);
                }
                return null;
            }
        }
        return null;
    }

    public void showDocument(URL uRL) {
        Main.debug("showDocument, url = " + uRL);
        if (this.active && uRL != null) {
            Main.protocol.sendShowDocumentCmd(this.myID, uRL.toString());
        }
    }

    public void showDocument(URL uRL, String string) {
        Main.debug("showDocument, url = " + uRL + " targetFrame = " + string);
        if (this.active && uRL != null && string != null) {
            Main.protocol.sendShowDocumentCmd(this.myID, uRL.toString(), string);
        }
    }

    public void showStatus(String string) {
        if (this.active && string != null) {
            Main.protocol.sendShowStatusCmd(this.myID, string);
        }
    }
}

