/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmark-file.h,v 1.8 2005/07/12 01:55:11 ikezoe Exp $
 */

#ifndef __KZ_BOOKMARK_FILE_H__
#define __KZ_BOOKMARK_FILE_H__

#include <glib-object.h>
#include "kz-bookmark.h"

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARK_FILE		(kz_bookmark_file_get_type ())
#define KZ_BOOKMARK_FILE(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARK_FILE, KzBookmarkFile))
#define KZ_BOOKMARK_FILE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_BOOKMARK_FILE, KzBookmarkFileClass))
#define KZ_IS_BOOKMARK_FILE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARK_FILE))
#define KZ_IS_BOOKMARK_FILE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_BOOKMARK_FILE))
#define KZ_BOOKMARK_FILE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_BOOKMARK_FILE, KzBookmarkFileClass))

#define KZ_TYPE_BOOKMARK_FILE_TYPE		(kz_bookmark_file_type_get_type())

typedef struct _KzBookmarkFile         KzBookmarkFile;
typedef struct _KzBookmarkFileClass    KzBookmarkFileClass;
typedef struct _KzBookmarkFileType     KzBookmarkFileType;

typedef enum {
	KZ_BOOKMARK_FILE_EDITABLE_FLAG    = 1 << 0,  /* not used yet */
} KzBookmarkFileFlag;

typedef enum {
	KZ_BOOKMARK_FILE_STATE_NORMAL,
	KZ_BOOKMARK_FILE_STATE_LOADING,
	KZ_BOOKMARK_FILE_STATE_SAVING
} KzBookmarkFileState;

struct _KzBookmarkFile
{
	KzBookmark         parent;
	KzBookmarkFileFlag  flags;
};

struct _KzBookmarkFileClass
{
	KzBookmarkClass parent_class;

	/* -- signals -- */

	void (*load_start)         (KzBookmarkFile  *bookmark_file);
	void (*load_completed)     (KzBookmarkFile  *bookmark_file);
	void (*save_start)         (KzBookmarkFile  *bookmark_file);
	void (*save_completed)     (KzBookmarkFile  *bookmark_file);

	void (*error)              (KzBookmarkFile  *bookmark_file,
				    const gchar     *message);
};

struct _KzBookmarkFileType
{
	gint         priority_hint;
	const gchar *file_type;
	gboolean   (*is_supported) (KzBookmarkFile  *bookmark_file,
				    const gchar     *buffer);
	void       (*init)         (KzBookmarkFile  *bookmark_file);
	gboolean   (*from_string)  (KzBookmarkFile  *bookmark_file,
				    const gchar     *buffer,
				    guint            length,
				    GError         **error);
	gchar     *(*to_string)    (KzBookmarkFile  *bookmark_file);
};


/* GType */
GType		kz_bookmark_file_get_type	(void) G_GNUC_CONST;

/* boomark item creating functions */
KzBookmarkFile     *kz_bookmark_file_new	(const gchar *location,
						 const gchar *title,
						 const gchar *file_type);

KzBookmarkFile     *kz_bookmark_file_create_new	(const gchar *location,
						 const gchar *title,
						 const gchar *file_type);

/* set/get properties */
/*
 * "location" means location of bookmark_file file itself.
 */
const gchar    *kz_bookmark_file_get_location	(KzBookmarkFile  *bookmark_file);
const gchar    *kz_bookmark_file_get_file_type	(KzBookmarkFile  *bookmark_file);
const gchar    *kz_bookmark_file_get_xmlrpc	(KzBookmarkFile  *bookmark_file);
const gchar    *kz_bookmark_file_get_xmlrpc_user(KzBookmarkFile  *bookmark_file);
const gchar    *kz_bookmark_file_get_xmlrpc_pass(KzBookmarkFile  *bookmark_file);
guint		kz_bookmark_file_get_interval   (KzBookmarkFile  *bookmark_file);
gboolean        kz_bookmark_file_is_editable    (KzBookmarkFile  *bookmark_file);

void		kz_bookmark_file_set_location	(KzBookmarkFile  *bookmark_file,
						 const gchar     *location);
void		kz_bookmark_file_set_file_type	(KzBookmarkFile  *bookmark_file,
						 const gchar     *file_type);
void		kz_bookmark_file_set_interval	(KzBookmarkFile  *bookmark_file,
						 guint            interval);
void		kz_bookmark_file_set_xmlrpc	(KzBookmarkFile  *bookmark_file,
						 const gchar     *xmlrpc);
void		kz_bookmark_file_set_xmlrpc_user(KzBookmarkFile  *bookmark_file,
						 const gchar     *user);
void		kz_bookmark_file_set_xmlrpc_pass(KzBookmarkFile  *bookmark_file,
						 const gchar     *pass);

/* load/save interface */
/* async */
gboolean	kz_bookmark_file_load_start	 (KzBookmarkFile *bookmark_file);
void		kz_bookmark_file_load_stop	 (KzBookmarkFile *bookmark_file);
gboolean	kz_bookmark_file_save_start	 (KzBookmarkFile *bookmark_file);
void		kz_bookmark_file_save_stop	 (KzBookmarkFile *bookmark_file);
/* sync */
void		kz_bookmark_file_load		 (KzBookmarkFile *bookmark_file);
void		kz_bookmark_file_save		 (KzBookmarkFile *bookmark_file);

KzBookmarkFileState kz_bookmark_file_get_state	 (KzBookmarkFile *bookmark_file);

gboolean	kz_bookmark_file_has_xmlrpc	 (KzBookmarkFile *bookmark_file);
void		kz_bookmark_file_xmlrpc_insert   (KzBookmarkFile *file, 
						  KzBookmark *folder,
						  KzBookmark *sibling,
						  KzBookmark *child);
void		kz_bookmark_file_xmlrpc_remove   (KzBookmarkFile *file, 
						  KzBookmark *child);
void		kz_bookmark_file_xmlrpc_move     (KzBookmarkFile *file,
						  KzBookmark *folder,
						  KzBookmark *sibling,
						  KzBookmark *child);
gboolean	kz_bookmark_file_is_update	 (KzBookmarkFile *bookmark_file);

G_END_DECLS

#endif /* __KZ_BOOKMARK_FILE_H__ */
