///////
   //    _Url.cc
   //    _Url Class definitions
   //
   //    Class to interface with Url table of mysql Database
   //    This inherits from the Url class.
   //
   //    Copyright (c) 1999-2002 Comune di Prato - Prato - Italy
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: _Url.cc,v 1.9 2002/02/18 10:44:59 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.07.1999
///////

#include "_Url.h"

///////
   //    Static variables
///////

   unsigned int _Url::TotUrls = 0;
   

///////
   //    Construction
///////

_Url::_Url ()
   : URL (),
   IDUrl(0),
   IDServer(0),
   ContentType(0),
   TransferEncoding(0),
   LastModified(0),
   LastAccess(0),
   Size(0),
   StatusCode(0),
   ReasonPhrase(0),
   Location(0),
   pServer(0),
   Title(0),
   ConnStatus(Url_OtherError),
   ContentLanguage(0),
   _HideLastModified(0)
{
}


_Url::_Url (const String &url)
   : URL (url),
   IDUrl(0),
   IDServer(0),
   ContentType(0),
   TransferEncoding(0),
   LastModified(0),
   LastAccess(0),
   Size(0),
   StatusCode(0),
   ReasonPhrase(0),
   Location(0),
   pServer(0),
   Title(0),
   ConnStatus(Url_OtherError),
   ContentLanguage(0),
   _HideLastModified(0)
{
}


_Url::_Url (const _Url &rhs)
   : URL (rhs),
   IDUrl(rhs.IDUrl),
   IDServer(rhs.IDServer),
   ContentType(rhs.ContentType),
   TransferEncoding(rhs.TransferEncoding),
   LastModified(rhs.LastModified),
   LastAccess(rhs.LastAccess),
   Size(rhs.Size),
   StatusCode(rhs.StatusCode),
   ReasonPhrase(rhs.ReasonPhrase),
   Location(rhs.Location),
   pServer(rhs.pServer),
   Title(rhs.Title),
   ConnStatus(rhs.ConnStatus),
   ContentLanguage(rhs.ContentLanguage),
   _HideLastModified(rhs._HideLastModified)
{

}


_Url::_Url (const String &ref, _Url &parent)
   : URL (ref, parent),
   IDUrl(0),
   IDServer(parent.IDServer),
   ContentType(0),
   TransferEncoding(0),
   LastModified(0),
   LastAccess(0),
   Size(0),
   StatusCode(0),
   ReasonPhrase(0),
   Location(0),
   pServer(parent.pServer),
   Title(0),
   ConnStatus(Url_OtherError),
   ContentLanguage(0),
   _HideLastModified(0)
{
}


///////
   //    Destruction
///////

_Url::~_Url ()
{
   
}


///////
   //    Reset
///////

void _Url::Reset()
{
    IDUrl = 0;
    IDServer = 0;
    ContentType.trunc();
    TransferEncoding.trunc();
    Size = 0;
    StatusCode = 0;
    ReasonPhrase.trunc();
    Location.trunc();
    pServer = 0;
    Title.trunc();
    ContentLanguage.trunc();
   
    if (LastModified)
        delete LastModified;

    if (LastAccess)
        delete LastAccess;
      
    ConnStatus = Url_OtherError;
    _HideLastModified = false;

}


///////
   //    Managing the Connection Status of the Url
///////

void _Url::SetLastModified (HtDateTime *d)
{

   // If we had a previous value, let's delete it
   //   if (LastModified)
   //      delete LastModified;

   LastModified = d;  // just change it

}


///////
   //    Gives back the last modified time value for a URL
   //    depending also on the settings of the HideLastModified
   //    variable (in some cases we don't wanna show a last modified
   //    value - not found URLs, redirected ones, etc.)
///////

const HtDateTime *_Url::GetLastModified () const
{

   if (_HideLastModified)
      return 0;
   else return LastModified;

}


///////
   //    Managing the Connection Status of the Url
///////

///////
   //    Converts the Url_ConnStatus value into the corresponding
   //    String value
///////

void _Url::RetrieveConnStatus(String &Status) const
{

   switch(GetConnStatus())
   {
      case (Url_OK):
         Status="OK";
         break;
      case (Url_NoHeader):
         Status="NoHeader";
         break;
      case (Url_NoHost):
         Status="NoHost";
         break;
      case (Url_NoPort):
         Status="NoPort";
         break;
      case (Url_ConnectionDown):
         Status="ConnectionDown";
         break;
      case (Url_NoConnection):
         Status="NoConnection";
         break;
      case (Url_ServiceNotValid):
         Status="ServiceNotValid";
         break;
      case (Url_OtherError):
         Status="OtherError";
         break;
   }

}


///////
   //    Converts the Status string value
   //    into the corresponding Schedule_Status value 
   //    Returns 0 if an error occurs, 1 if OK.
///////

int _Url::SetConnStatus(const String &Status)
{

   if (!strcmp(Status, "OK"))
      SetConnStatus (Url_OK);
   if (!strcmp(Status, "NoHeader"))
      SetConnStatus (Url_NoHeader);
   else if (!strcmp(Status, "NoHost"))
      SetConnStatus (Url_NoHost);
   else if (!strcmp(Status, "NoPort"))
      SetConnStatus (Url_NoPort);
   else if (!strcmp(Status, "NoConnection"))
      SetConnStatus (Url_NoConnection);
   else if (!strcmp(Status, "ConnectionDown"))
      SetConnStatus (Url_ConnectionDown);
   else if (!strcmp(Status, "ServiceNotValid"))
      SetConnStatus (Url_ServiceNotValid);
   else if (!strcmp(Status, "OtherError"))
      SetConnStatus (Url_OtherError);
   else return 0;
   
   return 1;
}
