/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: miniopenwavesurf.cpp,v 1.7.12.1 2004/07/09 01:59:07 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "minisite.h"
#include "hxvsurf.h"
#include "ciddefs.h"

#include "miniopenwavesurf.h"
#include "miniopenwavesite.h"
#include "opwindow.h"


CMiniOpenwaveSurface::CMiniOpenwaveSurface(IUnknown* pContext, CMiniBaseSite* pSite)
    :  CMiniBaseSurface(pContext, pSite)
	,  m_nCompositionSize(0)
	,  m_nCompositionPitch(0)
    ,  m_pCompositionSurface(NULL)
    ,  m_ulTotalFramesBlted(0)
	,  m_cidIn(-1)
	,  m_cidOut(-1)
{
}

CMiniOpenwaveSurface::~CMiniOpenwaveSurface()
{

	HX_FREE(m_pCompositionSurface);
	m_nCompositionSize  = 0;
    m_nCompositionPitch = 0;
	memset(&m_surfaceSize, 0, sizeof( m_surfaceSize ) );
}

HX_RESULT CMiniOpenwaveSurface::_CreateDestBuffer( int cidIn,
                                                  int nWidth,
                                                  int nHeight,
                                                  int& nCount)
{
    HX_RESULT res = HXR_OK;

	HX_ASSERT( m_pSite );

    //For now, we only support RGB32
    HX_ASSERT( cidIn == CID_I420 );
	m_cidIn = cidIn;
	m_cidOut = CID_RGB565;

	int sc, sw, sh;

	COpWindow *pOpWin = ((CHXOpenwaveSite*)m_pSite)->GetOpWindow();
	/// color info has to be converted to something both sides understand
	/// for now it is hard coded
	pOpWin->GetScreenInfo(sc, sw, sh);
	((CHXOpenwaveSite*)m_pSite)->_SetScreenSize(sw, sh);


	/// if the site's default size is bigger than the image
	/// then make site fit the image instead of scaling the 
	/// image to fit the site
	if (nWidth < sw)
	{
		sw = nWidth;
	}
	if (nHeight < sh)
	{
		sh = nHeight;
	}

	HXxSize newScreenSize = {sw, sh};

	/// since we are sue sw <= nWidth and sh <= nHeight
	/// now let us do the scaling down to preserve the proportion of 
	/// original image, nWidth:nHeight
	float hr = (float)sh/(float)nHeight;
	float wr = (float)sw/(float)nWidth;
	if (hr < 1.0 && wr < 1.0)
	{
		if (hr < wr)
		{
			newScreenSize.cx = sh*nWidth/nHeight;
			newScreenSize.cy = sh;
		}
		else
		{
			newScreenSize.cx = sw;
			newScreenSize.cy = sw*nHeight/nWidth;
		}
	}


	/// color info has to be converted to something both sides understand
	/// for now it is hard coded
	pOpWin->SetImageInfo(m_cidOut, newScreenSize.cx, newScreenSize.cy);
	
	m_pSite->SetSize(newScreenSize);

	//Get the size of this site.
    m_pSite->GetSize(m_surfaceSize);

    //Malloc the room to hold the actual bits.
    HXBitmapInfo bmiTemp;
    m_pImageHelper->MakeBitmap( &bmiTemp,
                                sizeof(bmiTemp),
                                m_cidOut,
                                m_surfaceSize.cx,
                                m_surfaceSize.cy,
                                NULL,
                                0);
    
    m_nCompositionPitch = m_pImageHelper->GetBitmapPitch(&bmiTemp);
    int imageSize = bmiTemp.bmiHeader.biSizeImage;
    _ResizeVideoBuffer(imageSize);

    HX_ASSERT( m_pImageHelper->GetBitmapColor(&bmiTemp) == m_cidOut );

    return res;
}

HX_RESULT CMiniOpenwaveSurface::_ResizeVideoBuffer( INT32 nSize)
{
    HX_RESULT retVal=HXR_OK;

    //XXXgfw. Trade off here. We can use lots of mem if we just return and
    //the user has scaled the image up very much and then goes back down.
    //If we don't just return we can do tons and tons of mallocs. Maybe we
    //should add a timed callback to reclaim some of this mem after a few
    //seconds.
    if(nSize <= (INT32)m_nCompositionSize)
        return retVal;

    if(m_pCompositionSurface == NULL)
    {
        m_pCompositionSurface = (UCHAR*) malloc(nSize);
    }
    else
    {
        m_pCompositionSurface = (UCHAR*) realloc(m_pCompositionSurface, nSize);
    }
    if( m_pCompositionSurface )
    {
        m_nCompositionSize = nSize;
    }
    else
    {
        HX_ASSERT("We can't alloc the composition surface." == NULL );
        m_nCompositionSize = 0;
    }

    return retVal;
}
         
HX_RESULT CMiniOpenwaveSurface::_LockDestBuffer( UCHAR** ppDestPtr,
                                                LONG32* pnDestPitch,
                                                int& cid,
                                                REF(HXxSize) srcSize,
                                                int nIndex)
{
    HX_RESULT res = HXR_OK;

	*ppDestPtr = m_pCompositionSurface;
    *pnDestPitch = m_nCompositionPitch;
    cid = m_cidOut;
    
    return res;
}

         
HX_RESULT CMiniOpenwaveSurface::_TransferToDestBuffer( UCHAR*   pSrcBuffer,
                                                      HXBitmapInfoHeader* pBitmapInfo,
                                                      HXxRect* prSrcRect,
                                                      HXxRect* prDstRect,
                                                      UCHAR*   pDstBuffer,
                                                      LONG32   nDstPitch)
{
    HX_RESULT res = HXR_OK;


    //XXXGfw when we really have a buffer to color convert to we
    //can uncomment this....

	BOOL bTransfer = FALSE;
	UCHAR* pOutBuffer = pSrcBuffer;

	if ((prSrcRect != prDstRect) || (m_cidIn != m_cidOut))
	{
		bTransfer = TRUE;

	}

	// First do the transfer if it needed
	if (bTransfer)
	{
		res =  CMiniBaseSurface::_TransferToDestBuffer( pSrcBuffer,
			                                             pBitmapInfo,
				                                         prSrcRect,
					                                     prDstRect,
						                                 pDstBuffer,
							                             nDstPitch);
		if (SUCCEEDED(res))
		{
			pOutBuffer = pDstBuffer;
		}
	}
    
	// Simply set the source buffer back to TLC's window object
	// and invalidate the window for drawing to happen 
	// in the next event loop
	COpWindow *pOpWin = ((CHXOpenwaveSite*)m_pSite)->GetOpWindow();

	pOpWin->SetImageSource(pOutBuffer);
	pOpWin->Invalidate();

    return res;
}

         
HX_RESULT CMiniOpenwaveSurface::_UnlockDestBuffer(UCHAR* pSurfPtr, int nIndex)
{
    //Nothing to do here for Openwave.....
    return HXR_OK;
}

         
HX_RESULT CMiniOpenwaveSurface::_RenderDestBuffer(HXxRect* prSrcRect,
                                                  HXxRect* prDestRect,
                                                  int nIndex)
{
    HX_RESULT res = HXR_OK;

	// Since we already invalidated the window in the _TransferToDstBuffer which
	// will render the frame, so nothing to do here but simply
    // output a message here about how many frames we have seen...
    m_ulTotalFramesBlted++;
#ifdef _DEBUG
		fprintf(stderr, "CMiniOpenwaveSurface: m_ulTotalFramesBlted: m_ulTotalFramesBlted\n");
#endif

    
    return res;
}

         
HX_RESULT CMiniOpenwaveSurface::_DestroyDestBuffer(int cid, int nCount)
{
	HX_FREE(m_pCompositionSurface);
    m_nCompositionSize  = 0;
    m_nCompositionPitch = 0;
    memset(&m_surfaceSize, 0, sizeof( m_surfaceSize ) );
    
    return HXR_OK;
}

HX_RESULT CMiniOpenwaveSurface::_init()
{
   return HXR_OK;
}

int CMiniOpenwaveSurface::GetDstCID(int nIndex)
{
    //right hard coded, but should use GetScreenInfo call to set
	// it correctly
    return m_cidOut;
}

