# ***** BEGIN LICENSE BLOCK *****
# Source last modified: $Id: installer.py,v 1.2.2.4 2004/07/09 02:02:53 hubbe Exp $
# 
# Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
# 
# The contents of this file, and the files included with this file,
# are subject to the current version of the RealNetworks Public
# Source License (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the current version of the RealNetworks Community
# Source License (the "RCSL") available at
# http://www.helixcommunity.org/content/rcsl, in which case the RCSL
# will apply. You may also obtain the license terms directly from
# RealNetworks.  You may not use this file except in compliance with
# the RPSL or, if you have a valid RCSL with RealNetworks applicable
# to this file, the RCSL.  Please see the applicable RPSL or RCSL for
# the rights, obligations and limitations governing use of the
# contents of the file.
# 
# Alternatively, the contents of this file may be used under the
# terms of the GNU General Public License Version 2 or later (the
# "GPL") in which case the provisions of the GPL are applicable
# instead of those above. If you wish to allow use of your version of
# this file only under the terms of the GPL, and not to allow others
# to use your version of this file under the terms of either the RPSL
# or RCSL, indicate your decision by deleting the provisions above
# and replace them with the notice and other provisions required by
# the GPL. If you do not delete the provisions above, a recipient may
# use your version of this file under the terms of any one of the
# RPSL, the RCSL or the GPL.
# 
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the
# portions it created.
# 
# This file, and the files included with this file, is distributed
# and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
# KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
# ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
# ENJOYMENT OR NON-INFRINGEMENT.
# 
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
# 
# Contributor(s):
# 
# ***** END LICENSE BLOCK *****
# Installer: installer base class. Contains methods for manipulating
# the temp install dir and making the archive and installer
#######################################################################

execfile(os.path.join(project.inst_script_dir, "defines.py"))

class Installer:

    #######################################################################
    # Constructor: tempdir is the name of the temp install directory
    def __init__(self):
        self.tempdir = "temp"
        self.archive_info_header = "archive_info.h"
        self.inst_output_dir = project.output_dir
        self.module_output_dir = project.output_dir
        self.include_archive_prog = 0
        self.stage1_name = "stage1"
        self.installer_name = None
        self.product_name = None
        self.version = None

        # XXXJDG this should be in a project variable somewhere
        if (project.BuildOption("release")):
            self.copy_dir = os.path.join(project.src_root_path, "release")
        else:
            self.copy_dir = os.path.join(project.src_root_path, "debug")

    #######################################################################
    # CreateMainDir: creates the main temp install directory, removing 
    # the existing copy if there is one.
    def CreateMainDir(self):
        project.writeln("all:")

        # create temp directory and subdirectories
        project.writeln(
            "\t@echo \"==== creating temporary directory \'" + self.tempdir + \
            "\' ====\"")
        project.writeln("\t" + platform.rmdir.cmd + " " + self.tempdir)
        project.writeln("\t" + platform.mkdir.execute(self.tempdir))

    #######################################################################
    # MakeDir: creates a subdirectory of the install directory
    def MakeDirs(self, *dirs):
        for dir in dirs:
            self.MakeDir(dir)

    def MakeDir(self, subdir):
        if(subdir == ""):
            subdir_path = self.tempdir
        else:
            subdir_path = os.path.join(self.tempdir, self.NativePath(subdir))
        project.writeln("\t" + platform.mkdir.execute(subdir_path))

    #######################################################################
    # CopyFile: copies file(s) from source_path to dest_path in the install
    # directory. Can include wildcards.
    def CopyFiles(self, *files):
        for file in files:
            self.CopyFile(file[0], file[1])

    def CopyMultiFiles(self, source, dest, *files):
        for file in files:
            self.CopyFile(os.path.join(source, file), os.path.join(dest, file))

    def CopyFile(self, source, dest):
        # dest_path is a subdirectory of the temp dir
        if (dest == ""):
            destfull = self.tempdir
        else:
            destfull = os.path.join(self.tempdir, self.NativePath(dest))

        # write the copy command
        project.writeln("\t" + platform.copy.cmd + " " + \
            self.NativePath(source) + " " + destfull)

    #######################################################################
    # CopyModuleFile: copies file(s) from source_path in the source root 
    # to dest_path in the install directory.
    def CopyModuleFiles(self, *files):
        for file in files:
            self.CopyModuleFile(file[0], file[1])

    def CopyModuleFile(self, source, dest):
        self.CopyFile(os.path.join(project.src_root_path, source), dest)

    #######################################################################
    # CopyModuleBuildFile: copies a file from a module's output directory
    def CopyModuleBuildFiles(self, *files):
        for file in files:
            self.CopyModuleBuildFile(file[0], file[1], file[2])

    def CopyModuleBuildFile(self, module, source, dest):
        source_file = os.path.join(project.src_root_path, module, 
                self.module_output_dir, source)
        if not os.path.exists(source_file):
            source_file = os.path.join(project.src_root_path, module, source)

        self.CopyFile(source_file, dest)

    #######################################################################
    # CopyModuleExe: copies an executable, with appropriate extension
    def CopyModuleExes(self, *exes):
        for exe in exes:
            self.CopyModuleExe(exe[0], exe[1], exe[2])

    def CopyModuleExe(self, module, source, dest):
        self.CopyModuleBuildFile(module, self.GetExeName(source),
            self.GetExeName(dest))

    #######################################################################
    # CopyInstallerExe: copies an installer exe, with appropriate extension
    def CopyInstallerExes(self, *exes):
        for exe in exes:
            self.CopyInstallerExe(exe[0], exe[1], exe[2])

    def CopyInstallerExe(self, module, source, dest):        
        self.CopyFile(os.path.join(project.src_root_path, module,
            self.inst_output_dir, self.GetExeName(source)),
            self.GetExeName(dest))

    def GetExeName(self, file):
        if (platform.exe_suffix == ""):
            return file
        else:
            return file + "." + platform.exe_suffix

    #######################################################################
    # CopyModuleDll: copies a dll, with appropriate extension
    def CopyModuleDlls(self, *dlls):
        for dll in dlls:
            self.CopyModuleDll(dll[0], dll[1], dll[2])

    def CopyModuleDll(self, module, source, dest):
        self.CopyModuleBuildFile(module, self.GetDllName(source), 
            self.GetDllName(dest))

    def GetDllName(self, file):
        if (platform.dll_suffix == ""):
            return file
        else:
            return file + "." + platform.dll_suffix
        
    #######################################################################
    # CopyModuleLib: copies a library, with appropriate extension
    def CopyModuleLibs(self, *libs):
        for lib in libs:
            self.CopyModuleLib(lib[0], lib[1], lib[2])

    def CopyModuleLib(self, module, source, dest):
        self.CopyModuleBuildFile(module, self.GetLibName(source), 
            self.GetLibName(dest))

    def GetLibName(self, file):
        if (platform.library_suffix == ""):
            return file
        else:
            return file + "." + platform.library_suffix        

    #######################################################################
    # CleanupTempdir: finishes off the makefile ...
    def CleanupTempdir(self):
        project.writeln("copy:")
        project.writeln("depend:")
        project.writeln("clean:")
        project.writeln("\t" + platform.rmdir.cmd + " " + self.tempdir)
        project.writeln("")

    #######################################################################
    # SetArchiveType: sets the archive type
    def SetArchiveType(self, archive_type):
        self.archive_type = archive_type
        if (self.archive_type == "bz2"):
            self.archive_prog = os.path.join(project.bzip2_path,
                self.inst_output_dir, "bzip2")

    #######################################################################
    # CleanTempFiles: clean up temp files
    def CleanTempFiles(self):
        project.writeln("\t%s %s" % (platform.rmdir.cmd, self.tempdir))
        project.writeln("\t%s %s" % (platform.rm.cmd, self.archive_file))

    #######################################################################
    # MakeCleanTemp: creates the cleaup makefile, to cleanup temp files
    def MakeCleanTemp(self):
        project.writeln("all:")
        project.writeln("\t@echo ==== removing temp files ====")
        self.CleanTempFiles()

        project.writeln("depend::")
        project.writeln("")

        project.writeln("copy::")
        project.writeln("")

        project.writeln("clean::")
        self.CleanTempFiles()

        project.writeln("")

    #######################################################################
    # MakeInstaller: Writes the makefile to create the final installer.
    # Combines stage1 app with archive and (if necessary) the archive prog.
    def MakeInstaller(self, stage1_path = None):
        return

        
    #######################################################################
    # SetVersionFromFile: set the product version from a .ver file
    def SetVersionFromFile(self, verfile):
        # we need to strip the .ver extension, because get_version()
        # automatically adds it for us
        if verfile[-4:] == ".ver":
            verfile = verfile[:-4]
        try:
            self.version = platform.versioning.get_version(verfile,"")
        except:
            project.warn("unable to read version file %s.ver" % verfile)


    #######################################################################
    # SetInstallerName: come up with a uniform installer name that
    # incorporates the name, system id and version info
    def SetInstallerName(self, name = None, verfile = None):
        # default: no version string
        verstr = ""

        if verfile:
            self.SetVersionFromFile(verfile)
        verstr = "-%s.%s.%s.%s" % self.version

        if not name:
            name = self.product_name

        if platform.type == "unix":
            ext = "bin"
        else:
            ext = "exe"

        self.installer_name = "%s%s-%s.%s" % (name, verstr, sysinfo.id, ext)


    #######################################################################
    # CopyArchive: copy the archive target to the debug or release dir
    # incorporates the name, system id and version info
    def CopyArchive(self, name = None, verfile = None):
        # default: no version string
        verstr = ""

        if verfile:
            self.SetVersionFromFile(verfile)
        verstr = "-%s.%s.%s.%s" % self.version
           
        if not name:
            name = self.product_name

        if self.archive_type == "bz2":
            ext = "tar.bz2"
        else:
            ext = self.archive_type

        dest_arch = "%s%s-%s.%s" % (name, verstr, sysinfo.id, ext)
        project.writeln("copy:")
        project.writeln("\t %s %s %s" %
                        (platform.copy.cmd, self.archive_file,
                         os.path.join(project.target_dir, dest_arch)))
