/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: ppffhttp.h,v 1.1.1.1.38.1 2004/07/19 21:04:16 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _PPLYHTTP_H_
#define _PPLYHTPP_H_



class CScalableHTTP : public IUnknown 
{
public:
    CScalableHTTP();
    ~CScalableHTTP();

    // *** IUnknown methods ***
    STDMETHOD(QueryInterface)	(THIS_
				 REFIID riid,
				 void** ppvObj);
    
    STDMETHOD_(ULONG32,AddRef)	(THIS);
    
    STDMETHOD_(ULONG32,Release)	(THIS);

    HX_RESULT	Init(IUnknown* pContext, UINT32 ulTimeout);
    HX_RESULT   Post(REF(CHXString) strMsg, const char* pHost, UINT16 nPort);

    HX_RESULT	ConnectDone(HX_RESULT status);
    HX_RESULT	ReadDone(HX_RESULT status, IHXBuffer* pBuffer);
    HX_RESULT	Closed(HX_RESULT status);

private:
    void	RemoveCallback(void);

private:
    class CHTTPResponse : public IHXTCPResponse
    {
    public:
    
    	CHTTPResponse();
    	~CHTTPResponse();
    
    	HX_RESULT Init(CScalableHTTP* pOwner);
    	
	// *** IUnknown methods ***
	STDMETHOD(QueryInterface)	(THIS_
					REFIID riid,
					void** ppvObj);

	STDMETHOD_(ULONG32,AddRef)	(THIS);

	STDMETHOD_(ULONG32,Release)	(THIS);

    	/*
     	*	IHXTCPResponse methods
     	*/
    
    	STDMETHOD(ConnectDone)	(THIS_
				     HX_RESULT		status);
    
    	STDMETHOD(ReadDone)		(THIS_
				    HX_RESULT		status,
				    IHXBuffer*		pBuffer);
    
    	STDMETHOD(WriteReady)	(THIS_
    				    HX_RESULT		status);
    
    	STDMETHOD(Closed)		(THIS_
				    HX_RESULT		status);

    protected:
    	LONG32			m_lRefCount;
    	CScalableHTTP*		m_pOwner;
    };

    class CHTTPConnectionTimeoutCallback : public IHXCallback
    {
    public:
	CHTTPConnectionTimeoutCallback(CScalableHTTP* pOwner);
	~CHTTPConnectionTimeoutCallback();

	// *** IUnknown methods ***
	STDMETHOD(QueryInterface)	(THIS_
					REFIID riid,
					void** ppvObj);

	STDMETHOD_(ULONG32,AddRef)	(THIS);

	STDMETHOD_(ULONG32,Release)	(THIS);

	// *** IHXCallback method ***
	STDMETHOD(Func) (THIS);

	// for m_ulCallbackID				    
	friend class CScalableHTTP;				    

    private:
    	LONG32			m_lRefCount;
	CScalableHTTP*		m_pOwner;	
	CallbackHandle		m_ulCallbackID;	
    };

private:
    IHXBuffer*		    m_pBufMsg;
    IHXTCPSocket*	    m_pSocket;
    CHTTPResponse*	    m_pResponse;   
    LONG32		    m_lRefCount;    
    BOOL		    m_bReleased;
    UINT32		    m_ulConnTimeout;
    IHXScheduler*	    m_pScheduler;
    CHTTPConnectionTimeoutCallback* m_pCallback;   
};


#endif //  _PPLYHTTP_H_

