/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: file_info.cpp,v 1.1.4.1 2004/11/24 18:02:52 acolwell Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#include "file_info.h"

#include "group_info.h"
#include "ogg_timestamp.h"
#include "hxassert.h"

COggFileInfo::COggFileInfo() :
    m_uGroupCount(0),
    m_ppGroups(NULL)
{}

COggFileInfo::~COggFileInfo()
{
    if (m_ppGroups)
    {
        for (UINT32 i = 0; i < m_uGroupCount; i++)
        {
            delete m_ppGroups[i];
        }

        delete [] m_ppGroups;
        m_ppGroups = NULL;
        m_uGroupCount = 0;
    }
}

UINT32 COggFileInfo::GroupCount() const
{
    return m_uGroupCount;
}

HX_RESULT 
COggFileInfo::GetDuration(COggTimestamp& duration) const
{
    HX_RESULT res = HXR_UNEXPECTED;

    if (m_uGroupCount)
    {
        duration = m_duration;
        res = HXR_OK;
    }

    return res;
}

HX_RESULT 
COggFileInfo::GetGroupByTimestamp(UINT32 uTimestamp, 
                                  UINT32& uGroupIndex) const
{
    HX_RESULT res = HXR_UNEXPECTED;

    for (UINT32 i = 0; (HXR_OK != res) && (i < m_uGroupCount); i++)
    {
        COggTimestamp start;
        COggTimestamp duration;

        if ((HXR_OK == m_ppGroups[i]->GetStartTime(start)) &&
            (HXR_OK == m_ppGroups[i]->GetDuration(duration)))
        {
            // Convert the start time and durations to
            // the highest sample rate between the 2. 
            // This is a lossy operation, but it prevents
            // us from having to deal with large fractions.
            start.SetSampleRateToHighest(duration);
            duration.SetSampleRateToHighest(start);

            COggTimestamp end = start + duration;

            // Convert the times to milliseconds
            start.SetSampleRate(1000);
            end.SetSampleRate(1000);
            if (((uTimestamp > start.Samples()) ||
                 ((uTimestamp == start.Samples()) &&
                  (!start.LostPrecision()))) &&
                (uTimestamp <= end.Samples()))
            {
                uGroupIndex = i;
                res = HXR_OK;
            }
        }
    }

    return res;
}

HX_RESULT 
COggFileInfo::GetGroupInfo(UINT32 uGroupIndex, 
                           const COggGroupInfo*& pGroupInfo) const
{
    HX_RESULT res = HXR_INVALID_PARAMETER;

    if (uGroupIndex < m_uGroupCount)
    {
        pGroupInfo = m_ppGroups[uGroupIndex];
        res = HXR_OK;
    }

    return res;
}

HX_RESULT 
COggFileInfo::AddGroupInfo(COggGroupInfo* pGroupInfo)
{
    HX_RESULT res = HXR_INVALID_PARAMETER;

    if (pGroupInfo)
    {
        COggTimestamp duration;
        res = pGroupInfo->GetDuration(duration);
        
        if (HXR_OK == res)
        {
            COggGroupInfo** ppNewBuf = new COggGroupInfo*[m_uGroupCount + 1];
            
            if (ppNewBuf)
            {
                if (m_ppGroups)
                {
                    memcpy(ppNewBuf, m_ppGroups, 
                           sizeof(COggGroupInfo*) *  m_uGroupCount);
                    
                    delete [] m_ppGroups;
                }

                m_ppGroups = ppNewBuf;
                m_ppGroups[m_uGroupCount] = pGroupInfo;
                m_uGroupCount++;

                if (m_uGroupCount == 1)
                {
                    // If we only have 1 group then the duration of
                    // the file is the same as the group duration
                    m_duration = duration;
                    pGroupInfo->SetStartTime(COggTimestamp(0, 
                                                           duration.SampleRate()));
                }
                else
                {
                    pGroupInfo->SetStartTime(m_duration);
                    
                    // Set both durations to the highest sample
                    // rate of the 2. This loses some accuracy,
                    // but by choosing the largest the error is
                    // kept small.
                    duration.SetSampleRateToHighest(m_duration);
                    m_duration.SetSampleRateToHighest(duration);
                    // Add the duration of this group to the file duration
                    m_duration += duration;
                }
            }
            else
            {
                res = HXR_OUTOFMEMORY;
            }
        }
    }

    return res;
}
