/* xmasmashupService.cpp
   Generated by gSOAP 2.8.1 from xmas.hpp
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   The generated code is released under one of the following licenses:
   GPL OR Genivia's license for commercial use.
*/

#include "xmasmashupService.h"

namespace xmas {

mashupService::mashupService()
{	mashupService_init(SOAP_IO_DEFAULT, SOAP_IO_DEFAULT);
}

mashupService::mashupService(const struct soap &_soap) :soap(_soap)
{ }

mashupService::mashupService(soap_mode iomode)
{	mashupService_init(iomode, iomode);
}

mashupService::mashupService(soap_mode imode, soap_mode omode)
{	mashupService_init(imode, omode);
}

mashupService::~mashupService()
{ }

void mashupService::mashupService_init(soap_mode imode, soap_mode omode)
{	soap_imode(this, imode);
	soap_omode(this, omode);
	static const struct Namespace namespaces[] =
{
	{"SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/", "http://www.w3.org/*/soap-envelope", NULL},
	{"SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/", "http://www.w3.org/*/soap-encoding", NULL},
	{"xsi", "http://www.w3.org/2001/XMLSchema-instance", "http://www.w3.org/*/XMLSchema-instance", NULL},
	{"xsd", "http://www.w3.org/2001/XMLSchema", "http://www.w3.org/*/XMLSchema", NULL},
	{"ns1", "http://www.genivia.com/mashup.wsdl", NULL, NULL},
	{"ns2", "urn:daystoxmas", NULL, NULL},
	{NULL, NULL, NULL, NULL}
};
	this->namespaces = namespaces;
};

void mashupService::destroy()
{	soap_destroy(this);
	soap_end(this);
}

mashupService *mashupService::copy()
{	mashupService *dup = SOAP_NEW_COPY(mashupService(*(struct soap*)this));
	return dup;
}

int mashupService::soap_close_socket()
{	return soap_closesock(this);
}

int mashupService::soap_senderfault(const char *string, const char *detailXML)
{	return ::soap_sender_fault(this, string, detailXML);
}

int mashupService::soap_senderfault(const char *subcodeQName, const char *string, const char *detailXML)
{	return ::soap_sender_fault_subcode(this, subcodeQName, string, detailXML);
}

int mashupService::soap_receiverfault(const char *string, const char *detailXML)
{	return ::soap_receiver_fault(this, string, detailXML);
}

int mashupService::soap_receiverfault(const char *subcodeQName, const char *string, const char *detailXML)
{	return ::soap_receiver_fault_subcode(this, subcodeQName, string, detailXML);
}

void mashupService::soap_print_fault(FILE *fd)
{	::soap_print_fault(this, fd);
}

#ifndef WITH_LEAN
void mashupService::soap_stream_fault(std::ostream& os)
{	::soap_stream_fault(this, os);
}

char *mashupService::soap_sprint_fault(char *buf, size_t len)
{	return ::soap_sprint_fault(this, buf, len);
}
#endif

void mashupService::soap_noheader()
{	header = NULL;
}

int mashupService::run(int port)
{	if (soap_valid_socket(bind(NULL, port, 100)))
	{	for (;;)
		{	if (!soap_valid_socket(accept()))
				return this->error;
			(void)serve();
			soap_destroy(this);
			soap_end(this);
		}
	}
	else
		return this->error;
	return SOAP_OK;
}

SOAP_SOCKET mashupService::bind(const char *host, int port, int backlog)
{	return soap_bind(this, host, port, backlog);
}

SOAP_SOCKET mashupService::accept()
{	return soap_accept(this);
}

int mashupService::serve()
{
#ifndef WITH_FASTCGI
	unsigned int k = this->max_keep_alive;
#endif
	do
	{	soap_begin(this);
#ifdef WITH_FASTCGI
		if (FCGI_Accept() < 0)
		{
			this->error = SOAP_EOF;
			return soap_send_fault(this);
		}
#endif

		soap_begin(this);

#ifndef WITH_FASTCGI
		if (this->max_keep_alive > 0 && !--k)
			this->keep_alive = 0;
#endif

		if (soap_begin_recv(this))
		{	if (this->error < SOAP_STOP)
			{
#ifdef WITH_FASTCGI
				soap_send_fault(this);
#else 
				return soap_send_fault(this);
#endif
			}
			soap_closesock(this);

			continue;
		}

		if (soap_envelope_begin_in(this)
		 || soap_recv_header(this)
		 || soap_body_begin_in(this)
		 || dispatch() || (this->fserveloop && this->fserveloop(this)))
		{
#ifdef WITH_FASTCGI
			soap_send_fault(this);
#else
			return soap_send_fault(this);
#endif
		}

#ifdef WITH_FASTCGI
		soap_destroy(this);
		soap_end(this);
	} while (1);
#else
	} while (this->keep_alive);
#endif
	return SOAP_OK;
}

static int serve___ns1__dtx(mashupService*);

int mashupService::dispatch()
{	soap_peek_element(this);
	if (!soap_match_tag(this, this->tag, "ns2:daystoxmas"))
		return serve___ns1__dtx(this);
	return this->error = SOAP_NO_METHOD;
}

static int serve___ns1__dtx(mashupService *soap)
{	struct __ns1__dtx soap_tmp___ns1__dtx;
	_ns2__commingtotown ns2__commingtotown;
	ns2__commingtotown.soap_default(soap);
	soap_default___ns1__dtx(soap, &soap_tmp___ns1__dtx);
	soap->encodingStyle = NULL;
	if (!soap_get___ns1__dtx(soap, &soap_tmp___ns1__dtx, "-ns1:dtx", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = soap->dtx(soap_tmp___ns1__dtx.ns2__daystoxmas, &ns2__commingtotown);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	ns2__commingtotown.soap_serialize(soap);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || ns2__commingtotown.soap_put(soap, "ns2:commingtotown", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || ns2__commingtotown.soap_put(soap, "ns2:commingtotown", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

} // namespace xmas

/* End of server object code */
