/* gmtProxy.cpp
   Generated by gSOAP 2.8.1 from gmt.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   The generated code is released under one of the following licenses:
   GPL OR Genivia's license for commercial use.
*/

#include "gmtProxy.h"

namespace gmt {

Proxy::Proxy()
{	Proxy_init(SOAP_IO_DEFAULT, SOAP_IO_DEFAULT);
}

Proxy::Proxy(const struct soap &_soap) : soap(_soap)
{ }

Proxy::Proxy(const char *url)
{	Proxy_init(SOAP_IO_DEFAULT, SOAP_IO_DEFAULT);
	soap_endpoint = url;
}

Proxy::Proxy(soap_mode iomode)
{	Proxy_init(iomode, iomode);
}

Proxy::Proxy(const char *url, soap_mode iomode)
{	Proxy_init(iomode, iomode);
	soap_endpoint = url;
}

Proxy::Proxy(soap_mode imode, soap_mode omode)
{	Proxy_init(imode, omode);
}

void Proxy::Proxy_init(soap_mode imode, soap_mode omode)
{	soap_imode(this, imode);
	soap_omode(this, omode);
	soap_endpoint = NULL;
	static const struct Namespace namespaces[] =
{
	{"SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/", "http://www.w3.org/*/soap-envelope", NULL},
	{"SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/", "http://www.w3.org/*/soap-encoding", NULL},
	{"xsi", "http://www.w3.org/2001/XMLSchema-instance", "http://www.w3.org/*/XMLSchema-instance", NULL},
	{"xsd", "http://www.w3.org/2001/XMLSchema", "http://www.w3.org/*/XMLSchema", NULL},
	{"t", "http://tempuri.org/t.xsd", NULL, NULL},
	{NULL, NULL, NULL, NULL}
};
	this->namespaces = namespaces;
}

Proxy::~Proxy()
{ }

void Proxy::destroy()
{	soap_destroy(this);
	soap_end(this);
}

void Proxy::soap_noheader()
{	header = NULL;
}

const SOAP_ENV__Fault *Proxy::soap_fault()
{	return this->fault;
}

const char *Proxy::soap_fault_string()
{	return *soap_faultstring(this);
}

const char *Proxy::soap_fault_detail()
{	return *soap_faultdetail(this);
}

int Proxy::soap_close_socket()
{	return soap_closesock(this);
}

void Proxy::soap_print_fault(FILE *fd)
{	::soap_print_fault(this, fd);
}

#ifndef WITH_LEAN
void Proxy::soap_stream_fault(std::ostream& os)
{	::soap_stream_fault(this, os);
}

char *Proxy::soap_sprint_fault(char *buf, size_t len)
{	return ::soap_sprint_fault(this, buf, len);
}
#endif

int Proxy::gmt(time_t *_param_1)
{	struct soap *soap = this;
	struct t__gmt soap_tmp_t__gmt;
	struct t__gmtResponse *soap_tmp_t__gmtResponse;
	const char *soap_action = NULL;
	soap->encodingStyle = NULL;
	soap_begin(soap);
	soap_serializeheader(soap);
	soap_serialize_t__gmt(soap, &soap_tmp_t__gmt);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_t__gmt(soap, &soap_tmp_t__gmt, "t:gmt", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	}
	if (soap_end_count(soap))
		return soap->error;
	if (soap_connect(soap, soap_endpoint, soap_action)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_t__gmt(soap, &soap_tmp_t__gmt, "t:gmt", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap_closesock(soap);
	if (!_param_1)
		return soap_closesock(soap);
	soap_default_time(soap, _param_1);
	if (soap_begin_recv(soap)
	 || soap_envelope_begin_in(soap)
	 || soap_recv_header(soap)
	 || soap_body_begin_in(soap))
		return soap_closesock(soap);
	soap_tmp_t__gmtResponse = soap_get_t__gmtResponse(soap, NULL, "t:gmtResponse", "");
	if (soap->error)
		return soap_recv_fault(soap, 0);
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap_closesock(soap);
	if (_param_1 && soap_tmp_t__gmtResponse->_param_1)
		*_param_1 = *soap_tmp_t__gmtResponse->_param_1;
	return soap_closesock(soap);
}

} // namespace gmt

/* End of client proxy code */
