#
# "$Id$"
#
#   RPM "spec" file for ESP Ghostscript.
#
#   Copyright 2000-2006 by Easy Software Products.
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#   Please report all bugs and problems to "espgs@easysw.com".
#

Summary: ESP Ghostscript
Name: ghostscript
Version: 8.15.3
Release: 0
License: GPL
Group: Applications/Publishing
Source: http://ftp.easysw.com/pub/ghostscript/espgs-%{version}-source.tar.gz
Url: http://www.cups.org/espgs/
Packager: Some Vendor <info@vendor.com>
Vendor: Easy Software Products
# use buildroot so as not to disturb the version already installed
BuildRoot: /var/tmp/%{name}-root

%package cups
Summary: ESP Ghostscript Support for CUPS
Group: Applications/Publishing
Requires: ghostscript cups

%description
ESP Ghostscript is an enhanced version of GNU Ghostscript that
includes new printer drivers and support for the Common UNIX
Printing System.

%description cups
ESP Ghostscript support for the Common UNIX Printing System
("CUPS"). This package is required to support non-PostScript
printers with CUPS.

%prep
%setup -n espgs-%{version}

%build
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{_prefix} --bindir=%{_bindir} --mandir=%{_mandir}

# If we got this far, all prerequisite libraries must be here.
make

%install
# Make sure destination directories are there, since Ghostscript doesn't make them...
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1
mkdir -p $RPM_BUILD_ROOT%{_docdir}/ghostscript
mkdir -p $RPM_BUILD_ROOT%{_datadir}/ghostscript/8.15/examples

make prefix=$RPM_BUILD_ROOT%{_prefix} install_prefix=$RPM_BUILD_ROOT/ bindir=$RPM_BUILD_ROOT%{_bindir} datadir=$RPM_BUILD_ROOT%{_datadir} mandir=$RPM_BUILD_ROOT%{_mandir} install

%post
if test -f /usr/share/fonts/ttf/japanese/cidinst; then
	sh /usr/share/fonts/ttf/japanese/cidinst
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/*
%{_mandir}/*
%{_docdir}/*
%dir %{_datadir}/ghostscript
%{_datadir}/ghostscript/*

%files cups
%defattr(-,root,root)
/etc/cups/*
%{_libdir}/cups/filter/*
%{_datadir}/cups/model/*

#
# End of "$Id$".
#
