/* $Id: grid.h,v 1.9 2005/04/05 12:02:55 ellson Exp $ $Revision: 1.9 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#ifndef GRID_H
#define GRID_H

#include "cdt.h"
#include "common/derivable_dt.h"
#include "common/freelist.h"
#include <list>

struct gridpt {
	int i, j;
};
typedef std::list<FDPModel::Node*> node_list;
// this extra struct is to evade gcc3 warnings, which
// do not like offsetof(complicated struct)
struct PODCell {
  gridpt p;
  Dtlink_t link;
};
struct Cell : PODCell {
  node_list nodes;
};
struct Grid : derivable_dt { // cells indexed by (i,j)
	Freelist<Cell> cells; // this is wasteful; isn't deque supposed to not realloc if you just push?
	Grid(int size);
	~Grid() {
		close();
	}
	Cell *getCell();
	void clear() {
		dtclear(this);
		cells.clear();
	}
	void add(int i, int j, FDPModel::Node*);
	Cell* find(int i, int j);
	void walk(int(*walkf)(Dt_t *dt,void *cell,void *grid));
	struct Visitor {
		virtual int VisitCell(Cell *cell,Grid *grid) = 0;
	};
	void walk(Visitor *visitor);
};

extern int gLength (Cell* p);

#endif
