/* $Id: gvlang.c,v 1.4 2004/12/11 19:26:07 ellson Exp $ $Revision: 1.4 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/


#include	"config.h"

#if ENABLE_GVRENDER

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"const.h"
#include	"types.h"
#include	"graph.h"   /* must follow types.h */	/* FOR AGWARN */
#include	"gvre.h"
#include	"gvrender.h"

extern struct gvre_s {
    gvrender_engine_t *gvre;
    char *name;
} gvrender_engines[];

char *gvlang_name(int langID)
{
    struct gvre_s *gvre;

    for (gvre = gvrender_engines; gvre->name; gvre++) {
	if (gvre->gvre->id == langID)
	    return gvre->name;
    }
    return NULL;
}

#endif				/* ENABLE_GVRENDER */
