/* $Id: tstring.h,v 1.5 2000/02/20 21:45:37 bergo Exp $ */

#ifndef TSTRING_H
#define TSTRING_H

/**
 provides a special type of String for tokenizing
 purposes. It provides a method with the same functionality
 of strtok and a method for token advancing. It was written
 when strtok gave me a headache when I introduced POSIX threads
 to gPS. All operations (containment, for example) are performed
 on the current token, not the whole string.
 */
class TString {

 public:

  /// Creates a new empty TString that holds at most l characters.
  TString(int l);

  /// Creates a new TString with the string pointed by s.
  TString(char *s);

  ~TString();

  /// sets the contents of this string to s and resets the token position.  
  void set(char *s);

  /// Moves to start of next token, t contains the token separators.
  char *token(char *t);

  /// Moves token to next position of the next occurrence of a character in t.
  char *advance(char *t); 

  /// Returns a pointer to first occurrence of t in the token, NULL otherwise.
  char *contains(char *t);

 private:
  char *data,*dtoken;
  int initl;
};

#endif
