#line 2 "pascal-lex.c"
#define  YY_INT_ALIGNED short int


/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 27
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif


#endif /* ! FLEXINT_H */



#ifdef __cplusplus

/* C++ compilers don't understand traditional function definitions. */
#ifdef YY_TRADITIONAL_FUNC_DEFS
#undef YY_TRADITIONAL_FUNC_DEFS
#endif

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* We're not in a C++ compiler, so by default,
   we generate C99 function defs, unless you explicitly ask
   for traditional defs by defining YY_TRADITIONAL_FUNC_DEFS */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* For compilers that can't handle prototypes.
 * e.g.,
 * The function prototype
 *    int foo(int x, char* y);
 *
 * ...should be written as
 *    int foo YY_PARAMS((int x, char* y));
 *
 * ...which could possibly generate
 *    int foo ();
 */
#ifdef YY_NO_PROTOS
#define YY_PARAMS(proto) ()
#else
#define YY_PARAMS(proto) proto
#endif


/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)



/* Define these macros to be no-ops. */
#define YY_G(var) (var)
#define YY_PROTO_LAST_ARG
#define YY_PROTO_ONLY_ARG void
#define YY_DEF_LAST_ARG
#ifdef YY_TRADITIONAL_FUNC_DEFS
#define YY_DEF_ONLY_ARG
#else
#define YY_DEF_ONLY_ARG void
#endif
#define YY_DECL_LAST_ARG
#define YY_CALL_LAST_ARG
#define YY_CALL_ONLY_ARG



/* For compilers that need traditional function definitions.
 * e.g.,
 * The function prototype taking 2 arguments
 *    int foo (int x, char* y)
 *
 * ...should be written as
 *    int foo YYFARGS2(int,x, char*,y)
 *
 * ...which could possibly generate
 *    int foo (x,y,yyscanner)
 *        int x;
 *        char * y;
 *        yyscan_t yyscanner;
 */
#ifdef YY_TRADITIONAL_FUNC_DEFS
/* Generate traditional function defs */
#define YYFARGS0(v) (YY_DEF_ONLY_ARG) YY_DECL_LAST_ARG
#define YYFARGS1(t1,n1) (n1 YY_DEF_LAST_ARG) t1 n1; YY_DECL_LAST_ARG
#define YYFARGS2(t1,n1,t2,n2) (n1,n2 YY_DEF_LAST_ARG) t1 n1; t2 n2; YY_DECL_LAST_ARG
#define YYFARGS3(t1,n1,t2,n2,t3,n3) (n1,n2,n3 YY_DEF_LAST_ARG) t1 n1; t2 n2; t3 n3; YY_DECL_LAST_ARG
#else
/* Generate C99 function defs. */
#define YYFARGS0(v) (YY_DEF_ONLY_ARG)
#define YYFARGS1(t1,n1) (t1 n1 YY_DEF_LAST_ARG)
#define YYFARGS2(t1,n1,t2,n2) (t1 n1,t2 n2 YY_DEF_LAST_ARG)
#define YYFARGS3(t1,n1,t2,n2,t3,n3) (t1 n1,t2 n2,t3 n3 YY_DEF_LAST_ARG)
#endif

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN YY_G(yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((YY_G(yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin YY_CALL_LAST_ARG )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif


#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

#ifdef YY_USE_LINENO
/* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
 *       access to the local variable yy_act. Since yyless() is a macro, it would break
 *       existing scanners that call yyless() from OUTSIDE yylex. 
 *       One obvious solution it to make yy_act a global. I tried that, and saw
 *       a 5% performance hit in a non-yylineno scanner, because yy_act is
 *       normally declared as a register variable-- so it's not worth it.
 */
#define  YY_LESS_LINENO(n) \
        do { \
			int yyl;\
			for ( yyl = n; yyl < yyleng; ++yyl )\
				if ( yytext[yyl] == '\n' )\
					--yylineno;\
        }while(0)
#else
#define YY_LESS_LINENO(n)
#endif

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = YY_G(yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		YY_G(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, YY_G(yytext_ptr) YY_CALL_LAST_ARG )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;



	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
static YY_BUFFER_STATE yy_current_buffer = 0;
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */

void yyrestart YY_PARAMS(( FILE *input_file YY_PROTO_LAST_ARG ));


void yy_switch_to_buffer YY_PARAMS(( YY_BUFFER_STATE new_buffer YY_PROTO_LAST_ARG ));
void yy_load_buffer_state YY_PARAMS(( YY_PROTO_ONLY_ARG ));
YY_BUFFER_STATE yy_create_buffer YY_PARAMS(( FILE *file, int size YY_PROTO_LAST_ARG ));
void yy_delete_buffer YY_PARAMS(( YY_BUFFER_STATE b YY_PROTO_LAST_ARG ));
void yy_init_buffer YY_PARAMS(( YY_BUFFER_STATE b, FILE *file YY_PROTO_LAST_ARG ));
void yy_flush_buffer YY_PARAMS(( YY_BUFFER_STATE b YY_PROTO_LAST_ARG ));

#define YY_FLUSH_BUFFER yy_flush_buffer( YY_G(yy_current_buffer) YY_CALL_LAST_ARG)

YY_BUFFER_STATE yy_scan_buffer YY_PARAMS(( char *base, yy_size_t size YY_PROTO_LAST_ARG ));
YY_BUFFER_STATE yy_scan_string YY_PARAMS(( yyconst char *yy_str YY_PROTO_LAST_ARG ));
YY_BUFFER_STATE yy_scan_bytes YY_PARAMS(( yyconst char *bytes, int len YY_PROTO_LAST_ARG ));


void *yyalloc YY_PARAMS(( yy_size_t YY_PROTO_LAST_ARG ));
void *yyrealloc YY_PARAMS(( void *, yy_size_t YY_PROTO_LAST_ARG ));
void yyfree YY_PARAMS(( void * YY_PROTO_LAST_ARG ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_G(yy_current_buffer) ) \
		YY_G(yy_current_buffer) =    \
            yy_create_buffer( yyin, YY_BUF_SIZE YY_CALL_LAST_ARG); \
	YY_G(yy_current_buffer)->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_G(yy_current_buffer) ) \
		YY_G(yy_current_buffer) =    \
            yy_create_buffer( yyin, YY_BUF_SIZE YY_CALL_LAST_ARG); \
	YY_G(yy_current_buffer)->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_G(yy_current_buffer)->yy_at_bol)

/* Begin user sect3 */

#define yywrap(n) 1
#define YY_SKIP_YYWRAP
#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
typedef unsigned char YY_CHAR;
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */
#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
#ifndef YY_REENTRANT
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
#endif
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */
#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
typedef int yy_state_type;
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */
extern int yylineno;
#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
int yylineno = 1;
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */
extern char *yytext;
#define yytext_ptr yytext

#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
static yy_state_type yy_get_previous_state YY_PARAMS(( YY_PROTO_ONLY_ARG ));
static yy_state_type yy_try_NUL_trans YY_PARAMS(( yy_state_type current_state  YY_PROTO_LAST_ARG));
static int yy_get_next_buffer YY_PARAMS(( YY_PROTO_ONLY_ARG ));
static void yy_fatal_error YY_PARAMS(( yyconst char msg[] YY_PROTO_LAST_ARG ));
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	YY_G(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	YY_G(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	YY_G(yy_c_buf_p) = yy_cp;

#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
#define YY_NUM_RULES 86
#define YY_END_OF_BUFFER 87
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[195] =
    {   0,
       84,   84,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   54,   54,   78,   78,   87,   85,   84,   84,
       53,   85,   85,   53,    1,    1,    1,    1,    1,    1,
        1,   23,    1,    1,    1,    1,   22,    1,   56,   84,
       85,   50,   49,   77,   68,   64,   60,   77,   69,   77,
       77,   77,   70,   77,   77,   64,   60,   77,   77,   67,
       63,   54,   54,   78,   78,   84,   84,    0,   52,    0,
        0,   40,   28,    0,   51,   57,    3,   11,   18,   14,
       16,   12,   17,   13,    4,   20,   55,   19,   15,    0,
       33,   23,   25,   25,    5,    8,    6,   10,    9,    7,

       22,   48,   47,   44,   44,   46,   58,   84,    0,   83,
       83,    0,   68,   71,    0,   69,    0,    0,   65,   61,
        0,   70,    0,    0,   74,   66,   62,   65,   61,   54,
       54,   78,   78,   42,   41,   29,   59,    0,   21,   55,
       55,   26,   24,   24,   31,   38,   35,    0,   30,   45,
       83,   83,   83,   82,   72,   73,   75,   76,   43,    2,
       27,   34,   32,   32,    0,   37,   36,   82,   82,   79,
       82,   82,    0,   31,   39,   82,   82,   82,   82,    0,
        0,   82,   80,   82,    0,   80,    0,   82,   81,   82,
        0,   81,    0,    0

    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,    4,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    5,    6,    7,    1,    1,    8,    9,
       10,   11,   12,   13,   14,   15,   16,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   18,   13,   19,
       20,   21,    1,   13,   22,   22,   22,   22,   23,   22,
       24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
       24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
       13,   25,   13,   26,   27,    1,   22,   22,   22,   22,

       23,   22,   24,   24,   24,   24,   24,   24,   24,   24,
       24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
       24,   24,   28,    1,   29,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[30] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    2,    1,    1,    1,
        1,    2,    2,    2,    1,    1,    2,    1,    1
    } ;

static yyconst flex_int16_t yy_base[224] =
    {   0,
        0,   28,    9,   15,   32,   37,   38,   41,   64,   91,
      118,  145,  314,  313,  312,  310,  311,  383,   51,  383,
       38,   39,   47,  302,   47,  383,   57,   38,   53,   67,
       64,  169,  289,   66,  287,   69,    0,  196,  297,   93,
       96,  383,  383,   76,  383,  383,  383,   98,  383,  103,
      107,  223,  383,  250,  277,  383,  383,   80,  293,  383,
      383,  299,  383,  298,  383,  120,  383,   46,  383,    0,
      108,  283,   21,  291,  290,  290,  281,  383,  383,  383,
      383,  383,  383,  383,  383,  280,  291,  383,  383,  111,
      297,    0,  383,  124,  383,  383,  383,  383,  383,  383,

        0,  383,  383,  383,  383,    0,  383,  147,  135,  290,
      141,  136,  383,  383,  152,  383,  157,  167,  282,  383,
      281,  383,  161,  280,  383,  279,  383,  275,  383,  281,
      383,  280,  383,   57,  383,  383,  383,  267,  383,  278,
      383,  250,  383,  130,  109,  383,  313,  259,  258,  383,
      271,  383,  177,  225,  263,  383,  262,  383,  383,  383,
      383,  383,  383,  145,  254,  252,  383,  265,  180,  383,
      164,  233,  250,  249,  383,  383,  184,  260,  237,  259,
      241,  243,  383,  178,  245,  383,  238,  254,  383,  246,
      234,  383,  253,  383,  340,  342,  344,  346,  348,  350,

      352,  354,  231,  356,  358,  360,  362,  364,  366,  229,
      227,  368,  188,  370,  186,  113,  109,  372,  106,  374,
      376,  378,  380
    } ;

static yyconst flex_int16_t yy_def[224] =
    {   0,
      194,    1,  195,  195,  196,  196,  197,  197,  198,  198,
      198,  198,  199,  199,  200,  200,  194,  194,  194,  194,
      201,  194,  194,  202,  194,  194,  194,  194,  194,  194,
      194,  194,  194,  194,  194,  194,  203,  194,  194,  194,
      204,  194,  194,  205,  194,  194,  194,  206,  194,  206,
      206,  207,  194,  207,  207,  194,  194,   55,   55,  194,
      194,  208,  194,  209,  194,  194,  194,  201,  194,  201,
      194,  210,  211,  202,  194,  194,  194,  194,  194,  194,
      194,  194,  194,  194,  194,  194,  212,  194,  194,  194,
      194,   32,  194,  194,  194,  194,  194,  194,  194,  194,

      203,  194,  194,  194,  194,  213,  194,  194,  204,  214,
      214,  205,  194,  194,  206,  194,  206,  206,  194,  194,
       55,  194,   55,   55,  194,  194,  194,  194,  194,  208,
      194,  209,  194,  215,  194,  194,  194,  194,  194,  212,
      194,  216,  194,  194,  217,  194,  194,  194,  217,  194,
      214,  194,  214,  218,  194,  194,  194,  194,  194,  194,
      194,  194,  194,  194,  194,  219,  194,  218,  218,  194,
      220,  218,  194,  217,  194,  194,  220,  221,  218,  221,
      194,  218,  194,  222,  194,  194,  223,  222,  194,  222,
      223,  194,  223,    0,  194,  194,  194,  194,  194,  194,

      194,  194,  194,  194,  194,  194,  194,  194,  194,  194,
      194,  194,  194,  194,  194,  194,  194,  194,  194,  194,
      194,  194,  194
    } ;

static yyconst flex_int16_t yy_nxt[413] =
    {   0,
       18,   19,   20,   19,   21,   22,   23,   24,   25,   26,
       27,   28,   26,   29,   30,   31,   32,   33,   34,   35,
       36,   37,   37,   37,   18,   38,   37,   39,   18,   40,
       43,   43,   43,   41,   45,   43,   43,   43,   43,   45,
       49,   43,   69,   49,  136,   71,   50,  136,   51,   50,
       69,   51,   66,   67,   66,   72,   81,   76,   82,   46,
       47,   77,   70,   73,   46,   47,   53,   78,   73,   73,
       70,   83,   54,   84,   55,   79,   85,   80,  113,   87,
      159,   86,   88,  159,   89,   96,   97,   99,  100,  121,
      128,   56,   57,   53,  108,   67,   66,  111,  109,   54,

      116,   55,   71,  114,  114,  116,  117,  175,  118,  116,
      163,  117,   72,  119,  142,  117,  120,  118,   56,   57,
       53,   66,   67,   66,  134,  145,   58,  142,   59,  134,
      134,  164,  142,  142,  142,  148,  111,  148,  113,  162,
      149,  194,  153,  152,  162,   60,   61,   53,  108,   67,
       66,  194,  109,   58,  116,   59,  173,  154,  173,  116,
      117,  174,  118,  114,  114,  117,  178,  155,  179,  116,
      121,  157,   60,   61,   90,  117,  156,  118,  153,  152,
      189,  169,  170,   91,  171,   92,  178,  134,  179,  150,
       93,   94,   93,  154,  190,   93,  102,  103,  104,  103,

      102,  102,  102,  102,  105,  105,  105,  105,  105,  105,
      105,  105,  102,  105,  105,  105,  105,  106,  106,  106,
      102,  105,  106,  105,  102,  122,  169,  170,   73,  171,
      135,  123,  101,  124,  169,  170,  192,  171,  182,  183,
      192,  172,  185,  186,  182,  183,  185,  186,  189,  172,
      125,  125,  122,  184,  193,  192,  189,  187,  123,  184,
      126,  187,  190,  181,  181,  174,  174,  176,  166,  193,
      166,  158,  156,  152,  149,  149,  161,  125,  125,  122,
      141,  160,  133,  131,  158,  123,  127,  124,  158,  158,
      121,  156,  152,  141,  139,  138,  137,   74,   75,   72,

      133,  131,  129,  107,  125,  125,  143,   98,   95,   75,
      194,  144,   65,  145,   65,   63,   63,  194,  146,  147,
      146,  194,  194,  146,  165,  194,  165,  194,  194,  166,
      194,  194,  194,  194,  167,  167,  167,  194,  194,  167,
       42,   42,   44,   44,   48,   48,   52,   52,   62,   62,
       64,   64,   68,   68,   74,   74,  110,  110,  112,  112,
      115,  115,  121,  121,  130,  130,  132,  132,  140,  140,
      151,  151,  168,  168,  177,  177,  180,  180,  188,  188,
      191,  191,   17,  194,  194,  194,  194,  194,  194,  194,
      194,  194,  194,  194,  194,  194,  194,  194,  194,  194,

      194,  194,  194,  194,  194,  194,  194,  194,  194,  194,
      194,  194
    } ;

static yyconst flex_int16_t yy_chk[413] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    2,
        3,    3,    3,    2,    5,    3,    4,    4,    4,    6,
        7,    4,   21,    8,   73,   22,    7,   73,    7,    8,
       68,    8,   19,   19,   19,   22,   28,   25,   28,    5,
        5,   25,   21,   23,    6,    6,    9,   27,   23,   23,
       68,   29,    9,   29,    9,   27,   30,   27,   44,   31,
      134,   30,   31,  134,   31,   34,   34,   36,   36,   58,
       58,    9,    9,   10,   40,   40,   40,   41,   40,   10,

       48,   10,   41,   44,   44,   50,   48,  219,   48,   51,
      217,   50,   41,   50,  216,   51,   51,   51,   10,   10,
       11,   66,   66,   66,   71,  145,   11,   90,   11,   71,
       71,  145,   90,   90,   90,   94,  109,   94,  112,  144,
       94,  109,  111,  111,  144,   11,   11,   12,  108,  108,
      108,  109,  108,   12,  115,   12,  164,  111,  164,  117,
      115,  164,  115,  112,  112,  117,  171,  117,  171,  118,
      123,  123,   12,   12,   32,  118,  118,  118,  153,  153,
      184,  169,  169,   32,  169,   32,  177,  215,  177,  213,
       32,   32,   32,  153,  184,   32,   38,   38,   38,   38,

       38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
       38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
       38,   38,   38,   38,   38,   52,  154,  154,  211,  154,
      210,   52,  203,   52,  172,  172,  191,  172,  179,  179,
      187,  154,  181,  181,  182,  182,  185,  185,  190,  172,
       52,   52,   54,  179,  187,  193,  188,  181,   54,  182,
       54,  185,  190,  180,  178,  174,  173,  168,  166,  193,
      165,  157,  155,  151,  149,  148,  142,   54,   54,   55,
      140,  138,  132,  130,  128,   55,   55,   55,  126,  124,
      121,  119,  110,   87,   86,   77,   76,   75,   74,   72,

       64,   62,   59,   39,   55,   55,   91,   35,   33,   24,
       17,   91,   16,   91,   15,   14,   13,    0,   91,   91,
       91,    0,    0,   91,  147,    0,  147,    0,    0,  147,
        0,    0,    0,    0,  147,  147,  147,    0,    0,  147,
      195,  195,  196,  196,  197,  197,  198,  198,  199,  199,
      200,  200,  201,  201,  202,  202,  204,  204,  205,  205,
      206,  206,  207,  207,  208,  208,  209,  209,  212,  212,
      214,  214,  218,  218,  220,  220,  221,  221,  222,  222,
      223,  223,  194,  194,  194,  194,  194,  194,  194,  194,
      194,  194,  194,  194,  194,  194,  194,  194,  194,  194,

      194,  194,  194,  194,  194,  194,  194,  194,  194,  194,
      194,  194
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#ifndef YY_REENTRANT
char *yytext;
#endif
#line 1 "pascal-lex.l"
#define INITIAL 0
/*Lexer for Standard and Extended Pascal with Borland and GNU
  extensions

  Copyright (C) 2000-2004 Free Software Foundation, Inc.

  Author: Frank Heckenbach <frank@pascal.gnu.de>

  This file is part of GNU Pascal.

  GNU Pascal is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation; either version 1, or (at your
  option) any later version.

  GNU Pascal is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNU Pascal; see the file COPYING. If not, write to the
  Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA. */
/*Notes:

  - Return everything, including whitespace and comments if the
    corresponding token values are >= 0.

  - Call SaveTokenString before modifying yyleng or the content of
    yytext. */
#define CaretLetter 1

#define Comment1 2

#define Comment2 3

#define Comment1B 4

#define Comment2B 5

#define Discard 6

#define DiscardComment 7

#line 46 "pascal-lex.l"
typedef enum {
  DoubleQuotedStrings,
  MultilineStrings,
  IntegersWithoutSeparator,
  IntegersBase,
  IntegersHex,
  RealsWithoutSeparator,
  RealsWithDotOnly,
  RealsWithoutExpDigits,
  CharConstantsHash,
  MixedComments,
  NestedComments,
  DelphiComments,
  LF_MAX
} TLexFeatureIndex;

typedef struct
{
  HOST_WIDE_INT IntegerValueBytes[BYTES_PER_INTEGER];
  int IntegerValue, IntegerValueOverflow;
  char *TokenString, *StringValue;
  int TokenStringLength, StringValueLength;
} TLexSem;

typedef struct
{
  int Line, Column;
  char *SrcName;
} TLexPos;

extern int CommentLevelCount;
extern int Directive;
extern TLexSem LexSem;
extern TLexPos LexPos;

int CheckFeature (TLexFeatureIndex Feature, int Message);
void ExtraUserAction (const char *buf, unsigned int length);
void SetFileName (int);
void InitLex (const char *, FILE *, int);
void DoneLex (void);
int lexscan (void);
void lex_error (const char *Msg);

int CommentLevelCount = 0, Directive = 0;
TLexSem LexSem;

static int TokenStringBufSize = 0;
static char *TokenStringBuf = NULL;

TLexPos LexPos = { 0, 0, NULL };
static TLexPos NewPos = { 0, 0, NULL }, CommentStartPos = { 0, 0, NULL };

#ifndef lex_malloc
static char *
lex_malloc (size)
     size_t size;
{
  char *p = (char *) malloc (size);
  if (!p)
    yy_fatal_error ("out of memory");
  return p;
}
#endif

/* Don't use the locale dependent routines. */
#undef isdigit
#define isdigit new_isdigit
static inline int isdigit PARAMS ((int));
static inline int
isdigit (c)
     int c;
{
  return c >= '0' && c <= '9';
}

void InitLex (const char *SrcName, FILE *i, int IsInteractive)
{
  if (IsInteractive >= 0)
    yy_set_interactive (IsInteractive);
  if (LexPos.SrcName) free (LexPos.SrcName);
  LexPos.SrcName = lex_malloc (strlen (SrcName) + 1);
  strcpy (LexPos.SrcName, SrcName);
  LexPos.Line = LexPos.Column = 1;
  NewPos = LexPos;
  yy_current_buffer->yy_input_file = yyin = i;
  YY_FLUSH_BUFFER;
}

void DoneLex ()
{
  LexPos.Line = LexPos.Column = 0;
  NewPos = LexPos;
}

#define YY_INPUT(buf, result, max_size) ((result) = DoInput ((buf), (max_size)))
static inline int DoInput (char *buf, int max_size)
{
  static char last = 0;
  char *p, *q;
  int r = fread (buf, 1, max_size, yyin), i;
  if (r == 0 && ferror (yyin))
    yy_fatal_error ("input in flex scanner failed");
  for (p = q = buf, i = r; i; i--, p++)
    if ((last == '\r' && *p == '\n') || (last == '\n' && *p == '\r'))
      last = 0;
    else
      *q++ = (last = *p) == '\r' ? '\n' : *p;
  return q - buf;
}

#define YY_USER_ACTION UserAction ();
static inline void UserAction (void)
{
  char *c = yytext;
  int l = yyleng;
  LexSem.TokenString = yytext;
  LexSem.TokenStringLength = yyleng;
  LexSem.StringValue = NULL;
  LexSem.StringValueLength = 0;
  LexPos = NewPos;
  while (l--)
    if (*c++ == '\n')
      {
        NewPos.Line++;
        NewPos.Column = 1;
      }
    else
      NewPos.Column++;
  ExtraUserAction (yytext, yyleng);
}

static void SaveTokenString (void)
{
  if (!TokenStringBuf || TokenStringBufSize < yyleng + 1)
    {
      if (TokenStringBuf)
        free (TokenStringBuf);
      TokenStringBuf = lex_malloc ((TokenStringBufSize = yyleng + 1));
    }
  strncpy (TokenStringBuf, yytext, yyleng + 1);
  LexSem.TokenString = TokenStringBuf;
}

static int Char2Digit (char c)
{
  if (c >= '0' && c <= '9')
    return c - '0';
  else if (c >= 'A' && c <= 'Z')
    return c - 'A' + 0xa;
  else if (c >= 'a' && c <= 'z')
    return c - 'a' + 0xa;
  else
    return -1;
}

static char *ReadIntegerConstant (char *p, int base)
{
  int digit, largest_digit = 0, overflow = 0, i, v;
  if (!LEX_SEMANTIC_VALUES) return p;
  for (i = 0; i < BYTES_PER_INTEGER; i++)
    LexSem.IntegerValueBytes[i] = 0;
  while (1)
    {
      digit = Char2Digit (*p);
      if (digit < 0) break;
      if (digit > largest_digit)
        largest_digit = digit;
      for (i = 0; i < BYTES_PER_INTEGER; i++)
        {
          v = LexSem.IntegerValueBytes[i] * base + digit;
          LexSem.IntegerValueBytes[i] = v & ((1 << BITS_PER_BYTES) - 1);
          digit = v >> BITS_PER_BYTES;
        }
      if (digit > 0)
        overflow = 1;
      p++;
    }
  if (largest_digit >= base)
    {
      if (base <= 10 && largest_digit >= 10)
        lex_error ("nondigits in integer constant whose radix <= 10");
      else
        lex_error ("integer constant contains digits beyond the radix");
    }
  else if (overflow)
    lex_error ("integer constant overflow");
  LexSem.IntegerValue = 0;
  LexSem.IntegerValueOverflow = 0;
  for (i = 0, v = 1; i < BYTES_PER_INTEGER; i++, v <<= BITS_PER_BYTES)
    if (v != 0)
      LexSem.IntegerValue += v * LexSem.IntegerValueBytes[i];
    else if (LexSem.IntegerValueBytes[i] != 0)
      LexSem.IntegerValueOverflow = 1;
  return p;
}

static void ReadIntegerBase (void)
{
  char *p;
  CheckFeature (IntegersBase, 1);
  if (LEX_SEMANTIC_VALUES)
    {
      p = ReadIntegerConstant (yytext, 10);
      if (LexSem.IntegerValueOverflow || LexSem.IntegerValue < 2 || LexSem.IntegerValue > 36)
        {
          lex_error ("integer base out of range (2 .. 36)");
          LexSem.IntegerValue = 10;
        }
      ReadIntegerConstant (p + 1, LexSem.IntegerValue);
    }
}

static inline void SetCharConst (int c)
{
  static char CharConstBuf[2] = { 0, 0 };
  CharConstBuf[0] = c;
  LexSem.StringValue = CharConstBuf;
  LexSem.StringValueLength = 1;
}

static void SetCaretCharConst (void)
{
  char c = yytext[1];
  if (c >= 'a' && c <= 'z')
    c -= 'a' - 'A';
  SetCharConst (c ^ 0x40);  /* sic! */
}

static void BPCharConstant (char *p, int base)
{
  CheckFeature (CharConstantsHash, 1);
  if (!LEX_SEMANTIC_VALUES) return;
  ReadIntegerConstant (p, base);
  if (LexSem.IntegerValueOverflow || LexSem.IntegerValue > 0xff)
    lex_error ("numeric value out of range for character constant");
  SetCharConst (LexSem.IntegerValue);
}

static void SetString (int DoubleQuoted)
{
  char *c = yytext, *d = yytext;
  while (*c && *c != '\n')
    c++;
  if (*c)
    CheckFeature (MultilineStrings, 1);
  if (DoubleQuoted)
    CheckFeature (DoubleQuotedStrings, 1);
  if (!LEX_SEMANTIC_VALUES)
    return;
  SaveTokenString ();
  if (!DoubleQuoted)
    {
      for (c = yytext + 1; *c && c[1]; c++)
        if ((*d++ = *c) == '\'')
          c++;
    }
  else
    {
      for (c = yytext + 1; *c && *c != '"'; c++)
        if (*c != '\\')
          *d++ = *c;
        else
          switch (*++c)
            {
              case 'n':  *d++ = TARGET_NEWLINE; break;
              case 't':  *d++ = TARGET_TAB;     break;
              case 'r':  *d++ = TARGET_CR;      break;
              case 'f':  *d++ = TARGET_FF;      break;
              case 'b':  *d++ = TARGET_BS;      break;
              case 'v':  *d++ = TARGET_VT;      break;
              case 'a':  *d++ = TARGET_BELL;    break;
              case 'e':
              case 'E':  *d++ = 27;             break;
              case 'x':  {
                           int v = 0, n = 0, overflow = 0;
                           while (1)
                             {
                               int digit = Char2Digit (*++c);
                               if (digit < 0 || digit >= 0x10) break;
                               v = 0x10 * v + digit;
                               overflow |= v > 0xff;
                               n++;
                             }
                           if (overflow)
                             lex_error ("hex character escape out of range");
                           else if (!n)
                             lex_error ("hex character escape with no digits");
                           *d++ = v;
                           c--;
                           break;
                         }
              case '0': case '1': case '2': case '3':
              case '4': case '5': case '6': case '7':
                         {
                           int v = 0, n = 1;
                           do
                             v = 8 * v + (*c++ - '0');
                           while (n++ < 3 && *c >= '0' && *c <= '7');
                           if (v > 0xff)
                             lex_error ("octal character escape out of range");
                           *d++ = v;
                           c--;
                           break;
                         }
              case '\n': break;
              default:   *d++ = *c;
            }
    }
  *d = 0;
  LexSem.StringValue = yytext;
  LexSem.StringValueLength = d - yytext;
}

static void DoLineDir (int items)
{
  char *p1 = yytext;
  while (!isdigit (*p1)) p1++;
  ReadIntegerConstant (p1, 10);
  if (LexSem.IntegerValueOverflow)
    lex_error ("number in line directive out of range");
  NewPos.Line = LexSem.IntegerValue;
  if (items >= 2)
    {
      int v = 0;
      char *p2, *q;
      while (*p1 != '"') p1++;
      p2 = ++p1;
      while (*p2 != '"') p2++;
      /* Never free an input filename, since copies of the pointer are
         kept around (in DECL_SOURCE_FILE etc.). */
      NewPos.SrcName = q = lex_malloc (p2 - p1 + 1);
      while (p1 < p2)
        {
          if (*p1 == '\\')
            p1++;
          *q++ = *p1++;
        }
      *q = 0;
      if (items >= 3)
        {
          while (!isdigit (*p2)) p2++;
          p2 = ReadIntegerConstant (p2, 10);
          if (LexSem.IntegerValueOverflow)
            lex_error ("number in line directive out of range");
          v = LexSem.IntegerValue;
        }
      SetFileName (v);
    }
}

static inline void StartComment (int IsDirective, int State, int StateBoth)
{
  CommentStartPos = LexPos;
  CommentLevelCount = 1;
  Directive = IsDirective;
  BEGIN (CheckFeature (MixedComments, 0) ? StateBoth : State);
}

#define CommentContent \
  RETURN_IF_DEFINED ((CommentLevelCount == 1 && Directive) ? LEX_DIRECTIVE_CONTENT : LEX_COMMENT_CONTENT)

#define EndComment \
  if (--CommentLevelCount == 0) \
    BEGIN (INITIAL); \
  RETURN_IF_DEFINED ((CommentLevelCount == 0 && Directive) ? LEX_DIRECTIVE_END : LEX_COMMENT_END);

#define RETURN_IF_DEFINED(x) do { if ((x) >= 0) return (x); } while (0)

#define YY_DECL int lexscan (void)
#define YY_NO_UNPUT
#line 1126 "pascal-lex.c"
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */

/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#ifndef YY_NO_UNISTD_H
#include <unistd.h>
#endif /* !YY_NO_UNISTD_H */

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */
#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */
#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

#ifndef YY_NO_DESTROY
int yylex_destroy YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#endif

#ifndef YY_NO_GET_DEBUG
int yyget_debug YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#endif

#ifndef YY_NO_SET_DEBUG
void yyset_debug YY_PARAMS(( int debug_flag YY_PROTO_LAST_ARG ));
#endif

#ifndef YY_NO_GET_EXTRA
YY_EXTRA_TYPE yyget_extra YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#endif

#ifndef YY_NO_SET_EXTRA
void yyset_extra YY_PARAMS(( YY_EXTRA_TYPE user_defined YY_PROTO_LAST_ARG ));
#endif

#ifndef YY_NO_GET_IN
FILE *yyget_in YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#endif

#ifndef YY_NO_SET_IN
void yyset_in  YY_PARAMS(( FILE * in_str YY_PROTO_LAST_ARG ));
#endif

#ifndef YY_NO_GET_OUT
FILE *yyget_out YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#endif

#ifndef YY_NO_SET_OUT
void yyset_out  YY_PARAMS(( FILE * out_str YY_PROTO_LAST_ARG ));
#endif

#ifndef YY_NO_GET_LENG
int yyget_leng YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#endif

#ifndef YY_NO_GET_TEXT
char *yyget_text YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#endif

#ifndef YY_NO_GET_LINENO
int yyget_lineno YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#endif

#ifndef YY_NO_SET_LINENO
void yyset_lineno YY_PARAMS(( int line_number YY_PROTO_LAST_ARG ));
#endif


/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#else
extern int yywrap YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#endif
#endif

#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
#ifndef YY_NO_UNPUT
static void yyunput YY_PARAMS(( int c, char *buf_ptr  YY_PROTO_LAST_ARG));
#endif
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PARAMS(( char *, yyconst char *, int YY_PROTO_LAST_ARG));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PARAMS(( yyconst char * YY_PROTO_LAST_ARG));
#endif

#ifndef YY_NO_INPUT
#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
#ifdef __cplusplus
static int yyinput YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#else
static int input YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#endif
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */
#endif


#if YY_STACK_USED
#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */

#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PARAMS(( int new_state YY_PROTO_LAST_ARG));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PARAMS(( YY_PROTO_ONLY_ARG ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_G(yy_current_buffer)->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}
\
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg YY_CALL_LAST_ARG)
#endif

#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */
#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
/* end tables serialization structures and prototypes */

#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL

/* If the bison pure parser is used, then bison will provide
   one or two additional arguments. */


#      define YY_LEX_PROTO YY_PARAMS((YY_PROTO_ONLY_ARG))
#      define YY_LEX_DECLARATION YYFARGS0(void)


extern int yylex YY_LEX_PROTO;

#define YY_DECL int yylex YY_LEX_DECLARATION
#endif


/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_G(yy_current_buffer)->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

#line 434 "pascal-lex.l"
#define YY_TABLES_VERIFY 0


#line 1386 "pascal-lex.c"


	if ( YY_G(yy_init) )
		{
		YY_G(yy_init) = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

#ifdef YY_USES_REJECT
        if ( ! YY_G(yy_state_buf) )
            YY_G(yy_state_buf) = (yy_state_type *)yyalloc(YY_BUF_SIZE + 2  YY_CALL_LAST_ARG);
#endif

		if ( ! YY_G(yy_start) )
			YY_G(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_G(yy_current_buffer) )
			YY_G(yy_current_buffer) =
				yy_create_buffer( yyin, YY_BUF_SIZE YY_CALL_LAST_ARG);

		yy_load_buffer_state( YY_CALL_ONLY_ARG );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = YY_G(yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = YY_G(yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = YY_G(yy_start);
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				YY_G(yy_last_accepting_state) = yy_current_state;
				YY_G(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 195 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 383 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = YY_G(yy_last_accepting_cpos);
			yy_current_state = YY_G(yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

#ifdef YY_USE_LINENO
		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					++yylineno;
			}
#endif

do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = YY_G(yy_hold_char);
			yy_cp = YY_G(yy_last_accepting_cpos);
			yy_current_state = YY_G(yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 436 "pascal-lex.l"
return yytext[0];
	YY_BREAK
case 2:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 437 "pascal-lex.l"
return '(';
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 438 "pascal-lex.l"
return '[';
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 439 "pascal-lex.l"
return ']';
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 440 "pascal-lex.l"
return LEX_ASSIGN;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 441 "pascal-lex.l"
return LEX_NE;
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 442 "pascal-lex.l"
return LEX_GE;
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 443 "pascal-lex.l"
return LEX_LE;
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 444 "pascal-lex.l"
return LEX_SYMDIFF;
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 445 "pascal-lex.l"
return LEX_RENAME;
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 446 "pascal-lex.l"
return LEX_POWER;
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 447 "pascal-lex.l"
return LEX_CEIL_PLUS;
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 448 "pascal-lex.l"
return LEX_CEIL_MINUS;
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 449 "pascal-lex.l"
return LEX_CEIL_MULT;
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 450 "pascal-lex.l"
return LEX_CEIL_DIV;
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 451 "pascal-lex.l"
return LEX_FLOOR_PLUS;
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 452 "pascal-lex.l"
return LEX_FLOOR_MINUS;
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 453 "pascal-lex.l"
return LEX_FLOOR_MULT;
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 454 "pascal-lex.l"
return LEX_FLOOR_DIV;
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 455 "pascal-lex.l"
return LEX_RANGE;
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 456 "pascal-lex.l"
return LEX_ELLIPSIS;
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 458 "pascal-lex.l"
return LEX_ID;
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 460 "pascal-lex.l"
ReadIntegerConstant (yytext, 10); return LEX_INTCONST;
	YY_BREAK
case 24:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 461 "pascal-lex.l"
ReadIntegerConstant (yytext, 10); return LEX_INTCONST;
	YY_BREAK
case 25:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 462 "pascal-lex.l"
CheckFeature (IntegersWithoutSeparator, 1); ReadIntegerConstant (yytext, 10); return LEX_INTCONST;
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 463 "pascal-lex.l"
ReadIntegerBase (); return LEX_INTCONST_BASE;
	YY_BREAK
case 27:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 464 "pascal-lex.l"
CheckFeature (IntegersWithoutSeparator, 1); ReadIntegerBase (); return LEX_INTCONST_BASE;
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 465 "pascal-lex.l"
CheckFeature (IntegersHex, 1); ReadIntegerConstant (yytext + 1, 0x10); return LEX_INTCONST_BASE;
	YY_BREAK
case 29:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 466 "pascal-lex.l"
CheckFeature (IntegersHex, 1); CheckFeature (IntegersWithoutSeparator, 1); ReadIntegerConstant (yytext + 1, 0x10); return LEX_INTCONST_BASE;
	YY_BREAK
case 30:
#line 469 "pascal-lex.l"
case 31:
YY_RULE_SETUP
#line 469 "pascal-lex.l"
return LEX_REALCONST;
	YY_BREAK
case 32:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 470 "pascal-lex.l"
CheckFeature (RealsWithoutSeparator, 1); return LEX_REALCONST;
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 471 "pascal-lex.l"
CheckFeature (RealsWithDotOnly, 1); return LEX_REALCONST;
	YY_BREAK
case 34:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 472 "pascal-lex.l"
CheckFeature (RealsWithDotOnly, 1); return LEX_REALCONST;  /* note the `{DS}/"."[.)]' rule (fjf528b.pas) */
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 473 "pascal-lex.l"
CheckFeature (RealsWithDotOnly, 1); CheckFeature (RealsWithoutExpDigits, 1); return LEX_REALCONST;
	YY_BREAK
case 36:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 474 "pascal-lex.l"
CheckFeature (RealsWithDotOnly, 1); CheckFeature (RealsWithoutExpDigits, 1); CheckFeature (RealsWithoutSeparator, 1); return LEX_REALCONST;
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 475 "pascal-lex.l"
CheckFeature (RealsWithDotOnly, 1); return LEX_REALCONST;
	YY_BREAK
case 38:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 476 "pascal-lex.l"
CheckFeature (RealsWithDotOnly, 1); CheckFeature (RealsWithoutSeparator, 1); return LEX_REALCONST;
	YY_BREAK
case 39:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 477 "pascal-lex.l"
CheckFeature (RealsWithDotOnly, 1); CheckFeature (RealsWithoutSeparator, 1); return LEX_REALCONST;
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 479 "pascal-lex.l"
BPCharConstant (yytext + 1, 10); return LEX_STRCONST;
	YY_BREAK
case 41:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 480 "pascal-lex.l"
CheckFeature (IntegersWithoutSeparator, 1); BPCharConstant (yytext + 1, 10); return LEX_STRCONST;
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 481 "pascal-lex.l"
BPCharConstant (yytext + 2, 0x10); return LEX_STRCONST;
	YY_BREAK
case 43:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 482 "pascal-lex.l"
CheckFeature (IntegersWithoutSeparator, 1); BPCharConstant (yytext + 2, 0x10); return LEX_STRCONST;
	YY_BREAK
case 44:
/* rule 44 can match eol */
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 484 "pascal-lex.l"
return '^';
	YY_BREAK
case 45:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 485 "pascal-lex.l"
return '^';
	YY_BREAK
case 46:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 486 "pascal-lex.l"
BEGIN (CaretLetter); return '^';
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 487 "pascal-lex.l"
SetCaretCharConst (); return LEX_CARET_WHITE;
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 488 "pascal-lex.l"
SetCaretCharConst (); return LEX_STRCONST;
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 489 "pascal-lex.l"
BEGIN (INITIAL); return LEX_CARET_LETTER;
	YY_BREAK
case 50:
/* rule 50 can match eol */
#line 491 "pascal-lex.l"
case YY_STATE_EOF(CaretLetter):
#line 491 "pascal-lex.l"
assert (0);
	YY_BREAK
case 51:
/* rule 51 can match eol */
YY_RULE_SETUP
#line 493 "pascal-lex.l"
SetString (0); return LEX_STRCONST;
	YY_BREAK
case 52:
/* rule 52 can match eol */
YY_RULE_SETUP
#line 494 "pascal-lex.l"
SetString (1); return LEX_STRCONST;
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 495 "pascal-lex.l"
lex_error ("unterminated string constant"); BEGIN (Discard); RETURN_IF_DEFINED (LEX_INVALID);
	YY_BREAK
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 496 "pascal-lex.l"
RETURN_IF_DEFINED (LEX_INVALID);
	YY_BREAK
case 55:
/* rule 55 can match eol */
YY_RULE_SETUP
#line 498 "pascal-lex.l"
CheckFeature (DelphiComments, 1); RETURN_IF_DEFINED (LEX_COMMENT);
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 499 "pascal-lex.l"
StartComment (0, Comment1, Comment1B); RETURN_IF_DEFINED (LEX_COMMENT_BEGIN);
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 500 "pascal-lex.l"
StartComment (0, Comment2, Comment2B); RETURN_IF_DEFINED (LEX_COMMENT_BEGIN);
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 501 "pascal-lex.l"
StartComment (1, Comment1, Comment1B); RETURN_IF_DEFINED (LEX_DIRECTIVE_BEGIN);
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 502 "pascal-lex.l"
StartComment (1, Comment2, Comment2B); RETURN_IF_DEFINED (LEX_DIRECTIVE_BEGIN);
	YY_BREAK
case 60:
#line 504 "pascal-lex.l"
case 61:
YY_RULE_SETUP
#line 504 "pascal-lex.l"
EndComment;
	YY_BREAK
case 62:
#line 506 "pascal-lex.l"
case 63:
YY_RULE_SETUP
#line 506 "pascal-lex.l"
CheckFeature (MixedComments, 1); EndComment;
	YY_BREAK
case 64:
#line 508 "pascal-lex.l"
case 65:
YY_RULE_SETUP
#line 508 "pascal-lex.l"
{
                             if (CheckFeature (NestedComments, 0))
                               {
                                 CheckFeature (NestedComments, 1);
                                 CommentLevelCount++;
                                 RETURN_IF_DEFINED (LEX_COMMENT_BEGIN);
                               }
                             else
                               CommentContent;
                           }
	YY_BREAK
case 66:
#line 519 "pascal-lex.l"
case 67:
YY_RULE_SETUP
#line 519 "pascal-lex.l"
{
                             if (CheckFeature (NestedComments, 0))
                               {
                                 CheckFeature (NestedComments, 1);
                                 CheckFeature (MixedComments, 1);
                                 CommentLevelCount++;
                                 /* Theoretically, we should adjust the lexer state.
                                    But this would require a stack to pop it back
                                    when the nested comment is closed. Since we have
                                    just given a warning for mixed comments (if
                                    requested), this effort seems unjustified just
                                    to give a possible further one. */
                                 RETURN_IF_DEFINED (LEX_COMMENT_BEGIN);
                               }
                             else
                               CommentContent;
                           }
	YY_BREAK
case 68:
/* rule 68 can match eol */
#line 537 "pascal-lex.l"
case 69:
/* rule 69 can match eol */
#line 538 "pascal-lex.l"
case 70:
/* rule 70 can match eol */
YY_RULE_SETUP
#line 538 "pascal-lex.l"
CommentContent;
	YY_BREAK
case 71:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 539 "pascal-lex.l"
CommentContent;
	YY_BREAK
case 72:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 540 "pascal-lex.l"
CommentContent;
	YY_BREAK
case 73:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 541 "pascal-lex.l"
CommentContent;
	YY_BREAK
case 74:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 542 "pascal-lex.l"
CommentContent;
	YY_BREAK
case 75:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 543 "pascal-lex.l"
CommentContent;
	YY_BREAK
case 76:
*yy_cp = YY_G(yy_hold_char); /* undo effects of setting up yytext */
YY_G(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 544 "pascal-lex.l"
CommentContent;
	YY_BREAK
case 77:
#line 546 "pascal-lex.l"
case YY_STATE_EOF(Comment1):
case YY_STATE_EOF(Comment2):
case YY_STATE_EOF(Comment1B):
case YY_STATE_EOF(Comment2B):
#line 546 "pascal-lex.l"
LexPos = CommentStartPos; lex_error ("unterminated comment"); BEGIN (DiscardComment); CommentContent;
	YY_BREAK
case 78:
/* rule 78 can match eol */
YY_RULE_SETUP
#line 547 "pascal-lex.l"
CommentContent;
	YY_BREAK
case 79:
/* rule 79 can match eol */
YY_RULE_SETUP
#line 549 "pascal-lex.l"
DoLineDir (1); RETURN_IF_DEFINED (LEX_LINE_DIRECTIVE);
	YY_BREAK
case 80:
/* rule 80 can match eol */
YY_RULE_SETUP
#line 550 "pascal-lex.l"
DoLineDir (2); RETURN_IF_DEFINED (LEX_LINE_DIRECTIVE);
	YY_BREAK
case 81:
/* rule 81 can match eol */
YY_RULE_SETUP
#line 551 "pascal-lex.l"
DoLineDir (3); RETURN_IF_DEFINED (LEX_LINE_DIRECTIVE);
	YY_BREAK
case 82:
/* rule 82 can match eol */
#line 553 "pascal-lex.l"
case 83:
/* rule 83 can match eol */
YY_RULE_SETUP
#line 553 "pascal-lex.l"
lex_error ("invalid `#' directive"); RETURN_IF_DEFINED (LEX_INVALID);
	YY_BREAK
case 84:
/* rule 84 can match eol */
YY_RULE_SETUP
#line 555 "pascal-lex.l"
RETURN_IF_DEFINED (LEX_WHITESPACE);
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 556 "pascal-lex.l"
lex_error ("invalid character"); RETURN_IF_DEFINED (LEX_INVALID);
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(Discard):
case YY_STATE_EOF(DiscardComment):
#line 557 "pascal-lex.l"
return 0;
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 559 "pascal-lex.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 2006 "pascal-lex.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - YY_G(yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = YY_G(yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_G(yy_current_buffer)->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			YY_G(yy_n_chars) = YY_G(yy_current_buffer)->yy_n_chars;
			YY_G(yy_current_buffer)->yy_input_file = yyin;
			YY_G(yy_current_buffer)->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( YY_G(yy_c_buf_p) <= &YY_G(yy_current_buffer)->yy_ch_buf[YY_G(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			YY_G(yy_c_buf_p) = YY_G(yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( YY_CALL_ONLY_ARG );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state YY_CALL_LAST_ARG);

			yy_bp = YY_G(yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++YY_G(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = YY_G(yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( YY_CALL_ONLY_ARG ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				YY_G(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( YY_CALL_ONLY_ARG ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					YY_G(yy_c_buf_p) = YY_G(yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! YY_G(yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				YY_G(yy_c_buf_p) =
					YY_G(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( YY_CALL_ONLY_ARG );

				yy_cp = YY_G(yy_c_buf_p);
				yy_bp = YY_G(yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				YY_G(yy_c_buf_p) =
				&YY_G(yy_current_buffer)->yy_ch_buf[YY_G(yy_n_chars)];

				yy_current_state = yy_get_previous_state( YY_CALL_ONLY_ARG );

				yy_cp = YY_G(yy_c_buf_p);
				yy_bp = YY_G(yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */

#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
static int yy_get_next_buffer YYFARGS0(void)
	{
	register char *dest = YY_G(yy_current_buffer)->yy_ch_buf;
	register char *source = YY_G(yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( YY_G(yy_c_buf_p) > &YY_G(yy_current_buffer)->yy_ch_buf[YY_G(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_G(yy_current_buffer)->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( YY_G(yy_c_buf_p) - YY_G(yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (YY_G(yy_c_buf_p) - YY_G(yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_G(yy_current_buffer)->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_G(yy_current_buffer)->yy_n_chars = YY_G(yy_n_chars) = 0;

	else
		{
			size_t num_to_read =
			YY_G(yy_current_buffer)->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_G(yy_current_buffer);

			int yy_c_buf_p_offset =
				(int) (YY_G(yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 YY_CALL_LAST_ARG );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			YY_G(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_G(yy_current_buffer)->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_G(yy_current_buffer)->yy_ch_buf[number_to_move]),
			YY_G(yy_n_chars), num_to_read );

		YY_G(yy_current_buffer)->yy_n_chars = YY_G(yy_n_chars);
		}

	if ( YY_G(yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  YY_CALL_LAST_ARG);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_G(yy_current_buffer)->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	YY_G(yy_n_chars) += number_to_move;
	YY_G(yy_current_buffer)->yy_ch_buf[YY_G(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_G(yy_current_buffer)->yy_ch_buf[YY_G(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	YY_G(yytext_ptr) = &YY_G(yy_current_buffer)->yy_ch_buf[0];

	return ret_val;
	}
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */

/* yy_get_previous_state - get the state just before the EOB char was reached */

#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */
    static yy_state_type yy_get_previous_state YYFARGS0(void)
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = YY_G(yy_start);
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = YY_G(yytext_ptr) + YY_MORE_ADJ; yy_cp < YY_G(yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			YY_G(yy_last_accepting_state) = yy_current_state;
			YY_G(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 195 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  YYFARGS1( yy_state_type, yy_current_state)
	{
	register int yy_is_jam;
	register char *yy_cp = YY_G(yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		YY_G(yy_last_accepting_state) = yy_current_state;
		YY_G(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 195 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 194);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
    static void yyunput YYFARGS2( int,c, register char *,yy_bp)
	{
	register char *yy_cp = YY_G(yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = YY_G(yy_hold_char);

	if ( yy_cp < YY_G(yy_current_buffer)->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = YY_G(yy_n_chars) + 2;
		register char *dest = &YY_G(yy_current_buffer)->yy_ch_buf[
					YY_G(yy_current_buffer)->yy_buf_size + 2];
		register char *source =
				&YY_G(yy_current_buffer)->yy_ch_buf[number_to_move];

		while ( source > YY_G(yy_current_buffer)->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_G(yy_current_buffer)->yy_n_chars =
			YY_G(yy_n_chars) = YY_G(yy_current_buffer)->yy_buf_size;

		if ( yy_cp < YY_G(yy_current_buffer)->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

#ifdef YY_USE_LINENO
    if ( c == '\n' )
        --yylineno;
#endif
	YY_G(yytext_ptr) = yy_bp;
	YY_G(yy_hold_char) = *yy_cp;
	YY_G(yy_c_buf_p) = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput YYFARGS0(void)
#else
    static int input  YYFARGS0(void)
#endif


	{
	int c;

	*YY_G(yy_c_buf_p) = YY_G(yy_hold_char);

	if ( *YY_G(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( YY_G(yy_c_buf_p) < &YY_G(yy_current_buffer)->yy_ch_buf[YY_G(yy_n_chars)] )
			/* This was really a NUL. */
			*YY_G(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = YY_G(yy_c_buf_p) - YY_G(yytext_ptr);
			++YY_G(yy_c_buf_p);

			switch ( yy_get_next_buffer( YY_CALL_ONLY_ARG ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin YY_CALL_LAST_ARG);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( YY_CALL_ONLY_ARG ) )
						return EOF;

					if ( ! YY_G(yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(YY_CALL_ONLY_ARG);
#else
					return input(YY_CALL_ONLY_ARG);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					YY_G(yy_c_buf_p) = YY_G(yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) YY_G(yy_c_buf_p);	/* cast for 8-bit char's */
	*YY_G(yy_c_buf_p) = '\0';	/* preserve yytext */
	YY_G(yy_hold_char) = *++YY_G(yy_c_buf_p);

	YY_G(yy_current_buffer)->yy_at_bol = (c == '\n');

	return c;
	}
#endif	/* ifndef YY_NO_INPUT */

    void yyrestart  YYFARGS1( FILE *,input_file)
	{
	if ( ! YY_G(yy_current_buffer) )
		YY_G(yy_current_buffer) =
            yy_create_buffer( yyin, YY_BUF_SIZE YY_CALL_LAST_ARG);

	yy_init_buffer( YY_G(yy_current_buffer), input_file YY_CALL_LAST_ARG);
	yy_load_buffer_state( YY_CALL_ONLY_ARG );
	}

    void yy_switch_to_buffer  YYFARGS1( YY_BUFFER_STATE ,new_buffer)
	{
	if ( YY_G(yy_current_buffer) == new_buffer )
		return;

	if ( YY_G(yy_current_buffer) )
		{
		/* Flush out information for old buffer. */
		*YY_G(yy_c_buf_p) = YY_G(yy_hold_char);
		YY_G(yy_current_buffer)->yy_buf_pos = YY_G(yy_c_buf_p);
		YY_G(yy_current_buffer)->yy_n_chars = YY_G(yy_n_chars);
		}

	YY_G(yy_current_buffer) = new_buffer;
	yy_load_buffer_state( YY_CALL_ONLY_ARG );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	YY_G(yy_did_buffer_switch_on_eof) = 1;
	}


    void yy_load_buffer_state  YYFARGS0(void)
	{
	YY_G(yy_n_chars) = YY_G(yy_current_buffer)->yy_n_chars;
	YY_G(yytext_ptr) = YY_G(yy_c_buf_p) = YY_G(yy_current_buffer)->yy_buf_pos;
	yyin = YY_G(yy_current_buffer)->yy_input_file;
	YY_G(yy_hold_char) = *YY_G(yy_c_buf_p);
	}

    YY_BUFFER_STATE yy_create_buffer  YYFARGS2( FILE *,file, int ,size)
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) YY_CALL_LAST_ARG );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( b->yy_buf_size + 2 YY_CALL_LAST_ARG );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file YY_CALL_LAST_ARG);

	return b;
	}

    void yy_delete_buffer YYFARGS1( YY_BUFFER_STATE ,b)
	{
	if ( ! b )
		return;

	if ( b == YY_G(yy_current_buffer) )
		YY_G(yy_current_buffer) = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf YY_CALL_LAST_ARG );

	yyfree( (void *) b YY_CALL_LAST_ARG );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
#ifndef __cplusplus
extern int isatty YY_PARAMS(( int ));
#endif /* __cplusplus */
#endif /* !YY_NEVER_INTERACTIVE */
#endif /* !YY_ALWAYS_INTERACTIVE */

    void yy_init_buffer  YYFARGS2( YY_BUFFER_STATE ,b, FILE *,file)

	{
	int oerrno = errno;

	yy_flush_buffer( b YY_CALL_LAST_ARG);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	errno = oerrno;
	}

    void yy_flush_buffer YYFARGS1( YY_BUFFER_STATE ,b)
	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_G(yy_current_buffer) )
		yy_load_buffer_state( YY_CALL_ONLY_ARG );
	}


#ifndef YY_NO_SCAN_BUFFER
YY_BUFFER_STATE yy_scan_buffer  YYFARGS2( char *,base, yy_size_t ,size)
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) YY_CALL_LAST_ARG );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b YY_CALL_LAST_ARG );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
YY_BUFFER_STATE yy_scan_string YYFARGS1( yyconst char *,yy_str)
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len YY_CALL_LAST_ARG);
	}
#endif


#ifndef YY_NO_SCAN_BYTES
YY_BUFFER_STATE yy_scan_bytes  YYFARGS2( yyconst char *,bytes, int ,len)
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yyalloc( n YY_CALL_LAST_ARG );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n YY_CALL_LAST_ARG);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
    static void yy_push_state YYFARGS1( int ,new_state)
	{
	if ( YY_G(yy_start_stack_ptr) >= YY_G(yy_start_stack_depth) )
		{
		yy_size_t new_size;

		YY_G(yy_start_stack_depth) += YY_START_STACK_INCR;
		new_size = YY_G(yy_start_stack_depth) * sizeof( int );

		if ( ! YY_G(yy_start_stack) )
			YY_G(yy_start_stack) = (int *) yyalloc( new_size YY_CALL_LAST_ARG );

		else
			YY_G(yy_start_stack) = (int *) yyrealloc(
					(void *) YY_G(yy_start_stack), new_size YY_CALL_LAST_ARG );

		if ( ! YY_G(yy_start_stack) )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	YY_G(yy_start_stack)[YY_G(yy_start_stack_ptr)++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
    static void yy_pop_state  YYFARGS0(void)
	{
	if ( --YY_G(yy_start_stack_ptr) < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(YY_G(yy_start_stack)[YY_G(yy_start_stack_ptr)]);
	}
#endif


#ifndef YY_NO_TOP_STATE
    static int yy_top_state  YYFARGS0(void)
	{
	return YY_G(yy_start_stack)[YY_G(yy_start_stack_ptr) - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error YYFARGS1(yyconst char*, msg)
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = YY_G(yy_hold_char); \
		YY_G(yy_c_buf_p) = yytext + yyless_macro_arg; \
		YY_G(yy_hold_char) = *YY_G(yy_c_buf_p); \
		*YY_G(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )



/* Accessor  methods (get/set functions) to struct members. */


#ifndef YY_NO_GET_LINENO
int yyget_lineno  YYFARGS0(void)
{
    return yylineno;
}
#endif /* !YY_NO_GET_LINENO */

#ifndef YY_NO_GET_IN
FILE *yyget_in  YYFARGS0(void)
{
    return yyin;
}
#endif /* !YY_NO_GET_IN */

#ifndef YY_NO_GET_OUT
FILE *yyget_out  YYFARGS0(void)
{
    return yyout;
}
#endif /* !YY_NO_GET_OUT */

#ifndef YY_NO_GET_LENG
int yyget_leng  YYFARGS0(void)
{
    return yyleng;
}
#endif /* !YY_NO_GET_LENG */

#ifndef YY_NO_GET_TEXT
char *yyget_text  YYFARGS0(void)
{
    return yytext;
}
#endif /* !YY_NO_GET_TEXT */


#ifndef YY_NO_SET_LINENO
void yyset_lineno YYFARGS1( int ,line_number)
{
    yylineno = line_number;
}
#endif /* !YY_NO_SET_LINENO */


#ifndef YY_NO_SET_IN
void yyset_in YYFARGS1( FILE * ,in_str)
{
    yyin = in_str ;
}
#endif /* !YY_NO_SET_IN */

#ifndef YY_NO_SET_OUT
void yyset_out YYFARGS1( FILE * ,out_str)
{
    yyout = out_str ;
}
#endif /* !YY_NO_SET_OUT */


#ifndef YY_NO_GET_DEBUG
int yyget_debug  YYFARGS0(void)
{
    return yy_flex_debug;
}
#endif /* !YY_NO_GET_DEBUG */

#ifndef YY_NO_SET_DEBUG
void yyset_debug YYFARGS1( int ,bdebug)
{
    yy_flex_debug = bdebug ;
}
#endif /* !YY_NO_SET_DEBUG */


/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  YYFARGS0(void)
{
    /* Destroy the current (main) buffer. */
    yy_delete_buffer( YY_G(yy_current_buffer) YY_CALL_LAST_ARG );
    YY_G(yy_current_buffer) = NULL;

#if defined(YY_STACK_USED) || defined(YY_REENTRANT)
    /* Destroy the start condition stack. */
    if (YY_G(yy_start_stack) ){
        yyfree( YY_G(yy_start_stack) YY_CALL_LAST_ARG );
        YY_G(yy_start_stack) = NULL;
    }
#endif

#ifdef YY_USES_REJECT
    yyfree ( YY_G(yy_state_buf) YY_CALL_LAST_ARG);
#endif

    return 0;
}


/* Internal utility routines. */

#ifndef yytext_ptr
static void yy_flex_strncpy YYFARGS3( char*,s1, yyconst char *,s2, int,n)
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YYFARGS1( yyconst char *,s)
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif

/* You may override yyalloc by defining YY_NO_FLEX_ALLOC and linking to
 * your own version */
#ifndef YY_NO_FLEX_ALLOC
void *yyalloc YYFARGS1( yy_size_t ,size)
	{
	return (void *) malloc( size );
	}
#endif

/* You may override yyrealloc by defining YY_NO_FLEX_REALLOC and linking
 * to your own version. */
#ifndef YY_NO_FLEX_REALLOC
void *yyrealloc  YYFARGS2( void *,ptr, yy_size_t ,size)
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}
#endif

/* You may override yyfree by defining YY_NO_FLEX_FREE and linking to
 * your own version.*/
#ifndef YY_NO_FLEX_FREE
void yyfree YYFARGS1( void *,ptr)
	{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
	}
#endif

#define YYTABLES_NAME "yytables"

#if YY_MAIN
int main YY_PARAMS((void));

int main ()
	{

	yylex();

	return 0;
	}
#endif
#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */
#line 559 "pascal-lex.l"
#ifndef yyIN_HEADER /* YY-DISCARD-FROM-HEADER */

#endif /* !yyIN_HEADER YY-END-DISCARD-FROM-HEADER */
