/*
 *  Copyright (C) 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __misc_string_h
#define __misc_string_h

#ifdef __cplusplus
extern "C" {
#endif

#include <glib.h>

/* misc_string.c */
void misc_string_free_array (char *array[], int size);
gchar *misc_string_new_num_accel (gint num, gchar *text, gboolean lettersok);
gchar *misc_string_strip_uline_accel (const gchar *text);
gchar *misc_string_escape_uline_accel (const gchar *text);
gchar *misc_string_shorten_name(const gchar *input_name, gint target_length);
gchar *misc_string_shorten (const gchar *str, gint target_length);
const gchar *misc_string_strcasestr (const gchar *a, const gchar *b);
gchar *misc_string_strdup_replace (const gchar *str, const gchar *a,
				   const gchar *b);
gchar *misc_string_escape_xml_prop (const gchar *text);
gchar *misc_string_escape_path (const gchar *text);
gchar *misc_string_unescape_hexed_string (const gchar *text);
void misc_string_store_time_in_string (GTime t, gchar *str);
void misc_string_store_full_time_in_string (GTime t, gchar *str);
gchar *misc_string_time_to_string (GTime t);
gchar *misc_string_simplify_uri (const gchar *uri);
gchar *misc_string_xml_decode_entity (const unsigned char *encoded);
gchar *misc_string_parse_uri (const gchar *uri);
gchar *misc_string_strip_newline (const gchar *c);
gchar *misc_string_remove_outside_whitespace (const gchar *str);
gchar *misc_string_expand_home_dir (const gchar *str);

#ifdef __cplusplus
}
#endif
#endif
