"""

Gnome Python Tools: GnomeFileSelection, GnomeProgressbar, GnomePixmap, GnomePixmapWithLabel, 
                    GnomePopupQuestionDialog, GnomeOptionMenu

"""

from os import environ
import sys

if (not environ.has_key("DISPLAY")):              # This happens when started in a console
    raise ImportError, "DISPLAY environment variable not set"

from gnome.ui import GnomeQuestionDialog, GnomeApp, GnomeEntry, GnomeErrorDialog
from gtk import GtkLabel, GtkPixmap, GtkHBox, GtkFrame, GtkVBox, GtkProgressBar, GtkButton, GtkCList, GtkTable
from gtk import GtkEntry, GtkScrolledWindow, GdkColor, GtkCheckButton, GtkOptionMenu, GtkMenu, GtkRadioMenuItem
from gtk import GtkMenuItem, create_pixmap_from_xpm, TRUE, FALSE
from gtk import events_pending, mainiteration, SHADOW_ETCHED_OUT, SELECTION_SINGLE
from gtk import JUSTIFY_RIGHT, POLICY_AUTOMATIC, FILL, SELECTION_EXTENDED, JUSTIFY_CENTER
from GDK import _2BUTTON_PRESS, BUTTON_PRESS
from time import sleep
from os import listdir, stat, getcwd, chmod
from string import join, split, lower, upper, zfill, strip, atoi, find
from time import localtime, asctime, time
from ConfigParser import ConfigParser
from re import sub
from tempfile import mktemp

try:
    from log4py import Logger
    log4pyavailable = TRUE
except ImportError:
    log4pyavailable = FALSE

import os

# Dicitionary caching common used GdkColors
GdkColorCache = {}

# Drag & Drop target definition
targets = [('text/plain', 0, 1),
            ('text/uri-list', 0, 2),
            ('STRING', 0, 3)]

# Constants for various file-types
ALL_FILES = ("All Files", ["*"])
AUDIO_FILES = ("Audio Files", ["mp3", "ogg", "wav"])
EROASTER_PROJECTS = ("ERoaster Projects", ["erp"])
ISO_IMAGES = ("ISO Images", ["iso", "img"])
XMMS_PLAYLISTS = ("XMMS Playlists", ["m3u"])
WINGIDE_PROJECTS = ("WingIDE Projects", ["wpr"])
CUE_SHEETS = ("Cuesheets", ["cue"])
BIN_FILES = ("BIN files", ["bin"])

# Short cuts (default)
SHORTCUTS = [ [ "HOME", "$HOME" ],
              [ "DESKTOP", "%s/.gnome-desktop" % environ["HOME"] ],
              [ "START", "$CWD" ],
              [ "LASTDIR", "$LASTDIR"],
              [ "", ""],
              [ "", ""]
              ]

# Dictionary containing icons for different filetypes
ICONS = {}
ICONS["DIRECTORY"] = "folder.xpm"                      # DO NOT CHANGE THIS ONE !
ICONS["UNKNOWN"] = "unknown.xpm"                       # DO NOT CHANGE THIS ONE !

ICONS["HOME"] = "home.xpm"                             # These icons are for the shortcuts
ICONS["DESKTOP"] = "desktop.xpm"
ICONS["START"] = "start.xpm"
ICONS["LASTDIR"] = "lastdir.xpm"
ICONS["CDROM"] = "cdrom.xpm"
ICONS["HARDDISK"] = "harddisk.xpm"
ICONS["NETWORK"] = "network.xpm"
ICONS["LINK"] = "link.xpm"

ICONS["DOC"] = "doc.xpm"                               # These icons are compared to file extensions
ICONS["GZ"] = "compressed.xpm"
ICONS["BZ2"] = "compressed.xpm"
ICONS["GIF"] = "image.xpm"
ICONS["JPG"] = "image.xpm"
ICONS["BMP"] = "image.xpm"
ICONS["PNG"] = "image.xpm"
ICONS["XPM"] = "image.xpm"
ICONS["PATCH"] = "patch.xpm"
ICONS["PS"] = "ps.xpm"
ICONS["MP3"] = "sound.xpm"
ICONS["WAV"] = "sound.xpm"
ICONS["OGG"] = "sound.xpm"
ICONS["TAR"] = "tar.xpm"
ICONS["TXT"] = "text.xpm"

# Returns a string representation of a number (with a pretty-print option)
def lng2str(number, prettyprint = TRUE):
    if (prettyprint == TRUE):
        number = list(str(number))
        if number[-1] == "L":
            number = number[:-1]
        number.reverse()
        dots = divmod(len(number) - 1, 3)[0]
        for i in range(dots):
            number.insert(3 + (i * 3) + i, ".")
        number.reverse()
        return join(number, "")
    else:
        return str(number)

# Converts RGB value to a GdkColor
def hex2gdkcolor(widget, color):
    global GdkColorCache
    if (color[0] == "#"):
        color = color[1:]
    if (GdkColorCache.has_key(color)):
        return GdkColorCache[color]
    else:
        red = eval("0x%s" % color[0:2]) * 257
        green = eval("0x%s" % color[2:4]) * 257
        blue = eval("0x%s" % color[4:6]) * 257
        color_map = widget.get_colormap()
        gdkcolor = color_map.alloc(red, green, blue)
        if (not GdkColorCache.has_key(color)):
            GdkColorCache[color] = gdkcolor
        return gdkcolor

def indexof(dict, elem):
    for i in range(len(dict)):
        if (dict[i] == elem):
            return i

def get_file_icon(filename, window, icondir):
    if (os.path.islink(filename)):
        filename = "LINK"
    elif (os.path.isdir(filename)):
        filename = "DIRECTORY"
    if (filename in [ "LINK", "DIRECTORY", "HOME", "DESKTOP", "START", "LASTDIR", "CDROM", "HARDDISK", "NETWORK" ]):
        xpmname = ICONS[filename]
    else:
        extension = upper(os.path.splitext(filename)[1])
        if (len(extension) > 0):
            extension = extension[1:]
        if (ICONS.has_key(extension)):
            xpmname = ICONS[extension]
        else:
            xpmname = ICONS["UNKNOWN"]
    if (len(icondir) > 0):
        if (icondir[-1] != "/"):
            icondir = "%s/" % icondir
        pix, mask = create_pixmap_from_xpm(window, None, "%s%s" % (icondir, xpmname))
        pixmap = GtkPixmap(pix, mask)
        pixmap.show()
        return pixmap
    else:
        return None

def format_duration(seconds):
    hours = int(divmod(seconds, (60 * 60))[0])
    seconds = seconds - (hours * (60 * 60))
    minutes = int(divmod(seconds, 60)[0])
    seconds = str(seconds - (minutes * 60))
    splitted = split(seconds, ".")
    seconds = zfill(splitted[0], 2)
    if (len(splitted) > 1):
        milliseconds = splitted[1][:3]
    else:
        milliseconds = ""
    while (len(milliseconds) < 3):
        milliseconds = "%s0" % milliseconds
    return "%s:%s:%s.%s" % (zfill(hours, 2), zfill(minutes, 2), seconds, milliseconds)

# GnomeFileSelection: advanced file selection dialog
class GnomeFileSelection:

    def __init__(self, path = getcwd(), showhiddenfiles = FALSE, multiselection = TRUE, filetypes = [ALL_FILES], icondir = "", windowtitle = "Open File", loglevel = 1 << 1):
        self.filelist = []
        self.path = path
        self.showhiddenfiles = showhiddenfiles
        self.filetypes = filetypes
        self.currentextension = filetypes[0][1]
        self.icondir = icondir
        self.windowtitle = windowtitle
        if (len(self.icondir) > 0):
            if (self.icondir[-1] != "/"):
                self.icondir = "%s/" % self.icondir
        if (multiselection == TRUE):
            self.selectiontype = SELECTION_EXTENDED
        else:
            self.selectiontype = SELECTION_SINGLE
        self.selectedfiles = []
        self.__GnomeFileSelection__lastdirectory = ""
        self.__GnomeFileSelection_lastdirectoryread = ""
        self.__GnomeFileSelection__shortcuts = SHORTCUTS
        if (log4pyavailable == TRUE):
            self.log4py = Logger().get_instance(self)
            self.log4py.set_loglevel(loglevel)
            self.log4py.debug("GnomeFileSelection initialized")
        else:
            self.log4py = None
        self.__GnomeFileSelection__drawwindow()

    def __GnomeFileSelection__drawwindow(self):

        self.window = GnomeApp("Open File", self.windowtitle)
        self.window.set_border_width(5)
        lookinlabel = GtkLabel("Look in:")
        lookinlabel.show()
        self.lookinpath = GnomeEntry("fileselector")
        self.lookinpath.load_history()
        self.lookinpath.gtk_entry().connect("key_press_event", self.__GnomeFileSelection__changedirectorymanually)
        self.lookinpath.gtk_entry().set_text(self.path)
        self.lookinpath.list.connect("select_child", self.__GnomeFileSelection__changedirectoryselection)
        self.lookinpath.show()
        self.lookinparent = GtkButton(" .. ")
        self.lookinparent.connect("clicked", self.__GnomeFileSelection__changetoparentdir)
        self.lookinparent.show()
        lookinbox = GtkHBox(spacing = 5)
        lookinbox.pack_start(lookinlabel, expand = FALSE)
        lookinbox.pack_start(self.lookinpath)
        lookinbox.pack_start(self.lookinparent, expand = FALSE)
        lookinbox.show()

        if (self.icondir != ""):
            self.fileclist = GtkCList(4, ["", " Name ", " Size ", " Last modified "])
            self.fileclist.set_column_width(0, 18)
            self.fileclist.set_column_width(1, 132)
            self.fileclist.set_column_width(2, 80)
            self.fileclist.set_column_width(3, 155)
            self.fileclist.set_column_justification(2, JUSTIFY_RIGHT)
            self.fileclist.set_column_justification(3, JUSTIFY_RIGHT)
        else:
            self.fileclist = GtkCList(3, [" Name ", " Size ", " Last modified "])
            self.fileclist.set_column_width(0, 150)
            self.fileclist.set_column_width(1, 80)
            self.fileclist.set_column_width(2, 155)
            self.fileclist.set_column_justification(1, JUSTIFY_RIGHT)
            self.fileclist.set_column_justification(2, JUSTIFY_RIGHT)
        self.fileclist.set_usize(440, 245)
        self.fileclist.set_selection_mode(self.selectiontype)
        self.fileclist.connect("key_press_event", self.__GnomeFileSelection__changedirectorykeyboard)
        self.fileclist.connect("button_press_event", self.__GnomeFileSelection__changedirectory)
        self.fileclist.connect("select_row", self.__GnomeFileSelection__updatefileselection)
        self.fileclist.connect("unselect_row", self.__GnomeFileSelection__updatefileselection)
        self.fileclist.show()

        filescrolledwin = GtkScrolledWindow()
        filescrolledwin.set_policy(POLICY_AUTOMATIC, POLICY_AUTOMATIC)
        filescrolledwin.add(self.fileclist)
        filescrolledwin.show()

        filenamelabel = GtkLabel("Filename:")
        filenamelabel.set_alignment(0, 0.5)
        filenamelabel.show()
        self.filename = GtkEntry()
        self.filename.show()

        filetypeoptionmenu = GtkOptionMenu()
        self.filetypemenu = GtkMenu()
        self.filetypemenu.show()
        self.filetypeitems = {}
        for i in range(len(self.filetypes)):
            description = self.filetypes[i][0] + " ("
            for j in range(len(self.filetypes[i][1])):
                extension = self.filetypes[i][1][j]
                if (extension == "*"):
                    description = "%s%s; " % (description, extension)
                else:
                    description = "%s*.%s; " % (description, extension)
            description = "%s)" % description[:-2]
            self.filetypeitems[i] = GtkMenuItem(description)
            self.filetypeitems[i].connect("activate", self.__GnomeFileSelection__activatefiletype)
            self.filetypeitems[i].show()
            self.filetypemenu.append(self.filetypeitems[i])
        self.__GnomeFileSelection__updateonactivate = FALSE
        self.filetypemenu.activate_item(self.filetypeitems[0], TRUE)
        self.__GnomeFileSelection__updateonactivate = TRUE
        filetypeoptionmenu.set_menu(self.filetypemenu)
        filetypeoptionmenu.show()

        filetypelabel = GtkLabel("Files of type: ")
        filetypelabel.set_alignment(0, 0.5)
        filetypelabel.show()

        filetable = GtkTable(2, 2)
        filetable.attach(filenamelabel, 0, 1, 0, 1, FILL, 0)
        filetable.attach(self.filename, 1, 2, 0, 1)
        filetable.attach(filetypelabel, 0, 1, 1, 2, FILL, 0)
        filetable.attach(filetypeoptionmenu, 1, 2, 1, 2, FILL, 0)
        filetable.show()

        self.hidden = GtkCheckButton("Show hidden files")
        self.hidden.set_active(self.showhiddenfiles)
        self.hidden.connect("clicked", self.__GnomeFileSelection__changehiddenfiles)
        self.hidden.show()
        dummy = GtkLabel()
        dummy.show()
        self.ok_button = GtkButton("OK")
        self.ok_button.set_usize(75, -1)
        self.ok_button.show()
        self.close_button = GtkButton("Close")
        self.close_button.set_usize(75, -1)
        self.close_button.show()
        buttonbox = GtkHBox(spacing = 5)
        buttonbox.pack_start(self.hidden, expand = FALSE)
        buttonbox.pack_start(dummy)
        buttonbox.pack_start(self.ok_button, expand = FALSE)
        buttonbox.pack_start(self.close_button, expand = FALSE)
        buttonbox.show()

        self.shortcuts = GtkCList(1, [ " Shortcuts " ])
        self.shortcuts.set_column_justification(0, JUSTIFY_CENTER)
        self.shortcuts.set_row_height(50)
        self.shortcuts.connect("select_row", self.__GnomeFileSelection__changeshortcut)
        self.__GnomeFileSelection__addshortcuts()
        self.shortcuts.show()

        rightbox = GtkVBox(spacing = 5)
        rightbox.pack_start(filescrolledwin, expand = TRUE, fill = TRUE)
        rightbox.pack_start(filetable, expand = FALSE)
        rightbox.pack_start(buttonbox, expand = FALSE)
        rightbox.show()

        shortfilebox = GtkHBox(spacing = 5)
        shortfilebox.pack_start(self.shortcuts, expand = FALSE)
        shortfilebox.pack_start(rightbox, expand = TRUE, fill = TRUE)
        shortfilebox.show()

        openfilebox = GtkVBox(spacing = 5)
        openfilebox.pack_start(lookinbox, expand = FALSE)
        openfilebox.pack_start(shortfilebox)
        openfilebox.show()

        self.window.set_contents(openfilebox)

    def __GnomeFileSelection__addshortcuts(self):
        for i in range(len(self.__GnomeFileSelection__shortcuts)):
            tuple = self.__GnomeFileSelection__shortcuts[i]
            self.shortcuts.append([tuple[1]])
            gdkcolor = hex2gdkcolor(self.window, "#7b7b7b")
            if (gdkcolor != None):
                self.shortcuts.set_background(i, gdkcolor)
            if (tuple[0] != "") and (self.icondir != ""):
                self.shortcuts.set_pixmap(i, 0, get_file_icon(tuple[0], self.window, self.icondir))

    def __GnomeFileSelection__getfreeshortcutindex(self):
        index = 0
        for i in range(len(self.__GnomeFileSelection__shortcuts)):
            if (self.__GnomeFileSelection__shortcuts[i][0] != ""):
                index = (i + 1)
            else:
                return index
        return index

    def __GnomeFileSelection__getlastshortcutindex(self):
        return self.__GnomeFileSelection__getfreeshortcutindex() - 1

    def __GnomeFileSelection__setshortcutbyindex(self, index, identifier, target):
        shortcut = self.__GnomeFileSelection__shortcuts[index]
        shortcut[0] = identifier
        target = sub("\$HOME", environ["HOME"], target)
        target = sub("\$CWD", getcwd(), target)
        target = sub("\$LASTDIR", self.__GnomeFileSelection__lastdirectory, target)
        shortcut[1] = target
        self.__GnomeFileSelection__shortcuts[index] = shortcut
        if (identifier != "") and (self.icondir != ""):
            self.shortcuts.set_pixmap(index, 0, get_file_icon(identifier, self.window, self.icondir))

    def __GnomeFileSelection__readdirectory(self):
        if (self.path == self.__GnomeFileSelection_lastdirectoryread):
            return
        self.fileclist.clear()
        self.filename.set_text("")
        self.fileclist.freeze()
        if (self.log4py != None):
            self.log4py.debug("Reading directory: %s" % self.path)
        if (not (os.path.exists(self.path))):
            if (self.log4py != None):
                self.log4py.error("Error: Directory %s doesn't exist - using $HOME" % self.path)
            self.path = environ["HOME"]
            self.lookinpath.gtk_entry().set_text(self.path)
        files = listdir(self.path)
        files.sort()
        linenumber = 0

        # First show all directories
        for i in range(len(files)):
            filename = "%s/%s" % (self.path, files[i])
            showfile = not ((self.showhiddenfiles == FALSE) and (files[i][0] == "."))
            if (os.path.exists(filename)) and (os.path.isdir(filename)) and (showfile == TRUE):
                statinfo = stat(filename)
                if (self.icondir != ""):
                    self.fileclist.append(["", files[i], lng2str(statinfo[6]), asctime(localtime(statinfo[8]))])
                    self.fileclist.set_pixmap(linenumber, 0, get_file_icon("DIRECTORY", self.window, self.icondir))
                else:
                    self.fileclist.append([files[i], lng2str(statinfo[6]), asctime(localtime(statinfo[8]))])
                if (divmod(linenumber, 2)[1] == 0):
                    gdkcolor = hex2gdkcolor(self.window, "#f6f6f6")
                    if (gdkcolor != None):
                        self.fileclist.set_background(linenumber, gdkcolor)
                linenumber = linenumber + 1

        # And now all other files and symlinks
        for i in range(len(files)):
            filename = "%s/%s" % (self.path, files[i])
            showfile = not ((self.showhiddenfiles == FALSE) and (files[i][0] == "."))
            if (showfile == TRUE):
                extensionok = FALSE
                for j in range(len(self.currentextension)):
                    extension = lower(self.currentextension[j])
                    if (extension == "*") or ((len(files[i]) >= len(extension)) and (extension == files[i][len(files[i])-(len(extension)):])):
                        extensionok = TRUE
            if (os.path.exists(filename)) and (not os.path.isdir(filename)) and (showfile == TRUE) and (extensionok == TRUE):
                statinfo = stat(filename)
                if (self.icondir != ""):
                    self.fileclist.append(["", files[i], lng2str(statinfo[6]), asctime(localtime(statinfo[8]))])
                    self.fileclist.set_pixmap(linenumber, 0, get_file_icon(files[i], self.window, self.icondir))
                else:
                    self.fileclist.append([files[i], lng2str(statinfo[6]), asctime(localtime(statinfo[8]))])
                if (divmod(linenumber, 2)[1] == 0):
                    gdkcolor = hex2gdkcolor(self.window, "#f6f6f6")
                    if (gdkcolor != None):
                        self.fileclist.set_background(linenumber, gdkcolor)
                linenumber = linenumber + 1

        self.fileclist.thaw()
        self.__GnomeFileSelection_lastdirectoryread = self.path

    def __GnomeFileSelection__changetoparentdir(self, args):
        if (self.path != "/"):
            self.path = join(split(self.path, "/")[:-1], "/")
            if (self.path == ""):
                self.path = "/"
        self.lookinpath.gtk_entry().set_text(self.path)
        self.__GnomeFileSelection__readdirectory()

    # Add a file by pressing Enter on the keyboard
    def __GnomeFileSelection__changedirectorykeyboard(self, clist, event):
        if ((event.keyval == 65293) or (event.keyval == 65421)):
            self.ok_button.emit("clicked")

    def __GnomeFileSelection__changedirectory(self, clist, event):
        if (event.type == _2BUTTON_PRESS):                                     # Double click
            try:
                row = self.fileclist.get_selection_info(event.x, event.y)[0]
                if (self.icondir != ""):
                    columnnr = 1
                else:
                    columnnr = 0
                directory = self.fileclist.get_text(row, columnnr)
                if (self.path == "/"):
                    tmppath = "/%s" % directory
                else:
                    tmppath = "%s/%s" % (self.path, directory)
                if (os.path.isdir(tmppath)):
                    self.path = tmppath
                    self.lookinpath.gtk_entry().set_text(self.path)
                    self.__GnomeFileSelection__readdirectory()
                else:
                    self.ok_button.emit("clicked")
            except:
                row = -1

    def __GnomeFileSelection__updatefileselection(self, clist, row, column, event):
        if (self.icondir != ""):
            columnnr = 1
        else:
            columnnr = 0
        if (len(self.fileclist.selection) == 1):
            filenames = self.fileclist.get_text(self.fileclist.selection[0], columnnr)
        else:
            filenames = ""
            for i in range(len(self.fileclist.selection)):
                filename = self.fileclist.get_text(self.fileclist.selection[i], columnnr)
                filenames = "%s\"%s\" " % (filenames, filename)
            if (len(filenames) > 0):
                filenames = filenames[:-1]
        self.filename.set_text(filenames)

    def __GnomeFileSelection__changedirectoryselection(self, clist, clistitem):
        path = self.lookinpath.gtk_entry().get_text()
        if (os.path.isdir(path)):
            if (self.path != path):
                self.path = path
                self.__GnomeFileSelection__readdirectory()
        else:
            GnomeErrorDialog("Error - %s is not a valid directory !" % path)

    def __GnomeFileSelection__changedirectorymanually(self, entry, event):
        if ((event.keyval == 65293) or (event.keyval == 65421)):
            path = self.lookinpath.gtk_entry().get_text()
            if (os.path.isdir(path)):
                if (self.path != path):
                    self.path = path
                    self.__GnomeFileSelection__readdirectory()
            else:
                GnomeErrorDialog("Error - %s is not a valid directory !" % path)

    def __GnomeFileSelection__changehiddenfiles(self, args):
        self.showhiddenfiles = self.hidden.get_active()
        self.__GnomeFileSelection__readdirectory()

    def __GnomeFileSelection__activatefiletype(self, args):
        self.currentextension = self.filetypes[indexof(self.filetypeitems, self.filetypemenu.get_active())][1]
        if (self.__GnomeFileSelection__updateonactivate == TRUE):
            self.__GnomeFileSelection__readdirectory()

    def __GnomeFileSelection__changeshortcut(self, clist, row, column, event):
        if (self.__GnomeFileSelection__shortcuts[row][1] != ""):
            self.path = self.__GnomeFileSelection__shortcuts[row][1]
            self.lookinpath.gtk_entry().set_text(self.path)
            self.__GnomeFileSelection__readdirectory()

    def __GnomeFileSelection_loadlastdirectory(self):
        if (os.path.exists(self.__GnomeFileSelection__lastdirectoryfilename)):
            file = open(self.__GnomeFileSelection__lastdirectoryfilename, "r")
            self.__GnomeFileSelection__lastdirectory = strip(file.readline())
            file.close()
            if (self.log4py != None):
                self.log4py.debug("Last directory %s loaded from %s" % (self.__GnomeFileSelection__lastdirectory, self.__GnomeFileSelection__lastdirectoryfilename))
            self.path = self.__GnomeFileSelection__lastdirectory
            self.lookinpath.gtk_entry().set_text(self.__GnomeFileSelection__lastdirectory)

    def __GnomeFileSelection_savelastdirectory(self):
        file = open(self.__GnomeFileSelection__lastdirectoryfilename, "w")
        file.write("%s\n" % self.lookinpath.gtk_entry().get_text())
        file.close()

    def show(self):
        self.__GnomeFileSelection__readdirectory()
        self.window.show()

    def destroy(self, args = None):
        self.lookinpath.save_history()
        if (self.__GnomeFileSelection__lastdirectoryfilename != ""):
            self.__GnomeFileSelection_savelastdirectory()
        self.window.destroy()

    def get_filenames(self):
        if (self.selectiontype == SELECTION_SINGLE):
            return self.filename.get_text()
        else:
            if (len(self.filename.get_text()) > 0):
                if (self.filename.get_text()[0] != "\""):
                    filenames = [self.filename.get_text()]
                else:
                    filenames = self.filename.get_text()
                    filenames = filenames[1:-1]
                    filenames = split(filenames, "\" \"")
            else:
                filenames = []
            return filenames

    def get_directory(self):
        return self.lookinpath.gtk_entry().get_text()

    def clear_shortcuts(self):
        for i in range(len(self.__GnomeFileSelection__shortcuts)):
            if (self.__GnomeFileSelection__shortcuts[i][0] != ""):
                self.__GnomeFileSelection__shortcuts[i][0] = ""
                self.__GnomeFileSelection__shortcuts[i][1] = ""
                self.shortcuts.set_text(i, 0, "")

    def append_shortcut(self, identifier, target):
        freeindex = self.__GnomeFileSelection__getfreeshortcutindex()
        self.__GnomeFileSelection__setshortcutbyindex(freeindex, identifier, target)

    def remove_shortcut(self):
        lastindex = self.__GnomeFileSelection__getlastshortcutindex()
        self.__GnomeFileSelection__shortcuts[lastindex][0] = ""
        self.__GnomeFileSelection__shortcuts[lastindex][1] = ""
        self.shortcuts.set_text(lastindex, 0, "")

    def load_shortcuts_from_file(self, filename):
        self.clear_shortcuts()
        parser = ConfigParser()
        parser.read(filename)
        section = "shortcuts"
        for i in range(len(parser.options(section))):
            option = lower(parser.options(section)[i])
            if (option[:8] == "shortcut"):
                value = strip(parser.get(section, option, 1))
                if (value != ""):
                    if (find(value, ":") == -1):
                        if (self.log4py != None):
                            self.log4py.error("Invalid entry #%d in %s: %s" % (atoi(option[8:]), filename, value))
                    else:
                        splitted = split(value, ":")
                        index = atoi(option[8:])
                        self.__GnomeFileSelection__setshortcutbyindex(index, upper(strip(splitted[0])), strip(splitted[1]))

    def use_lastdirectory(self, filename):
        self.__GnomeFileSelection__lastdirectoryfilename = filename
        if (self.__GnomeFileSelection__lastdirectoryfilename != ""):
            self.__GnomeFileSelection_loadlastdirectory()

# GnomeProgressBar: extendend progressbar class with additional information
class GnomeProgressBar:

    def __init__(self, title, description, maxvalue, minvalue = 0.0):
        labDescription = GtkLabel(" %s\n" % description)
        labDescription.set_usize(100, -1)
        labDescription.set_alignment(0, 0)
        labDescription.show()

        self.progressbar = GtkProgressBar()
        self.progressbar.configure(minvalue, minvalue, maxvalue)
        self.progressbar.set_format_string("%v of %u (%p%%)")
        self.progressbar.set_show_text(TRUE)
        self.progressbar.show()

        labTimeStart = GtkLabel(" Time started: ")
        labTimeStart.set_alignment(1, 0)
        labTimeStart.show()
        self.__GnomeProgressBar_starttime = time()
        self.__GnomeProgressBar_laststep = self.__GnomeProgressBar_starttime
        now = localtime(self.__GnomeProgressBar_starttime)
        self.timestart = GtkLabel("%s:%s:%s" % (zfill(now[3],2), zfill(now[4],2), zfill(now[5],2)))
        self.timestart.set_alignment(0, 0)
        self.timestart.show()
        labTimeEnd = GtkLabel(" Estimated end time: ")
        labTimeEnd.set_alignment(1, 0)
        labTimeEnd.show()
        self.timeend = GtkLabel("--:--:--")
        self.timeend.set_alignment(0, 0)
        self.timeend.show()
        labTimeDuration = GtkLabel(" Duration: ")
        labTimeDuration.set_alignment(1, 0)
        labTimeDuration.show()
        self.timeduration = GtkLabel("--:--:--.---")
        self.timeduration.set_alignment(0, 0)
        self.timeduration.show()
        labTimeRemaining = GtkLabel(" Time remaining: ")
        labTimeRemaining.set_alignment(1, 0)
        labTimeRemaining.show()
        self.timeremaining = GtkLabel("--:--:--.---")
        self.timeremaining.set_alignment(0, 0)
        self.timeremaining.show()

        statustable = GtkTable(2, 5)                 # 2 rows, 5 columns
        statustable.attach(labTimeStart, 0, 1, 0, 1, FILL, 0, 1, 1)
        statustable.attach(self.timestart, 1, 2, 0, 1, 0, 0, 1, 1)
        statustable.attach(labTimeEnd, 0, 1, 1, 2, 0, 0, 1, 1)
        statustable.attach(self.timeend, 1, 2, 1, 2, 0, 0, 1, 1)
        statustable.attach(labTimeDuration, 2, 3, 0, 1, FILL, 0, 1, 1)
        statustable.attach(self.timeduration, 3, 4, 0, 1, 0, 0, 1, 1)
        statustable.attach(labTimeRemaining, 2, 3, 1, 2, 0, 0, 1, 1)
        statustable.attach(self.timeremaining, 3, 4, 1, 2, 0, 0, 1, 1)
        statustable.show()

        timingframe = GtkFrame("Timing Information")
        timingframe.set_border_width(3)
        timingframe.add(statustable)
        timingframe.show()

        vbox = GtkVBox()
        vbox.set_border_width(3)
        vbox.pack_start(labDescription)
        vbox.pack_start(timingframe)
        vbox.show()

        labThroughputCurrent = GtkLabel(" Current:")
        labThroughputCurrent.set_alignment(1, 0.5)
        labThroughputCurrent.show()
        self.throughput_current = GtkLabel(" ---")
        self.throughput_current.set_alignment(1, 0.5)
        self.throughput_current.show()
        labThroughputMinimum = GtkLabel(" Minimum:")
        labThroughputMinimum.set_alignment(1, 0.5)
        labThroughputMinimum.show()
        self.throughput_minimum = GtkLabel(" ---")
        self.throughput_minimum.set_alignment(1, 0.5)
        self.throughput_minimum.show()
        labThroughputAverage = GtkLabel(" Average:")
        labThroughputAverage.set_alignment(1, 0.5)
        labThroughputAverage.show()
        self.throughput_average = GtkLabel(" ---")
        self.throughput_average.set_alignment(1, 0.5)
        self.throughput_average.show()
        labThroughputMaximum = GtkLabel(" Maximum:")
        labThroughputMaximum.set_alignment(1, 0.5)
        labThroughputMaximum.show()
        self.throughput_maximum = GtkLabel(" ---")
        self.throughput_maximum.set_alignment(1, 0.5)
        self.throughput_maximum.show()

        self.__GnomeProgressBar_throughput_minimum = -1
        self.__GnomeProgressBar_throughput_maximum = -1

        throughputtable = GtkTable(4, 2)
        throughputtable.attach(labThroughputCurrent, 0, 1, 0, 1, FILL, 0, 1, 1)
        throughputtable.attach(self.throughput_current, 1, 2, 0, 1)
        throughputtable.attach(labThroughputMinimum, 0, 1, 1, 2, FILL, 0, 1, 1)
        throughputtable.attach(self.throughput_minimum, 1, 2, 1, 2)
        throughputtable.attach(labThroughputAverage, 0, 1, 2, 3, FILL, 0, 1, 1)
        throughputtable.attach(self.throughput_average, 1, 2, 2, 3)
        throughputtable.attach(labThroughputMaximum, 0, 1, 3, 4, FILL, 0, 1, 1)
        throughputtable.attach(self.throughput_maximum, 1, 2, 3, 4)
        throughputtable.show()

        throughputframe = GtkFrame("Throughput / Min")
        throughputframe.set_border_width(3)
        throughputframe.add(throughputtable)
        throughputframe.show()

        hbox = GtkHBox()
        hbox.set_border_width(3)
        hbox.pack_start(vbox)
        hbox.pack_start(throughputframe)
        hbox.show()

        vboxprogress = GtkVBox()
        vboxprogress.set_border_width(3)
        vboxprogress.pack_start(hbox)
        vboxprogress.pack_start(self.progressbar)
        vboxprogress.show()

        self.window = GnomeApp("ProgressWindow", title)
        self.window.set_border_width(3)
        self.window.set_contents(vboxprogress)
        self.window.show()

        self.redraw()

    def redraw(self):
        # FIXME: make sure window is being drawn; use gtk.idle_add probably
        while events_pending():
            mainiteration()

    def update(self, step = 1):
        self.redraw()
        self.progressbar.set_value(self.progressbar.get_value() + step)
        currenttime = time()
        duration = currenttime - self.__GnomeProgressBar_starttime
        durationlaststep = currenttime - self.__GnomeProgressBar_laststep
        self.__GnomeProgressBar_laststep = currenttime
        throughput_current = (60 / durationlaststep) / step
        if ((self.__GnomeProgressBar_throughput_minimum == -1) or (throughput_current < self.__GnomeProgressBar_throughput_minimum)):
            self.__GnomeProgressBar_throughput_minimum = throughput_current
            self.throughput_minimum.set_text(" %.2f " % self.__GnomeProgressBar_throughput_minimum)
        if ((self.__GnomeProgressBar_throughput_maximum == -1) or (throughput_current > self.__GnomeProgressBar_throughput_maximum)):
            self.__GnomeProgressBar_throughput_maximum = throughput_current
            self.throughput_maximum.set_text(" %.2f " % self.__GnomeProgressBar_throughput_maximum)
        percent = self.progressbar.get_current_percentage()
        remaining = (duration / percent) * (1 - percent)
        endtime = localtime(self.__GnomeProgressBar_starttime + duration + remaining)
        self.timeduration.set_text("%s " % format_duration(duration))
        self.timeremaining.set_text("%s " % format_duration(remaining))
        self.timeend.set_text("%s:%s:%s" % (zfill(endtime[3],2), zfill(endtime[4],2), zfill(endtime[5],2)))
        self.throughput_current.set_text(" %.2f " % throughput_current)
        self.throughput_average.set_text(" %.2f " % ((60 / duration) * self.progressbar.get_value()))
        self.redraw()

    def close(self):
        sleep(0.3)
        self.window.destroy()
        self.windows = None

# GnomePixmap: easier / faster way to access pixmaps
class GnomePixmap:

    def __init__(self, window, pixmap):
        pix, mask = create_pixmap_from_xpm(window, None, pixmap)
        self.__GnomePixmap_pixmap = GtkPixmap(pix, mask)
        self.__GnomePixmap_pixmap.show()

    def show(self):
        self.__GnomePixmap_pixmap.show()

    def hide(self):
        self.__GnomePixmap_pixmap.hide()
    
    def get_pixmap(self):
        return self.__GnomePixmap_pixmap

# GnomePixmapWithLabel: creates a HBox including a Pixmap and a Label
class GnomePixmapWithLabel:
    
    def __init__(self, window, pixmap, label):
        pix, mask = create_pixmap_from_xpm(window, None, pixmap)
        pixmap = GtkPixmap(pix, mask)
        pixmap.show()
        label = GtkLabel(label)
        label.set_padding(2, 2)
        label.show()
        self.__GnomePixmapWithLabel_hbox = GtkHBox()
        self.__GnomePixmapWithLabel_hbox.add(pixmap)
        self.__GnomePixmapWithLabel_hbox.add(label)
        self.__GnomePixmapWithLabel_hbox.show()

    def show(self):
        self.__GnomePixmapWithLabel_hbox.show()

    def hide(self):
        self.__GnomePixmapWithLabel_hbox.hide()

    def get_hbox(self):
        return self.__GnomePixmapWithLabel_hbox

# GnomePopupQuestionDialog: asks a question and handles the appropriate answer
class GnomePopupQuestionDialog:

    def __init__(self, text):
        self.__GnomePopupQuestionDialog_result = FALSE
        questiondialog = GnomeQuestionDialog(text, self.__GnomePopupQuestionDialog_callback)
        questiondialog.run_and_close()

    def __GnomePopupQuestionDialog_callback(self, result):
        self.__GnomePopupQuestionDialog_Result = (result == 0)

    def get_result(self):
        return self.__GnomePopupQuestionDialog_Result

# GnomeOptionMenu is an easy way to build GtkOptionMenus
class GnomeOptionMenu:

    def __init__(self, loglevel = 1 << 1):
        self.__GnomeOptionMenu_optionmenu = GtkOptionMenu()
        self.__GnomeOptionMenu_menu = GtkMenu()
        self.__GnomeOptionMenu_menu.show()
        self.__GnomeOptionMenu_previousitem = None
        self.__GnomeOptionMenu_items = {}
        if (log4pyavailable == TRUE):
            self.log4py = Logger().get_instance(self)
            self.log4py.set_loglevel(loglevel)
        else:
            self.log4py = None

    def get_active_item(self):
        for i in range(len(self.__GnomeOptionMenu_items.keys())):
            key = self.__GnomeOptionMenu_items.keys()[i]
            if (self.__GnomeOptionMenu_items[key].active):
                return key
        return None

    def activate_item(self, key):
        if (self.__GnomeOptionMenu_items.has_key(key)):
            item = self.__GnomeOptionMenu_items[key]
            self.__GnomeOptionMenu_menu.select_item(item)
            self.__GnomeOptionMenu_menu.activate_item(item, TRUE)
        else:
            if (self.log4py != None):
                self.log4py.error("Item %s doesn't exist." % key)

    def get_gtkoptionmenu(self):
        return self.__GnomeOptionMenu_optionmenu

    def append_item(self, item):
        self.__GnomeOptionMenu_items[item] = GtkRadioMenuItem(self.__GnomeOptionMenu_previousitem, item)
        self.__GnomeOptionMenu_items[item].show()
        self.__GnomeOptionMenu_menu.append(self.__GnomeOptionMenu_items[item])
        self.__GnomeOptionMenu_previousitem = self.__GnomeOptionMenu_items[item]

    def append_itemlist(self, itemlist):
        for i in range(len(itemlist)):
            self.append_item(itemlist[i])

    def show(self):
        self.__GnomeOptionMenu_optionmenu.set_menu(self.__GnomeOptionMenu_menu)
        self.__GnomeOptionMenu_optionmenu.show()
