/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Point;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class Rect
implements Codable {
    public int x;
    public int y;
    public int width;
    public int height;
    private static Vector _rectCache = new Vector();
    private static boolean _cacheRects = true;
    static final String X_KEY = "x";
    static final String Y_KEY = "y";
    static final String WIDTH_KEY = "width";
    static final String HEIGHT_KEY = "height";

    public static boolean contains(int n, int n2, int n3, int n4, int n5, int n6) {
        return n5 >= n && n5 < n + n3 && n6 >= n2 && n6 < n2 + n4;
    }

    public static Rect rectFromIntersection(Rect rect, Rect rect2) {
        Rect rect3 = new Rect(rect);
        rect3.intersectWith(rect2);
        return rect3;
    }

    public static Rect rectFromUnion(Rect rect, Rect rect2) {
        Rect rect3 = new Rect(rect);
        rect3.unionWith(rect2);
        return rect3;
    }

    public Rect() {
    }

    public Rect(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Rect(Rect rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3 < 0 ? 0 : n3;
        this.height = n4 < 0 ? 0 : n4;
    }

    public void setBounds(Rect rect) {
        if (rect == null) {
            this.setBounds(0, 0, 0, 0);
            return;
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setCoordinates(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3 - n, n4 - n2);
    }

    public void moveTo(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void moveBy(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public void sizeTo(int n, int n2) {
        this.width = n < 0 ? 0 : n;
        this.height = n2 < 0 ? 0 : n2;
    }

    public void sizeBy(int n, int n2) {
        this.width += n;
        if (this.width < 0) {
            this.width = 0;
        }
        this.height += n2;
        if (this.height < 0) {
            this.height = 0;
        }
    }

    public void growBy(int n, int n2) {
        this.x -= n;
        this.y -= n2;
        this.width += 2 * n;
        this.height += 2 * n2;
        if (this.width < 0) {
            this.width = 0;
        }
        if (this.height < 0) {
            this.height = 0;
        }
    }

    public int maxX() {
        return this.x + this.width;
    }

    public int maxY() {
        return this.y + this.height;
    }

    public int midX() {
        return this.x + this.width / 2;
    }

    public int midY() {
        return this.y + this.height / 2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rect)) {
            return false;
        }
        Rect rect = (Rect)object;
        return rect.x == this.x && rect.y == this.y && rect.width == this.width && rect.height == this.height;
    }

    public int hashCode() {
        return this.x ^ this.y ^ this.width ^ this.height;
    }

    public boolean isEmpty() {
        return this.width == 0 || this.height == 0;
    }

    public boolean contains(int n, int n2) {
        return n >= this.x && n < this.x + this.width && n2 >= this.y && n2 < this.y + this.height;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(Rect rect) {
        if (rect == null) {
            return false;
        }
        return rect.x >= this.x && rect.x + rect.width <= this.x + this.width && rect.y >= this.y && rect.y + rect.height <= this.y + this.height;
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        if (this.x >= n + n3 || this.x + this.width <= n || this.y >= n2 + n4 || this.y + this.height <= n2) {
            return false;
        }
        return this.width != 0 && this.height != 0 && n3 != 0 && n4 != 0;
    }

    public boolean intersects(Rect rect) {
        if (rect == null) {
            return false;
        }
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public void intersectWith(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = n5 + n3;
        int n8 = n6 + n4;
        int n9 = this.x + this.width;
        int n10 = this.y + this.height;
        if (this.x >= n7 || n9 <= n5) {
            n7 = 0;
            n5 = 0;
        } else if (this.x > n5 && this.x < n7) {
            n5 = this.x;
            if (n9 < n7) {
                n7 = n9;
            }
        } else if (n9 > n5 && n9 < n7) {
            n7 = n9;
        }
        if (this.y >= n8 || n10 <= n6) {
            n8 = 0;
            n6 = 0;
        } else if (this.y > n6 && this.y < n8) {
            n6 = this.y;
            if (n10 < n8) {
                n8 = n10;
            }
        } else if (n10 > n6 && n10 < n8) {
            n8 = n10;
        }
        this.setCoordinates(n5, n6, n7, n8);
    }

    public void intersectWith(Rect rect) {
        this.intersectWith(rect.x, rect.y, rect.width, rect.height);
    }

    public Rect intersectionRect(Rect rect) {
        int n = rect.x;
        int n2 = rect.y;
        int n3 = rect.x + rect.width;
        int n4 = rect.y + rect.height;
        int n5 = this.x + this.width;
        int n6 = this.y + this.height;
        if (this.x >= n3 || n5 <= n || this.y >= n4 || n6 <= n2) {
            return new Rect();
        }
        if (this.x > n && this.x < n3) {
            n = this.x;
            if (n5 < n3) {
                n3 = n5;
            }
        } else if (n5 > n && n5 < n3) {
            n3 = n5;
        }
        if (this.y > n2 && this.y < n4) {
            n2 = this.y;
            if (n6 < n4) {
                n4 = n6;
            }
        } else if (n6 > n2 && n6 < n4) {
            n4 = n6;
        }
        return new Rect(n, n2, n3 - n, n4 - n2);
    }

    public void unionWith(int n, int n2, int n3, int n4) {
        int n5 = this.x < n ? this.x : n;
        int n6 = n + n3;
        if (this.x + this.width > n6) {
            n6 = this.x + this.width;
        }
        int n7 = this.y < n2 ? this.y : n2;
        int n8 = n2 + n4;
        if (this.y + this.height > n8) {
            n8 = this.y + this.height;
        }
        this.setCoordinates(n5, n7, n6, n8);
    }

    public void unionWith(Rect rect) {
        if (rect == null) {
            return;
        }
        this.unionWith(rect.x, rect.y, rect.width, rect.height);
    }

    public Rect unionRect(Rect rect) {
        if (rect == null) {
            return new Rect(this);
        }
        int n = this.x < rect.x ? this.x : rect.x;
        int n2 = this.x + this.width;
        int n3 = rect.x + rect.width;
        if (n2 > n3) {
            n3 = n2;
        }
        int n4 = this.y < rect.y ? this.y : rect.y;
        int n5 = this.y + this.height;
        int n6 = rect.y + rect.height;
        if (n5 > n6) {
            n6 = n5;
        }
        return new Rect(n, n4, n3 - n, n6 - n4);
    }

    void filterEmptyRects(Vector vector) {
        int n = vector.count();
        while (n-- > 0) {
            Rect rect = (Rect)vector.elementAt(n);
            if (rect.width != 0 && rect.height != 0) continue;
            vector.removeElementAt(n);
        }
    }

    public void computeDisunionRects(Rect rect, Vector vector) {
        if (rect == null || !this.intersects(rect) || vector == null) {
            return;
        }
        if (rect.contains(this)) {
            return;
        }
        if (this.contains(rect)) {
            vector.addElement((Object)Rect.newRect(this.x, this.y, rect.x - this.x, this.height));
            vector.addElement((Object)Rect.newRect(rect.x, this.y, rect.width, rect.y - this.y));
            vector.addElement((Object)Rect.newRect(rect.x, rect.maxY(), rect.width, this.maxY() - rect.maxY()));
            vector.addElement((Object)Rect.newRect(rect.maxX(), this.y, this.maxX() - rect.maxX(), this.height));
            this.filterEmptyRects(vector);
            return;
        }
        if (rect.x <= this.x && rect.y <= this.y) {
            if (rect.maxX() > this.maxX()) {
                vector.addElement((Object)Rect.newRect(this.x, rect.maxY(), this.width, this.maxY() - rect.maxY()));
            } else if (rect.maxY() > this.maxY()) {
                vector.addElement((Object)Rect.newRect(rect.maxX(), this.y, this.maxX() - rect.maxX(), this.height));
            } else {
                vector.addElement((Object)Rect.newRect(rect.maxX(), this.y, this.maxX() - rect.maxX(), rect.maxY() - this.y));
                vector.addElement((Object)Rect.newRect(this.x, rect.maxY(), this.width, this.maxY() - rect.maxY()));
            }
            this.filterEmptyRects(vector);
            return;
        }
        if (rect.x <= this.x && rect.maxY() >= this.maxY()) {
            if (rect.maxX() > this.maxX()) {
                vector.addElement((Object)Rect.newRect(this.x, this.y, this.width, rect.y - this.y));
            } else {
                vector.addElement((Object)Rect.newRect(this.x, this.y, this.width, rect.y - this.y));
                vector.addElement((Object)Rect.newRect(rect.maxX(), rect.y, this.maxX() - rect.maxX(), this.maxY() - rect.y));
            }
            this.filterEmptyRects(vector);
            return;
        }
        if (rect.x <= this.x) {
            if (rect.maxX() >= this.maxX()) {
                vector.addElement((Object)Rect.newRect(this.x, this.y, this.width, rect.y - this.y));
                vector.addElement((Object)Rect.newRect(this.x, rect.maxY(), this.width, this.maxY() - rect.maxY()));
            } else {
                vector.addElement((Object)Rect.newRect(this.x, this.y, this.width, rect.y - this.y));
                vector.addElement((Object)Rect.newRect(rect.maxX(), rect.y, this.maxX() - rect.maxX(), rect.height));
                vector.addElement((Object)Rect.newRect(this.x, rect.maxY(), this.width, this.maxY() - rect.maxY()));
            }
            this.filterEmptyRects(vector);
            return;
        }
        if (rect.x <= this.maxX() && rect.maxX() > this.maxX()) {
            if (rect.y <= this.y && rect.maxY() > this.maxY()) {
                vector.addElement((Object)Rect.newRect(this.x, this.y, rect.x - this.x, this.height));
            } else if (rect.y <= this.y) {
                vector.addElement((Object)Rect.newRect(this.x, this.y, rect.x - this.x, rect.maxY() - this.y));
                vector.addElement((Object)Rect.newRect(this.x, rect.maxY(), this.width, this.maxY() - rect.maxY()));
            } else if (rect.maxY() > this.maxY()) {
                vector.addElement((Object)Rect.newRect(this.x, this.y, this.width, rect.y - this.y));
                vector.addElement((Object)Rect.newRect(this.x, rect.y, rect.x - this.x, this.maxY() - rect.y));
            } else {
                vector.addElement((Object)Rect.newRect(this.x, this.y, this.width, rect.y - this.y));
                vector.addElement((Object)Rect.newRect(this.x, rect.y, rect.x - this.x, rect.height));
                vector.addElement((Object)Rect.newRect(this.x, rect.maxY(), this.width, this.maxY() - rect.maxY()));
            }
            this.filterEmptyRects(vector);
            return;
        }
        if (rect.x >= this.x && rect.maxX() <= this.maxX()) {
            if (rect.y <= this.y && rect.maxY() > this.maxY()) {
                vector.addElement((Object)Rect.newRect(this.x, this.y, rect.x - this.x, this.height));
                vector.addElement((Object)Rect.newRect(rect.maxX(), this.y, this.maxX() - rect.maxX(), this.height));
            } else if (rect.y <= this.y) {
                vector.addElement((Object)Rect.newRect(this.x, this.y, rect.x - this.x, this.height));
                vector.addElement((Object)Rect.newRect(rect.x, rect.maxY(), rect.width, this.maxY() - rect.maxY()));
                vector.addElement((Object)Rect.newRect(rect.maxX(), this.y, this.maxX() - rect.maxX(), this.height));
            } else {
                vector.addElement((Object)Rect.newRect(this.x, this.y, rect.x - this.x, this.height));
                vector.addElement((Object)Rect.newRect(rect.x, this.y, rect.width, rect.y - this.y));
                vector.addElement((Object)Rect.newRect(rect.maxX(), this.y, this.maxX() - rect.maxX(), this.height));
            }
            this.filterEmptyRects(vector);
            return;
        }
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.Rect", 1);
        classInfo.addField(X_KEY, (byte)8);
        classInfo.addField(Y_KEY, (byte)8);
        classInfo.addField(WIDTH_KEY, (byte)8);
        classInfo.addField(HEIGHT_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt(X_KEY, this.x);
        encoder.encodeInt(Y_KEY, this.y);
        encoder.encodeInt(WIDTH_KEY, this.width);
        encoder.encodeInt(HEIGHT_KEY, this.height);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.x = decoder.decodeInt(X_KEY);
        this.y = decoder.decodeInt(Y_KEY);
        this.width = decoder.decodeInt(WIDTH_KEY);
        this.height = decoder.decodeInt(HEIGHT_KEY);
    }

    public void finishDecoding() throws CodingException {
    }

    static Rect newRect(int n, int n2, int n3, int n4) {
        Rect rect;
        Vector vector = _rectCache;
        synchronized (vector) {
            if (!_cacheRects || _rectCache.isEmpty()) {
                Rect rect2 = new Rect(n, n2, n3, n4);
                Object var7_6 = null;
                return rect2;
            }
            rect = (Rect)_rectCache.removeLastElement();
        }
        rect.setBounds(n, n2, n3, n4);
        return rect;
    }

    static Rect newRect(Rect rect) {
        if (rect == null) {
            return Rect.newRect(0, 0, 0, 0);
        }
        return Rect.newRect(rect.x, rect.y, rect.width, rect.height);
    }

    static Rect newRect() {
        return Rect.newRect(0, 0, 0, 0);
    }

    static void returnRect(Rect rect) {
        if (!_cacheRects) {
            return;
        }
        Vector vector = _rectCache;
        synchronized (vector) {
            if (_rectCache.count() < 50) {
                _rectCache.addElement((Object)rect);
            }
            return;
        }
    }

    static void returnRects(Vector vector) {
        if (vector == null || !_cacheRects) {
            return;
        }
        int n = vector.count();
        while (n-- > 0) {
            Rect.returnRect((Rect)vector.elementAt(n));
        }
        vector.removeAllElements();
    }

    static void setShouldCacheRects(boolean bl) {
        Vector vector = _rectCache;
        synchronized (vector) {
            _cacheRects = bl;
            if (!_cacheRects) {
                _rectCache.removeAllElements();
            }
            return;
        }
    }
}

