/*
 * multilingual support for nvi
 * Copyright(c) 1996, 1997 by Jun-ichiro Itoh.  All rights reserved.
 * Author contact: <itojun@mt.cs.keio.ac.jp>
 * $Id: multi_chclass.c,v 1.1.2.1 1997/09/23 00:43:46 itojun Exp $
 *
 * Freely redistributable, reusable, unless otherwise noted in accompanying
 * document. (for example, redistribution is prohibited during alpha-test
 * period)
 * Absolutely no warranty.
 *
 * The code is based on:
 *	jelvis japanization patch by Jun-ichiro Itoh
 *	nvi 1.03 japanization patch by Yoshitaka Tokugawa <toku@dit.co.jp>
 */
/*
 * Derived code:
 *
 * The code to determine KSC5601 character class was implemented by
 * kjlee@sgi.co.jp.
 */

#include "config.h"

#ifdef MULTIBYTE

#include <sys/types.h>
#include <sys/queue.h>

#include <bitstring.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../common/common.h"
#include "multibyte.h"

/*
 * Returns character class for the character pointed to by p.
 *
 * PUBLIC: #ifdef MULTIBYTE
 * PUBLIC: u_int multi_chclass __P((CHAR_T *, u_int));
 * PUBLIC: #endif
 */
u_int
multi_chclass(p, ctxt)
	CHAR_T *p;
	u_int ctxt;
{
	u_int class;

	if (ischarset(p[0]) && !CS_RAW(p[0])) {
		class = (u_int)p[0] << 8; 
		if (charset(p[0]).chclass)
			class = (*charset(p[0]).chclass)(p, ctxt);
	} else
		class = (u_short)CS_NONE << 8;
	return class;
}

/*
 * Functions that are dependent to character set.
 */
u_int
jis0208_chclass(p, ctxt)
	CHAR_T *p;
	u_int ctxt;
{
#define START_MARK	0x2121
#define START_ALPHA	0x2330
#define START_HIRAGANA	0x2421
#define START_KATAKANA	0x2521
#define START_GREEK	0x2621
#define START_KANJI	0x3021

#define	CLASS_MARK		0
#define	CLASS_ALPHA		5
#define	CLASS_HIRAGANA		1
#define	CLASS_KATAKANA		10
#define	CLASS_GREEK		5
#define	CLASS_KANJI		20
#define	CLASS_NONKANJI		100

	u_short ch;
	u_int class;
	size_t i;
	static u_short ch_kanji[] = {
		0x2137, 0x2138, 0x2139, 0x213a,
	};
	static u_short ch_kana[] = {
		0x2133, 0x2134, 0x2135, 0x2136, 0x213c, 0x2141,
	};

	class = (u_int)p[0] << 8;
	ch = ((u_short)p[1] << 8) | p[2];

	for (i = 0; i < sizeof(ch_kanji); i++) {
		if (ch == ch_kanji[i])
			return class | CLASS_KANJI;
	}
	for (i = 0; i < sizeof(ch_kana); i++) {
		if (ch == ch_kana[i]) {
			if ((ctxt & 0xff) == CLASS_HIRAGANA)
				return class | CLASS_HIRAGANA;
			else
				return class | CLASS_KATAKANA;
		}
	}

	if (ch < START_ALPHA)
		return class | CLASS_MARK;
	if (ch < START_HIRAGANA)
		return class | CLASS_ALPHA;
	if (ch < START_KATAKANA)
		return class | CLASS_HIRAGANA;
	if (ch < START_GREEK)
		return class | CLASS_KATAKANA;
	if (ch < START_KANJI)
		return class | CLASS_GREEK;
	return class | CLASS_KANJI;

#undef START_MARK
#undef START_ALPHA
#undef START_HIRAGANA
#undef START_KATAKANA
#undef START_GREEK
#undef START_KANJI
 
#undef CLASS_MARK
#undef CLASS_ALPHA
#undef CLASS_HIRAGANA
#undef CLASS_KATAKANA
#undef CLASS_GREEK
#undef CLASS_KANJI
#undef CLASS_NONKANJI
}

u_int
ksc5601_chclass(p, ctxt)
	CHAR_T *p;
	u_int ctxt;
{
#define START_MARK	0x2121
#define START_ALPHA	0x2330
#define START_HIRAGANA	0x2a21
#define START_KATAKANA	0x2b21
#define START_GREEK	0x2c21
#define START_KOREAN	0x3021
#define START_KANJI	0x4a21

#define	CLASS_MARK		0
#define	CLASS_ALPHA		5
#define	CLASS_HIRAGANA		1
#define	CLASS_KATAKANA		10
#define	CLASS_GREEK		5
#define	CLASS_KOREAN		15
#define	CLASS_KANJI		20
#define	CLASS_NONKANJI		100

	u_short ch;
	u_int class;
	size_t i;

	class = (u_int)p[0] << 8;
	ch = ((u_short)p[1] << 8) | p[2];

	if (ch < START_ALPHA)
		return class | CLASS_MARK;
	if (ch < START_HIRAGANA)
		return class | CLASS_ALPHA;
	if (ch < START_KATAKANA)
		return class | CLASS_HIRAGANA;
	if (ch < START_GREEK)
		return class | CLASS_KATAKANA;
	if (ch < START_KOREAN)
		return class | CLASS_GREEK;
	if (ch < START_KANJI)
		return class | CLASS_KOREAN;
	return class | CLASS_KANJI;

#undef START_MARK
#undef START_ALPHA
#undef START_HIRAGANA
#undef START_KATAKANA
#undef START_GREEK
#undef START_KANJI
 
#undef CLASS_MARK
#undef CLASS_ALPHA
#undef CLASS_HIRAGANA
#undef CLASS_KATAKANA
#undef CLASS_GREEK
#undef CLASS_KANJI
#undef CLASS_NONKANJI
}
#endif /*MULTIBYTE*/
