/* SHA1 Production Implementation                                             */
/* This implementation: (c) 1999 Andreas Steinmetz                            */
/* SHA1 algorithm: see FIPS PUB 180-1                                         */
/* HMAC algorithm by Krawczyk, et. al., see RFC2104                           */
/* Test cases for HMAC: see RFC2202                                           */
/*                                                                            */
/* License:                                                                   */
/* This code is under the GNU public license                                  */
/* for use with the virtual private network daemon (vpnd).                    */
/* The copyright holder will however retain the copyright.                    */
/* In addition to vpnd this code may be used                                  */
/* for all GPL/LGPL based open source software products.                      */
/* For all other software products please contact astmail@yahoo.com           */
/* for a license agreement. There is no guarantee for the fitness             */
/* and usability of this code for any purpose. The author takes no            */
/* responsibility for any damages caused by the use of this code.             */
/* Distribution and use of this code is explicitly granted provided           */
/* that the above header is not modified and the above conditions             */
/* are met.                                                                   */
/*                                                                            */
/* This implementation is tuned for speed.                                    */
/*                                                                            */
/* Note that the implementation does not depend on any run time library.      */
/*                                                                            */
/* Restriction:                                                               */
/*                                                                            */
/* The maximum data length to be processed is 2^32-1 bytes but                */
/* this shouldn't be an issue for nearly all applications. If                 */
/* it is an issue you will have to extend the variable 'total'                */
/* from 32 bits to 64 bits in the SHA1 routines.                              */
/*                                                                            */
/* Data sizes:                                                                */
/*                                                                            */
/* data block for SHA1 transformation   WORD08[64]                            */
/* resulting SHA1 or HMAC hash          WORD08[20]                            */
/*                                                                            */
/* WORD08 means an unsigned word of 8 bits length                             */
/* WORD32 means an unsigned word of at least 32 bits length                   */
/*                                                                            */
/* Mode of operation:                                                         */
/*                                                                            */
/* SHA1_FULL defined:                                                         */
/*                                                                            */
/* 1. Call sha1init                                                           */
/* 2. For all data to be hashed call sha1next                                 */
/* 3. To retrieve the hash call sha1end                                       */
/*                                                                            */
/* SHA1_FAST defined:                                                         */
/*                                                                            */
/* Call sha1 to get the hash for the specified data                           */
/*                                                                            */
/* SHA1_HMAC_FULL defined:                                                    */
/*                                                                            */
/* 1. Call sha1hmkey once to preprocess the selected key                      */
/* 2. Call sha1hminit                                                         */
/* 3. For all data to be hashed call sha1hmnext                               */
/* 4. To retrieve the hash call sha1hmend                                     */
/* 5. When the preprocessed key is no longer required                         */
/*    reset the SHA1HMDATA structure                                          */
/*                                                                            */
/* SHA1_HMAC_FAST defined:                                                    */
/*                                                                            */
/* 1. Call sha1hmkey once to preprocess the selected key                      */
/* 2. Call sha1hmac to get the hash for the specified data                    */
/* 3. When the preprocessed key is no longer required                         */
/*    reset the SHA1HMDATA structure                                          */

.text

.ifndef SHA1_FULL
.ifndef SHA1_FAST
.ifndef SHA1_HMAC_FULL
.ifndef SHA1_HMAC_FAST
		SHA1_FULL=1
		SHA1_FAST=1
		SHA1_HMAC_FULL=1
		SHA1_HMAC_FAST=1
		SHA1_PARANOID=1
.endif
.endif
.endif
.endif

.ifdef  SHA1_HMAC_FULL
                _SHA1_HMAC=1
.endif
.ifdef  SHA1_HMAC_FAST
                _SHA1_HMAC=1
.endif
.ifdef  SHA1_FULL
                _SHA1_FULL=1
.endif
.ifdef  _SHA1_HMAC
                _SHA1_FULL=1
                SHA1_PARANOID=1
.endif

/* static void sha1block(WORD32 *sha1,WORD08 *block) */

		.type	sha1block,@function
		.align	16
sha1block:
		pushl	%edi
		pushl	%esi
		pushl	%ebx
		pushl	%ebp

		/* load block to be hashed */

		movl	(%edi),%eax
		movl	4(%edi),%ebx
		movl	8(%edi),%ecx
		movl	12(%edi),%edx
		subl	$64,%esp
		bswapl	%eax
		bswapl	%ebx
		bswapl	%ecx
		bswapl	%edx
		movl	%eax,(%esp)
		movl	%ebx,4(%esp)
		movl	%ecx,8(%esp)
		movl	%edx,12(%esp)

		movl	16(%edi),%eax
		movl	20(%edi),%ebx
		movl	24(%edi),%ecx
		movl	28(%edi),%edx
		bswapl	%eax
		bswapl	%ebx
		bswapl	%ecx
		bswapl	%edx
		movl	%eax,16(%esp)
		movl	%ebx,20(%esp)
		movl	%ecx,24(%esp)
		movl	%edx,28(%esp)

		movl	32(%edi),%eax
		movl	36(%edi),%ebx
		movl	40(%edi),%ecx
		movl	44(%edi),%edx
		bswapl	%eax
		bswapl	%ebx
		bswapl	%ecx
		bswapl	%edx
		movl	%eax,32(%esp)
		movl	%ebx,36(%esp)
		movl	%ecx,40(%esp)
		movl	%edx,44(%esp)

		movl	48(%edi),%eax
		movl	52(%edi),%ebx
		movl	56(%edi),%ecx
		movl	60(%edi),%edx
		bswapl	%eax
		bswapl	%ebx
		bswapl	%ecx
		bswapl	%edx
		movl	%eax,48(%esp)
		movl	%ebx,52(%esp)
		movl	%ecx,56(%esp)
		movl	%edx,60(%esp)

		/* load old hash */

		movl	(%ebp),%ecx
		movl	4(%ebp),%esi
		movl	8(%ebp),%eax
		movl	12(%ebp),%edi
		movl	16(%ebp),%edx

		/* round 1 to 20 */

		movl	%ecx,%ebp
		movl	%eax,%ebx
		roll	$5,%ebp
		xorl	%edi,%ebx
		leal	0x5a827999(%ebp,%edx,),%edx
		andl	%esi,%ebx
		addl	(%esp),%edx
		xorl	%edi,%ebx
		rorl	$2,%esi
		addl	%ebx,%edx

		movl	%edx,%ebp
		movl	%esi,%ebx
		roll	$5,%ebp
		xorl	%eax,%ebx
		leal	0x5a827999(%ebp,%edi,),%edi
		andl	%ecx,%ebx
		addl	4(%esp),%edi
		xorl	%eax,%ebx
		rorl	$2,%ecx
		addl	%ebx,%edi

		movl	%edi,%ebp
		movl	%ecx,%ebx
		roll	$5,%ebp
		xorl	%esi,%ebx
		leal	0x5a827999(%ebp,%eax,),%eax
		andl	%edx,%ebx
		addl	8(%esp),%eax
		xorl	%esi,%ebx
		rorl	$2,%edx
		addl	%ebx,%eax

		movl	%eax,%ebp
		movl	%edx,%ebx
		roll	$5,%ebp
		xorl	%ecx,%ebx
		leal	0x5a827999(%ebp,%esi,),%esi
		andl	%edi,%ebx
		addl	12(%esp),%esi
		xorl	%ecx,%ebx
		rorl	$2,%edi
		addl	%ebx,%esi

		movl	%esi,%ebp
		movl	%edi,%ebx
		roll	$5,%ebp
		xorl	%edx,%ebx
		leal	0x5a827999(%ebp,%ecx,),%ecx
		andl	%eax,%ebx
		addl	16(%esp),%ecx
		xorl	%edx,%ebx
		rorl	$2,%eax
		addl	%ebx,%ecx

		movl	%ecx,%ebp
		movl	%eax,%ebx
		roll	$5,%ebp
		xorl	%edi,%ebx
		leal	0x5a827999(%ebp,%edx,),%edx
		andl	%esi,%ebx
		addl	20(%esp),%edx
		xorl	%edi,%ebx
		rorl	$2,%esi
		addl	%ebx,%edx

		movl	%edx,%ebp
		movl	%esi,%ebx
		roll	$5,%ebp
		xorl	%eax,%ebx
		leal	0x5a827999(%ebp,%edi,),%edi
		andl	%ecx,%ebx
		addl	24(%esp),%edi
		xorl	%eax,%ebx
		rorl	$2,%ecx
		addl	%ebx,%edi

		movl	%edi,%ebp
		movl	%ecx,%ebx
		roll	$5,%ebp
		xorl	%esi,%ebx
		leal	0x5a827999(%ebp,%eax,),%eax
		andl	%edx,%ebx
		addl	28(%esp),%eax
		xorl	%esi,%ebx
		rorl	$2,%edx
		addl	%ebx,%eax

		movl	%eax,%ebp
		movl	%edx,%ebx
		roll	$5,%ebp
		xorl	%ecx,%ebx
		leal	0x5a827999(%ebp,%esi,),%esi
		andl	%edi,%ebx
		addl	32(%esp),%esi
		xorl	%ecx,%ebx
		rorl	$2,%edi
		addl	%ebx,%esi

		movl	%esi,%ebp
		movl	%edi,%ebx
		roll	$5,%ebp
		xorl	%edx,%ebx
		leal	0x5a827999(%ebp,%ecx,),%ecx
		andl	%eax,%ebx
		addl	36(%esp),%ecx
		xorl	%edx,%ebx
		rorl	$2,%eax
		addl	%ebx,%ecx

		movl	%ecx,%ebp
		movl	%eax,%ebx
		roll	$5,%ebp
		xorl	%edi,%ebx
		leal	0x5a827999(%ebp,%edx,),%edx
		andl	%esi,%ebx
		addl	40(%esp),%edx
		xorl	%edi,%ebx
		rorl	$2,%esi
		addl	%ebx,%edx

		movl	%edx,%ebp
		movl	%esi,%ebx
		roll	$5,%ebp
		xorl	%eax,%ebx
		leal	0x5a827999(%ebp,%edi,),%edi
		andl	%ecx,%ebx
		addl	44(%esp),%edi
		xorl	%eax,%ebx
		rorl	$2,%ecx
		addl	%ebx,%edi

		movl	%edi,%ebp
		movl	%ecx,%ebx
		roll	$5,%ebp
		xorl	%esi,%ebx
		leal	0x5a827999(%ebp,%eax,),%eax
		andl	%edx,%ebx
		addl	48(%esp),%eax
		xorl	%esi,%ebx
		rorl	$2,%edx
		addl	%ebx,%eax

		movl	%eax,%ebp
		movl	%edx,%ebx
		roll	$5,%ebp
		xorl	%ecx,%ebx
		leal	0x5a827999(%ebp,%esi,),%esi
		andl	%edi,%ebx
		addl	52(%esp),%esi
		xorl	%ecx,%ebx
		rorl	$2,%edi
		addl	%ebx,%esi

		movl	%esi,%ebp
		movl	%edi,%ebx
		roll	$5,%ebp
		xorl	%edx,%ebx
		leal	0x5a827999(%ebp,%ecx,),%ecx
		andl	%eax,%ebx
		addl	56(%esp),%ecx
		xorl	%edx,%ebx
		rorl	$2,%eax
		addl	%ebx,%ecx

		movl	%ecx,%ebp
		movl	%eax,%ebx
		roll	$5,%ebp
		xorl	%edi,%ebx
		leal	0x5a827999(%ebp,%edx,),%edx
		andl	%esi,%ebx
		addl	60(%esp),%edx
		xorl	%edi,%ebx
		rorl	$2,%esi
		addl	%ebx,%edx

		movl	%edx,%ebx
		movl	52(%esp),%ebp
		roll	$5,%ebx
		xorl	32(%esp),%ebp
		leal	0x5a827999(%ebx,%edi,),%edi
		movl	%esi,%ebx
		xorl	8(%esp),%ebp
		xorl	%eax,%ebx
		xorl	(%esp),%ebp
		andl	%ecx,%ebx
		roll	$1,%ebp
		xorl	%eax,%ebx
		addl	%ebp,%edi
		movl	%ebp,(%esp)
		rorl	$2,%ecx
		addl	%ebx,%edi

		movl	%edi,%ebx
		movl	56(%esp),%ebp
		roll	$5,%ebx
		xorl	36(%esp),%ebp
		leal	0x5a827999(%ebx,%eax,),%eax
		movl	%ecx,%ebx
		xorl	12(%esp),%ebp
		xorl	%esi,%ebx
		xorl	4(%esp),%ebp
		andl	%edx,%ebx
		roll	$1,%ebp
		xorl	%esi,%ebx
		addl	%ebp,%eax
		movl	%ebp,4(%esp)
		rorl	$2,%edx
		addl	%ebx,%eax

		movl	%eax,%ebx
		movl	60(%esp),%ebp
		roll	$5,%ebx
		xorl	40(%esp),%ebp
		leal	0x5a827999(%ebx,%esi,),%esi
		movl	%edx,%ebx
		xorl	16(%esp),%ebp
		xorl	%ecx,%ebx
		xorl	8(%esp),%ebp
		andl	%edi,%ebx
		roll	$1,%ebp
		xorl	%ecx,%ebx
		addl	%ebp,%esi
		movl	%ebp,8(%esp)
		rorl	$2,%edi
		addl	%ebx,%esi

		movl	%esi,%ebx
		movl	(%esp),%ebp
		roll	$5,%ebx
		xorl	44(%esp),%ebp
		leal	0x5a827999(%ebx,%ecx,),%ecx
		movl	%edi,%ebx
		xorl	20(%esp),%ebp
		xorl	%edx,%ebx
		xorl	12(%esp),%ebp
		andl	%eax,%ebx
		roll	$1,%ebp
		xorl	%edx,%ebx
		addl	%ebp,%ecx
		movl	%ebp,12(%esp)
		rorl	$2,%eax
		addl	%ebx,%ecx

		/* round 21 to 40 */

		movl	%ecx,%ebx
		movl	4(%esp),%ebp
		roll	$5,%ebx
		xorl	48(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	24(%esp),%ebp
		xorl	%eax,%ebx
		xorl	16(%esp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,16(%esp)

		movl	%edx,%ebx
		movl	8(%esp),%ebp
		roll	$5,%ebx
		xorl	52(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	28(%esp),%ebp
		xorl	%esi,%ebx
		xorl	20(%esp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,20(%esp)

		movl	%edi,%ebx
		movl	12(%esp),%ebp
		roll	$5,%ebx
		xorl	56(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	32(%esp),%ebp
		xorl	%ecx,%ebx
		xorl	24(%esp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,24(%esp)

		movl	%eax,%ebx
		movl	16(%esp),%ebp
		roll	$5,%ebx
		xorl	60(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	36(%esp),%ebp
		xorl	%edx,%ebx
		xorl	28(%esp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,28(%esp)

		movl	%esi,%ebx
		movl	20(%esp),%ebp
		roll	$5,%ebx
		xorl	(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	40(%esp),%ebp
		xorl	%edi,%ebx
		xorl	32(%esp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,32(%esp)

		movl	%ecx,%ebx
		movl	24(%esp),%ebp
		roll	$5,%ebx
		xorl	4(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	44(%esp),%ebp
		xorl	%eax,%ebx
		xorl	36(%esp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,36(%esp)

		movl	%edx,%ebx
		movl	28(%esp),%ebp
		roll	$5,%ebx
		xorl	8(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	48(%esp),%ebp
		xorl	%esi,%ebx
		xorl	40(%esp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,40(%esp)

		movl	%edi,%ebx
		movl	32(%esp),%ebp
		roll	$5,%ebx
		xorl	12(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	52(%esp),%ebp
		xorl	%ecx,%ebx
		xorl	44(%esp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,44(%esp)

		movl	%eax,%ebx
		movl	36(%esp),%ebp
		roll	$5,%ebx
		xorl	16(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	56(%esp),%ebp
		xorl	%edx,%ebx
		xorl	48(%esp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,48(%esp)

		movl	%esi,%ebx
		movl	40(%esp),%ebp
		roll	$5,%ebx
		xorl	20(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	60(%esp),%ebp
		xorl	%edi,%ebx
		xorl	52(%esp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,52(%esp)

		movl	%ecx,%ebx
		movl	44(%esp),%ebp
		roll	$5,%ebx
		xorl	24(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	(%esp),%ebp
		xorl	%eax,%ebx
		xorl	56(%esp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,56(%esp)

		movl	%edx,%ebx
		movl	48(%esp),%ebp
		roll	$5,%ebx
		xorl	28(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	4(%esp),%ebp
		xorl	%esi,%ebx
		xorl	60(%esp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,60(%esp)

		movl	%edi,%ebx
		movl	52(%esp),%ebp
		roll	$5,%ebx
		xorl	32(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	8(%esp),%ebp
		xorl	%ecx,%ebx
		xorl	(%esp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,(%esp)

		movl	%eax,%ebx
		movl	56(%esp),%ebp
		roll	$5,%ebx
		xorl	36(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	12(%esp),%ebp
		xorl	%edx,%ebx
		xorl	4(%esp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,4(%esp)

		movl	%esi,%ebx
		movl	60(%esp),%ebp
		roll	$5,%ebx
		xorl	40(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	16(%esp),%ebp
		xorl	%edi,%ebx
		xorl	8(%esp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,8(%esp)

		movl	%ecx,%ebx
		movl	(%esp),%ebp
		roll	$5,%ebx
		xorl	44(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	20(%esp),%ebp
		xorl	%eax,%ebx
		xorl	12(%esp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,12(%esp)

		movl	%edx,%ebx
		movl	4(%esp),%ebp
		roll	$5,%ebx
		xorl	48(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	24(%esp),%ebp
		xorl	%esi,%ebx
		xorl	16(%esp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,16(%esp)

		movl	%edi,%ebx
		movl	8(%esp),%ebp
		roll	$5,%ebx
		xorl	52(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	28(%esp),%ebp
		xorl	%ecx,%ebx
		xorl	20(%esp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,20(%esp)

		movl	%eax,%ebx
		movl	12(%esp),%ebp
		roll	$5,%ebx
		xorl	56(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	32(%esp),%ebp
		xorl	%edx,%ebx
		xorl	24(%esp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,24(%esp)

		movl	%esi,%ebx
		movl	16(%esp),%ebp
		roll	$5,%ebx
		xorl	60(%esp),%ebp
		leal	0x6ed9eba1(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	36(%esp),%ebp
		xorl	%edi,%ebx
		xorl	28(%esp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,28(%esp)

		/* round 41 to 60 */

		movl	%ecx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edx,),%edx
		movl	%esi,%ebx
		movl	%esi,%ebp
		orl	%eax,%ebx
		andl	%eax,%ebp
		andl	%edi,%ebx
		orl	%ebp,%ebx
		movl	20(%esp),%ebp
		addl	%ebx,%edx
		xorl	(%esp),%ebp
		xorl	40(%esp),%ebp
		rorl	$2,%esi
		xorl	32(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edx
		movl	%ebp,32(%esp)

		movl	%edx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		movl	%ecx,%ebp
		orl	%esi,%ebx
		andl	%esi,%ebp
		andl	%eax,%ebx
		orl	%ebp,%ebx
		movl	24(%esp),%ebp
		addl	%ebx,%edi
		xorl	4(%esp),%ebp
		xorl	44(%esp),%ebp
		rorl	$2,%ecx
		xorl	36(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edi
		movl	%ebp,36(%esp)

		movl	%edi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%eax,),%eax
		movl	%edx,%ebx
		movl	%edx,%ebp
		orl	%ecx,%ebx
		andl	%ecx,%ebp
		andl	%esi,%ebx
		orl	%ebp,%ebx
		movl	28(%esp),%ebp
		addl	%ebx,%eax
		xorl	8(%esp),%ebp
		xorl	48(%esp),%ebp
		rorl	$2,%edx
		xorl	40(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%eax
		movl	%ebp,40(%esp)

		movl	%eax,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%esi,),%esi
		movl	%edi,%ebx
		movl	%edi,%ebp
		orl	%edx,%ebx
		andl	%edx,%ebp
		andl	%ecx,%ebx
		orl	%ebp,%ebx
		movl	32(%esp),%ebp
		addl	%ebx,%esi
		xorl	12(%esp),%ebp
		xorl	52(%esp),%ebp
		rorl	$2,%edi
		xorl	44(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%esi
		movl	%ebp,44(%esp)

		movl	%esi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		movl	%eax,%ebp
		orl	%edi,%ebx
		andl	%edi,%ebp
		andl	%edx,%ebx
		orl	%ebp,%ebx
		movl	36(%esp),%ebp
		addl	%ebx,%ecx
		xorl	16(%esp),%ebp
		xorl	56(%esp),%ebp
		rorl	$2,%eax
		xorl	48(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%ecx
		movl	%ebp,48(%esp)

		movl	%ecx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edx,),%edx
		movl	%esi,%ebx
		movl	%esi,%ebp
		orl	%eax,%ebx
		andl	%eax,%ebp
		andl	%edi,%ebx
		orl	%ebp,%ebx
		movl	40(%esp),%ebp
		addl	%ebx,%edx
		xorl	20(%esp),%ebp
		xorl	60(%esp),%ebp
		rorl	$2,%esi
		xorl	52(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edx
		movl	%ebp,52(%esp)

		movl	%edx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		movl	%ecx,%ebp
		orl	%esi,%ebx
		andl	%esi,%ebp
		andl	%eax,%ebx
		orl	%ebp,%ebx
		movl	44(%esp),%ebp
		addl	%ebx,%edi
		xorl	24(%esp),%ebp
		xorl	(%esp),%ebp
		rorl	$2,%ecx
		xorl	56(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edi
		movl	%ebp,56(%esp)

		movl	%edi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%eax,),%eax
		movl	%edx,%ebx
		movl	%edx,%ebp
		orl	%ecx,%ebx
		andl	%ecx,%ebp
		andl	%esi,%ebx
		orl	%ebp,%ebx
		movl	48(%esp),%ebp
		addl	%ebx,%eax
		xorl	28(%esp),%ebp
		xorl	4(%esp),%ebp
		rorl	$2,%edx
		xorl	60(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%eax
		movl	%ebp,60(%esp)

		movl	%eax,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%esi,),%esi
		movl	%edi,%ebx
		movl	%edi,%ebp
		orl	%edx,%ebx
		andl	%edx,%ebp
		andl	%ecx,%ebx
		orl	%ebp,%ebx
		movl	52(%esp),%ebp
		addl	%ebx,%esi
		xorl	32(%esp),%ebp
		xorl	8(%esp),%ebp
		rorl	$2,%edi
		xorl	(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%esi
		movl	%ebp,(%esp)

		movl	%esi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		movl	%eax,%ebp
		orl	%edi,%ebx
		andl	%edi,%ebp
		andl	%edx,%ebx
		orl	%ebp,%ebx
		movl	56(%esp),%ebp
		addl	%ebx,%ecx
		xorl	36(%esp),%ebp
		xorl	12(%esp),%ebp
		rorl	$2,%eax
		xorl	4(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%ecx
		movl	%ebp,4(%esp)

		movl	%ecx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edx,),%edx
		movl	%esi,%ebx
		movl	%esi,%ebp
		orl	%eax,%ebx
		andl	%eax,%ebp
		andl	%edi,%ebx
		orl	%ebp,%ebx
		movl	60(%esp),%ebp
		addl	%ebx,%edx
		xorl	40(%esp),%ebp
		xorl	16(%esp),%ebp
		rorl	$2,%esi
		xorl	8(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edx
		movl	%ebp,8(%esp)

		movl	%edx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		movl	%ecx,%ebp
		orl	%esi,%ebx
		andl	%esi,%ebp
		andl	%eax,%ebx
		orl	%ebp,%ebx
		movl	(%esp),%ebp
		addl	%ebx,%edi
		xorl	44(%esp),%ebp
		xorl	20(%esp),%ebp
		rorl	$2,%ecx
		xorl	12(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edi
		movl	%ebp,12(%esp)

		movl	%edi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%eax,),%eax
		movl	%edx,%ebx
		movl	%edx,%ebp
		orl	%ecx,%ebx
		andl	%ecx,%ebp
		andl	%esi,%ebx
		orl	%ebp,%ebx
		movl	4(%esp),%ebp
		addl	%ebx,%eax
		xorl	48(%esp),%ebp
		xorl	24(%esp),%ebp
		rorl	$2,%edx
		xorl	16(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%eax
		movl	%ebp,16(%esp)

		movl	%eax,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%esi,),%esi
		movl	%edi,%ebx
		movl	%edi,%ebp
		orl	%edx,%ebx
		andl	%edx,%ebp
		andl	%ecx,%ebx
		orl	%ebp,%ebx
		movl	8(%esp),%ebp
		addl	%ebx,%esi
		xorl	52(%esp),%ebp
		xorl	28(%esp),%ebp
		rorl	$2,%edi
		xorl	20(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%esi
		movl	%ebp,20(%esp)

		movl	%esi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		movl	%eax,%ebp
		orl	%edi,%ebx
		andl	%edi,%ebp
		andl	%edx,%ebx
		orl	%ebp,%ebx
		movl	12(%esp),%ebp
		addl	%ebx,%ecx
		xorl	56(%esp),%ebp
		xorl	32(%esp),%ebp
		rorl	$2,%eax
		xorl	24(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%ecx
		movl	%ebp,24(%esp)

		movl	%ecx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edx,),%edx
		movl	%esi,%ebx
		movl	%esi,%ebp
		orl	%eax,%ebx
		andl	%eax,%ebp
		andl	%edi,%ebx
		orl	%ebp,%ebx
		movl	16(%esp),%ebp
		addl	%ebx,%edx
		xorl	60(%esp),%ebp
		xorl	36(%esp),%ebp
		rorl	$2,%esi
		xorl	28(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edx
		movl	%ebp,28(%esp)

		movl	%edx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		movl	%ecx,%ebp
		orl	%esi,%ebx
		andl	%esi,%ebp
		andl	%eax,%ebx
		orl	%ebp,%ebx
		movl	20(%esp),%ebp
		addl	%ebx,%edi
		xorl	(%esp),%ebp
		xorl	40(%esp),%ebp
		rorl	$2,%ecx
		xorl	32(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edi
		movl	%ebp,32(%esp)

		movl	%edi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%eax,),%eax
		movl	%edx,%ebx
		movl	%edx,%ebp
		orl	%ecx,%ebx
		andl	%ecx,%ebp
		andl	%esi,%ebx
		orl	%ebp,%ebx
		movl	24(%esp),%ebp
		addl	%ebx,%eax
		xorl	4(%esp),%ebp
		xorl	44(%esp),%ebp
		rorl	$2,%edx
		xorl	36(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%eax
		movl	%ebp,36(%esp)

		movl	%eax,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%esi,),%esi
		movl	%edi,%ebx
		movl	%edi,%ebp
		orl	%edx,%ebx
		andl	%edx,%ebp
		andl	%ecx,%ebx
		orl	%ebp,%ebx
		movl	28(%esp),%ebp
		addl	%ebx,%esi
		xorl	8(%esp),%ebp
		xorl	48(%esp),%ebp
		rorl	$2,%edi
		xorl	40(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%esi
		movl	%ebp,40(%esp)

		movl	%esi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		movl	%eax,%ebp
		orl	%edi,%ebx
		andl	%edi,%ebp
		andl	%edx,%ebx
		orl	%ebp,%ebx
		movl	32(%esp),%ebp
		addl	%ebx,%ecx
		xorl	12(%esp),%ebp
		xorl	52(%esp),%ebp
		rorl	$2,%eax
		xorl	44(%esp),%ebp
		roll	$1,%ebp
		addl	%ebp,%ecx
		movl	%ebp,44(%esp)

		/* round 61 to 80 */

		movl	%ecx,%ebx
		movl	36(%esp),%ebp
		roll	$5,%ebx
		xorl	16(%esp),%ebp
		leal	0xca62c1d6(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	56(%esp),%ebp
		xorl	%eax,%ebx
		xorl	48(%esp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,48(%esp)

		movl	%edx,%ebx
		movl	40(%esp),%ebp
		roll	$5,%ebx
		xorl	20(%esp),%ebp
		leal	0xca62c1d6(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	60(%esp),%ebp
		xorl	%esi,%ebx
		xorl	52(%esp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,52(%esp)

		movl	%edi,%ebx
		movl	44(%esp),%ebp
		roll	$5,%ebx
		xorl	24(%esp),%ebp
		leal	0xca62c1d6(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	(%esp),%ebp
		xorl	%ecx,%ebx
		xorl	56(%esp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,56(%esp)

		movl	%eax,%ebx
		movl	48(%esp),%ebp
		roll	$5,%ebx
		xorl	28(%esp),%ebp
		leal	0xca62c1d6(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	4(%esp),%ebp
		xorl	%edx,%ebx
		xorl	60(%esp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,60(%esp)

		movl	%esi,%ebx
		movl	52(%esp),%ebp
		roll	$5,%ebx
		xorl	32(%esp),%ebp
		leal	0xca62c1d6(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	8(%esp),%ebp
		xorl	%edi,%ebx
		xorl	(%esp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,(%esp)

		movl	%ecx,%ebx
		movl	56(%esp),%ebp
		roll	$5,%ebx
		xorl	36(%esp),%ebp
		leal	0xca62c1d6(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	12(%esp),%ebp
		xorl	%eax,%ebx
		xorl	4(%esp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,4(%esp)

		movl	%edx,%ebx
		movl	60(%esp),%ebp
		roll	$5,%ebx
		xorl	40(%esp),%ebp
		leal	0xca62c1d6(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	16(%esp),%ebp
		xorl	%esi,%ebx
		xorl	8(%esp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,8(%esp)

		movl	%edi,%ebx
		movl	(%esp),%ebp
		roll	$5,%ebx
		xorl	44(%esp),%ebp
		leal	0xca62c1d6(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	20(%esp),%ebp
		xorl	%ecx,%ebx
		xorl	12(%esp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,12(%esp)

		movl	%eax,%ebx
		movl	4(%esp),%ebp
		roll	$5,%ebx
		xorl	48(%esp),%ebp
		leal	0xca62c1d6(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	24(%esp),%ebp
		xorl	%edx,%ebx
		xorl	16(%esp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,16(%esp)

		movl	%esi,%ebx
		movl	8(%esp),%ebp
		roll	$5,%ebx
		xorl	52(%esp),%ebp
		leal	0xca62c1d6(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	28(%esp),%ebp
		xorl	%edi,%ebx
		xorl	20(%esp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,20(%esp)

		movl	%ecx,%ebx
		movl	12(%esp),%ebp
		roll	$5,%ebx
		xorl	56(%esp),%ebp
		leal	0xca62c1d6(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	32(%esp),%ebp
		xorl	%eax,%ebx
		xorl	24(%esp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,24(%esp)

		movl	%edx,%ebx
		movl	16(%esp),%ebp
		roll	$5,%ebx
		xorl	60(%esp),%ebp
		leal	0xca62c1d6(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	36(%esp),%ebp
		xorl	%esi,%ebx
		xorl	28(%esp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,28(%esp)

		movl	%edi,%ebx
		movl	20(%esp),%ebp
		roll	$5,%ebx
		xorl	(%esp),%ebp
		leal	0xca62c1d6(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	40(%esp),%ebp
		xorl	%ecx,%ebx
		xorl	32(%esp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,32(%esp)

		movl	%eax,%ebx
		movl	24(%esp),%ebp
		roll	$5,%ebx
		xorl	4(%esp),%ebp
		leal	0xca62c1d6(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	44(%esp),%ebp
		xorl	%edx,%ebx
		xorl	36(%esp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,36(%esp)

		movl	%esi,%ebx
		movl	28(%esp),%ebp
		roll	$5,%ebx
		xorl	8(%esp),%ebp
		leal	0xca62c1d6(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	48(%esp),%ebp
		xorl	%edi,%ebx
		xorl	40(%esp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,40(%esp)

		movl	%ecx,%ebx
		movl	32(%esp),%ebp
		roll	$5,%ebx
		xorl	12(%esp),%ebp
		leal	0xca62c1d6(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	52(%esp),%ebp
		xorl	%eax,%ebx
		xorl	44(%esp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,44(%esp)

		movl	%edx,%ebx
		movl	36(%esp),%ebp
		roll	$5,%ebx
		xorl	16(%esp),%ebp
		leal	0xca62c1d6(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	56(%esp),%ebp
		xorl	%esi,%ebx
		xorl	48(%esp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,48(%esp)

		movl	%edi,%ebx
		movl	40(%esp),%ebp
		roll	$5,%ebx
		xorl	20(%esp),%ebp
		leal	0xca62c1d6(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	60(%esp),%ebp
		xorl	%ecx,%ebx
		xorl	52(%esp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax

		movl	%eax,%ebx
		movl	44(%esp),%ebp
		roll	$5,%ebx
		xorl	24(%esp),%ebp
		leal	0xca62c1d6(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	(%esp),%ebp
		xorl	%edx,%ebx
		xorl	56(%esp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi

		movl	%esi,%ebx
		movl	48(%esp),%ebp
		roll	$5,%ebx
		xorl	28(%esp),%ebp
		leal	0xca62c1d6(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	4(%esp),%ebp
		xorl	%edi,%ebx
		xorl	60(%esp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	$64,%esp
		addl	%ebp,%ecx

		/* create new hash */

		popl	%ebp
		popl	%ebx
		addl	%ecx,(%ebp)
		addl	%esi,4(%ebp)
		addl	%eax,8(%ebp)
		addl	%edi,12(%ebp)
		addl	%edx,16(%ebp)

		popl	%esi
		popl	%edi
		ret

/* void sha1init(SHA1DATA *ptr) */

.ifdef _SHA1_FULL

.globl sha1init
		.type	sha1init,@function
		.align	16
sha1init:
		movl	4(%esp),%eax
		movl	$0x67452301,(%eax)
		movl	$0xefcdab89,4(%eax)
		movl	$0x98badcfe,8(%eax)
		movl	$0x10325476,12(%eax)
		movl	$0xc3d2e1f0,16(%eax)
		movl	$0,20(%eax)
		movb	$0,88(%eax)
		ret

.endif

/* void sha1next(WORD08 *data,WORD32 length,SHA1DATA *ptr) */

.ifdef _SHA1_FULL

.globl sha1next
		.type	sha1next,@function
		.align	16
sha1next:
		pushl	%ebp
		pushl	%ebx
		pushl	%esi
		pushl	%edi

		movl	28(%esp),%ebp
		movl	24(%esp),%esi
		leal	24(%ebp),%edi
		movl	20(%esp),%ebx
		addl	%esi,20(%ebp)

		movzbl	88(%ebp),%ecx
		testl	%esi,%esi
		je	sha1nxtlp1end
sha1nextloop1:	testl	%ecx,%ecx
		je	sha1nxtlp1end
		movb	(%ebx),%al
		incl	%ebx
		movb	%al,(%edi,%ecx,)
		incl	%ecx
		cmpl	$64,%ecx
		je	sha1nextcont1
		decl	%esi
		jne	sha1nextloop1
		jmp	sha1nxtlp1end
sha1nextcont1:	call	sha1block
		xorl	%ecx,%ecx
		decl	%esi

sha1nxtlp1end:	movl	%ebx,%edi
		movl	%ecx,%ebx
		cmpl	$64,%esi
		jnae	sha1nxtlp2end

sha1nextloop2:	call	sha1block
		subl	$64,%esi
		addl	$64,%edi
		cmpl	$64,%esi
		jnb	sha1nextloop2

sha1nxtlp2end:	movl	%esi,%edx
		shrl	$2,%esi
		je	sha1nxtlp3end

sha1nextloop3:	movl	(%edi),%eax
		addl	$4,%edi
		movl	%eax,24(%ebp,%ebx,)
		addl	$4,%ebx
		decl	%esi
		jne	sha1nextloop3

sha1nxtlp3end:	andl	$3,%edx
		je	sha1nextend

sha1nextloop4:	movb	(%edi),%al
		incl	%edi
		movb	%al,24(%ebp,%ebx,)
		incl	%ebx
		decl	%edx
		jne	sha1nextloop4

sha1nextend:	popl	%edi
		popl	%esi

		movb	%bl,88(%ebp)

		popl	%ebx
		popl	%ebp
		ret

.endif

/* void sha1end(WORD08 *result,SHA1DATA *ptr) */

.ifdef _SHA1_FULL

.globl sha1end
		.type	sha1end,@function
		.align	16
sha1end:
		pushl	%ebp
		pushl	%esi
		pushl	%edi
		pushl	%ebx

		movl	24(%esp),%ebp
		movl	20(%esp),%esi
		leal	24(%ebp),%edi

		movzbl	88(%ebp),%ebx
		incl	%ebx
		movl	%ebx,%eax
		movb	$128,-1(%edi,%ebx,)
		andl	$3,%eax
		je	sha1endlp1aend

sha1endloop1a:	movb	$0,(%edi,%ebx,)
		incl	%eax
		incl	%ebx
		cmpl	$4,%eax
		jne	sha1endloop1a

sha1endlp1aend:	shrl	$2,%ebx
		jmp	sha1endlp1bbeg

sha1endloop1b:	movl	$0,(%edi,%ebx,4)
		incl	%ebx

sha1endlp1bbeg:	cmpl	$14,%ebx
		je	sha1endlp1end
		cmpl	$16,%ebx
		jne	sha1endloop1b
		xorl	%ebx,%ebx
		call	sha1block
		jmp	sha1endloop1b

sha1endlp1end:	movl	20(%ebp),%edx
		movl	%edx,%ecx
		shrl	$29,%ecx
		bswapl	%ecx
		shll	$3,%edx
		bswapl	%edx
		movl	%ecx,80(%ebp)
		movl	%edx,84(%ebp)
		call	sha1block

		movl	$5,%edx

.ifdef SHA1_PARANOID
		movl	$16,%ecx
		xorl	%eax,%eax
.endif

sha1endloop2:	decl	%edx
		movl	(%ebp,%edx,4),%ebx
		bswapl	%ebx
		movl	%ebx,(%esi,%edx,4)
		jne	sha1endloop2

		popl	%ebx
		popl	%edi

.ifdef SHA1_PARANOID
sha1endloop3:	decl	%ecx
		movl	%eax,24(%ebp,%ecx,4)
		jne	sha1endloop3
.endif

		popl	%esi
		popl	%ebp
		ret

.endif

/* void sha1(WORD08 *data,WORD32 length,WORD08 *result) */

.ifdef SHA1_FAST

.globl sha1
		.type	sha1,@function
		.align	16
sha1:
		pushl	%ebx
		pushl	%ebp
		pushl	%esi
		pushl	%edi
		subl	$84,%esp

		movl	%esp,%ebp
		movl	$0x67452301,(%ebp)
		movl	$0xefcdab89,4(%ebp)
		movl	$0x98badcfe,8(%ebp)
		movl	$0x10325476,12(%ebp)
		movl	$0xc3d2e1f0,16(%ebp)

		movl	108(%esp),%esi
		movl	104(%esp),%edi
		cmpl	$64,%esi
		jnae	sha1loop2end

sha1loop2:	call	sha1block
		subl	$64,%esi
		addl	$64,%edi
		cmpl	$64,%esi
		jnb	sha1loop2

sha1loop2end:	movl	%esi,%ecx
		movl	%edi,%edx
		xorl	%ebx,%ebx
		leal	20(%esp),%edi
		shrl	$2,%ecx
		je	sha1loop3bbeg

sha1loop3a:	movl	(%edx,%ebx,4),%eax
		movl	%eax,(%edi,%ebx,4)
		incl	%ebx
		decl	%ecx
		jne	sha1loop3a
		leal	(,%ebx,4),%ebx

sha1loop3bbeg:	andl	$3,%esi
		je	sha1loop3end

sha1loop3b:	movb	(%edx,%ebx,),%al
		movb	%al,(%edi,%ebx,)
		incl	%ebx
		decl	%esi
		jne	sha1loop3b

sha1loop3end:	incl	%ebx
		movl	%ebx,%eax
		movb	$128,-1(%edi,%ebx,)
		andl	$3,%eax
		je	sha1loop4aend

sha1loop4a:	movb	$0,(%edi,%ebx,)
		incl	%eax
		incl	%ebx
		cmpl	$4,%eax
		jne	sha1loop4a

sha1loop4aend:	shrl	$2,%ebx
		jmp	sha1loop4bbeg

sha1loop4b:	movl	$0,(%edi,%ebx,4)
		incl	%ebx

sha1loop4bbeg:	cmpl	$14,%ebx
		je	sha1loop4end
		cmpl	$16,%ebx
		jne	sha1loop4b
		xorl	%ebx,%ebx
		call	sha1block
		jmp	sha1loop4b

sha1loop4end:	movl	108(%esp),%edx
		movl	%edx,%ecx
		shrl	$29,%ecx
		bswapl	%ecx
		shll	$3,%edx
		bswapl	%edx
		movl	%ecx,56(%edi)
		movl	%edx,60(%edi)
		call	sha1block

		movl	112(%esp),%ecx
		movl	$5,%ebx
sha1loop5:	decl	%ebx
		movl	(%ebp,%ebx,4),%eax
		bswapl	%eax
		movl	%eax,(%ecx,%ebx,4)
		jne	sha1loop5

.ifdef SHA1_PARANOID

		movl	$16,%ebx
		xorl	%eax,%eax
sha1loop6:	decl	%ebx
		movl	%eax,(%edi,%ebx,4)
		jne	sha1loop6

.endif

		addl	$84,%esp
		popl	%edi
		popl	%esi
		popl	%ebp
		popl	%ebx
		ret

.endif

/* void sha1hmkey(WORD08 *key,WORD32 keylength,SHA1HMDATA *ptr) */

.ifdef	_SHA1_HMAC

.globl sha1hmkey
		.type	sha1hmkey,@function
		.align	16
sha1hmkey:
		pushl	%ebx
		pushl	%esi
		pushl	%ebp
		pushl	%edi

		movl	20(%esp),%ebx
		movl	24(%esp),%esi
		movl	28(%esp),%ebp
		subl	$112,%esp
		movl	%esp,%edi

		cmpl	$65,%esi
		jnae	sha1hmkey1

		pushl	%edi
		call	sha1init
		pushl	%esi
		pushl	%ebx
		call	sha1next
		leal	92(%edi),%ebx
		pushl	%edi
		pushl	%ebx
		call	sha1end
		xorl	%eax,%eax
		movl	%edi,%esp
		movl	$20,%esi
		movl	%eax,(%edi)
		movl	%eax,4(%edi)
		movl	%eax,8(%edi)
		movl	%eax,12(%edi)
		movl	%eax,16(%edi)

sha1hmkey1:	movl	$0x67452301,(%ebp)
		movl	$0xefcdab89,4(%ebp)
		movl	$0x98badcfe,8(%ebp)
		movl	$0x10325476,12(%ebp)
		movl	$0xc3d2e1f0,16(%ebp)
		movl	$0x67452301,20(%ebp)
		movl	$0xefcdab89,24(%ebp)
		movl	$0x98badcfe,28(%ebp)
		movl	$0x10325476,32(%ebp)
		movl	$0xc3d2e1f0,36(%ebp)

		xorl	%ecx,%ecx
		movb	$54,%dl
		jmp	sha1hmkey2
sha1hmkeyloop3:	movb	(%ebx,%ecx,),%al
		xorb	%dl,%al
		movb	%al,(%edi,%ecx,)
		incl	%ecx
sha1hmkey2:	cmpl	%ecx,%esi
		jne	sha1hmkeyloop3

		jmp	sha1hmkey3
sha1hmkeyloop4:	movb	%dl,(%edi,%ecx,)
		incl	%ecx
sha1hmkey3:	cmpl	$64,%ecx
		jne	sha1hmkeyloop4

		call	sha1block

		xorl	%ecx,%ecx
		movb	$92,%dl
		jmp	sha1hmkey4
sha1hmkeyloop5:	movb	(%ebx,%ecx,),%al
		xorb	%dl,%al
		movb	%al,(%edi,%ecx,)
		incl	%ecx
sha1hmkey4:	cmpl	%ecx,%esi
		jne	sha1hmkeyloop5

		jmp	sha1hmkey5
sha1hmkeyloop6:	movb	%dl,(%edi,%ecx,)
		incl	%ecx
sha1hmkey5:	cmpl	$64,%ecx
		jne	sha1hmkeyloop6

		addl	$20,%ebp
		call	sha1block

		movl	$20,%edx
		xorl	%eax,%eax
sha1hmkeyloop7:	decl	%edx
		movl	%eax,(%edi,%edx,4)
		movb	%al,92(%edi,%edx,)
		jne	sha1hmkeyloop7

		addl	$112,%esp
		popl	%edi
		popl	%ebp
		popl	%esi
		popl	%ebx
		ret

.endif

/* void sha1hminit(SHA1DATA *ptr,SHA1HMDATA *key) */

.ifdef	SHA1_HMAC_FULL

.globl sha1hminit
		.type	sha1hminit,@function
		.align	16
sha1hminit:
		movl	8(%esp),%ecx
		movl	4(%esp),%edx
		movl	(%ecx),%eax
		movb	$0,88(%edx)
		movl	%eax,(%edx)
		movl	4(%ecx),%eax
		movl	$64,20(%edx)
		movl	%eax,4(%edx)
		movl	8(%ecx),%eax
		movl	%eax,8(%edx)
		movl	12(%ecx),%eax
		movl	%eax,12(%edx)
		movl	16(%ecx),%eax
		movl	%eax,16(%edx)
		ret

.endif

/* void sha1hmend(WORD08 *result,SHA1DATA *ptr,SHA1HMDATA *key) */

.ifdef	SHA1_HMAC_FULL

.globl sha1hmend
		.type	sha1hmend,@function
		.align	16
sha1hmend:
		pushl	%ebx
		pushl	%esi
		subl	$12,%esp
		movl	%esp,%esi
		movl	24(%esi),%eax
		movl	28(%esi),%ebx
		movl	%eax,(%esi)
		movl	%ebx,4(%esi)
		call	sha1end
		movl	32(%esi),%ecx
		movb	$0,88(%ebx)
		movl	20(%ecx),%eax
		movl	24(%ecx),%edx
		movl	%eax,(%ebx)
		movl	%edx,4(%ebx)
		movl	28(%ecx),%eax
		movl	32(%ecx),%edx
		movl	%eax,8(%ebx)
		movl	%edx,12(%ebx)
		movl	36(%ecx),%eax
		movl	$64,20(%ebx)
		movl	%eax,16(%ebx)
		movl	$20,4(%esi)
		movl	%ebx,8(%esi)
		call	sha1next
		movl	%ebx,4(%esi)
		call	sha1end
		addl	$12,%esp
		popl	%esi
		popl	%ebx
		ret

.endif

/* void sha1hmac(WORD08 *data,WORD32 length,WORD08 *result,SHA1HMDATA *key) */

.ifdef	SHA1_HMAC_FAST

.globl sha1hmac
		.type	sha1hmac,@function
		.align	16
sha1hmac:
		pushl	%ebx
		pushl	%edi
		pushl	%esi

		xorl	%ecx,%ecx	/* keep this ! */

		movl	28(%esp),%ebx
		subl	$104,%esp
		movl	%esp,%esi
		leal	12(%esi),%edi

		movl	(%ebx),%eax
		movl	4(%ebx),%edx
		movl	%eax,(%edi)
		movl	%edx,4(%edi)
		movl	8(%ebx),%eax
		movl	12(%ebx),%edx
		movl	%eax,8(%edi)
		movl	%edx,12(%edi)
		movl	16(%ebx),%eax
		movb	$0,88(%edi)
		movl	%eax,16(%edi)

		movl	$64,20(%edi)

		movl	120(%esi),%eax
		movl	124(%esi),%ecx
		movl	%eax,(%esi)
		movl	%ecx,4(%esi)
		movl	%edi,8(%esi)
		call	sha1next

		movl	128(%esi),%eax
		movl	%edi,4(%esi)
		movl	%eax,(%esi)
		call	sha1end

		movl	20(%ebx),%eax
		movl	24(%ebx),%edx
		movl	%eax,(%edi)
		movl	%edx,4(%edi)
		movl	28(%ebx),%eax
		movl	32(%ebx),%edx
		movl	%eax,8(%edi)
		movl	%edx,12(%edi)
		movl	36(%ebx),%eax
		movb	$0,88(%edi)
		movl	%eax,16(%edi)

		movl	$64,20(%edi)

		movl	$20,4(%esi)
		call	sha1next

		movl	%edi,4(%esi)
		call	sha1end

		addl	$104,%esp
		popl	%esi
		popl	%edi
		popl	%ebx
		ret

.endif
