/* $Id: myname.C,v 1.4 1999/11/16 04:21:03 dm Exp $ */

/*
 *
 * Copyright (C) 1998 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "dns.h"
#include <sys/utsname.h>

str
mydomain ()
{
  if (!(_res.options & RES_INIT))
    res_init ();
  return _res.dnsrch[0];
}

str
myname ()
{
  struct utsname unm;

  if (uname (&unm) < 0) {
    warn ("uname: %m\n");
    return NULL;
  }
  if (strchr (unm.nodename, '.'))
    return unm.nodename;

  if (!(_res.options & RES_INIT))
    res_init ();
  if (!_res.dnsrch[0]) {
    warn ("cannot find fully qualified domain name\n");
    return NULL;
  }
  return strbuf () << unm.nodename << "." << _res.dnsrch[0];
}
