/* keymanager.h - Seahorse
 *
 * Copyright (C) 2000 Anthony Mulcahy
 * Copyright (C) 2000, Jos Carlos Garca Sogo <jsogo@arrakis.es>
 *
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <keyrings.h>

void keymanager_button_clicked (GtkButton *button,  gpointer user_data);

void display_keyring (GtkCTree *KeyCTree);

void add_key_to_ctree (Key *key, GtkCTree *ctree);

void add_uids_to_ctreenode (Key *key, GtkCTreeNode *keynode, GtkCTree *ctree);

void add_sigs_to_ctreenode (Uid *uid, GtkCTreeNode *uidnode, GtkCTree *ctree);

GtkCTreeNode *keymanager_get_selected_node (void);

gchar *keymanager_get_keyid_from_node (GtkCTreeNode* node);

gint keymanager_get_type_from_node (GtkCTreeNode* node);

gchar *keymanager_get_username_from_node (GtkCTreeNode* node);

GtkWidget *activate_keyproperties_dialog (void);

GtkWidget *gen_key;
