/***************************************************************************
                          QDBTABLEEDIT.CPP  -  description
                             -------------------                                         
    begin                : 09.03.2000
    version              : $Id: qdbtableedit.cpp,v 1.20 2001/03/06 21:32:33 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <qpixmap.h>
#include <qvaluelist.h>
#include <stdio.h>
#include <qmessagebox.h>
#include <qheader.h>

#include "qdbtableedit.h"

QDBTableEdit::QDBTableEdit( QWidget *parent, const char *name,
														SQLQuerier *sql_ptr, SQLTable* table_ptr,
														QStatusBar *statusBar_ptr,
														const char *tableName, bool all_visible,
														bool editable )
	: QListView( parent, name )
{
	bool ok = true;
	int i;
	QDBTableEditItem *lvi = new QDBTableEditItem( this, 0, 0 );

	if ((sql_ptr == 0) || (table_ptr == 0) || (tableName == 0)) {
		QMessageBox::warning( this, "QtTudo", "QDBTableEdit: Ein bergabeparameter fehlt!" );
		ok = false;
	}

	if (table_ptr->PrimaryKeys[0][0] == 0) {
		QMessageBox::warning( this, "QtTudo",
			"QDBTableEdit: Diese Funktion braucht einen Primrschlssel!" );
		ok = false;
	}

	prEdit = 0L;
//	myUnEditableDict.setAutoDelete( true );
	setAllColumnsShowFocus( true );
	setSorting(-1); // Disable Sorting
	header()->setClickEnabled( false );
	header()->setMovingEnabled( false ); // Moving not allowed (not yet)
	puCol = 0;
	sql	= sql_ptr;
	table = table_ptr;
	sName = tableName;
	statusBar = statusBar_ptr;
	nTuples = 0;
	ilastKey = 0;
	insMode = false;
	table->pos = 0;
	isEditable = editable;

  // Datenverbindung herstellen
	if (( sql->conn != NULL ) && (ok)) {
		// make all columns visible
		for (i=0; i < MAXFELDER; i++) {
			if (all_visible)
				visible[i] = true;
			else
				visible[i] = false;
			colSize[i] = 0;
		}
		if ( update() ) {
			// create column headers
			for (i=0; i < table->getnFields(); i++) {
				tupleIndex[i] = -1;
				Feldvorgabe[i] = new QString();
				colName[i] = new QString();
				if (visible[i]) {
					makeVisible( i );
					addCol( i );
				}
			}
			table->pos = table->getnTuples()-1;
//			if (table->pos < 0)
//				table->pos = 0;

			// look for the current position
			lvi = (QDBTableEditItem *) firstChild();
			for ( i = 0; i < childCount(); i++ ) {
				if ( lvi->DBPos == table->pos ) {
					setCurrentItem( lvi );
					break;
				}
				lvi = (QDBTableEditItem *) lvi->itemBelow();
			}
		}
	}	else
		QMessageBox::warning( this, "QtTudo",
			"Keine Datenbankverbindung aktiv oder Fehler in Parametern!" );

//	connect( this, SIGNAL( selectionChanged() ),
//			SLOT( slotDestroyEdit() ));
	connect( this, SIGNAL( doubleClicked( QDBTableEditItem * ) ),
			SLOT( slotItemClicked( QDBTableEditItem * ) ));
}

QDBTableEdit::~QDBTableEdit()
{
	delete prEdit;
//	myUnEditableDict.clear();
}

void QDBTableEdit::makeVisible( int i )
{
	visible[i] = true;
}

void QDBTableEdit::addCol( int i )
{
	int colInd;

	if ( strlen(colName[i]->copy()) != 0 )
		colInd = addColumn( colName[i]->copy() );
	else
		colInd = addColumn( table->fName(i) );
	setColumnWidthMode( colInd, Manual );
	if (colSize[i] > 0)
		setColumnWidth( colInd, colSize[i] );
	tupleIndex[i] = colInd;
}

void QDBTableEdit::changeColumn( int tupleInd, int size, const char *text )
{
	int colInd = colIndex( tupleInd );

	setColumnWidth( colInd, size );
	setColumnText( colInd, text );
}

//void QDBTableEdit::setEditable( QDBTableEditItem *item, int col, bool enable)
//{
//	ASSERT( item != 0L );

//	ColumnList *list = myUnEditableDict.find( item );
//	if ( list && enable )
//		list->remove( col );
//	else
//		if ( list && !enable && list->find( col ) == list->end() )
//			list->append( col );
//   else
//			if ( !list && !enable ) {
//				list = new ColumnList;
//				list->append( col );
//				myUnEditableDict.insert( item, list );
//			}
//}

void QDBTableEdit::slotItemClicked( QDBTableEditItem *item )
{
	int i = 0;
	QRect r( itemRect( item ) );
	int x = r.x();

	if ( item == 0 )
		return;

	// this table is not editable
	if (!isEditable)
		return;

	// is the item editable?
//	ColumnList *eList = myUnEditableDict.find( item );
//	if ( eList && eList->find( puCol ) != eList->end() )
//		return;

	item->modified = true;
	prEdit = new RectLineEdit( viewport() );
	prEdit->setText( item->text( puCol ) );
	if ((ilastKey >= Key_0) && (ilastKey <= Key_Z)) {
		prEdit->setText(slastKey);
	} else
		prEdit->setText( item->text( puCol ) );
	prEdit->adjustSize();

	for ( i = 0; i < puCol; i++ ) {
		x += columnWidth( i );
	}

	prEdit->move( x, r.y() );
	prEdit->setFixedWidth( columnWidth( puCol ) );
	prEdit->show();
	prEdit->setFocus();
}

bool QDBTableEdit::isInsMode()
{
	return insMode;
}

void QDBTableEdit::setText( const char *field, const char *value )
{
	currentItem()->setText( tupleIndex[ table->fNumber(field) ], value );
}

QString QDBTableEdit::getText( const char *field )
{
	return currentItem()->text( tupleIndex[ table->fNumber(field) ] );
}

void QDBTableEdit::copyText( const char *fromField, const char *toField )
{
	currentItem()->setText( tupleIndex[ table->fNumber(toField) ],
		getText( fromField ));
}

void QDBTableEdit::fReturnPressed( bool ColumnChange )
{
	// Hiermit werden die nderungen bearbeitet
	SQLTable* tableNeu;
	QCString *DBneu = new QCString();

	currentItem()->setText( puCol, prEdit->text() );

	if ( !insMode ) {
  	// saving displayed data to database, but only this modified line
  	if (currentItem()->modified) {
  		// save a datafield
  		currentItem()->modified = false;
  		DBneu->setStr( "UPDATE " );
  		DBneu->append( sName );
  		DBneu->append( " SET " );
  		DBneu->append( table->fName( colIndex(puCol) ) );
  		DBneu->append( " = " );
  		DBneu->append( "'" );
  		DBneu->append( currentItem()->text( puCol ) );
  		DBneu->append( "'" );
 			DBneu->append( " WHERE " );
 			table->GetPrimaryKey( DBneu );

  		// Only for test
  		//QMessageBox::information( this, "Test: Update", DBneu->copy() );

  		tableNeu = new SQLTable( DBneu->copy(), 0 );
  		if (tableNeu->execute() != SUCCESS_NO_RESULTS)
  			QMessageBox::warning( this, "QtTudo", tableNeu->ErrorText );
  	}

  	// Read and shows the new table in the view.
  	if ( !update())
 			QMessageBox::warning( this, "QtTudo", table->ErrorText );
	}

	slotDestroyEdit();
	emit tupleUpdated( table->fName(colIndex(puCol)));
	if ( ColumnChange ) {
		if ( puCol < (table->getnFields()-1) ) {
			puCol++;
		} else {
			if (insMode) {
				insTuple();
			} else {
				if ( currentItem()->itemBelow() ) {
					setCurrentItem( currentItem()->itemBelow() );
					if ( table->pos < (table->getnTuples()-1) )
						table->pos++;
					puCol = 0;
				}
			}
		}
	}
	makeItemVisible();
	repaintItem( currentItem() );
	setFocus();
}

void QDBTableEdit::slotDestroyEdit()
{
	delete prEdit;
	prEdit = 0L;
}

void QDBTableEdit::makeItemVisible() {
	int i, iWidth;

	iWidth = 0;
	for (i=0;i<puCol;i++)
		iWidth += columnWidth( i );
	ensureVisible( iWidth, itemPos( currentItem() ) );
}

void QDBTableEdit::keyPressEvent( QKeyEvent *e )
{
	bool bEdit = false;
	bool InsOk = false;

	if ( prEdit && prEdit->hasFocus() ) {
		bEdit = true;
		if ( e->key() == Key_Escape ) {
			slotDestroyEdit();
			setFocus();
		}
		if ( e->key() == Key_Return ) {
			fReturnPressed( true );
			slotDestroyEdit();
			setFocus();
		}
		if ( e->key() == Key_Down ) {
			if (insMode)
				insTuple();
			else
				fReturnPressed( false );
			slotDestroyEdit();
			setFocus();
		}
		if ( e->key() == Key_Up ) {
			if (insMode)
				insTuple();
			else
				fReturnPressed( false );
			slotDestroyEdit();
			setFocus();
		}
	}
	if ( hasFocus() && !bEdit ) {
		if ( e->key() == Key_Return ) {
			slastKey = e->text();
			ilastKey = e->key();
			slotItemClicked( currentItem() );
		}
		if ((e->key() >= Key_0) && (e->key() <= Key_Z)) {
			slastKey = e->text();
			ilastKey = e->key();
			slotItemClicked( currentItem() );
		}
		if ( e->key() == Key_Left ) {
			if ( puCol > 0 ) {
				puCol--;
				makeItemVisible();
				repaintItem( currentItem() );
			}
		}
		if ( e->key() == Key_Right ) {
			if ( puCol < (table->getnFields()-1) ) {
				puCol++;
				makeItemVisible();
				repaintItem( currentItem() );
			}
		}
		if ( e->key() == Key_Up ) {
			if (insMode)
				InsOk = insTuple();
			else
				InsOk = true;
			if (( currentItem() != 0 ) && (InsOk)) {
				if ( currentItem()->itemAbove()) {
					setCurrentItem( currentItem()->itemAbove() );
					if ( table->pos > 0 )
						table->pos--;
					makeItemVisible();
				}
			}
		}
		if ( e->key() == Key_Down ) {
			if (insMode)
				InsOk = insTuple();
			else
				InsOk = true;
			if (( currentItem() != 0 ) && (InsOk)) {
				if ( currentItem()->itemBelow() ) {
					setCurrentItem( currentItem()->itemBelow() );
					if ( table->pos < (table->getnTuples()-1) )
						table->pos++;
					makeItemVisible();
				}
			}
		}
		if ( e->key() == Key_F2 ) { // reload database table
			update( false );
		}
		if ( e->key() == Key_F4 ) { // delete a tuple
			// is the table editable
			if (!isEditable)
				return;
			if ( currentItem() != 0 ) {
				if (!insMode) {
					switch( QMessageBox::information( this, "QtTudo Datensatz lschen",
						"Der Datensatz geht unwiderruflich verloren.\n"
						"Mchten Sie den Datensatz trotzdem lschen?",
						"&Ja", "&Nein", "",
						1,2 ))     // Nein == button 0 -> default
					{
						case 0: // Ja clicked, Alt-J or Enter pressed.
							// delete
							takeItem( currentItem() );
							delTuple();
							insMode = false;
							if (statusBar != 0)
								statusBar->clear();
							break;
						case 1: // Nein clicked or Alt-N pressed
							// don't delete
							break;
					} // switch
				} else {
					takeItem( currentItem() );
					insMode = false;
					if (statusBar != 0)
						statusBar->clear();
				}
				if ( childCount() == 0 ) {
					//insLine();
					setFocus();
				}
			} // if ( currentItem() != 0 )
		} // if Key_Delete
		if ( e->key() == Key_Insert ) {
			// is the table editable
			if (!isEditable)
				return;
			if ( !insMode ) {
				// Generieren einer leeren Zeile (QDBTableEditItem).
				// Bei Return werden die Daten noch nicht abgespeichert.
				// Das wird durch die speziell hierfr gesetzte Variable
				// insMode gesteuert.
				insLine();
				setFocus();
			}
		}
	} // if hasFocus()
}

//void QDBTableEdit::contentsMousePressEvent ( QMouseEvent * e ) {
//	printf( "test maus\n" );
//	QListView::contentsMousePressEvent( e );
//}

//void QDBTableEdit::setSelected ( QDBTableEditItem * item, bool selected ) {

//}

bool QDBTableEdit::update( bool withEmit )
{
	int i, felder, iPos;
	QDBTableEditItem *lvi;

	// In the table are max. SHOWTUPLES stored.
	//
	// The QDBTableEditItems must be deleted and new created.
	if ( sql->conn != NULL ) {

		// In Insert-Mode is no update possible.
		if (insMode)
			return false;

		// if query is empty, there is nothing to do
		if (table->sQuery == 0)
			return false;

	  if ( table->execute() != SUCCESS_RESULTS ) {
			QMessageBox::warning( this, "QtTudo", table->ErrorText );
			return false;
		}

		if (table->table == 0) {
			QMessageBox::warning( this, "QtTudo", "Kein Ergebnis von der Datenbank erhalten!" );
			return false;
		}

		// Loop through all selected tuples.
		iPos = table->getnTuples()-1;

		// Delete old QDBTableEditItems if we don't have tuples
		if (iPos < 0)
			clear();

		if (iPos > -1) {
			// saving the current position for
			// restore after updating the view
			if ( currentItem() != 0 ) {
				if (!insMode) {
					//printf( "DBPos: %i\n", currentItem()->DBPos );
					table->savePos( currentItem()->DBPos, false );
				} else {
					//printf( "nummer: %s  Pos: %i\n", currentItem()->text(0).latin1(), currentItem()->DBPos);
  				for (i=0; i<MAXKEYS; i++)
						table->sNewPos[i] = currentItem()->text( i );
					table->savePos( currentItem()->DBPos, true );
				}
			} else // no current position before
				table->savePos( 0, false );

			felder = table->getnFields();

			clear();

			for ( nTuples = 0; nTuples < table->getnTuples(); nTuples++ ) {
				lvi = new QDBTableEditItem( this, 0, iPos );
				// Loop through all datafields.
				for ( i = 0; i < felder; i++ ) {
					if (visible[i])
						lvi->setText( tupleIndex[i], table->getValue( iPos, i ) );
				}
				iPos--;
			}
  		table->pos = table->setPos();

			// look for the current position
			lvi = (QDBTableEditItem *) firstChild();
			for ( i = 0; i < childCount(); i++ ) {
				if ( lvi->DBPos == table->pos ) {
					setCurrentItem( lvi );
					break;
				}
				lvi = (QDBTableEditItem *) lvi->itemBelow();
			}

			if (withEmit)
				emit tupleModified();
		} // if (iPos > -1 }

		return true;
	}
	return false;
}

void QDBTableEdit::delTuple()
{
	int i;
	QCString *DB = new QCString();
	int DBPos = table->pos;

	DB->setStr( "DELETE FROM " );
	DB->append( sName );
	DB->append( " WHERE " );
	table->GetPrimaryKey( DB );

	SQLTable *tableNeu = new SQLTable( DB->copy(), 0 );
	if (tableNeu->execute() != SUCCESS_NO_RESULTS) {
		QMessageBox::warning( this, "QtTudo", tableNeu->ErrorText );
	}
	// Read and shows the new table in the view.
	if ( !update())
		QMessageBox::warning( this, "QtTudo", table->ErrorText );

	// look for the current position
	QDBTableEditItem *lvi = (QDBTableEditItem *) firstChild();
	for ( i = 0; i < childCount(); i++ ) {
		if ( lvi->DBPos == DBPos ) {
			setCurrentItem( lvi );
			table->pos = DBPos;
			makeItemVisible();
			break;
		}
		lvi = (QDBTableEditItem *) lvi->itemBelow();
	}
}

int QDBTableEdit::colIndex( int tupleInd )
{
	for (int i = 0; i < table->getnFields(); i++)
		if ( tupleInd == tupleIndex[i])
			return i;
	return -1;
}

bool QDBTableEdit::insTuple() {
	int i;
	QCString *DBneu = new QCString();
	SQLTable* tableNeu;

	if ((sql->conn != NULL) && (currentItem() != 0)) {
		DBneu->setStr( "INSERT INTO " );
		DBneu->append( sName );
		DBneu->append( " (" );
		// read the field names
		for ( i = 0; i < table->getnFields(); i++) {
			if (visible[i]) {
				if ( strlen( currentItem()->text( tupleIndex[i] ) ) != 0 ) {
					if ( i > 0 )
						DBneu->append( "," );
					DBneu->append( table->fName(i) );
				}
			} else { // not visible
				if (strlen( Feldvorgabe[i]->copy()) != 0) {
					if ( i > 0 )
						DBneu->append( "," );
					DBneu->append( table->fName(i) );
				}
			} // not visible
		}
		DBneu->append( ")" );
		DBneu->append( " VALUES (" );
		// read the field names
		for ( i = 0; i < table->getnFields(); i++) {
			if (visible[i]) {
				if ( strlen( currentItem()->text( tupleIndex[i] ) ) != 0 ) {
					if ( i > 0 )
						DBneu->append( ",'" );
					else
						DBneu->append( "'" );
					DBneu->append( currentItem()->text( tupleIndex[i] ) );
					DBneu->append( "'" );
				}
			} else { // not visible
				if (strlen( Feldvorgabe[i]->copy()) != 0) {
					if ( i > 0 )
						DBneu->append( ",'" );
					else
						DBneu->append( "'" );
					DBneu->append( Feldvorgabe[i]->copy() );
					DBneu->append( "'" );
				}
			} // not visible
		}
		DBneu->append( ")" );

		// Test: Falls man die Query vorher sehen mchte.
		//QMessageBox::information( this, "Test: Insert", DBneu->copy() );

		tableNeu = new SQLTable( DBneu->copy(), 0 );
	  if (tableNeu->execute() != SUCCESS_NO_RESULTS) {
			QMessageBox::warning( this, "QtTudo",
				"Ihre Daten sind unvollstndig.\n"
				"Bitte vervollstndigen Sie die neuen Daten oder\n"
				"lschen die Position mit <Entf>.\n\n"
				"Fehler: " + tableNeu->ErrorText );
			return false;
		} else {
			insMode = false;
			if (statusBar != 0)
				statusBar->clear();
		 	// Read and shows the new table in the view.
			if ( !update()) {
				QMessageBox::warning( this, "QtTudo",
					"Aktualisierung der Tabelle ist fehlgeschlagen." );
				return false;
			}
		}
	}
	return true;
}

void QDBTableEdit::insLine()
{
	int i;

	insMode = true;
	if (statusBar != 0)
		statusBar->message( "Einfgen" );

	int iPos = table->getnTuples();
	if ( iPos < 0 )
		iPos = 0;
	QDBTableEditItem *item = new QDBTableEditItem( this, 0, iPos );
	if ( iPos != 0 )
		setCurrentItem( item );
	// fill in the default values
	for (i=0; i < table->getnFields(); i++) {
		if (strlen(Feldvorgabe[i]->copy()) > 0) {
			if ((visible[i]) && (tupleIndex[i] > -1))
				currentItem()->setText( tupleIndex[i], Feldvorgabe[i]->copy() );
		}
	}

	// signal to program, that a line was inserted
	emit newTuple();
}

//=================================================================================
//	QDBTableEditItem
//=================================================================================

QDBTableEditItem * QDBTableEdit::currentItem() const
{
	return (QDBTableEditItem *) QListView::currentItem();
}

QDBTableEditItem::QDBTableEditItem( QDBTableEdit *parent, const QString &name, int pos )
    : QListViewItem( parent, name )
{
	DBTableEdit = parent;
	DBPos = pos; // Tuple Number
	modified = false;
}

QDBTableEditItem::~QDBTableEditItem() {
}

QDBTableEditItem * QDBTableEditItem::itemBelow()
{
	return (QDBTableEditItem *) QListViewItem::itemBelow();
}

void QDBTableEditItem::paintFocus( QPainter *p, const QColorGroup &cg, const QRect & r )
{
	int i = 0;
	QRect r2 = r;
	QColor c = cg.foreground(); // only for suppress compiler warnings

	c = Qt::green; // that looks better

	for ( ; i < DBTableEdit->puCol; i++ ) {
		r2.setX( r2.x() + DBTableEdit->columnWidth( i ) );
	}
	r2.setWidth( DBTableEdit->columnWidth( i ) );
	p->setPen( c );
	p->drawRect( r2 );
}

//=================================================================================
//	RectLineEdit
//=================================================================================

RectLineEdit::RectLineEdit( QWidget *parent, const char *name )
		: QLineEdit( parent, name )
{
	setFrame( false );
}

RectLineEdit::RectLineEdit( const QString& text, QWidget *parent, const char *name )
		: QLineEdit( text, parent, name )
{
	setFrame( false );
}

void RectLineEdit::keyPressEvent( QKeyEvent *e )
{
	if ( hasFocus() ) {
		// Key weiterreichen (Daten speichern und Zeile wechseln)
		if ( e->key() == Key_Return )
			e->ignore();
		else
		if ( e->key() == Key_Up )
			e->ignore();
		else
		if ( e->key() == Key_Down )
			e->ignore();
		else {
			if ( e->key() == Key_Escape )
				e->accept();
			QLineEdit::keyPressEvent( e );
		}
	}
}

void RectLineEdit::paintEvent( QPaintEvent *e )
{
	QLineEdit::paintEvent( e );

	if ( !frame() ) {
		QPainter p( this );
		p.setClipRegion( e->region() );
		p.drawRect( rect() );
	}
}
