/***************************************************************************
                          printsystem.cpp  -  description
                             -------------------
    begin                : Sun Nov 19 2000
    version              : $Id: printsystem.cpp,v 1.14 2001/03/06 21:32:33 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : j.bemme@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include <qdialog.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qprinter.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qfiledialog.h>

#include "printsystem.h"
#include "qdbtableselect.h"

#define LINE_LENGTH 10000

PrintSystem::PrintSystem(QWidget *parent, const char *name, SQLQuerier *sql_ptr )
	: QWidget(parent,name)
{
	sql = sql_ptr;
	tableRep = 0;
	editRep = 0;

	dlg = new QDialog(this,"getFilename",true); // modal dialog

  QPushButton *readFile = new QPushButton( "&Datei lesen", dlg );
  QPushButton *abbruch = new QPushButton( "&Abbruch", dlg );
  QPushButton *search = new QPushButton( "Durch&suchen", dlg );
	QLabel			*lFilename = new QLabel( dlg );
	QLabel			*lReportname = new QLabel( dlg );
  filename = new QLineEdit( dlg );
	reportName = new QLineEdit( dlg );

  lFilename->move( 40, 35 );
  lFilename->setText( "Datei&name:" );
  lFilename->setBuddy( filename );
  lReportname->move( 40, 85 );
  lReportname->setText( "&Berichtsname:" );
  lReportname->setBuddy( reportName );
  filename->move( 140, 40 );
  filename->resize( 200, 20 );
  reportName->move( 140, 90 );
  reportName->resize( 200, 20 );
  readFile->move( 110, 160 );
  readFile->resize( 100, 30 );
  readFile->setFont( QFont( "Times", 14, QFont::Bold ) );
  abbruch->move( 280, 160 );
  abbruch->resize( 100, 30 );
  abbruch->setFont( QFont( "Times", 14, QFont::Bold ) );
  search->move( 360, 34 );
  search->resize( 100, 30 );
  search->setFont( QFont( "Times", 14, QFont::Bold ) );

	filename->setFocus();

	connect( abbruch, SIGNAL(clicked()), dlg, SLOT(close()) );
	connect( readFile, SIGNAL(clicked()), this, SLOT(sImportTexFile()) );
	connect( search, SIGNAL(clicked()), SLOT(sSearchingFile()) );
}

PrintSystem::~PrintSystem(){
}

// show the import window
void PrintSystem::importTexFile()
{
	dlg->show();
}

void PrintSystem::printGenerator( const char *filename, const char *name )
{
	int y;
	int stepY=14; // later we will get this from the file 'filename'
	QString s;
	QPrinter printer;
	QString query = "SELECT * FROM print_report WHERE name = '";

	if (name == 0)
		return;

	query.append( name ); // append reportname
	query.append( "'" );

	// We need a filename, otherwise return.
	if (filename == 0)
		return;

  QFile f( filename );

	// read the file
  if ( f.open(IO_ReadOnly) ) {
		if ( printer.setup(this) ) {
			QPainter paint( &printer );
			QTextStream t( &f );

			SQLTable *tableRepKopf = new SQLTable( query.ascii(), "name" );
		  if (tableRepKopf->execute() != SUCCESS_RESULTS) {
				QMessageBox::warning( this, "QtTudo", tableRepKopf->ErrorText );
				return;
			}

			y = 0; // linenumber
			s = t.readLine();
			// loop through all lines of the kdevdlg-file
			while (!t.atEnd()) {
				// read a line
				s = t.readLine();

				// don't print orders and comments
				if ((s.find("%%") == -1) && (s.find("//") == -1)) {
					y++;
					paint.drawText( 0, y*stepY, s );
				}
				// create a new page if there is a order inside the report or
				// the report hight is exceeded
				if (s.find("%%newPage") != -1) {
					printer.newPage();
					y = 0;
				}
				if (s.find("%%newFontCourier5") != -1)
					paint.setFont( QFont("Courier", 5) );
				if (s.find("%%newFontCourier6") != -1)
					paint.setFont( QFont("Courier", 6) );
				if (s.find("%%newFontCourier7") != -1)
					paint.setFont( QFont("Courier", 7) );
				if (s.find("%%newFontCourier8") != -1)
					paint.setFont( QFont("Courier", 8) );
				if (s.find("%%newFontCourier9") != -1)
					paint.setFont( QFont("Courier", 9) );
				if (s.find("%%newFontCourier10") != -1)
					paint.setFont( QFont("Courier", 10) );
				if (s.find("%%newFontCourier11") != -1)
					paint.setFont( QFont("Courier", 11) );
				if (s.find("%%newFontCourier12") != -1)
					paint.setFont( QFont("Courier", 12) );
				if (s.find("%%newFontCourier13") != -1)
					paint.setFont( QFont("Courier", 13) );
				if (s.find("%%newFontCourier14") != -1)
					paint.setFont( QFont("Courier", 14) );
			}
		}
	}
}

// a window for create and modify reports
void PrintSystem::editReport()
{
	if (tableRep == 0) {
		tableRep = new SQLTable( "SELECT * FROM print_design WHERE report = '' ORDER BY no",
			"report,art,no" );
		editRep = new EditReport(this,0,sql,tableRep);
  }
	if (editRep != 0)
		editRep->show();
}

// Showing a reportlist and printing directly the report
void PrintSystem::printReport()
{
	QString s;
	QStringList list;

	// for test only
	QMessageBox::information( this, "QtTudo Test",
		"Der nchste Bericht ist nur zum Test." );

	s = "SELECT * FROM deb_rech_kopf WHERE nummer=2400000032";
	list << s; // add to list
	s = "SELECT * FROM deb_rech_zeile WHERE belegnr=2400000032";
	list << s;

	reportGenerator( "Debitor_Rechnung", &list );
}

void PrintSystem::sSearchingFile()
{
	filename->setText( QFileDialog::getOpenFileName(0,0,this) );
}

// import a ASCII file into database
void PrintSystem::sImportTexFile()
{
	int i = 0;
	char cI[10]; // the i-value in a string
	FILE *quelle;
	char line[LINE_LENGTH];
	SQLTable* tablePrintDesign;
	QCString *DBneu = new QCString();
	tablePrintDesign = new SQLTable( "", 0 );

	if (sql==0) {
		QMessageBox::information( this, "QtTudo: PrintSystem->sImportTexFile",
			"Der Parameter sql wurde nicht gesetzt." );
		return;
	}

	if (sql->conn != NULL) {
		if ((quelle = fopen( filename->text(), "r" )) != 0 ) {
			DBneu->setStr( "INSERT INTO print_report (name) VALUES ('" );
			DBneu->append( reportName->text() ); // report
			DBneu->append( "')" );
			tablePrintDesign->sQuery = DBneu->copy();
		  if (tablePrintDesign->execute() != SUCCESS_NO_RESULTS)
				QMessageBox::warning( this, "QtTudo", tablePrintDesign->ErrorText );
			else
				while (fgets((char *) line, LINE_LENGTH, quelle) != NULL) {
					DBneu->setStr( "INSERT INTO print_design (report,art,no,code) VALUES ('" );
					DBneu->append( reportName->text() ); // report
					DBneu->append( "','" );
					DBneu->append( "head" ); // art
					DBneu->append( "','" );
					i += 10000;
					sprintf( cI, "%i", i );
					DBneu->append( cI ); // no (number)
					DBneu->append( "','" );
					DBneu->append( line ); // code
					DBneu->append( "')" );

					// only for testing
					//QMessageBox::information( this, "Test: Insert", DBneu->copy() );

					tablePrintDesign->sQuery = DBneu->copy();
				  if (tablePrintDesign->execute() != SUCCESS_NO_RESULTS) {
						QMessageBox::warning( this, "QtTudo", tablePrintDesign->ErrorText );
						break;
					}
				}
		} else
			QMessageBox::information(0, "QtTudo Text-Datei importieren",
				"Fehler beim ffnen der Datei.");
	}
}

//==============================================================================
// ReportGenerator
// ---------------
// Parameter:
//  name      -> reportname
//  selection -> selection of tuples (tables, fields)
//  type      -> type of sourcecode (ASCII, LaTeX, XML, etc.)
//==============================================================================
bool PrintSystem::reportGenerator(const char *name, QStringList *selection,
		int type)
{
	int mainPos;
	int tablePos;
	char s[50];
	QString query;
	QString filename;
	QString line;
	QString element;
	SQLTable *tableElements;
	SQLTable *tableReport;
	bool wasOK = true;

	if (type != 0) {
		QMessageBox::information(0, "QtTudo Reportgenerator",
			"Es wird z. Zt. nur der Typ 0 (Druckformat fr Qt) untersttzt.");
		return false;
	}

	// create file number.qttudo
	sprintf( s, "%d", rand() ); // generate random number
	filename.truncate(0);
	filename.append( "/tmp/" );
	filename.append( s );	
	filename.append( ".qttudo" );

	QFile f( filename );
	//QMessageBox::information( this, "QtTudo: Test", filename );

	// if the file already exist try again with another number
	if (f.exists()) {
		// create new file number.qttudo
		sprintf( s, "%d", rand() ); // generate random number
		filename.truncate(0);
		filename.append( "/tmp/" );
		filename.append( s );	
		filename.append( ".qttudo" );
		f.setName( filename );
		if (f.exists()) {
			// no, that can't be, return with error
			QMessageBox::warning( this, "QtTudo", "Konnte Spooldatei nicht anlegen!\n"
				"Bitte nochmal versuchen.\n"
				"Lschen Sie die Spooldateien *.qttudo im Verzeichnis /tmp/." );
			return false;
		}
	}

  if ( f.open(IO_WriteOnly) ) {
		textstream.setDevice( &f ); // stream for destination file

		// initialize all table variables from selection
		createSelections( selection );

		// read report elements (only mesh 1) from database
		query = "SELECT * FROM print_elements WHERE report = '";
		query.append( name ); // append reportname
		query.append( "' AND mesh = 1 ORDER BY pos" );

		tableElements = new SQLTable( query.ascii(), "report,pos,art,mesh" );
		if (tableElements->execute() != SUCCESS_RESULTS) {
			QMessageBox::warning( this, "QtTudo", tableElements->ErrorText );
			wasOK = false;
		}
		if ((tableElements->getnTuples() <= 0)&&(wasOK)) {
			QMessageBox::warning( this, "QtTudo", "Berichtselemente nicht gefunden." );
			wasOK = false;
		}

		// reset the counters for line and page numbers
		// they will be incrementing in function printElement
		pageNo = 1; // first page
		lineNo = 1; // first line

		// get the used printer step 1
		// read the report tuple from database
		query = "SELECT * FROM print_report WHERE name = '";
		query.append( name ); // append reportname
		query.append( "'" );

		tableReport = new SQLTable( query.ascii(), "name" );
		if (tableReport->execute() != SUCCESS_RESULTS) {
			QMessageBox::warning( this, "QtTudo", tableReport->ErrorText );
			wasOK = false;
		}
		if ((tableReport->getnTuples() != 1)&&(wasOK)) {
			QMessageBox::warning( this, "QtTudo", "Bericht nicht gefunden." );
			wasOK = false;
		} else {
			// get the used printer step 1
			// read the report tuple from database
			query = "SELECT * FROM printer WHERE name = '";
			query.append( tableReport->getValue(0,"default_printer") ); // append printername
			query.append( "'" );

			tablePrinter = new SQLTable( query.ascii(), "name" );
			if (tablePrinter->execute() != SUCCESS_RESULTS) {
				QMessageBox::warning( this, "QtTudo", tablePrinter->ErrorText );
				wasOK = false;
			}
			if ((tablePrinter->getnTuples() != 1)&&(wasOK)) {
				QMessageBox::warning( this, "QtTudo", "Drucker nicht gefunden." );
				wasOK = false;
			}
		}

		// only if we found a printer, because we need the page informations
		if (wasOK) {
			// This is the main loop through the tuples of the print_elements
			// where mesh is one.
			for (mainPos = 0; mainPos < tableElements->getnTuples();mainPos++) {
				// find tablename in selections, to get the right values
				for (tablePos=0; tablePos<10; tablePos++) {
					// it couldn't be empty
					if (qSel[tablePos] != 0) {
						// and now the compare
						if (strcmp(qSel[tablePos]->name, tableElements->getValue(mainPos,"tablename"))==0)
							break;
					}
				}

				// starting recursion
				if (!printElement( name, tableElements->getValue(mainPos, "art"), 1,
							tablePos, -1, &f, tableElements->getValue(mainPos, "type" ))) {
					wasOK = false;
					break;
				}
			}
			f.flush(); // write to file immediately (important for the printGenerator)
		}
	}

	// print report
	if ((type == 0)&&(wasOK)) // printing with Qt (QPrinter)
		printGenerator( filename, name );

	// delete file
	if (!f.remove()) {
		QMessageBox::warning( this, "QtTudo Fehler", "Konnte Spooldatei nicht entfernen!" );
		return false;
	}

	return true;
}

//==============================================================================
// printElement
// ---------------
// Parameter:
//  repName   -> reportname
//  repArt    -> which type of element (head, body, total, foot, etc. )
//  mesh      -> mesh in recursion
//  tablePos  -> position in the table array qSel[] of selection (select ... )
//  file      -> temporary file for creating results
//==============================================================================
bool PrintSystem::printElement( const char *repName, const char *repArt,
		int mesh, int qSelPos, int qSelPosBefore, QFile *file, const char *type )
{
	QString query;
	QString line;
	SQLTable *tableDesign;
	SQLTable *tableDesign2; // for the next mesh
	SQLTable *tableElements;
	char sMesh[9];
	char sMesh2[9];
	int iMesh;
	int pos;
	int loopSel;
	int pTuples;
	int nextTablePos; // that means in qSel[]
	int pTablePosHead;
	int printDesign; // counter for printing print_design lines

	sprintf( sMesh, "%i", mesh );
	sprintf( sMesh2, "%i", mesh + 1 );
	iMesh = mesh + 1;

	// set tableDesign
	query.truncate(0);
	query.append( "SELECT * FROM print_design WHERE report = '" );
	query.append( repName ); // append reportname
	query.append( "' AND art = '" );
	query.append( repArt );
	query.append( "' AND mesh = " );
	query.append( sMesh );
	query.append( " ORDER BY no" );

	// only for testing
	//QMessageBox::information( this, "Test", query.copy() );

	tableDesign = new SQLTable( query.ascii(), "report,art,mesh,no" );
	if (tableDesign->execute() != SUCCESS_RESULTS) {
		QMessageBox::warning( this, "QtTudo", tableDesign->ErrorText );
		return false;
	}

	// what kind of header is it?
	if (strcmp(repArt,"head") == 0) {
		// remember the header position
		pTablePosHead = qSelPos;
		qSelPos = 10; // only one loop (see next 'if')
	}

	// modify selection for linkups between the meshes
	if (mesh > 1) { // but only if we are in a higher level than mesh 1
		if (!modifySelection( repName, repArt, mesh, qSelPos, qSelPosBefore ))
			return false;
	}

	if (qSelPos == 10) // without a table reference
		pTuples = 1; // only one loop
	else {
		if (strcmp(type,"loop") == 0)
			pTuples = qSel[qSelPos]->getnTuples();
		else
			pTuples = 1;
	}

	// a loop through the tuples of qSel[tablePos]
	// qSel[] is a array with all selections for the report
	for ( loopSel = 0; loopSel < pTuples; loopSel++ ) {
		if (qSelPos != 10)
			qSel[qSelPos]->pos = loopSel;
		// printing the 'print_design'-lines
		//===============================================================================
		for ( printDesign=0; printDesign < tableDesign->getnTuples(); printDesign++) {
			// printing line
			line.truncate(0);
			line.append( tableDesign->getValue(printDesign,"code") );

			// examine tuple
			//--------------
			// if not a comment ...
			if (line.find("//") != 0) {
				// find variable name
				pos = line.find("%#");
				// a loop through each variable in a single line
				while (pos != -1) {
					// change variable with data
					if (!changeVariable( &line, pos, loopSel, repName )) {
						QMessageBox::warning( this, "QtTudo", "Konnte Variable nicht ndern" );
						pos = -1;
					} else
						pos = line.find("%#");
				}
			}
			// create lines with data in file
			textstream << line;
			textstream << "\n"; // linefeed

			// only for testing
			//QMessageBox::information( this, "Test Zeile", line.copy() );

			// incrementing line position
			lineNo++;

			// incrementing page number and adding a page feed
			if (lineNo > atoi(tablePrinter->getValue(0,"hoehe"))) {
				lineNo = 1;
				pageNo++;
				textstream << "%%newPage"; // page feed order for printGenerator
				textstream << "\n"; // linefeed

				if ( !printElement( repName, "head", 1, pTablePosHead, qSelPosBefore, file, "single" ) )
					QMessageBox::warning( this, "QtTudo",
					"Der Berichtskopf konnte nicht erzeugt werden." );
			}
		} // printing the 'print_design'-lines

		// is there a next mesh?
		//===============================================================================
		// set tableDesign
		query.truncate(0);
		query.append( "SELECT * FROM print_design WHERE report = '" );
		query.append( repName ); // append reportname
		query.append( "' AND art = '" );
		query.append( repArt );
		query.append( "' AND mesh = " );
		query.append( sMesh2 );
		query.append( " ORDER BY no" );

		// only for testing
		//QMessageBox::information( this, "Test", query.copy() );

		tableDesign2 = new SQLTable( query.ascii(), "report,art,mesh,no" );
		if (tableDesign2->execute() != SUCCESS_RESULTS) {
			QMessageBox::warning( this, "QtTudo", tableDesign2->ErrorText );
			return false;
		}

		// are there tuples (lines in print_design) for the next level (mesh)?
		if (tableDesign2->getnTuples() > 0) {
			// yes, there is a next mesh

			// read report elements from database
			query = "SELECT * FROM print_elements WHERE report = '";
			query.append( repName ); // append reportname
			query.append( "' AND art = '" );
			query.append( repArt );
			query.append( "' AND mesh = " );
			query.append( sMesh2 );
			query.append( " ORDER BY pos" );

			// only for testing
			//QMessageBox::information( this, "Test", query.copy() );

			tableElements = new SQLTable( query.ascii(), "report,pos,art,mesh" );
			if (tableElements->execute() != SUCCESS_RESULTS) {
				QMessageBox::warning( this, "QtTudo", tableElements->ErrorText );
				return false;
			}
			// for the moment, there is only one element in higher levels than mesh 1 allowed
			if (tableElements->getnTuples() != 1) {
				QMessageBox::warning( this, "QtTudo", "Berichtselemente nicht gefunden." );
				return false;
			}

			// find tablename in selections, to get the right values
			for (nextTablePos=0; nextTablePos<10; nextTablePos++) {
				// it couldn't be empty
				if (qSel[nextTablePos] != 0) {
				// and now the compare
					if (strcmp(qSel[nextTablePos]->name, tableElements->getValue(0,"tablename"))==0)
						break;
					}
			}
			printElement( repName, repArt, iMesh, nextTablePos, qSelPos,
					file, tableElements->getValue(0,"type") ); // recursion!
		}
	} // end of loop through tuples fo qSel[tablePos] (selections)

	return true;
}

bool PrintSystem::changeVariable( QString *line, int pos, int tupleNo, const char *repName )
{
	int i, i3, endV = 0;
	unsigned int ii, len;
	char name[31];
	double sum;
	QString value;
	QString valueType;
	QString valueJustify;
	QString varName;
	QString queryVar = "SELECT * FROM print_variable WHERE report = '";

	// find end of variable
	for (i=pos+2; (i < 200) && (line->at(i) != '#') && (i < (pos+32)); i++) {
		name[endV] = line->at(i).latin1();
		endV++;
	}

	name[endV] = 0; // end of string
	// for test only
	//QMessageBox::information( this, "QtTudo Test", name );

	queryVar.append( repName );
	queryVar.append( "' AND name = '" );
	queryVar.append( name );
	queryVar.append( "'" );

	SQLTable *tVar = new SQLTable( queryVar.ascii(), "report,name" );
  if (tVar->execute() != SUCCESS_RESULTS) {
		QMessageBox::warning( this, "QtTudo Reportgenerator", tVar->ErrorText );
		return false;
	}

	// it must be found exactly one tuple
	if (tVar->getnTuples() != 1) {
		QMessageBox::warning( this, "QtTudo Reportgenerator", "Variable nicht gefunden." );
		return false;
	}

	valueType = tVar->getValue(0,"type");
	valueJustify = tVar->getValue(0,"justify");

	if ( valueType == "table" ) {
		// get tablename and field value
		for (i=0; i<10; i++) {
			if (qSel[i] != 0) {
				//printf("qSel: %s  tVar: %s\n", qSel[i]->name, tVar->getValue(0,"tablename"));
				if (strcmp(qSel[i]->name, tVar->getValue(0,"tablename"))==0) {
					len = atoi(tVar->getValue(0,"length"));
					if (qSel[i]->fNumber(tVar->getValue(0,"field")) != -1) {
						value = qSel[i]->getValue(tupleNo, tVar->getValue(0,"field"));
						if (valueJustify == "right") {
							if ( value.find(".") != -1 )
								value.replace( value.find("."), 1, ",");
							value = value.rightJustify( len, ' ' );
						}
						else
							if ( strlen( value ) < len ) {
								for (ii=strlen(value); ii<len; ii++)
									value.append(' ');
							}
					} else {
						value.truncate(0);
						value.fill( ' ', len );
					}
					//printf("qSel: %s\n", value.ascii());
					// and replace
					if (!value.isNull())
						line->replace( pos, endV+3, value );
					else {
						QMessageBox::warning( this, "QtTudo Reportgenerator",
							"Datenfeld nicht gefunden (Variablen/Datenfeld)." );
						return false;
					}
					//printf("pos: %i endV: %i line: %s\n", pos, endV+3, line->ascii());
					break;
				}
			}
		}
		if (i == 10)
			return false;
	} else
	if ( valueType == "pos" ) {
		value.setNum( tupleNo + 1 );
		if (valueJustify == "right")
			value = value.rightJustify( atoi(tVar->getValue(0,"length")), ' ' );
		line->replace( pos, endV+3, value );
	} else
	if ( valueType == "sum" ) {
		// get tablename and field value
		for (i=0; i<10; i++) {
			if (qSel[i] != 0) {
				if (strcmp(qSel[i]->name, tVar->getValue(0,"tablename"))==0) {
					len = atoi(tVar->getValue(0,"length"));
					if (qSel[i]->fNumber(tVar->getValue(0,"field")) != -1) {
						sum = 0L;
						for (i3 = 0; i3 < qSel[i]->getnTuples(); i3++) {
							//printf( "v: %f\n", sum );
							sum += atof(qSel[i]->getValue(i3, tVar->getValue(0,"field")) );
							//printf( "n: %f\n", sum );
						}
						value.setNum( sum );
						// if point was not found
						if ( value.find(".") == -1 ) {
							value.append( ",00" );
						}
						if ( value.at(value.length()-2) == '.') {
							value.replace( value.length()-2, 1, ",");
							value.append( "0" );
						}
						if (valueJustify == "right")
							value = value.rightJustify( len, ' ' );
						else
							if ( strlen( value ) < len ) {
								for (ii=strlen(value); ii<len; ii++)
									value.append(' ');
							}
					} else {
						value.truncate(0);
						value.fill( ' ', len );
					}
					// and replace
					if (!value.isNull()) {
						line->replace( pos, endV+3, value );
					} else {
						QMessageBox::warning( this, "QtTudo Reportgenerator",
							"Datenfeld nicht gefunden (Variablen/Datenfeld)." );
						return false;
					}
					break;
				}
			}
		}
		if (i == 10) {
//00000000000000000000000000000000000000000000000000000000000000000000000000000000
// This part is only for the moment (will be changed in the future,
// when I have more time).
// This is rather a part of print_logic

			double netto, brutto;

			varName = tVar->getValue(0,"name");
			if ( varName == "sum_mwst") {
				netto = 0L;
				brutto = 0L;
				for (i3 = 0; i3 < qSel[1]->getnTuples(); i3++) {
					//printf( "v: %f\n", sum );
					netto += atof(qSel[1]->getValue(i3, "nettobetrag") );
					brutto += atof(qSel[1]->getValue(i3, "bruttobetrag") );
					//printf( "n: %f\n", sum );
				}
				value.setNum( brutto - netto );
				// if point was not found
				if ( value.find(".") == -1 ) {
					value.append( ",00" );
				}
				if ( value.at(value.length()-2) == '.') {
					value.replace( value.length()-2, 1, ",");
					value.append( "0" );
				}
				if (valueJustify == "right")
					value = value.rightJustify( 9, ' ' );
				else
					if ( strlen( value ) < 9 ) {
						for (ii=strlen(value); ii<9; ii++)
							value.append(' ');
					}
				line->replace( pos, endV+3, value );
				return true;
			}
//00000000000000000000000000000000000000000000000000000000000000000000000000000000
			line->fill( ' ', atoi(tVar->getValue(0,"length")) );
			return true;
		}
	} else {
		QMessageBox::warning( this, "QtTudo Reportgenerator",
			"Es ist z. Zt. nur der Datentyp 'table' und 'pos' zulssig\n"
			"('pos' fr eine laufende Zeilennummerierung)." );
		return false;
	}

	return true;
}

bool PrintSystem::createSelections( QStringList *list )
{
	int i=0;

	// clear all tables (max. 10)
	for (i=0; i<10; i++)
		qSel[i] = 0;

	i=0;
	for ( QStringList::Iterator it = list->begin(); it != list->end(); ++it, i++ ) {
		qSel[i] = new SQLTable( (*it).ascii() );
		if (qSel[i]->execute() != SUCCESS_RESULTS)
			QMessageBox::warning( this, "QtTudo Drucksystem Tabellenerz.",
					qSel[i]->ErrorText );
	}

	return true;
}

bool PrintSystem::modifySelection( const char *repName, const char *repArt,
		int mesh, int qSelPos, int qSelPosBefore )
{
	int i;
	int posWhere;
	int posOrder;
	char sMesh[9];
	QString query;
	QString qLinkup;
	QString sWhere;
	QString sOrder;
	SQLTable *tableLinkup;
	bool first_filter;

	if (mesh < 2)
		return false;

	sprintf( sMesh, "%i", mesh );

	// looking for WHERE
	posWhere = qSel[qSelPos]->sQuery.find("where",0,false);
	// looking for ORDER BY
	posOrder = qSel[qSelPos]->sQuery.find("order",0,false);

	if (posWhere != -1) {
		// if found, cut the where-clause for append later
		if (posOrder != -1) // copy until the begin of the order
			sWhere = qSel[qSelPos]->sQuery.mid( posWhere, qSel[qSelPos]->sQuery.length()-posOrder );
		else
			sWhere = qSel[qSelPos]->sQuery.right( qSel[qSelPos]->sQuery.length()-posWhere );
	}

	// only for testing
	//QMessageBox::information( this, "Test WHERE", sWhere.copy() );

	if (posOrder != -1) {
		// if found, cut the order for append later
		sOrder = qSel[qSelPos]->sQuery.right( qSel[qSelPos]->sQuery.length()-posOrder );
	}

	// only for testing
	//QMessageBox::information( this, "Test ORDER", sOrder.copy() );

	query = qSel[qSelPos]->sQuery.copy();
	if (posWhere != -1)
		query.truncate( posWhere );
	else
		if (posOrder != -1)
			query.truncate( posOrder );

	first_filter = true;
	// add the clause with the new relation
	// Evtl. Filter setzen
	qLinkup = "SELECT * FROM print_linkup WHERE report = '";
	qLinkup.append( repName ); // append reportname
	qLinkup.append( "' AND art = '" );
	qLinkup.append( repArt );
	qLinkup.append( "' AND mesh = " );
	qLinkup.append( sMesh );

	tableLinkup = new SQLTable( qLinkup.ascii(), "report,art,mesh" );
	if (tableLinkup->execute() != SUCCESS_RESULTS) {
		QMessageBox::warning( this, "QtTudo", tableLinkup->ErrorText );
		return false;
	}
	if (tableLinkup->getnTuples() <= 0) {
		QMessageBox::warning( this, "QtTudo", "Keine Relationen gefunden." );
		return false;
	} else { // found relations
		for (i=0; i < tableLinkup->getnTuples(); i++) {
			if (first_filter) {
				first_filter = false;
				query.append( "WHERE " );
			} else
				query.append( " AND " );
			query.append( tableLinkup->getValue(i,"slave") );
			query.append( " = '" );
			query.append( qSel[qSelPosBefore]->getValue( qSel[qSelPosBefore]->pos,
				tableLinkup->getValue(i,"master")) );
			query.append( "'" );
		}
	}

	// append ORDER BY
	if (posOrder != -1) {
		query.append( " " );
		query.append( sOrder );
	}

	// only for testing
	//QMessageBox::information( this, "Testende", query.copy() );

	qSel[qSelPos]->sQuery = query.ascii();
	if (qSel[qSelPos]->execute() != SUCCESS_RESULTS) {
		QMessageBox::warning( this, "QtTudo", qSel[qSelPos]->ErrorText );
		return false;
	}

	return true;
}

//==============================================================================
// class EditReport
//==============================================================================

EditReport::EditReport( QWidget *parent, const char *name,
				SQLQuerier *sql_ptr, SQLTable *table_ptr)
	: QDBErfassung(parent,name,sql_ptr,table_ptr,"print_design",false)
{
	sql = sql_ptr;
	table = table_ptr;

  Page1->setFont( QFont( "Courier", 13/*, QFont::Bold*/ ) );

	tableV = new SQLTable( "SELECT * FROM print_variable WHERE report = '' ORDER BY name", "report,name" );

	printVariable = new QDBTableEdit( 0,0, sql, tableV, statusBar(), "print_variable", true, true );
  printVariable->setCaption( "QtTudo Variablen bearbeiten" );
	printVariable->changeColumn( tableV->fNumber("report"), 130, "Berichtname" );
	printVariable->changeColumn( tableV->fNumber("name"), 140, "Variable" );
	printVariable->changeColumn( tableV->fNumber("tablename"), 100, "Tabelle" );
	printVariable->changeColumn( tableV->fNumber("type"), 40, "Typ" );
	printVariable->changeColumn( tableV->fNumber("length"), 50, "Lnge" );
	printVariable->changeColumn( tableV->fNumber("field"), 100, "Datenfeld" );
	printVariable->changeColumn( tableV->fNumber("justify"), 60, "Ausr." );

	tableE = new SQLTable( "SELECT * FROM print_elements WHERE report = '' ORDER BY art", "report,art" );

	printElements = new QDBTableEdit( 0,0, sql, tableE, statusBar(), "print_elements", true, true );
  printElements->setCaption( "QtTudo Elemente bearbeiten" );
	printElements->changeColumn( tableE->fNumber("report"), 130, "Berichtname" );
	printElements->changeColumn( tableE->fNumber("art"), 140, "Art" );
	printElements->changeColumn( tableE->fNumber("tablename"), 100, "Tabelle" );
	printElements->changeColumn( tableE->fNumber("no"), 40, "Nr." );

	// defaults
	Page1->Feldvorgabe[table->fNumber("art")]->append( "head" );

	// Special column headers
	Page1->colName[table->fNumber("report")]->append( "Bericht" );
	Page1->colSize[table->fNumber("report")] = 130;
	Page1->colName[table->fNumber("art")]->append( "Art" );
	Page1->colSize[table->fNumber("art")] = 50;
	Page1->colName[table->fNumber("no")]->append( "Lfd.-Nr." );
	Page1->colSize[table->fNumber("no")] = 50;
	Page1->colName[table->fNumber("print_nr")]->append( "Nr." );
	Page1->colSize[table->fNumber("print_nr")] = 25;
	Page1->colName[table->fNumber("code")]->append( "Code" );
	Page1->colSize[table->fNumber("code")] = 730;

	for (int i = 0; i < table->getnFields(); i++ ) {
		Page1->makeVisible( i );
		Page1->addCol( i );
	}

	QPopupMenu *fenster = new QPopupMenu( this );
	fenster->insertItem( "&Wechseln", this, SLOT(sReportWechselnClicked()) );
	fenster->insertItem( "&Kopieren", this, SLOT(sReportKopierenClicked()) );

	menuBar()->insertItem( "&Fenster", fenster );
	menuBar()->insertItem( "&Elemente", this, SLOT(sReportElementsClicked()) );
	menuBar()->insertItem( "&Logik", this, SLOT(sLogicClicked()) );
	menuBar()->insertItem( "&Variablen", this, SLOT(sVariableClicked()) );

	// to get a unique number (lfd_nr) for the tuple
	connect( Page1, SIGNAL(newTuple() ), SLOT(getLfdNr()) );

	setGeometry( x(), y(), 1000, 600 );
	setCaption( "QtTudo Bericht bearbeiten" );
}

EditReport::~EditReport(){
}

void EditReport::sReportKopierenClicked()
{
	QString s;
	QDialog *d = new QDialog( this, 0, true );

	int i, ii;
	QCString *DBneu = new QCString("");
	SQLTable *tableNeu = new SQLTable( "", "" );

  QPushButton *ok = new QPushButton( "&Ok", d );
  QPushButton *abbruch	= new QPushButton( "&Abbruch", d );
	QLabel			*lname		= new QLabel( d );
  QLineEdit		*db_name	= new QLineEdit( d );

  lname->setText( "Neuer &Reportname" );
  lname->move( 30, 36 );
	lname->resize(lname->width()+10,lname->height());
  lname->setBuddy( db_name );
  db_name->move( 150, 40 );
  db_name->resize( 200, 20 );

  ok->move( 80, 90 );
  abbruch->move( 220, 90 );

	d->resize(400,140);
	d->setCaption( "Bericht kopieren" );

	db_name->setFocus();

  connect( abbruch, SIGNAL(clicked()), d, SLOT(reject()) );
  connect( ok, SIGNAL(clicked()), d, SLOT(accept()) );

	if (d->exec()) { // if ok pressed
		// begin transaction
		SQLTable *tableTA = new SQLTable();
		tableTA->sQuery = "BEGIN TRANSACTION";
		if ( tableTA->execute() != SUCCESS_NO_RESULTS ) {
			QMessageBox::warning( 0, "QtTudo Transaktion Start", tableTA->ErrorText );
			tableTA->sQuery = "ROLLBACK";
			tableTA->execute();
			return;
		}

		// insert into print_report
		DBneu->setStr( "INSERT INTO print_report (name) VALUES ('" );
		DBneu->append( db_name->text() );
		DBneu->append( "')" );
		tableNeu->sQuery = DBneu->copy();
	  if (tableNeu->execute() != SUCCESS_NO_RESULTS) {
			QMessageBox::warning( this, "QtTudo", "Fehler: " + tableNeu->ErrorText );
			tableTA->sQuery = "ROLLBACK";
			tableTA->execute();
			return;
		}

		// insert into print_elements
		s = "select * from print_elements WHERE report = '";
		s.append( Page1->Feldvorgabe[table->fNumber("report")]->ascii() );
		s.append( "'" );
		SQLTable *copyE = new SQLTable( s.ascii(), "report,art" );
	  if (copyE->execute() != SUCCESS_RESULTS) {
			QMessageBox::warning( this, "QtTudo", "Fehler: " + copyE->ErrorText );
			tableTA->sQuery = "ROLLBACK";
			tableTA->execute();
			return;
		}
		for (i=0; i < copyE->getnTuples(); i++) {
			DBneu->setStr( "INSERT INTO print_elements (" );
			// read the field names
			for ( ii = 0; ii < copyE->getnFields(); ii++) {
				if ( ii > 0 )
					DBneu->append( "," );
				DBneu->append( copyE->fName(ii) );
			}
			DBneu->append( ") VALUES (" );
			// read the field values
			for ( ii = 0; ii < copyE->getnFields(); ii++) {
				if ( ii > 0 )
					DBneu->append( ",'" );
				else
					DBneu->append( "'" );
				if (ii == 0)
					DBneu->append( db_name->text() );
				else
					DBneu->append( copyE->getValue(i,ii) );
				DBneu->append( "'" );
			}
			DBneu->append( ")" );

			tableNeu->sQuery = DBneu->copy();
		  if (tableNeu->execute() != SUCCESS_NO_RESULTS) {
				QMessageBox::warning( this, "QtTudo", "Fehler: " + tableNeu->ErrorText );
				tableTA->sQuery = "ROLLBACK";
				tableTA->execute();
				return;
			}
		}

		// copy logic (coming soon ...)

		// copy variables
		s = "SELECT * FROM print_variable WHERE report = '";
		s.append( Page1->Feldvorgabe[table->fNumber("report")]->ascii() );
		s.append( "'" );
		SQLTable *copyV = new SQLTable( s.ascii(), "report,name" );
	  if (copyV->execute() != SUCCESS_RESULTS) {
			QMessageBox::warning( this, "QtTudo", "Fehler: " + copyV->ErrorText );
			tableTA->sQuery = "ROLLBACK";
			tableTA->execute();
			return;
		}
		for (i=0; i < copyV->getnTuples(); i++) {
			DBneu->setStr( "INSERT INTO print_variable (" );
			// read the field names
			for ( ii = 0; ii < copyV->getnFields(); ii++) {
				if ( ii > 0 )
					DBneu->append( "," );
				DBneu->append( copyV->fName(ii) );
			}
			DBneu->append( ") VALUES (" );
			// read the field values
			for ( ii = 0; ii < copyV->getnFields(); ii++) {
				if ( ii > 0 )
					DBneu->append( ",'" );
				else
					DBneu->append( "'" );
				if (ii == 0)
					DBneu->append( db_name->text() );
				else
					DBneu->append( copyV->getValue(i,ii) );
				DBneu->append( "'" );
			}
			DBneu->append( ")" );

			tableNeu->sQuery = DBneu->copy();
		  if (tableNeu->execute() != SUCCESS_NO_RESULTS) {
				QMessageBox::warning( this, "QtTudo", "Fehler: " + tableNeu->ErrorText );
				tableTA->sQuery = "ROLLBACK";
				tableTA->execute();
				return;
			}
		}

		s = "select * from print_design WHERE report = '";
		s.append( Page1->Feldvorgabe[table->fNumber("report")]->ascii() );
		s.append( "' order by no" );
		SQLTable *copy = new SQLTable( s.ascii(), "report,art,no" );
	  if (copy->execute() != SUCCESS_RESULTS) {
			QMessageBox::warning( this, "QtTudo", "Fehler: " + copy->ErrorText );
			tableTA->sQuery = "ROLLBACK";
			tableTA->execute();
			return;
		}
		// insert into print_design
		for (i=0; i < copy->getnTuples(); i++) {
			DBneu->setStr( "INSERT INTO print_design (" );
			// read the field names
			for ( ii = 0; ii < copy->getnFields(); ii++) {
				if ( ii > 0 )
					DBneu->append( "," );
				DBneu->append( copy->fName(ii) );
			}
			DBneu->append( ") VALUES (" );
			// read the field values
			for ( ii = 0; ii < copy->getnFields(); ii++) {
				if ( ii > 0 )
					DBneu->append( ",'" );
				else
					DBneu->append( "'" );
				if (ii == 0)
					DBneu->append( db_name->text() );
				else
					DBneu->append( copy->getValue(i,ii) );
				DBneu->append( "'" );
			}
			DBneu->append( ")" );

			tableNeu->sQuery = DBneu->copy();
		  if (tableNeu->execute() != SUCCESS_NO_RESULTS) {
				QMessageBox::warning( this, "QtTudo", "Fehler: " + tableNeu->ErrorText );
				tableTA->sQuery = "ROLLBACK";
				tableTA->execute();
				return;
			}
		}
		// end transaction
		tableTA->sQuery = "COMMIT";
		if ( tableTA->execute() != SUCCESS_NO_RESULTS ) {
			tableTA->sQuery = "ROLLBACK";
			tableTA->execute();
			return;
		}
	}
}

void EditReport::sReportElementsClicked()
{
  if (tableE->execute() != SUCCESS_RESULTS) {
		QMessageBox::warning( this, "QtTudo Elemente bearbeiten", tableV->ErrorText );
		return;
	}
	printElements->show();
}

void EditReport::sReportWechselnClicked()
{
	QString select;
	QString *vKladdenname = new QString("");

	SQLTable *table2 = new SQLTable( "select * from print_report ORDER BY name", "name" );

	QDBTableSelect *selectKladdenname =
		new QDBTableSelect( this, "QtTudo: Bericht auswhlen",
												sql, table2, vKladdenname, "print_report" );
	if (selectKladdenname->exec()) { // if ok pressed
		// defaults
		Page1->Feldvorgabe[table->fNumber("report")] = vKladdenname;
		printVariable->Feldvorgabe[tableV->fNumber("report")] = vKladdenname;
		printElements->Feldvorgabe[tableE->fNumber("report")] = vKladdenname;

		// make new view
		select = "SELECT * FROM print_variable WHERE report = '";
		select.append( vKladdenname->ascii() );
		select.append( "' order by name" );
		tableV->sQuery = select.ascii();
		if (!printVariable->update())
			QMessageBox::warning( this, "QtTudo Bericht auswhlen", tableV->ErrorText );
		else
			printVariable->setFocus();

		// make new view
		select = "SELECT * FROM print_elements WHERE report = '";
		select.append( vKladdenname->ascii() );
		select.append( "' ORDER BY art" );
		tableE->sQuery = select.ascii();
		if (!printElements->update()/*;tableE->execute() != SUCCESS_RESULTS*/)
			QMessageBox::warning( this, "QtTudo Bericht auswhlen", tableE->ErrorText );
		else
			printElements->setFocus();

		// make new view
		select = "select * from print_design WHERE report = '";
		select.append( vKladdenname->ascii() );
		select.append( "' order by no" );
		table->sQuery = select.ascii();
		if (table->execute() != SUCCESS_RESULTS)
			QMessageBox::warning( this, "QtTudo Bericht auswhlen", table->ErrorText );
		else {
			Page1->update();
			Page1->setFocus();
		}
	}
}

void EditReport::sLogicClicked()
{
	QMessageBox::information( this, "QtTudo Logik bearbeiten", "coming soon ..." );
}

void EditReport::sVariableClicked()
{
  if (tableV->execute() != SUCCESS_RESULTS) {
		QMessageBox::warning( this, "QtTudo Variablen bearbeiten", tableV->ErrorText );
		return;
	}

	printVariable->show();
}

void EditReport::getLfdNr()
{
	// (( zeileNext - zeileBefore ) / 2 ) + zeileBefore = zeileNeu

}
