/***************************************************************************
                          buchen.h  -  description
                             -------------------
    begin                : Wed Jul 26 2000
    version              : $Id: buchen.h,v 1.14 2001/03/14 13:59:04 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BUCHEN_H
#define BUCHEN_H

#include "sqlquerier.h"

#define ERFASSUNG	1
#define VERKAUF		2
#define EINKAUF		3

#define DEBITOR		1
#define KREDITOR	2

/**Accounting from invoices (Rechnungen), credit notes (Gutschriften),
payment (Zahlungen), delivery notes (Lieferscheine) and
changing quantity of article (Warenbewegungen).
  *@author Jrg Bemm
  */

class Buchen {
public: 
	Buchen( SQLQuerier *sql_ptr=0, SQLTable *tableKopf=0, SQLTable *tableZeile=0 );
	~Buchen();

	bool makeAccountErfassung();
	bool makeAccountVerkauf();
	bool makeAccountEinkauf();

private:
	bool KontoartSachkonto( int tuple, const char *kontoart );
	bool KontoartDebitor( int tuple );
	bool KontoartKreditor( int tuple );
	int getVATtuple( SQLTable *mwst, SQLTable *tablePositions, int tuple );
	// Give back the tuple number of table pos
	// (pos is warenbuch_gruppe or res_buch_gruppe)
	int getBuchGr( SQLTable *pos, int tuple );

	QCString	*getLfdNrBuchenIntern( QCString *nr );
	QString		*getSachkonto( int Type, QString *Sachkonto, int tuple );
	bool			createPosten( QString *values=0, QString *fields=0,
							int tuple = 0, int type=0,
							const char *posten = "sachposten" );
	// get values from allg_erfassung, verkauf or einkauf
	// type  = 1 -> ERFASSUNG (kassenkladdenzeile)
	//       = 2 -> VERKAUF (verkaufskopf/-zeile)
	//       = 3 -> EINKAUF (einkaufskopf/-zeile)
	// query = query where you want append the values
	// tuple = tuple number
	// table = kassenkladdenzeile, verkaufszeile or einkaufszeile
	void			getValuesToQuery( int type=0, QString *query=0, int tuple=0,
							SQLTable *table=0 );
	bool			createDebitorposten( int tuple );
	bool			createKreditorposten( int tuple );
	QString		*getVAT( QString *VAT, int tuple,
							QString *sVAT, QString *sVAT_Kto ); // VAT (Umsatzsteuer)
	double		getVAT( int tuple );
	void			addValue( SQLTable *table=0, QString *value=0, int tuple=0,
							const char *name=0, bool sep=false );
	void			deleteTuple( int tuple, QString *tableName );
	QCString	*setStr( QCString *str );
	bool			rollback();
	// copy the order to archive
	bool			copyOrder( const char *head, const char *positions);
	bool			deleteOrder(); // copy the order to deb_rech_kopf/deb_rech_zeile
	QString		*setDate( QString *date );

	SQLQuerier	*sql;

	SQLTable		*table;		// kassenkladdenzeile, verkaufskopf, einkaufskopf
	SQLTable		*tablePositions; // nothing, verkaufszeile or einkaufszeile

	SQLTable		*tableSP; // Sachposten
	SQLTable		*tableDP; // Debitorposten
	SQLTable		*tableKP; // Kreditorposten
	SQLTable		*tableWP; // Warenposten
	SQLTable		*tableTA; // Transaction start/end
	QCString iTableQuery;
	QString NoSP;
	QString NoDP;
	QString NoKP;
	QString NoWP;
	QString NoBO;
};

#endif
