/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997 - 2001 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "config.h"
#include "doc.h"
#include "tools.h"

#ifdef HAVE_FNMATCH
#include <fnmatch.h>
#else
#include "fnmatch.h"
#endif

/*********************************************/
/* oddelenie MIME hlavicky od tela dokumentu */
/*********************************************/
void split_mime_doc(docp)
doc *docp;
{
	char *p1,*p2;
	char *doc_c;
	int mime_size;
	
	p1 = strstr(docp->contents , "\n\n");
	p2 = strstr(docp->contents , "\r\n\r\n");

	if (p2 && ((p2 < p1) || !p1))
	{
		doc_c = p2 + 4;
		mime_size = p2 - docp->contents;
	}
	else if (p1)
	{
		doc_c = p1 + 2;
		mime_size = p1 - docp->contents;
	}
	else
	{
		doc_c = docp->contents;
		mime_size = 0;
	}

	p1 = docp->contents;

	docp->size = docp->size - (doc_c - docp->contents);

	docp->contents = (char *) _malloc(docp->size);
	memcpy(docp->contents , doc_c , docp->size);

	docp->mime = NULL;
	if (mime_size)
	{
		docp->mime = (char *) _malloc(mime_size + 3);
		strncpy(docp->mime , p1 , mime_size + 2);
		*(docp->mime +  mime_size + 2) = '\0';
	}	
	free(p1);
}

/************************************************/
/* vrati n-tu hodnotu atributu z MIME hlavicky	*/
/************************************************/
char *get_mime_n_param_val_str(param_id , mimet, n)
char *param_id;
char *mimet;
int n;
{
	char *p;
	int i = 0;
	int ilen;

	if (!mimet) return NULL;

	p = mimet;

	while (*p)
	{
		ilen = strcspn(p , "\r\n");

		if (!strncasecmp(p , param_id , strlen(param_id)))
		{
			if (i == n)
			{
				char *p1;
				p1 = p + strlen(param_id);
				while (isspace(*p1)) p1++;
				p += ilen;
				while (*p)
				{
					p += strspn(p , "\n\r");
					ilen = strcspn(p , "\r\n");
					if ((*p == ' ' || *p == '\t'))
					{
						p += ilen;
					}
					else
						break;
				}
				p1 = new_n_string(p1 , p-p1);
				omit_chars(p1 , "\r\n");
				return p1;
			}
			i++;
		}
		p += ilen;
		p += strspn(p , "\n\r");
	}
	return NULL;
}

static struct {
	char *mimet;
	char *ext;
} mime_type_exts[] = {
	{"text/html*", ".html"} ,
	{"text/plain", ".txt"} ,
	{"image/jpeg", ".jpg"} ,
	{"image/gif", ".gif"} ,
	{"image/png", ".png"} ,
};

char *mime_get_type_ext(type)
char *type;
{
	int i;

	if (!type)
		return NULL;

	for (i = 0; i < NUM_ELEM(mime_type_exts); i++)
	{
		if (!fnmatch(mime_type_exts[i].mimet, type, 0))
		{
			return mime_type_exts[i].ext;
		}
	}
	return NULL;
}

