// Copyright (C) 2001 Nils Bokermann <Nils.Bokermann@mediaWays.net>
//
// PURPOSE OF THIS FILE: Implement the ldap_result functions
//
// - Automatic Version Information via RCS:
//   $Id: getresults.cxx,v 1.2 2001/12/19 05:26:56 nilsb Exp $
//   $Source: /cvsroot/openh323gk/openh323gk/ldap/src/getresults.cxx,v $
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "ldapapi.h"
#include <ldap-int.h>

#ifndef lint
// mark object with version info
static const char vcid[] = "@(#) $Id: getresults.cxx,v 1.2 2001/12/19 05:26:56 nilsb Exp $";
static const char vcHid[] = __LDAP_OPENH323_H;
#endif

LDAPMessage * ldap_first_entry (LDAP *ld, LDAPMessage *entry) {
  if( ld == NULL || entry == NULL ) {
    return NULL;
  }
  if((&(entry->message->m_protocolOp.GetObject()))->IsClass("LDAP_SearchResponse")) {
    LDAP_SearchResponse &res=entry->message->m_protocolOp;
    return res.GetTag()==LDAP_SearchResponse::e_entry ? entry  : ldap_next_entry(ld, entry);
  }
  return entry;
}


LDAPMessage * ldap_next_entry (LDAP *ld, LDAPMessage *entry) {
  if ( ld == NULL || entry == NULL ) {
    return NULL;
  }

  for (entry = entry->next; entry != NULL; entry = entry->next) {
    if((&(entry->message->m_protocolOp.GetObject()))->IsClass("LDAP_SearchResponse")) {
      LDAP_SearchResponse &res=entry->message->m_protocolOp;
      if (res.GetTag()==LDAP_SearchResponse::e_entry)
	return entry;
    }
  }
  return(NULL);
}

int ldap_count_entries (LDAP *ld, LDAPMessage *entry){
  int	i;

  if ((ld == NULL) || (NULL==entry))
    return -1;
  
  for (i=0; entry!=NULL; entry=entry->next) {
    if((&(entry->message->m_protocolOp.GetObject()))->IsClass("LDAP_SearchResponse")) {
      LDAP_SearchResponse &res=entry->message->m_protocolOp;
      if (res.GetTag()==LDAP_SearchResponse::e_entry)
	i++;
    }
  }
  return( i );
}

//
// End of getresults.cxx
//
