/*
 * t38proto.cxx
 *
 * T.38 protocol handler
 *
 * Open Phone Abstraction Library
 *
 * Copyright (c) 1998-2000 Equivalence Pty. Ltd.
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Open H323 Library.
 *
 * The Initial Developer of the Original Code is Equivalence Pty. Ltd.
 *
 * Contributor(s): ______________________________________.
 *
 * $Log: t38proto.cxx,v $
 * Revision 1.4  2001/11/11 23:18:53  robertj
 * MSVC warnings removed.
 *
 * Revision 1.3  2001/11/11 23:07:52  robertj
 * Some clean ups after T.38 commit, thanks Adam Lazur
 *
 * Revision 1.2  2001/11/09 05:39:54  craigs
 * Added initial T.38 support thanks to Adam Lazur
 *
 * Revision 1.1  2001/07/17 04:44:32  robertj
 * Partial implementation of T.120 and T.38 logical channels.
 *
 */

#ifdef __GNUC__
#pragma implementation "t38proto.h"
#endif


#include <ptlib.h>
#include "t38proto.h"
#include "t38.h"
#include "transports.h"


#define new PNEW


/////////////////////////////////////////////////////////////////////////////

#if 0
OpalT38Protocol::OpalT38Protocol()
{
}


BOOL OpalT38Protocol::Originate(H323Transport & /*transport*/)
{
  return FALSE;
}


BOOL OpalT38Protocol::Answer(H323Transport & transport)
{
  PPER_Stream rawData;
  while (transport.ReadPDU(rawData)) {
    T38_IFPPacket pdu;
    if (pdu.Decode(rawData)) {
      PTRACE(4, "H323T38\tRead PDU:\n  " << setprecision(2) << pdu);
      if (!HandlePacket(pdu))
        return TRUE;
    }
    else {
      PTRACE(1, "H323T38\tDecode of PDU failed:\n  " << setprecision(2) << pdu);
    }
  }
  return FALSE;
}


BOOL OpalT38Protocol::HandlePacket(const T38_IFPPacket & /*pdu*/)
{
  return FALSE;
}
#endif

/////////////////////////////////////////////////////////////////////////////

OpalT38Protocol::OpalT38Protocol()
{
  /* pEngine = NULL; */
}

OpalT38Protocol::~OpalT38Protocol()
{
}

BOOL OpalT38Protocol::Originate(H323Transport & transport)
{
  PTRACE(1, "Originate LocalAddress: " << transport.GetLocalAddress()
          << " --> RemoteAddress: " << transport.GetRemoteAddress());

  WORD seq = 0;	// 16 bit
  T38_IFPPacket pdu;

  while( PreparePacket(pdu) ) {
    PTRACE(1, "<-- IFPPacket (" << seq << ") " << setprecision(2) << pdu);

    T38_UDPTLPacket udptl;

    udptl.m_seq_number = seq;
    udptl.m_primary_ifp_packet.EncodeSubType(pdu);

    PTRACE(1, "UDPTLPacket " << setprecision(2) << udptl);

    PPER_Stream rawData;

    udptl.Encode(rawData);
    PTRACE(1, "raw " << setprecision(2) << rawData);

    if(!transport.WritePDU(rawData) ) {
        PTRACE(1, "<-- OpalT38Protocol::Originate - WritePDU ERROR: " << transport.GetErrorText());
        break;
    }

    seq++;      // 16 bit
    /* sleep for a second and loop... this is only for debugging and should be
     * removed */
    PThread::Sleep(1);
  }

  PTRACE(2, "Originate end");
  return FALSE;
}

BOOL OpalT38Protocol::Answer(H323Transport & transport)
{
  PTRACE(1, "Answer LocalAddress: " << transport.GetLocalAddress()
          <<" <-- RemoteAddress: " << transport.GetRemoteAddress());

  /* HACK HACK HACK -- need to figure out how to get the remote address
   * properly here */
  transport.SetPromiscuous(TRUE);

  PPER_Stream rawData;
  int nBad = 0;
  WORD seq = 0;	// 16 bit

  while (transport.ReadPDU(rawData)) {
    PTRACE(1, "--> RemoteAddress: " << transport.GetRemoteAddress());
    rawData.ResetDecoder();

    T38_UDPTLPacket udptl;
    if( !udptl.Decode(rawData) ) {
      PTRACE(1, "--> raw  bad !!!" << setprecision(2) << rawData);
      if( ++nBad > 5 ) break;
      continue;
    }

    T38_IFPPacket pdu;
    if( !udptl.m_primary_ifp_packet.DecodeSubType(pdu) ) {
      PTRACE(1, "--> UDPTLPacket bad !!! " << setprecision(2) << udptl);
      continue;
    }
    WORD rseq = (WORD)udptl.m_seq_number;	// 16 bit

    PTRACE(1, "--> IFPPacket (" << rseq << ") " << setprecision(2) << pdu);

    if( seq != rseq ) {
      // recovery should be here
      PInt32 diff = PInt32(rseq) - PInt32(seq);
      if( diff < 0 ) diff += 0x10000;	// ???
      if( ! HandlePacketLost((unsigned)diff) ) break;
    }

    seq++;	// 16 bit

    if( !HandlePacket(pdu) ) break;
  }
  PTRACE(2, "Answer end");
  return FALSE;
}


BOOL OpalT38Protocol::HandlePacket(const T38_IFPPacket & pdu)
{
    PTRACE(1, "OpalT38Protocol::HandlePacket()");
    PTRACE(1, pdu);
    return TRUE;
}

BOOL OpalT38Protocol::PreparePacket(T38_IFPPacket & pdu)
{
    PTRACE(1, "OpalT38Protocol::PreparePacket()");
    pdu.m_type_of_msg = T38_Type_of_msg::e_t30_indicator;
    pdu.m_type_of_msg = T38_Type_of_msg_t30_indicator::e_cng;
    // pdu.m_data_field = new T38_Data_Field();
    return TRUE;
}

BOOL OpalT38Protocol::HandlePacketLost(unsigned /*nLost*/)
{
    PTRACE(1, "OpalT38Protocol::HandlePacketLost()");
    /* don't handle lost packets yet */
    return FALSE;
}

