SOURCES	+= audiooutput.cpp collection.cpp collectionview.cpp colorbutton.cpp configuration.cpp controls.cpp decoder.cpp dragobjects.cpp eqpreset.cpp equalizer.cpp group.cpp icons.cpp logscale.cpp main.cpp mainvisual.cpp mediasearch.cpp mediaview.cpp mq3.cpp organizer.cpp output.cpp recycler.cpp scrolllabel.cpp song.cpp streaminput.cpp
HEADERS	+= audiooutput.h buffer.h collection.h collectionview.h colorbutton.h configuration.h constants.h controls.h decoder.h dragobjects.h eqpreset.h equalizer.h group.h icons.h logscale.h mainvisual.h mediasearch.h mediaview.h mq3.h organizer.h output.h recycler.h scrolllabel.h song.h streaminput.h visual.h inlines.h
TARGET = mq3
REQUIRES = thread


xingmp3 {
    SOURCES   += decoder_mp3.cpp
    HEADERS   += decoder_mp3.h
    DEFINES   += XINGMP3
    unix:LIBS +=-L../xingmp3/ -lxingmp3
    win32:LIBS += ..\xingmp3\xingmp3.lib
}

mad {
    SOURCES   += decoder_mad.cpp
    HEADERS   += decoder_mad.h
    DEFINES   += MAD
    unix:LIBS += -lmad
    win32:LIBS += mad.lib
}

oggvorbis {
    SOURCES   += decoder_ogg.cpp
    HEADERS   += decoder_ogg.h
    DEFINES   += OGGVORBIS
    unix:LIBS += -lvorbisfile -lvorbis -logg
}

fftw {
    DEFINES += FFTW
    unix:LIBS += -lrfftw -lfftw
    win32:LIBS += ..\fftw\FFTW2dll.lib ..\rfftw\RFFTW2dll.lib
    win32:INCLUDEPATH += ..\rfftw ..\fftw
}

win32-msvc:LIBS += dsound.lib dxguid.lib
win32-borland:LIBS += $(BCB)\lib\PSDK\dsound.lib

FORMS	= about.ui configdialog.ui equalizerbase.ui groupedit.ui songedit.ui analyzeroptions.ui scopeoptions.ui topographoptions.ui spectroscopeoptions.ui
TEMPLATE	=app
CONFIG	+= qt warn_on
INCLUDEPATH	+= ../xingmp3/
unix:LIBS	+= -lssl -lcrypto
LANGUAGE	= C++

# install
target.path = $$MQ3_BINPATH
INSTALLS   += target

# default small icons
smallicons.path=$$MQ3_ICNPATH/default/small
smallicons.files = ../icons/default/small/*.png
INSTALLS += smallicons 

# default large icons
largeicons.path=$$MQ3_ICNPATH/default/large
largeicons.files = ../icons/default/large/*.png
INSTALLS += largeicons
