// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef MEDIASEARCH_H
#define MEDIASEARCH_H

#include <qwidget.h>
#include <qvaluelist.h>

class QComboBox;
class QLabel;
class QPushButton;

class Song;


class MediaSearch : public QWidget
{
    Q_OBJECT

public:
    MediaSearch(QWidget *parent, const char *name = 0);
    ~MediaSearch();

    bool useRegexp() const { return useregexp; }
    void setUseRegexp(bool r) { useregexp = r; }

    static MediaSearch *instance();


public slots:
    void search(const QString &);
    void searchNext();
    void searchPrev();
    void clear();


private:
    QComboBox *searchcombo;
    QLabel *searchlabel;
    QPushButton *searchprev, *searchnext;
    QValueList<Song *> matchlist;
    bool useregexp;
    int currentmatch;
};

#endif // MEDIASEARCH_H
