.\"
.\" $XFree86: xc/lib/fontconfig/src/fontconfig.man,v 1.1.1.1 2002/02/14 23:34:13 keithp Exp $
.\"
.\" Copyright  2002 Keith Packard, member of The XFree86 Project, Inc.
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name of Keith Packard not be used in
.\" advertising or publicity pertaining to distribution of the software without
.\" specific, written prior permission.  Keith Packard makes no
.\" representations about the suitability of this software for any purpose.  It
.\" is provided "as is" without express or implied warranty.
.\"
.\" KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
.\" EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
.\" DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
.\" TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\"
.de TQ
.br
.ns
.TP \\$1
..
.TH FONTCONFIG 3 "Version 1.0" "XFree86"

.SH NAME
fontconfig \- Font configuration and customization library

.SH SYNOPSIS
.nf
.B #include <fontconfig/fontconfig.h>
.B #include <fontconfig/fcfreetype.h>
.B #include <fontconfig/fcxml.h>
.fi
.SH DESCRIPTION
.B Fontconfig
is a library designed to provide system-wide font configuration,
customization and application access.

.SH FUNCTIONAL OVERVIEW
Fontconfig contains two essential modules, the configuration module which
builds an internal configuration from XML files and the matching module
which accepts font patterns and returns the nearest matching font.

.SS FONT CONFIGURATION
The configuration module consists of the FcConfig datatype, libxml2 and
FcConfigParse which walks over an XML tree and ammends a configuration with
data found within.  From an external perspective, configuration of the
library consists of generating a valid XML tree and feeding that to
FcConfigParse.  The only other mechanism provided to applications for
changing the running configuration is to add fonts and directories to the
list of application-provided font files.  
.P
The intent is to make font configurations relatively static, and shared by
as many applications as possible.  It is hoped that this will lead to more
stable font selection when passing names from one application to another.
XML was chosen as a configuration file format because it provides a format
which is easy for external agents to edit while retaining the correct
structure and syntax.
.P
Font configuration is separate from font matching; applications needing to
do their own matching can access the available fonts from the library and
perform private matching.  The intent is to permit applications to pick and
choose appropriate functionality from the library instead of forcing them to
choose between this library and a private configuration mechanism.  The hope
is that this will ensure that configuration of fonts for all applications
can be centralized in one place.  Centralizing font configuration will make
simplify and regularize font installation and customization.

.SS FONT PROPERTIES
While font patterns may contain essentially any properties, there are some
well known properties with associated types.  Fontconfig uses some of these
properties for font matching and font completion.  Others are provided as a
convenience for the applications rendering mechanism.
.sp
.nf
.ta 1i 2.75i 3.5i 5.5i
.lc \(em
Property	CPP symbol	Type	Description

family	FC_FAMILY	String	Font family name
style	FC_STYLE	String	Font style. Overrides weight and slant
slant	FC_SLANT	Int	Italic, oblique or roman
weight	FC_WEIGHT	Int	Light, medium, demibold, bold or black
size	FC_SIZE	Double	Point size
pixelsize	FC_PIXEL_SIZE	Double	Pixel size
spacing	FC_SPACING	Int	Proportional, monospace or charcell
foundry	FC_FOUNDRY	String	Font foundry name
antialias	FC_ANTIALIAS	Bool	Whether glyphs can be antialiased
hinting	FC_HINTING	Bool	Whether the rasterizer should use hinting
verticallayout	FC_VERTICAL_LAYOUT	Bool	Use vertical layout
globaladvance	FC_GLOBAL_ADVANCE	Bool	Use font global advance data
file	FC_FILE	String	The filename holding the font
index	FC_INDEX	Int	The index of the font within the file
rasterizer	FC_RASTERIZER	String	Which rasterizer is in use
outline	FC_OUTLINE	Bool	Whether the glyphs are outlines
scalable	FC_SCALABLE	Bool	Whether glyphs can be scaled
scale	FC_SCALE	Double	Scale factor for point->pixel conversions
dpi	FC_DPI	Double	Target dots per inch
rgba	FC_RGBA	Int	rgb, bgr, vrgb, vbgr - subpixel geometry
minspace	FC_MINSPACE	Bool	Eliminate leading from line spacing
charset	FC_CHARSET	CharSet	Unicode chars encoded by the font
lang	FC_LANG	String	List of language groups this font is designed for
.DT
.fi

.SS FONT MATCHING
Fontconfig performs matching by measuring the distance from a provided
pattern to all of the available fonts in the system.  The closest matching
font is selected.  This ensures that a font will always be returned, but
doesn't ensure that it is anything like the requested pattern.
.P
Font matching starts with an application constructed pattern.  The desired
attributes of the resulting font are collected together in an FcPattern
object.  Each property of the pattern can contain one or more values; these
are listed in priority order; matches earlier in the list are considered
"closer" than matches later in the list.
.P
The initial pattern is modified by applying the list of editing instructions
specific to patterns found in the configuration; each consists of a match
predicate and a set of editing operations.  They are executed in the order
they appeared in the configuration.  Each match causes the associated
sequence of editing operations to be applied.
.P
After the pattern has been edited, a sequence of default substitutions are
performed to canonicalize the set of available properties; this avoids the
need for the lower layers to constantly provide default values for various
font properties during rendering.
.P
The canonical font pattern is finally matched against all available fonts.
The distance from the pattern to the font is measured for each of several
properties: foundry, charset, antialias, family, spacing, pixelsize, style,
slant, weight, rasterizer and outline.  This list is in priority order --
results of comparing earlier elements of this list weigh more heavily than
later elements.
.P
The pattern representing that font is augmented to include any properties
found in the pattern but not found in the font itself; this permits the
application to pass rendering instructions or any other data through the
matching system.  Finally, the list of editing instructions specific to
fonts found in the configuration are applied to the pattern.  This modified
pattern is returned to the application.
.P
The return value contains sufficient information to locate and rasterize the
font, including the file name, pixel size and other rendering data.  As
none of the information involved pertains to the FreeType library,
applications are free to use any rasterization engine or even to take
the identified font file and access it directly.
.P
The match/edit sequences in the configuration are performed in two passes
because there are essentially two different operations necessary -- the
first is to modify how fonts are selected; aliasing families and adding
suitable defaults.  The second is to modify how the selected fonts are
rasterized.  Those must apply to the selected font, not the original pattern
as false matches will often occur.
.SS FONT NAMES
Fontconfig provides a textual representation for patterns that the library
can both accept and generate.  The representation is in three parts, first a
list of family names, second a list of point sizes and finally a list of
additional properties:
.nf
	<families>-<point sizes>:<name1>=<values1>:<name2>=<values2>...
.fi
Values in a list are separated with commas.  The name needn't include either
families or point sizes; they can be elided.  In addition, there are
symbolic constants that simultaneously indicate both a name and a value.
Here are some examples:
.sp
.nf
.ta 1i 3i
	Times-12	12 point Times Roman
	Times-12:bold	12 point Times Bold
	Courier:italic	Courier Italic in the default size
	Monospace:matrix=1 .1 0 1	The users preferred monospace font
		with artificial obliquing
.fi
.DT

.SH DATATYPES

.TP
.B FcChar8
.TQ
.B FcChar16
.TQ
.B FcChar32
.TQ
.B FcBool
These are primitive datatypes; the FcChar* types hold precisely the number
of bits stated (if supported by the C implementation).  FcBool holds
one of two CPP symbols: FcFalse or FcTrue.

.TP
.B FcMatrix
An FcMatrix holds an affine transformation, usually used to reshape glyphs.
A small set of matrix operations are provided to manipulate these.
.sp
.nf
	typedef struct _FcMatrix {
		double xx, xy, yx, yy;
	} FcMatrix;
.fi

.TP
.B FcCharSet
An FcCharSet is an abstract type that holds the set of encoded unicode chars
in a font.  Operations to build and compare these sets are provided.

.TP
.B FcType
Tags the kind of data stored in an FcValue.

.TP
.B FcValue
An FcValue object holds a single value with one of a number of different
types.  The 'type' tag indicates which member is valid.
.sp
.nf
	typedef struct _FcValue {
		FcType type;
		union {
			const FcChar8 *s;
			int i;
			FcBool b;
			double d;
			const FcMatrix *m;
			const FcCharSet *c;
		} u;
	} FcValue;
.fi
.P
.ta 1i 2i 3i 4i
.nf
.lc \(em
	type	Union member	Datatype
	
	FcTypeVoid	(none)	(none)
	FcTypeInteger	i	int
	FcTypeDouble	d	double
	FcTypeString	s	char *
	FcTypeBool	b	b
	FcTypeMatrix	m	FcMatrix *
	FcTypeCharSet	c	FcCharSet *
.fi
.DT
.TP
.B FcPattern
holds a set of names with associated value lists; each name refers to a
property of a font.  FcPatterns are used as inputs to the matching code as
well as holding information about specific fonts.  Each property can hold
one or more values; conventionally all of the same type, although the
interface doesn't demand that.

.TP
.B FcFontSet
.sp
.nf
	typedef struct _FcFontSet {
		int nfont;
		int sfont;
		FcPattern **fonts;
	} FcFontSet;
.fi	
An FcFontSet contains a list of FcPatterns.  Internally fontconfig uses this
data structure to hold sets of fonts.  Externally, fontconfig returns the
results of listing fonts in this format.  'nfont' holds the number of
patterns in the 'fonts' array; 'sfont' is used to indicate the size of that
array.

.TP
.B FcObjectSet
.sp
.nf
	typedef struct _FcObjectSet {
		int nobject;
		int sobject;
		const char **objects;
	} FcObjectSet;
.fi
holds a set of names and is used to specify which fields from fonts are
placed in the the list of returned patterns when listing fonts.

.TP
.B FcBlanks
holds a list of Unicode chars which are expected to be blank; unexpectedly
blank chars are assumed to be invalid and are elided from the charset
associated with the font.

.TP
.B FcFileCache
holds the per-user cache information for use while loading the font
database. This is built automatically for the current configuration when
that is loaded.  Applications must always pass '0' when one is requested.

.TP
.B FcConfig
holds a complete configuration of the library; there is one default
configuration, other can be constructed from XML data structures.  All
public entry points that need global data can take an optional FcConfig*
argument; passing 0 uses the default configuration.  FcConfig objects hold two
sets of fonts, the first contains those specified by the configuration, the
second set holds those added by the application at run-time.  Interfaces
that need to reference a particulat set use one of the FcSetName enumerated
values.

.TP
.B FcSetName
Specifies one of the two sets of fonts available in a configuration;
FcSetSystem for those fonts specified in the configuration and
FcSetApplication which holds fonts provided by the application.

.TP
.B FcResult
Used as a return type for functions manipulating FcPattern objects.
.P
.ta 1i 3i 4i
.lc \(em
	Result code	Meaning
.br
	
.br
	FcResultMatch	Object exists with the specified ID
.br
	FcResultNoMatch	Object doesn't exist at all
.br
	FcResultTypeMismatch	Object exists, but the type doesn't match
.br
	FcResultNoId	Object exists, but has fewer values than specified
.br
.DT

.SH FUNCTIONS

.SS FcMatrix
FcMatrix structures hold an affine transformation in matrix form.
.TP
#define FcMatrixInit(m)	((m)->xx = (m)->yy = 1, (m)->xy = (m)->yx = 0)
Initializes a matrix to the identify transformation.

.TP
FcMatrix *FcMatrixCopy (const FcMatrix *mat)
Allocates a new FcMatrix and copies 'mat' into it.

.TP
FcBool FcMatrixEqual (const FcMatrix *mat1, const FcMatrix *mat2)
Returns FcTrue if 'mat1' and 'mat2' are equal, else FcFalse.

.TP
void FcMatrixMultiply (FcMatrix *result, const FcMatrix *a, const FcMatrix *b)
Multiplies 'a' and 'b' together, placing the result in
'result'.  'result' may refer to the sam matrix as either 'a' or 'b'.

.TP
void FcMatrixRotate (FcMatrix *m, double c, double s)
If 'c' is cos(angle) and 's' is sin(angle), FcMatrixRotate rotates the
matrix by 'angle'.

.TP
void FcMatrixScale (FcMatrix *m, double sx, double sy)
Scales 'm' by 'sx' in the horizontal dimension and 'sy' in the
vertical dimension.

.TP
void FcMatrixShear (FcMatrix *m, double sh, double sv)
Shears 'm' by 'sh' in the horizontal direction and 'sv' in the
vertical direction.

.SS FcCharSet
An FcCharSet is a boolean array indicating a set of unicode chars.  Those
associated with a font are marked constant and cannot be edited.
FcCharSets may be reference counted internally to reduce memory consumption;
this may be visible to applications as the result of FcCharSetCopy may
return it's argument, and that CharSet may remain unmodifiable.

.TP
FcCharSet *FcCharSetCreate (void)
Creates an empty FcCharSet object.

.TP
void FcCharSetDestroy (FcCharSet *fcs)
Frees an FcCharSet object.

.TP
FcBool FcCharSetAddChar (FcCharSet *fcs, FcChar32 ucs4)
Adds a single unicode char to the set, returning FcFalse on
failure, either as a result of a constant set or from running out of memory.

.TP
FcCharSet *FcCharSetCopy (FcCharSet *src)
Makes a copy of 'src'; note that this may not actually do anything more than
increment the reference count on 'src'.

.TP
FcBool FcCharSetEqual (const FcCharSet *a, const FcCharSet *b)
Returns whether 'a' and 'b' contain the same set of unicode chars.

.TP
FcCharSet *FcCharSetIntersect (const FcCharSet *a, const FcCharSet *b)
Returns a set including only those chars found in both 'a' and 'b'.

.TP
FcCharSet *FcCharSetUnion (const FcCharSet *a, const FcCharSet *b);
Returns a set including only those chars found in either 'a' or 'b'.

.TP 
FcCharSet *FcCharSetSubtract (const FcCharSet *a, const FcCharSet *b)
Returns a set including only those chars found in 'a' but not 'b'.

.TP
FcBool FcCharSetHasChar (const FcCharSet *fcs, FcChar32 ucs4)
Returns whether 'fcs' contains the char 'ucs4'.

.TP
FcChar32 FcCharSetCount (const FcCharSet *a)
Returns the total number of unicode chars in 'a'.

.TP
FcChar32 FcCharSetIntersectCount (const FcCharSet *a, const FcCharSet *b)
Returns the number of chars that are in both 'a' and 'b'.

.TP
FcChar32 FcCharSetSubtractCount (const FcCharSet *a, const FcCharSet *b)
Returns the number of chars that are in 'a' but not in 'b'.

.SS FcValue
FcValue is a structure containing a type tag and a union of all possible
datatypes.  The tag is an enum of type 
.B FcType
and is intended to provide a measure of run-time
typechecking, although that depends on careful programming.

.TP
void FcValueDestroy (FcValue v)
Frees any memory referenced by `v'.  Values of type FcTypeString,
FcTypeMatrix and FcTypeCharSet reference memory, the other types do not.

.TP
FcValue FcValueSave (FcValue v)
Returns a copy of `v' duplicating any object referenced by it so that `v'
may be safely destroyed without harming the new value.

.SS FcPattern
An FcPattern is an opaque type that holds both patterns to match against the
available fonts, as well as the information about each font.

.TP
FcPattern *FcPatternCreate (void)
Creates a pattern with no properties; used to build patterns from scratch.

.TP
void FcPatternDestroy (FcPattern *p)
Destroys a pattern, in the process destroying all related values.

.TP
FcBool FcPatternAdd (FcPattern *p, const char *object, FcValue value, FcBool append)
Adds a single value to the list of values associated with the property named
`object'.  If `append' is FcTrue, the value is added at the end of any
existing list, otherwise it is inserted at the begining.  `value' is saved
(with FcValueSave) when inserted into the pattern so that the library
retains no reference to any application-supplied data structure.

.TP
FcBool FcPatternAddInteger (FcPattern *p, const char *object, int i)
.TQ
FcBool FcPatternAddDouble (FcPattern *p, const char *object, double d)
.TQ
FcBool FcPatternAddString (FcPattern *p, const char *object, const char *s)
.TQ
FcBool FcPatternAddMatrix (FcPattern *p, const char *object, const FcMatrix *s)
.TQ
FcBool FcPatternAddCharSet (FcPattern *p, const char *object, const FcCharSet *c)
.TQ
FcBool FcPatternAddBool (FcPattern *p, const char *object, FcBool b)
These are all convenience functions that insert objects of the specified
type into the pattern.  Use these in preference to FcPatternAdd as they
will provide compile-time typechecking.  These all append values to
any existing list of values.

.TP
FcResult FcPatternGet (FcPattern *p, const char *object, int id, FcValue *v)
Returns in `v' the `id'th value associated with the property `object'.
The value returned is not a copy, but rather refers to the data stored
within the pattern directly.  Applications must not free this value.

.TP
FcResult FcPatternGetInteger (FcPattern *p, const char *object, int n, int *i);
.TQ
FcResult FcPatternGetDouble (FcPattern *p, const char *object, int n, double *d);
.TQ
FcResult FcPatternGetString (FcPattern *p, const char *object, int n, char **const s);
.TQ
FcResult FcPatternGetMatrix (FcPattern *p, const char *object, int n, FcMatrix **s);
.TQ
FcResult FcPatternGetCharSet (FcPattern *p, const char *object, int n, FcCharSet **c);
.TQ
FcResult FcPatternGetBool (FcPattern *p, const char *object, int n, FcBool *b);
These are convenience functions that call FcPatternGet and verify that the
returned data is of the expected type. They return FcResultTypeMismatch if
this is not the case.  Note that these (like FcPatternGet) do not make a
copy of any data structure referenced by the return value.  Use these
in preference to FcPatternGet to provide compile-time typechecking.

.TP
FcPattern *FcPatternBuild (FcPattern *orig, ...);
.TQ
FcPattern *FcPatternVaBuild (FcPattern *orig, va_list va)
Builds a pattern using a list of objects, types and values.  Each
value to be entered in the pattern is specified with three arguments:
.IP
1. Object name, a string describing the property to be added.
.IP
2. Object type, one of the FcType enumerated values
.IP
3. Value, not an FcValue, but the raw type as passed to any of the
FcPatternAdd<type> functions.  Must match the type of the second argument.
.IP
The argument list is terminated by a null object name, no object type nor
value need be passed for this.  The values are added to `pattern', if
`pattern' is null, a new pattern is created.  In either case, the pattern is
returned. Example:
.RS
.IP
pattern = FcPatternBuild (0, FC_FAMILY, FtTypeString, "Times", (char *) 0);
.RE
.IP
FcPatternVaBuild is used when the arguments are already in the form of a
varargs value.

.TP
FcBool FcPatternDel (FcPattern *p, const char *object)
Deletes all values associated with the property `object', returning 
whether the property existed or not.

.TP
void FcPatternPrint (FcPattern *p)
Prints an easily readable version of the pattern to stdout.  There is
no provision for reparsing data in this format, it's just for diagnostics
and debugging.

.TP
void FcDefaultSubstitute (FcPattern *pattern)
Supplies default values for underspecified font patterns:
.RS
.IP \(bu 
Patterns without a specified style or weight are set to Medium
.IP \(bu
Patterns without a specified style or slant are set to Roman
.IP \(bu
Patterns without a specified pixel size are given one computed from
any specified point size (default 12), dpi (default 75) and scale (default
1).
.RE

.TP
FcPattern *FcNameParse (const char *name)
Converts 'name' from the standard text format described above into a pattern.

.TP
FcChar8 *FcNameUnparse (FcPattern *pat)
Converts the given pattern into the standard text format described above.
The return value is not static, but instead refers to newly allocated memory
which should be freed by the caller.

.SS FcFontSet
An FcFontSet simply holds a list of patterns; these are used to return the
results of listing available fonts.
.TP
FcFontSet *FcFontSetCreate (void)
Creates an empty font set.

.TP
void FcFontSetDestroy (FcFontSet *s);
Destroys a font set.  Note that this destroys any referenced patterns as
well.

.TP 
FcBool FcFontSetAdd (FcFontSet *s, FcPattern *font)
Adds a pattern to a font set.  Note that the pattern is not copied before
being inserted into the set.

.SS FcObjectSet
An FcObjectSet holds a list of pattern property names; it is used to
indiciate which properties are to be returned in the patterns from
FcFontList.

.TP
FcObjectSet *FcObjectSetCreate (void)
Creates an empty set.

.TP
FcBool FcObjectSetAdd (FcObjectSet *os, const char *object)
Adds a proprety name to the set.

.TP
void FcObjectSetDestroy (FcObjectSet *os)
Destroys an object set.


.TP
FcObjectSet *FcObjectSetBuild (const char *first, ...)
.TQ
FcObjectSet *FcObjectSetVaBuild (const char *first, va_list va)
These build an object set from a null-terminated list of property names.

.SS FcBlanks
An FcBlanks object holds a list of Unicode chars which are expected to
be blank when drawn.  When scanning new fonts, any glyphs which are
empty and not in this list will be assumed to be broken and not placed in
the FcCharSet associated with the font.  This provides a significantly more
accurate CharSet for applications.

.TP
FcBlanks *FcBlanksCreate (void)
Creates an empty FcBlanks object.

.TP
void FcBlanksDestroy (FcBlanks *b)
Destroys an FcBlanks object, freeing any associated memory.

.TP
FcBool FcBlanksAdd (FcBlanks *b, FcChar32 ucs4)
Adds a single character to an FcBlanks object, returning FcFalse
if this process ran out of memory.

.TP
FcBool FcBlanksIsMember (FcBlanks *b, FcChar32 ucs4)
Returns whether the specified FcBlanks object contains the indicated Unicode
value.

.SS FcConfig
An FcConfig object holds the internal representation of a configuration.
There is a default configuration which applications may use by passing 0 to
any function using the data within an FcConfig.

.TP
FcConfig *FcConfigCreate (void)
Creates an empty configuration.

.TP 
void FcConfigDestroy (FcConfig *config)
Destroys a configuration and any data associated with it.  Note that calling
this function with the return from FcConfigGetCurrent will place the library
in an indeterminate state.

.TP
FcBool FcConfigSetCurrent (FcConfig *config)
Sets the current default configuration to 'config'.  Implicitly calls
FcConfigBuildFonts if necessary, returning FcFalse if that call fails.

.TP
FcConfig *FcConfigGetCurrent (void)
Returns the current default configuration.

.TP
FcBool FcConfigBuildFonts (FcConfig *config)
Builds the set of available fonts for the given configuration.  Note that
any changes to the configuration after this call have indeterminate effects.
Returns FcFalse if this operation runs out of memory.

.TP
char **FcConfigGetDirs (FcConfig *config)
Returns the list of font directories specified in 'config'.

.TP 
char **FcConfigGetConfigFiles (FcConfig *config)
Returns the list of known configuration files used to generate 'config'.
Note that this will not include any configuration done with FcConfigParse.

.TP
char *FcConfigGetCache (FcConfig *config)
Returns the name of the file used to store per-user font information.

.TP
FcFontSet *FcConfigGetFonts (FcConfig *config, FcSetName set)
Returns one of the two sets of fonts from the configuration as specified 
by 'set'.

.TP
FcBlanks *FcConfigGetBlanks (FcConfig *config)
Returns the FcBlanks object associated with the given configuration, if no
blanks were present in the configuration, this function will return 0.

.TP
FcBool FcConfigAppFontAddFile (FcConfig *config, const char *file)
Adds an application-specific font to the configuration.

.TP 
FcBool FcConfigAppFontAddDir (FcConfig *config, const char *dir)
Scans the specified directory for fonts, adding each one found to the
application-specific set of fonts.

.TP 
void FcConfigAppFontClear (FcConfig *config)
Clears the set of application-specific fonts.

.TP
FcBool FcConfigSubstitute (FcConfig *config, FcPattern *p, FcMatchKind kind)
Performs the sequence of pattern modification operations, if 'kind' is
FcMatchPattern, then those tagged as pattern operations are applied, else 
if 'kind' is FcMatchFont, those tagged as font operations are applied.

.TP
FcPattern *FcFontMatch (FcConfig *config, FcPattern *p, FcResult *result)
Returns the font in 'config' most close matching 'p'.  This function
should be called only after FcConfigSubstitute and FcDefaultSubstitute have
been called; otherwise the results will be less useful.

.TP
FcFontSet *FcFontList (FcConfig *config, FcPattern *p, FcObjectSet *os)
Selects fonts matching 'p', creates patterns from those fonts containing
only the objects in 'os' and returns the set of unique such patterns.

.TP
char *FcConfigFilename (const char *name)
Given the specified external entity name, return the associated filename.
This provides applications a way to convert various configuration file
references into filename form. 
.P
A null or empty 'name' indicates that the default configuration file should
be used; which file this references can be overridden with the
FC_CONFIG_FILE environment variable.  Next, if the name starts with '~', it
refers to a file in the current users home directory.  Otherwise if the name
doesn't start with '/', it refers to a file in the default configuration
directory; the built-in default directory can be overridden with the
FC_CONFIG_DIR environment variable.

.SS Initialization
These functions provide some control over how the library is initialized.

.TP
FcBool FcInitConfig (void)
Initializes the default configuration using the default configuration file

.TP
FcBool FcInitFonts (void)
Initializes the set of fonts available in the default configuration

.TP
FcBool FcInit (void)
Calls FcInitConfig and FcInitFonts to completely initialize the default
configuration.

.SS FreeType specific functions
.nf
.B #include <fontconfig/fcfreetype.h>
.fi
While the fontconfig library doesn't insist that FreeType be used as the
rasterization mechanism for fonts, it does provide some convenience
functions.

.TP
FT_UInt FcFreeTypeCharIndex (FT_Face face, FcChar32 ucs4)
Maps a Unicode char to a glyph index.  This function uses information from
several possible underlying encoding tables to work around broken fonts.
As a result, this function isn't designed to be used in performance
sensitive areas; results from this function are intended to be cached by
higher level functions.

.TP
FcCharSet *FcFreeTypeCharSet (FT_Face face, FcBlanks *blanks) Scans a
FreeType face and returns the set of encoded Unicode chars.  This scans
several encoding tables to build as complete a list as possible.  If
'blanks' is not 0, the glyphs in the font are examined and any blank glyphs
not in 'blanks' are not placed in the returned FcCharSet.

.TP
FcPattern *FcFreeTypeQuery (const char *file, int id, FcBlanks *blanks, int *count)
Constructs a pattern representing the 'id'th font in 'file'.  The number
of fonts in 'file' is returned in 'count'.

.SS XML specific functions
.nf
.B #include <fontconfig/fcxml.h>
.fi
These functions expose the libxml2 datatypes used for font configuration.

.TP
xmlDocPtr FcConfigLoad (const char *file)
Loads a configuration file mapping 'file' into a filename with
FcConfigFilename.  This doesn't load a complete configuration as any
include files referenced from 'file' will not be loaded.

.TP
FcBool FcConfigParse (FcConfig *config, xmlDocPtr doc)
Walks the given configuration and constructs the internal representation in
'config'.  Any include files referenced from within 'doc' will be loaded
with FcConfigLoad and also parsed.

.SS File and Directory routines

.TP
FcBool FcFileScan (FcFontSet *set, FcFileCache *cache, FcBlanks *blanks, const char *file, FcBool force)
Scans a single file and adds all fonts found to 'set'.  If 'force' is FcTrue,
then the file is scanned even if associated information is found in 'cache'.

.TP
FcBool FcDirScan (FcFontSet *set, FcFileCache *cache, FcBlanks *blanks, const char *dir, FcBool force)
Scans an entire directory and adds all fonts found to 'set'.  If 'force' is
FcTrue, then the directory and all files within it are scanned even if
information is present in the per-directory cache file or 'cache'.

.TP
FcBool FcDirSave (FcFontSet *set, const char *dir)
Creates the per-directory cache file for 'dir' and populates it with the
fonts in 'set'.

.SS String utilities

.TP
int FcUtf8ToUcs4 (FcChar8 *src, FcChar32 *dst, int len)
Converts the next Unicode char from 'src' into 'dst' and returns the number
of bytes containing the char.  'src' nust be at least 'len' bytes long.

.TP
FcBool FcUtf8Len (FcChar8 *string, int len, int *nchar, int *wchar)
Counts the number of Unicode chars in 'len' bytes of 'string'.  Places that
count in 'nchar'.  'wchar' contains 1, 2 or 4 depending on the number of
bytes needed to hold the largest unicode char counted.  The return value
indicates whether 'string' is a well-formed UTF8 string.

.TP
char *FcStrCopy (const char *s)
Allocates memory, copies 's' and returns the resulting buffer.  Yes, this is
'strdup', but that function isn't available on every platform.

.TP
int FcStrCmpIgnoreCase (const char *s1, const char *s2)
Returns the usual <0, 0, >0 result of comparing 's1' and 's2'.  This test
is case-insensitive in the ASCII range and will operate properly with UTF8
encoded strings, although it does not check for well formed strings.

.SH CONFIGURATION FILE FORMAT
Configuration files for fontconfig are stored in XML format; this
format makes external configuration tools easier to write and ensures that
they will generate syntactically correct configuration files.  As XML
files are plain text, they can also be manipulated by the expert user using
a text editor.
.P
The fontconfig document type definition resides in the external entity
"fonts.dtd"; this is normally stored in the default font configuration
directory (/etc/fonts).  Each configuration file should contain the
following structure:
.sp
.nf
	<?xml version="1.0"?>
	<!DOCTYPE fontconfig SYSTEM "fonts.dtd">
	<fontconfig>
	...
	</fontconfig>
.fi
.P
.SS <fontconfig>
This is the top level element for a font configuration and can contain
<dir>, <cache>, <include>, <match> and <alias> elements in any order.

.SS <dir>
This element contains a directory name which will be scanned for font files
to include in the set of available fonts.

.SS <cache>
This element contains a file name for the per-user cache of font
information.  If it starts with '~', it refers to a file in the users
home directory.  This file is used to hold information about fonts that
isn't present in the per-directory cache files.  It is automatically
maintained by the fontconfig library.  The default for this file 
is ``~/.fonts.cache''.

.SS <include ignore_missing="no">
This element contains the name of an additional configuration file.  When
the XML datatype is traversed by FcConfigParse, the contents of the file
will also be incorporated into the configuration by passing the filename to
FcConfigLoadAndParse.  If 'ignore_missing' is set to "yes" instead of the
default "no", a missing file will elicit no warning message from the library.

.SS <match target="pattern">
This element holds first a (possibly empty) list of tests and then a
(possibly empty) list of edits.  Patterns which match all of the tests are
subjected to all the edits.  If 'target' is set to "font" instead of the
default "pattern", then this element applies to the font name resulting from
a match rather than a font pattern to be matched.

.SS <test qual="any" name="property" compare="eq">
This element contains a single value which is compared with the pattern
property "property" (substitute any of the property names seen above).
'compare' can be one of "eq", "not_eq", "less", "less_eq", "more", or
"more_eq".  'qual' may either be the default, "any", in which case the match
succeeds if any value associated with the property matches the test value, or
"all", in which case all of the values associated with the property must
match the test value.

.SS <edit name="property" mode="assign">
This element contains a list of expression elements (any of the value or
operator elements).  The expression elements are evaluated at run-time and
modify the property "property".  The modification depends on whether
"property" was matched by one of the associated <test> elements, if so, the
modification may affect the first matched value.  'mode' is one of:
.nf
.RS
.ta 1i 3i 5i
Mode	Operation with match	Operation without match

"assign"	Replace matching value	Replace all values
"assign_replace"	Replace all values	Replace all values
"prepend"	Insert before matching value	Insert at head of list
"prepend_first"	Insert at head of list	Insert at head of list
"append"	Append after matching value	Append at end of list
"append_last"	Append at end of list	Append at end of list
.RE
.DT
.fi
.SS <int>
.SS <double>
.SS <string>
.SS <bool>
These elements hold a single value of the indicated type.  <bool> elements
hold either true or false.
.SS <matrix>
This element holds the four <double> elements of an affine transformation.
.SS <name>
Holds a property name.  Evaluates to the first value from the property of
the font, not the pattern.
.SS <const>
Holds the name of a constant; these are always integers and serve as
symbolic names for common font values:
.RS
.sp
.nf
.ta 1i 2i 3i
.lc \(em
Constant	Property	CPP symbol

light	weight	FC_WEIGHT_LIGHT
medium	weight	FC_WEIGHT_MEDIUM
demibold	weight	FC_WEIGHT_DEMIBOLD
bold	weight	FC_WEIGHT_BOLD
black	weight	FC_WEIGHT_BLACK
roman	slant	FC_SLANT_ROMAN
italic	slant	FC_SLANT_ITALIC
oblique	slant	FC_SLANT_OBLIQUE
proportional	spacing	FC_PROPORTIONAL
mono	spacing	FC_MONO
charcell	spacing	FC_CHARCELL
rgb	rgba	FC_RGBA_RGB
bgr	rgba	FC_RGBA_BGR
vrgb	rgba	FC_RGBA_VRGB
vbgr	rgba	FC_RGBA_VBGR
.DT
.fi
.RE
.SS <or>
.SS <and>
.SS <plus>
.SS <minus>
.SS <times>
.SS <divide>
These elements perform the specified operation on a list of expression
elements.  <or> and <and> are boolean, not bitwise.
.SS <eq>
.SS <not_eq>
.SS <less>
.SS <less_eq>
.SS <more>
.SS <more_eq>
These elements compare two values, producing a boolean result.
.SS <not>
Inverts the boolean sense of its one expression element
.SS <if>
This element takes three expression elements; if the value of the first is
true, it produces the value of the second, otherwise it produces the value
of the third.
.SS <alias>
Alias elements provide a shorthand notation for the set of common match
operations needed to substitute one font family for another.  They contain a
<family> element followed by optional <prefer>, <accept> and <default>
elements.  Fonts matching the <family> element are edited to prepend the
list of <prefer>ed families before the matching <family>, append the
<accept>able familys after the matching <family> and append the <default>
families to the end of the family list.
.SS <family>
Holds a single font family name
.SS <prefer>
.SS <accept>
.SS <default>
These hold a list of <family> elements to be used by the <alias> element.
.SH EXAMPLE CONFIGURATION FILE
.SS System configuration file
This is an example of a system-wide configuration file
.sp
.nf
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "fonts.dtd">
<!-- /etc/fonts/fonts.conf file to configure system font access -->
<fontconfig>
<!-- 
	Find fonts in these directories
-->
<dir>/usr/X11R6/lib/X11/fonts/truetype</dir>
<dir>/usr/X11R6/lib/X11/fonts/Type1</dir>

<!--
	Accept deprecated 'mono' alias, replacing it with 'monospace'
-->
<match target="pattern">
	<test qual="any" name="family"><string>mono</string></test>
	<edit name="family" mode="assign"><string>monospace</string></edit>
</match>

<!--
	Names not including any well known alias are given 'sans'
-->
<match target="pattern">
	<test qual="all" name="family" mode="not_eq">sans</test>
	<test qual="all" name="family" mode="not_eq">serif</test>
	<test qual="all" name="family" mode="not_eq">monospace</test>
	<edit name="family" mode="append_last"><string>sans</string></edit>
</match>

<!--
	Load per-user customization file, but don't complain
	if it doesn't exist
-->
<include ignore_missing="yes">~/.fonts.conf</include>

<!--
	Alias well known font names to available TrueType fonts.
	These substitute TrueType faces for similar Type1
	faces to improve screen appearance.
-->
<alias>
	<family>Times</family>
	<prefer><family>Times New Roman</family></prefer>
	<default><family>serif</family></default>
</alias>
<alias>
	<family>Helvetica</family>
	<prefer><family>Verdana</family></prefer>
	<default><family>sans</family></default>
</alias>
<alias>
	<family>Courier</family>
	<prefer><family>Courier New</family></prefer>
	<default><family>monospace</family></default>
</alias>

<!--
	Provide required aliases for standard names
	Do these after the users configuration file so that
	any aliases there are used preferentially
-->
<alias>
	<family>serif</family>
	<prefer><family>Times New Roman</family></prefer>
</alias>
<alias>
	<family>sans</family>
	<prefer><family>Verdana</family></prefer>
</alias>
<alias>
	<family>monospace</family>
	<prefer><family>Andale Mono</family></prefer>
</alias>
</fontconfig>
.fi
.SS User configuration file
This is an example of a per-user configuration file that lives in
~/.fonts.conf
.sp
.nf
<?xml version="1.0"?>
<!DOCTYPE fontconfig SYSTEM "fonts.dtd">
<!-- ~/.fonts.conf for per-user font configuration -->
<fontconfig>

<!--
	Private font directory
-->
<dir>~/misc/fonts</dir>

<!--
	use rgb sub-pixel ordering to improve glyph appearance on
	LCD screens.  Changes affecting rendering, but not matching
	should always use target="font".
-->
<match target="font">
	<edit name="rgba" mode="assign"><const>rgb</const></edit>
</match>
</fontconfig>
.fi
.SH FILES
.B fonts.conf
contains configuration information for the fontconfig library
consisting of directories to look at for font information as well as
instructions on editing program specified font patterns before attempting to
match the available fonts.  It is in xml format.

.B fonts.dtd 
is a DTD that describes the format of the configuration files.

.B ~/.fonts.conf
is the conventional location for per-user font configuration, although the
actual location is specified in the global fonts.conf file.

.B ~/.fonts.cache
is the conventional repository of font information that isn't found in the
per-directory caches.  This file is automatically maintained by fontconfig.

.SH AUTHOR
Keith Packard, member of the XFree86 Project, Inc.
